/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.xy;

import com.inet.jfree.chart.plot.PlotOrientation;
import com.inet.jfree.chart.renderer.GradientPainter;
import com.inet.jfree.chart.renderer.xy.StandardXYBarPainter;
import com.inet.jfree.chart.renderer.xy.XYBarRenderer;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.ui.RectangleEdge;

public class SimpleGradientXYBarPainter
extends StandardXYBarPainter {
    private boolean horizontal;
    private GradientPainter painter;

    public SimpleGradientXYBarPainter(boolean horizontal) {
        this.horizontal = horizontal;
        this.painter = new GradientPainter();
    }

    @Override
    public void paintBar(Graphics2D g2, XYBarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base) {
        Paint itemPaint = renderer.getItemPaint(row, column);
        Rectangle2D bounds = bar.getBounds2D();
        Point2D.Float start = null;
        Point2D.Float end = null;
        if (!this.horizontal) {
            if (base == RectangleEdge.TOP) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
            } else if (base == RectangleEdge.BOTTOM) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
            } else if (base == RectangleEdge.LEFT) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
            } else if (base == RectangleEdge.RIGHT) {
                start = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
            }
        } else if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
            start = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
            end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
        }
        boolean success = this.painter.paintGradient(g2, itemPaint, bar, start, end, GradientPainter.ColorOfGradient.gradient);
        PlotOrientation orientation = renderer.getPlot().getOrientation();
        double barWidth = 0.0;
        barWidth = orientation == PlotOrientation.HORIZONTAL ? bar.getHeight() : bar.getWidth();
        if (success) {
            this.painter.drawOutline(g2, renderer, row, column, bar, renderer.isDrawBarOutline() && barWidth > 3.0);
        }
    }
}

