/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.plot.XYPlot;
import com.inet.jfree.data.general.DatasetUtilities;
import com.inet.jfree.data.xy.XYDataset;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;

public class PlotUtilities {
    private static final int ADDFAKTOR = 20;
    private static final double MULFAKTOR = 0.8;
    private static final double LESSMULFAKTOR = 0.9;

    public static boolean isEmptyOrNull(XYPlot plot) {
        if (plot != null) {
            int n = plot.getDatasetCount();
            for (int i = 0; i < n; ++i) {
                XYDataset dataset = plot.getDataset(i);
                if (DatasetUtilities.isEmptyOrNull(dataset)) continue;
                return false;
            }
        }
        return true;
    }

    public static Paint getDarker(Paint paint) {
        if (paint.getTransparency() != 1) {
            return paint;
        }
        if (paint instanceof Color) {
            return PlotUtilities.darker((Color)paint, 20, 0.8);
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gPaint = (GradientPaint)paint;
            Color c1 = gPaint.getColor1();
            Color c2 = gPaint.getColor2();
            return new GradientPaint(gPaint.getPoint1(), PlotUtilities.darker(c1, 20, 0.8), gPaint.getPoint2(), PlotUtilities.darker(c2, 20, 0.8), gPaint.isCyclic());
        }
        return paint;
    }

    private static Color darker(Color c, int add, double multi) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r = Math.max((int)((double)r * multi) - add, 0);
        g = Math.max((int)((double)g * multi) - add, 0);
        b = Math.max((int)((double)b * multi) - add, 0);
        return new Color(r, g, b);
    }

    public static Paint getLessDarker(Paint paint) {
        if (paint.getTransparency() != 1) {
            return paint;
        }
        if (paint instanceof Color) {
            return PlotUtilities.darker((Color)paint, 10, 0.9);
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gPaint = (GradientPaint)paint;
            Color c1 = gPaint.getColor1();
            Color c2 = gPaint.getColor2();
            return new GradientPaint(gPaint.getPoint1(), PlotUtilities.darker(c1, 10, 0.9), gPaint.getPoint2(), PlotUtilities.darker(c2, 10, 0.9), gPaint.isCyclic());
        }
        return paint;
    }

    private static Color brigther(Color c, int add, double multi) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r = Math.min((int)((double)r * (1.0 / multi)) + add, 255);
        g = Math.min((int)((double)g * (1.0 / multi)) + add, 255);
        b = Math.min((int)((double)b * (1.0 / multi)) + add, 255);
        return new Color(r, g, b);
    }

    public static Paint getBrighter(Paint paint) {
        if (paint.getTransparency() != 1) {
            return paint;
        }
        if (paint instanceof Color) {
            return PlotUtilities.brigther((Color)paint, 20, 0.8);
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gPaint = (GradientPaint)paint;
            Color c1 = gPaint.getColor1();
            Color c2 = gPaint.getColor2();
            return new GradientPaint(gPaint.getPoint1(), PlotUtilities.brigther(c1, 20, 0.8), gPaint.getPoint2(), PlotUtilities.brigther(c2, 20, 0.8), gPaint.isCyclic());
        }
        return paint;
    }

    public static Paint getLessBrighter(Paint paint) {
        if (paint.getTransparency() != 1) {
            return paint;
        }
        if (paint instanceof Color) {
            return PlotUtilities.brigther((Color)paint, 10, 0.9);
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gPaint = (GradientPaint)paint;
            Color c1 = gPaint.getColor1();
            Color c2 = gPaint.getColor2();
            return new GradientPaint(gPaint.getPoint1(), PlotUtilities.brigther(c1, 10, 0.9), gPaint.getPoint2(), PlotUtilities.brigther(c2, 10, 0.9), gPaint.isCyclic());
        }
        return paint;
    }
}

