/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigurationManager;
import com.inet.config.internal.PrivateCloudLicenseTimerTask;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ClearReportsStructureProvider
extends AbstractStructureProvider {
    public static final String LICENSE_TYPE_SELECT = "license.generateTrial.select";
    public static final String LICENSE_GENERATE_TRIAL_STANDARD = "license.generateTrial.standard";
    public static final String LICENSE_GENERATE_TRIAL_IP = "license.generateTrial.ip";
    public static final String LICENSE_GENERATE_TRIAL_PLUS = "license.generateTrial.plus";
    public static final String LICENSE_GENERATE_TRIAL_DOMAIN = "license.generateTrial.domain";
    public static final String LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD = "license.generateTrial.cloud";
    public static final String LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD = "license.generateTrial.privatecloud";
    public static final String LICENSE_GENERATE_TRIAL_CLOUD_DESCRIPTION = "license.generateTrial.cloud.description";
    public static final String FQDN = "license.generateTrial.fqdn";
    public static final String DOMAIN_NAME = "license.generateTrial.domain.name";

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.license": {
                propertyGroups.add(new ConfigPropertyGroup(100, "group.license.system", this.translate(settings, "group.license.system", new Object[0])));
                break;
            }
            case "action.generateTrial": {
                propertyGroups.add(new ConfigPropertyGroup(100, "action.generateTrial"));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.license.system": {
                void var9_13;
                boolean bl2 = CoreSystemStructureProvider.isDocker();
                StringBuilder stringBuilder = new StringBuilder();
                for (InetAddress inetAddress : ConfigurationManager.getInstance().getAvailableIPAddresses()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(inetAddress.getHostAddress());
                }
                String string2 = CoreSystemStructureProvider.getPublicDomain();
                if (!bl2) {
                    configProperties.add(new ConfigProperty(100, "license.systeminfo.ips", "KeyLabel", this.translate(settings, "license.systeminfo.ips", new Object[0]), (Object)stringBuilder.toString(), null, null));
                    configProperties.add(new ConfigProperty(200, "license.systeminfo.processors", "KeyLabel", this.translate(settings, "license.systeminfo.processors", new Object[0]), (Object)String.valueOf(Runtime.getRuntime().availableProcessors()), null, null));
                } else {
                    String string = string2 + " (" + CoreSystemStructureProvider.getMessageFromIsDockerMethod() + ")";
                }
                configProperties.add(new ConfigProperty(300, "license.systeminfo.domain", "KeyLabel", this.translate(settings, "license.systeminfo.domain", new Object[0]), (Object)var9_13, null, null));
                break;
            }
            case "action.generateTrial": {
                String string;
                boolean bl3 = CoreSystemStructureProvider.isDocker();
                String string2 = CoreSystemStructureProvider.getPublicDomain();
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                if (!bl3) {
                    arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_STANDARD, this.translate(settings, LICENSE_GENERATE_TRIAL_STANDARD, new Object[0])));
                    arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_PLUS, this.translate(settings, LICENSE_GENERATE_TRIAL_PLUS, new Object[0])));
                    string = LICENSE_GENERATE_TRIAL_PLUS;
                } else {
                    string = LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD;
                }
                arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_DOMAIN, this.translate(settings, LICENSE_GENERATE_TRIAL_DOMAIN, new Object[0])));
                arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD, this.translate(settings, LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD, new Object[0])));
                arrayList.add(new LocalizedKey(LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD, this.translate(settings, LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD, new Object[0])));
                this.addSelectTo(configProperties, LICENSE_TYPE_SELECT, string, null, settings, arrayList);
                InetAddress[] inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses();
                String string3 = "";
                ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
                for (InetAddress inetAddress : inetAddressArray) {
                    String string4 = inetAddress.getHostAddress();
                    if (string3.isEmpty()) {
                        string3 = string4;
                    }
                    arrayList2.add(new LocalizedKey(string4, null));
                }
                configProperties.add(new ConfigProperty(100, LICENSE_GENERATE_TRIAL_PLUS, "KeyLabel", null, (Object)this.translate(settings, "license.generateTrial.plus.description", new Object[0]), null, null));
                this.addSelectTo(configProperties, LICENSE_GENERATE_TRIAL_IP, string3, "SimpleText", settings, arrayList2);
                configProperties.add(new ConfigProperty(300, "license.generateTrial.domain.description", "KeyLabel", null, (Object)this.translate(settings, "license.generateTrial.domain.description", new Object[0]), null, null));
                configProperties.add(new ConfigProperty(400, "license.generateTrial.domain.description2", "KeyLabel", null, (Object)this.translate(settings, "license.generateTrial.domain.description2", new Object[0]), null, null));
                ArrayList arrayList3 = new ArrayList();
                for (String string5 : ConfigKeyParser.getKnownFQDNs()) {
                    arrayList3.add(new LocalizedKey(string5, null));
                }
                this.addSelectTo(configProperties, DOMAIN_NAME, string2, "SimpleText", settings, arrayList3);
                configProperties.add(new ConfigProperty(600, LICENSE_GENERATE_TRIAL_CLOUD_DESCRIPTION, "KeyLabel", null, (Object)this.translate(settings, LICENSE_GENERATE_TRIAL_CLOUD_DESCRIPTION, new Object[0]), null, null));
                configProperties.add(new ConfigProperty(700, FQDN, "SimpleText", this.translate(settings, FQDN, new Object[0]), null, null, null));
                this.addTo(configProperties, ConfigKey.SERVER_URL, settings);
                if (bl3) {
                    configProperties.add(new ConfigProperty(850, "", "KeyLabel", null, (Object)CoreSystemStructureProvider.getMessageFromIsDockerMethod(), null, null));
                }
                configProperties.add(new ConfigProperty(1000, "license.generateTrial.support", "Link", null, (Object)"configmanager?method=license_support_info", null, this.translate(settings, "license.generateTrial.support", new Object[0])));
                break;
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        switch (categoryKey) {
            case "action.generateTrial": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_STANDARD);
                ConfigCondition configCondition2 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_PLUS);
                ConfigCondition configCondition3 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_DOMAIN);
                ConfigCondition configCondition4 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD);
                ConfigCondition configCondition5 = conditionGenerator.createCondition().property(LICENSE_TYPE_SELECT).equals().value((Object)LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD);
                actions.add(conditionGenerator.visibleActionFor(configCondition2, LICENSE_GENERATE_TRIAL_PLUS));
                actions.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().or(new ConfigCondition[]{configCondition, configCondition2}), LICENSE_GENERATE_TRIAL_IP));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, "license.generateTrial.domain.description"));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, "license.generateTrial.domain.description2"));
                actions.add(conditionGenerator.visibleActionFor(configCondition3, DOMAIN_NAME));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, LICENSE_GENERATE_TRIAL_CLOUD_DESCRIPTION));
                actions.add(conditionGenerator.visibleActionFor(configCondition4, FQDN));
                actions.add(conditionGenerator.visibleActionFor(configCondition5, ConfigKey.SERVER_URL));
                break;
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
    }

    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        switch (actionKey) {
            case "action.generateTrial": {
                messages.add(0, new ConfigValidationMsg(ConfigValidationMsg.Type.Popup, null, "action.generateTrial"));
                break;
            }
            case "action.generateTrial.ok": {
                String string = settings.getValue(LICENSE_TYPE_SELECT);
                if (LICENSE_GENERATE_TRIAL_PUBLIC_CLOUD.equals(string)) {
                    String string2 = settings.getValue(FQDN);
                    if (StringFunctions.isEmpty((String)string2)) {
                        throw new ClientMessageException(this.translate(settings, "license.generateTrial.fqdn.error", new Object[0]));
                    }
                } else if (LICENSE_GENERATE_TRIAL_PRIVATE_CLOUD.equals(string)) {
                    URL uRL;
                    String string3 = settings.getValue(ConfigKey.SERVER_URL);
                    if (StringFunctions.isEmpty((String)string3)) {
                        throw new ClientMessageException(this.translate(settings, "license.generateTrial.serverurl.error", new Object[0]));
                    }
                    ConfigValidator configValidator = new ConfigValidator(messages, settings);
                    if (messages.size() > 0) {
                        throw new ClientMessageException(messages.get(0).getMsg());
                    }
                    configValidator.validateHttpURL(ConfigKey.SERVER_URL);
                    try {
                        uRL = new URL(string3);
                        PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)uRL);
                        for (int i2 = 0; i2 < 1000 && PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)uRL) != null; ++i2) {
                            Thread.sleep(1L);
                        }
                    }
                    catch (Exception exception) {
                        throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
                    }
                    String string4 = PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)uRL);
                    if (string4 != null) {
                        throw new ClientMessageException(string4);
                    }
                    settings.save(ConfigKey.SERVER_URL, string3);
                }
                CoreSystemStructureProvider.requestTrialLicense((ConfigStructureSettings)settings);
                break;
            }
        }
    }
}

