/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula;

import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.formula.IFormulaData;
import com.inet.report.formula.j;
import com.inet.report.formula.m;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;

public class FormulaException
extends ReportException {
    private m ais;
    private String ait;
    private int aiu;

    protected FormulaException(String msg, int messageId) {
        super(msg, messageId);
    }

    public FormulaException(String msg, int messageId, m position) {
        super(msg, messageId);
        this.ais = position;
    }

    public FormulaException(ReportException e2, m position) {
        super(e2.getMessage(), e2.getErrorCode());
        super.initCause(e2);
        this.ais = position;
    }

    public static FormulaException create(ReportErrorCode idAsString, m position, Object ... msgParameter) {
        String string = idAsString.name();
        int n2 = idAsString.getErrorCodeNumber();
        string = Msg.getMsg(string, msgParameter);
        FormulaException formulaException = new FormulaException(string, n2);
        formulaException.ais = position;
        return formulaException;
    }

    public int getRow() {
        if (this.ais != null) {
            return this.ais.getLine();
        }
        return -1;
    }

    public int getColumn() {
        if (this.ais != null) {
            return this.ais.getColumn();
        }
        return -1;
    }

    public int getEndRow() {
        if (this.ais != null) {
            return this.ais.qV();
        }
        return -1;
    }

    public int getEndColumn() {
        if (this.ais != null) {
            return this.ais.getEndColumn();
        }
        return -1;
    }

    public int getStartIndex() {
        if (this.ais != null) {
            return this.ais.getStartIndex();
        }
        return -1;
    }

    public int getLength() {
        if (this.ais != null) {
            return this.ais.getLength();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (this.ait != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Msg.getMsg(this.aiu == 0 ? "InFormula" : "InFunction", super.getMessage(), this.ait));
            if (this.ais != null) {
                stringBuilder.append(", ");
                stringBuilder.append(Msg.getMsg("FormulaError.Position", this.ais.getLine() + 1, this.ais.getColumn() + 1));
            }
            return stringBuilder.toString();
        }
        return super.getMessage();
    }

    public void setFormulaField(j formula) {
        if (formula != null) {
            this.setFormulaField(formula.pW());
        }
    }

    public void setFormulaField(IFormulaData formulaField) {
        if (formulaField != null && formulaField.getName() != null) {
            this.ait = formulaField.getName();
            this.aiu = formulaField instanceof FormulaField ? 0 : 1;
        }
    }

    public void setFormulaName(String name) {
        if (this.ait == null) {
            this.ait = name;
        }
    }

    public void setPosition(m position) {
        this.qL();
        this.ais = position;
    }

    public m getPosition() {
        return this.ais;
    }

    protected void qL() {
    }

    public String getCausingFormulaName() {
        return this.ait;
    }
}

