/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.coredata;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.af;
import com.inet.report.ba;
import com.inet.report.cb;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.parser.RFReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CoreData {
    public static final int VERSION = 2;
    public static final String DATA_DIRECTORY = "CoreData";
    public static final String TIMEZONE_ENTRY = "timezone";
    public static final String MAIN_ENTRY = "maindata";
    public static final String SUB_ENTRY_PREFIX = "subdata_";
    public static final String PROPERTIES_SUFFIX = ".properties";
    public static final String SORT_EXECUTED_PROP = "sortExecutedOnDB";
    public static final String USER_PROPERTIES = "user.properties";
    public static final String CORE_DATASOURCE = "Core";
    public static final int TYPE_NULL = 0;
    public static final int TYPE_BOOL = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_BYTE = 4;
    public static final int TYPE_SHORT = 5;
    public static final int TYPE_INT = 6;
    public static final int TYPE_LONG = 7;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_TIME = 9;
    public static final int TYPE_TIMESTAMP = 10;
    public static final int TYPE_DATE = 11;
    public static final int TYPE_BYTE_ARRAY = 12;
    public static final int TYPE_BIGDECIMAL = 14;
    public static final int TYPE_CURRENCY = 16;
    public static final int TYPE_RANGE = 32;

    public static final String getCoreFileKey(ba<?> renderer) {
        int n2 = renderer.getEngine().getReportID();
        if (n2 == 0) {
            return MAIN_ENTRY;
        }
        return SUB_ENTRY_PREFIX + n2 + "_" + Long.toHexString(CoreData.R(renderer));
    }

    public static long toNormalizedLong(double v2, int precision) {
        double d2 = Math.log10(Math.abs(v2));
        if (d2 == Double.NEGATIVE_INFINITY || d2 < -300.0) {
            return 0x100000000L;
        }
        long l2 = (int)Math.ceil(d2) - precision;
        return l2 << 32 | 0xFFFFFFFFL & Math.round(v2 / Math.exp(Math.log(10.0) * (double)l2));
    }

    private static long R(ba<?> ba2) {
        long l2 = 0L;
        long l3 = 2777L;
        PromptField[] promptFieldArray = af.y(ba2);
        for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
            int n2;
            Object[] objectArray;
            Object object;
            PromptField promptField = promptFieldArray[i2];
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[CCcore] Prompt[" + i2 + "]=" + String.valueOf(promptField.getValue()));
            }
            if ((object = promptField.getValue()) instanceof Number) {
                l2 = l2 * 2777L + CoreData.toNormalizedLong(((Number)object).doubleValue(), 8);
                continue;
            }
            if (object instanceof String) {
                objectArray = (Object[])object;
                for (n2 = 0; n2 < objectArray.length(); ++n2) {
                    l2 = l2 * 2777L + (long)objectArray.charAt(n2);
                }
                continue;
            }
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] == null) continue;
                    l2 = l2 * 2777L + (long)objectArray[n2].hashCode();
                }
                continue;
            }
            if (object instanceof Date) {
                l2 = l2 * 2777L + (long)object.toString().hashCode();
                continue;
            }
            if (object == null) continue;
            l2 = l2 * 2777L + (long)object.hashCode();
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCoreDataFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().startsWith(DATA_DIRECTORY)) continue;
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isCoreDataEngine(Engine engine) {
        Properties properties = engine.getUserProperties();
        return properties != null && properties.containsKey("coreDataSourceFile");
    }

    public static void onLoadingReportWithCoreData(Engine engine, RFReader reader, URL url) {
        Properties properties;
        byte[] byArray = reader.getEntryBuffer("CoreData/user.properties");
        if (byArray != null) {
            try {
                int n2;
                Serializable serializable;
                properties = new Properties();
                properties.load(new ByteArrayInputStream(byArray));
                String string = properties.getProperty("subreport_ondemand");
                if (string != null) {
                    serializable = new Properties();
                    cb.b(string, (Properties)serializable, false);
                    ((Properties)serializable).remove("subreport");
                    properties.putAll((Map<?, ?>)((Object)serializable));
                    properties.remove("subreport_ondemand");
                    engine.getArea(1).setSuppress(true);
                    engine.getArea(4).setSuppress(true);
                }
                cb.a(null, engine, properties, null, null, true);
                serializable = new DataSourceConfiguration(CORE_DATASOURCE);
                ((DataSourceConfiguration)serializable).setDatabaseClassname(DatabaseCore.class.getName());
                int n3 = engine.getDatabaseTables().getDatasourceCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    engine.getDatabaseTables().getDatasource(n2).setDataSourceConfiguration((DataSourceConfiguration)serializable);
                }
                n2 = engine.getSubReportCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    DatabaseTables databaseTables = engine.getSubReport(i2).getDatabaseTables();
                    for (int i3 = 0; i3 < databaseTables.getDatasourceCount(); ++i3) {
                        databaseTables.getDatasource(i3).setDataSourceConfiguration((DataSourceConfiguration)serializable);
                    }
                }
            }
            catch (ReportException | IOException exception) {
                BaseUtils.warning(exception);
            }
        }
        try {
            properties = engine.getUserProperties();
            if (properties == null) {
                properties = new Properties();
                engine.setUserProperties(properties);
            }
            properties.setProperty("coreDataSourceFile", url.toString());
        }
        catch (ReportException reportException) {
            BaseUtils.warning(reportException);
        }
    }

    public static void onEngineSavedInDesigner(Engine engine, File tempFile, File targetFile) {
        URI uRI = null;
        try {
            if (engine.getUserProperties() != null) {
                uRI = IOFunctions.getFileURL((String)engine.getUserProperties().getProperty("coreDataSourceFile")).toURI();
            }
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
        }
        if (uRI != null) {
            if (tempFile != null && uRI.equals(targetFile.toURI())) {
                uRI = tempFile.toURI();
            }
            try (FileSystem fileSystem = FileSystems.newFileSystem(Paths.get(uRI), (ClassLoader)null);
                 final FileSystem fileSystem2 = FileSystems.newFileSystem(targetFile.toPath(), (ClassLoader)null);){
                Path path = fileSystem.getPath(DATA_DIRECTORY, new String[0]);
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.a(path);
                    }

                    public FileVisitResult b(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.a(path);
                    }

                    private FileVisitResult a(Path path) throws IOException {
                        Files.copy(path, fileSystem2.getPath(path.toString(), new String[0]), new CopyOption[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.a((Path)object, basicFileAttributes);
                    }

                    @Override
                    public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.b((Path)object, basicFileAttributes);
                    }
                });
            }
            catch (IOException | IllegalArgumentException exception) {
                BaseUtils.warning(exception);
            }
        }
    }

    public static String createTableFileName(String table) {
        return "table_" + table.replaceAll("\\W+", "") + ".columns";
    }

    public static class a
    extends Properties {
        private Map<Object, Object> aca = new LinkedHashMap<Object, Object>();

        @Override
        public synchronized Object put(Object key, Object value) {
            return this.aca.put(key, value);
        }

        @Override
        public synchronized boolean contains(Object value) {
            return this.aca.containsValue(value);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.aca.containsValue(value);
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.aca.entrySet();
        }

        @Override
        public synchronized void clear() {
            this.aca.clear();
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            return this.aca.containsKey(key);
        }
    }
}

