/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.AbstractFontElement;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.Element;
import com.inet.report.FormulaField;
import com.inet.report.HyperlinkProperties;
import com.inet.report.Paragraph;
import com.inet.report.ReferenceHolder;
import com.inet.report.Section;
import com.inet.report.TextProperties;
import com.inet.report.ba;
import com.inet.report.by;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class Text
extends Element
implements BorderProperties,
HyperlinkProperties,
ReferenceHolder,
TextProperties {
    Paragraph[] PN;
    private int qA = 0;
    private int qB;
    private FormulaField qC = null;
    private FormulaField qD = null;

    Text(ba renderer, Section parentSection) {
        super(35, renderer, parentSection);
    }

    public Paragraph addParagraph() {
        return this.insertParagraph(this.getParagraphCount());
    }

    public Paragraph insertParagraph(int pos) {
        Paragraph paragraph = new Paragraph(this);
        paragraph.jE = this.jE;
        paragraph.vZ = new AbstractFontElement[0];
        if (this.PN == null || this.PN.length < 1) {
            this.PN = new Paragraph[1];
            this.PN[0] = paragraph;
        } else {
            Paragraph[] paragraphArray = new Paragraph[this.PN.length + 1];
            System.arraycopy(this.PN, 0, paragraphArray, 0, pos);
            System.arraycopy(this.PN, pos, paragraphArray, pos + 1, paragraphArray.length - pos - 1);
            paragraphArray[pos] = paragraph;
            this.PN = paragraphArray;
        }
        return paragraph;
    }

    public Paragraph getParagraph(int idx) {
        return this.PN[idx];
    }

    public int getParagraphCount() {
        if (this.PN == null) {
            return 0;
        }
        return this.PN.length;
    }

    public void removeParagraph(int idx) {
        if (this.PN == null || this.PN.length <= 0) {
            throw new IndexOutOfBoundsException("remove Paragraph with Index " + idx + " from " + this.PN.length + "is impossible");
        }
        this.PN[idx].resetReferences();
        Paragraph[] paragraphArray = new Paragraph[this.PN.length - 1];
        System.arraycopy(this.PN, 0, paragraphArray, 0, idx);
        System.arraycopy(this.PN, idx + 1, paragraphArray, idx, paragraphArray.length - idx);
        this.PN = paragraphArray;
    }

    public void removeAllParagraphs() {
        this.resetReferences();
        this.PN = new Paragraph[0];
        this.setReferences();
    }

    @Override
    void a(FormulaField formulaField) {
        switch (formulaField.rP) {
            case 1110: {
                this.setGlyphOrientationFormula(formulaField);
                break;
            }
            case 1009: {
                this.setTextRotationFormula(formulaField);
                break;
            }
            default: {
                super.a(formulaField);
            }
        }
    }

    @Override
    public void setReferences() {
        super.setReferences();
        if (this.PN != null && this.PN.length > 0) {
            for (int i2 = 0; i2 < this.PN.length; ++i2) {
                this.PN[i2].setReferences();
            }
        }
    }

    @Override
    public void resetReferences() {
        super.resetReferences();
        if (this.PN != null && this.PN.length > 0) {
            for (int i2 = 0; i2 < this.PN.length; ++i2) {
                this.PN[i2].resetReferences();
            }
        }
    }

    @Override
    public int getGlyphOrientation() {
        return this.qA;
    }

    @Override
    public void setGlyphOrientation(int orientation) {
        by.bV(orientation);
        this.qA = orientation;
    }

    @Override
    public void setGlyphOrientationFormula(FormulaField formula) {
        FormulaField.d(this.qC);
        this.qC = this.a(formula, 1110, "glyph orientation");
    }

    @Override
    public FormulaField getGlyphOrientationFormula() {
        return this.qC;
    }

    @Override
    public void setTextRotation(int rotation) {
        by.bW(rotation);
        this.qB = rotation;
    }

    @Override
    public int getTextRotation() {
        return this.qB;
    }

    @Override
    public FormulaField getTextRotationFormula() {
        return this.qD;
    }

    @Override
    public void setTextRotationFormula(FormulaField formula) {
        FormulaField.d(this.qD);
        this.qD = this.a(formula, 1009, "text rotation");
    }

    @Override
    public void setHorAlign(int value) {
        if (this.PN != null) {
            for (int i2 = 0; i2 < this.PN.length; ++i2) {
                this.PN[i2].setHorAlign(value);
            }
        }
    }

    @Override
    public int getHorAlign() {
        if (this.PN == null || this.PN.length == 0) {
            return 0;
        }
        int n2 = this.PN[0].getHorAlign();
        for (int i2 = 1; i2 < this.PN.length; ++i2) {
            if (this.PN[i2].getHorAlign() == n2) continue;
            return 0;
        }
        return n2;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        XMLTag xMLTag;
        if (group != null) {
            switch (group) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: {
                    NodeParser nodeParser = super.parseElement(group, tag, atts, parserMap);
                    return nodeParser;
                }
                case TextProperties: {
                    if (tag.equals(XMLTag.PropertyFormula.name())) {
                        return super.parseElement(group, tag, atts, parserMap);
                    }
                    by.a((TextProperties)this, tag, atts);
                    return null;
                }
            }
        }
        if ((xMLTag = XMLTag.getValueOf(tag)) == XMLTag.Element) {
            return super.parseElement(group, tag, atts, parserMap);
        }
        return null;
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        printWriter.print(string + "<Element" + k.l("type", "Text") + k.l("count", this.PN == null ? k.G(0) : k.G(this.PN.length)) + this.ck() + ">\n");
        this.b(printWriter, ++n2, Element.mb);
        this.a(printWriter, n2, Element.mb);
        this.r(printWriter, n2);
        by.a((TextProperties)this, printWriter, n2);
        if (this.PN != null) {
            for (int i2 = 0; i2 < this.PN.length; ++i2) {
                this.PN[i2].k(printWriter, n2);
            }
        }
        printWriter.print(string + "</Element>\n");
    }

    void normalize(boolean replacePrompts) {
        int n2 = this.getParagraphCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getParagraph(i2).normalize(replacePrompts);
        }
    }

    public List<Paragraph> getSubComponents() {
        return Arrays.asList(this.PN);
    }
}

