/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.PropertyConstants;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.SQLField;
import com.inet.report.SpecialField;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.cb;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.y;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class SortField
extends Field
implements ReferenceHolder,
Validatable {
    int Na;
    private FormulaField Nb;
    private Number Nc;
    public static final int ASCENDING_ORDER = 0;
    public static final int DESCENDING_ORDER = 1;
    public static final int ORIGINAL_ORDER = 2;
    public static final int ASCENDING_ALPHA_NUMERIC_ORDER = 16;
    public static final int DESCENDING_ALPHA_NUMERIC_ORDER = 17;
    private r qk = new r(this);

    SortField(ba<?> ren) {
        this.bB = ren;
        this.type = 15;
    }

    @Override
    public void setName(String name) throws ReportException {
        Object object;
        this.resetReferences();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a sort field cannot be empty");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        FormulaField formulaField = this.bB.getFields().getFormulaField(name);
        if (formulaField != null && (object = cb.a(formulaField, "sort")) != null) {
            BaseUtils.warning(object);
        }
        if (Fields.a((Field[])this.bB.IC, name)) {
            throw y.b("SortField", name, null);
        }
        object = this.bB.a(true, name);
        if (object == null) {
            throw new IllegalArgumentException("No field with name " + name + " exists. Add it first.");
        }
        this.setField((Field)object);
        this.name = name;
        this.setReferences();
    }

    public void setSort(int sort) {
        if (sort != 2 && sort != 0 && sort != 1 && sort != 16 && sort != 17) {
            throw y.a(sort, "sort", (ErrorCode)ReportErrorCode.wrongParamType);
        }
        this.Na = sort;
    }

    public int getSort() {
        return this.Na;
    }

    public void setSortDirectionFormula(FormulaField formula) throws ReportException {
        FormulaField.d(this.Nb);
        if (formula != null && !formula.isEmpty()) {
            if (formula.getFormulaType() != 3) {
                throw new ReportException("Wrong type of formula. Only type FormulaField.FORMULA_PROPERTY is permitted.", 0);
            }
            formula.setReferences();
            if (cb.a(formula, DatabaseField.class, false) || cb.a(formula, SQLField.class, false) || cb.a(formula, SpecialField.class, false)) {
                formula.resetReferences();
                throw new ReportException("Wrong formula. Sort Direction formula must not contains DatabaseFields, SQLFields or SpecialFields.", 0);
            }
        }
        this.Nb = formula != null && formula.isEmpty() ? null : formula;
        this.Nc = null;
        if (this.Nb != null) {
            this.Nb.setReferences();
        }
    }

    int kj() {
        if (this.Nc == null) {
            try {
                this.Nc = (Number)this.Nb.a(null, this.Nc);
            }
            catch (Exception exception) {
                BaseUtils.error("Wrong Sort Formula for SortField: " + String.valueOf(this.getField()));
                this.Nc = new Integer(this.Na);
            }
            if (this.Nc == null) {
                BaseUtils.error("Sort Direction Formula from SortField: " + String.valueOf(this.getField()) + " returns null.");
                this.Nc = new Integer(this.Na);
            }
            if (this.Nc.intValue() < 0 || this.Nc.intValue() > 2) {
                BaseUtils.error("Wrong value: " + this.Nc.intValue() + " of Sort Direction Formula from SortField: " + String.valueOf(this.getField()) + ". Allowed values see SortField.");
                this.Nc = new Integer(this.Na);
            }
        }
        return this.Nc.intValue();
    }

    public FormulaField getSortDirectionFormula() {
        return PropertyConstants.setPropertyDefault(this.Nb, this.getSort(), 6);
    }

    @Override
    Field[] K(int n2) {
        return new SortField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, "Operation", k.G(this.Na));
        if (this.Nb != null) {
            this.Nb.a(stringBuilder, n2, "SortDirectionFormula");
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    final void a(int n2, String string, at at2) {
        switch (n2) {
            case 176: {
                this.Na = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, at2);
            }
        }
    }

    @Override
    void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        super.changeAllAliases(oldAlias, newAlias, dc);
        if (this.Nb != null) {
            this.Nb.a(oldAlias, newAlias, dc);
        }
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qk.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qk.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qk.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qk.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qk.removeReferencedObject(reference);
    }

    @Override
    public final void setReferences() {
        try {
            Field field = this.getField();
            if (field == null) {
                field = this.bB.a(false, this.name);
                this.setField(field);
            }
            if (field == null) {
                return;
            }
            field.addReferenceHolder(this);
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        if (this.Nb != null) {
            this.Nb.setReferences();
        }
    }

    @Override
    public final void resetReferences() {
        this.qk.resetReferences();
        if (this.Nb != null) {
            this.Nb.resetReferences();
        }
    }

    @Override
    public boolean isUsed() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SortField && super.equals(obj) && this.Na == ((SortField)obj).Na;
    }

    @Override
    public int getValueType() {
        if (this.getField() == null) {
            return -1;
        }
        return this.getField().getValueType();
    }

    public void updateName() {
        this.name = this.getField().getRefName();
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            switch (a.ao(tag)) {
                case Ne: {
                    this.setField(Fields.b(atts, this.bB));
                    break;
                }
                case Nf: {
                    if (this.name == null) {
                        this.name = atts.getValue("value");
                    }
                    break;
                }
                case Ng: {
                    this.setSort(Integer.valueOf(atts.getValue("value")));
                    break;
                }
                case Ni: {
                    try {
                        FormulaField formulaField = new FormulaField(this.bB);
                        formulaField.setFormulaType(3);
                        formulaField.F("0");
                        String string = atts.getValue("propertyType");
                        if (string != null) {
                            formulaField.rP = PropertyConstants.toToken(string);
                        }
                        this.setSortDirectionFormula(formulaField);
                        formulaField.F("");
                        return formulaField;
                    }
                    catch (Exception exception) {
                        BaseUtils.error(exception);
                        return null;
                    }
                }
                default: {
                    return super.parseElement(group, tag, atts, parserMap);
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public Validity validate() {
        if (this.getField() == null) {
            return new Validity(Validity.States.ERROR, y.a("valueType", null));
        }
        if (this.getField() instanceof Validatable) {
            Validity validity = ((Validatable)((Object)this.getField())).validate();
            if (validity.hasState(Validity.States.ERROR, Validity.States.DEPENDING_ERROR)) {
                return new Validity(Validity.States.DEPENDING_ERROR, validity.getErrorData());
            }
        }
        return new Validity(Validity.States.VALID, null);
    }

    @Override
    Object getValue() throws ReportException {
        return null;
    }

    private static enum a {
        Ne,
        Nf,
        Ng,
        Nh,
        Ni;

        private static HashMap<String, a> gF;

        private static a ao(String string) {
            a a2 = gF.get(string);
            if (a2 == null) {
                a2 = Nh;
            }
            return a2;
        }

        static {
            gF = new HashMap();
            gF.put("Reference", Ne);
            gF.put("Name", Nf);
            gF.put("Operation", Ng);
            gF.put("PropertyFormula", Ni);
        }
    }
}

