/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportComponent;
import com.inet.report.Section;
import com.inet.report.SignatureProperties;
import com.inet.report.certificate.CertificateInfo;
import com.inet.report.certificate.CertificateInfoFactory;
import com.inet.report.i18n.Msg;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.xml.sax.Attributes;

@PublicApi
public class SignatureForm
extends Element
implements BorderProperties,
SignatureProperties {
    public static final int INSET_LEFT = 20;
    public static final int INSET_RIGHT = 20;
    public static final int INSET_TOP = 40;
    public static final int INSET_BOTTOM = 20;
    private String Mp;
    private String Mq;
    private String Mr;
    private String Ms;
    private String Mt;
    private String Mu;
    private String Mv;
    private Date Mw;
    private Date Mx;
    private String My;
    private String Mz;
    private boolean MA;
    private boolean MB;
    private int MC;
    private boolean MD;
    private boolean ME;
    private boolean MF;
    private boolean MG;
    private boolean MH;
    private boolean MI;

    SignatureForm(Engine engine, Section parentSection) {
        super(70, engine.bT(), parentSection);
        this.jY();
    }

    void dx() {
        CertificateInfoFactory certificateInfoFactory = RDC.getCertificateFactory();
        if (certificateInfoFactory == null) {
            throw new IllegalStateException("signature parameters are not defined: please define ceritifate info factory");
        }
        CertificateInfo certificateInfo = certificateInfoFactory.getCertificateInfo(this.getEngine());
        Certificate certificate = certificateInfo.getCertificate();
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            this.Mw = x509Certificate.getNotBefore();
            this.Mx = x509Certificate.getNotAfter();
            this.Mt = x500Principal2.getName();
            this.Mv = x500Principal.getName();
            if (this.Mv != null) {
                int n2 = this.Mv.indexOf("CN=");
                if (n2 == -1 && ((n2 = this.Mv.indexOf("cn=")) == -1 || n2 + "CN=".length() >= this.Mv.length())) {
                    if (BaseUtils.isWarning()) {
                        BaseUtils.warning("pdf signature: common name is not defined in the certificate");
                    }
                    this.Mu = "";
                    return;
                }
                int n3 = this.Mv.indexOf(44, n2);
                if (n3 == -1) {
                    n3 = this.Mv.length();
                }
                this.Mu = this.Mv.substring(n2 + "CN=".length(), n3);
            } else {
                this.Mu = "";
            }
        }
    }

    @Override
    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        printWriter.print(string + "<Element" + k.l("type", Element.c.nC.name()) + this.ck() + ">\n");
        this.b(printWriter, ++n2, Element.mb);
        this.a(printWriter, n2, Element.mb);
        this.r(printWriter, n2);
        this.y(printWriter, n2);
        printWriter.print(string + "</Element>\n");
    }

    final void y(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, ++n2, a.ML.name(), k.h(this.getDivideField()));
        k.a(stringBuilder, n2, a.MN.name(), k.h(this.getShowSubjectName()));
        k.a(stringBuilder, n2, a.MM.name(), k.h(this.getWriteCertificateLabels()));
        k.a(stringBuilder, n2, a.MO.name(), k.h(this.getWriteCertificateSubjectName()));
        k.a(stringBuilder, n2, a.MP.name(), k.h(this.getWriteCertificateDistinguishedName()));
        k.a(stringBuilder, n2, a.MQ.name(), k.h(this.getWriteCertificateLocation()));
        k.a(stringBuilder, n2, a.MR.name(), k.h(this.getWriteCertificateReason()));
        k.a(stringBuilder, n2, a.MS.name(), k.h(this.getWriteCertificateDate()));
        k.a(stringBuilder, n2, a.MT.name(), k.G(this.getTextPosition()));
        if (stringBuilder.length() > 0) {
            printWriter.print(string + "<" + XMLTag.SignatureFormProperties.name() + ">\n");
            printWriter.print(stringBuilder.toString());
            printWriter.print(string + "</" + XMLTag.SignatureFormProperties.name() + ">\n");
        }
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        if (group != null) {
            switch (group) {
                case CommonProperties: 
                case BorderProperties: 
                case HyperlinkProperties: {
                    NodeParser nodeParser = super.parseElement(group, tag, atts, parserMap);
                    return nodeParser;
                }
                case SignatureFormProperties: {
                    String string = atts.getValue("value");
                    if (string == null) {
                        return null;
                    }
                    try {
                        this.t(tag, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return null;
        }
        NodeParser nodeParser = null;
        XMLTag xMLTag = XMLTag.getValueOf(tag);
        switch (xMLTag) {
            // Empty switch
        }
        return nodeParser;
    }

    private void t(String string, String string2) {
        a a2 = a.MK;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case ML: {
                this.MA = Boolean.valueOf(string2);
                break;
            }
            case MN: {
                this.MB = Boolean.valueOf(string2);
                break;
            }
            case MO: {
                this.MI = Boolean.valueOf(string2);
                break;
            }
            case MP: {
                this.ME = Boolean.valueOf(string2);
                break;
            }
            case MQ: {
                this.MG = Boolean.valueOf(string2);
                break;
            }
            case MR: {
                this.MH = Boolean.valueOf(string2);
                break;
            }
            case MM: {
                this.MF = Boolean.valueOf(string2);
                break;
            }
            case MS: {
                this.MD = Boolean.valueOf(string2);
                break;
            }
            case MT: {
                this.setTextPosition(Integer.parseInt(string2));
            }
        }
    }

    @Override
    public boolean getDivideField() {
        return this.MA;
    }

    @Override
    public boolean getShowSubjectName() {
        return this.MB;
    }

    @Override
    public int getTextPosition() {
        return this.MC;
    }

    @Override
    public boolean getWriteCertificateDate() {
        return this.MD;
    }

    @Override
    public boolean getWriteCertificateDistinguishedName() {
        return this.ME;
    }

    @Override
    public boolean getWriteCertificateLabels() {
        return this.MF;
    }

    @Override
    public boolean getWriteCertificateLocation() {
        return this.MG;
    }

    @Override
    public boolean getWriteCertificateReason() {
        return this.MH;
    }

    @Override
    public boolean getWriteCertificateSubjectName() {
        return this.MI;
    }

    @Override
    public void setDivideField(boolean val) {
        this.MA = val;
    }

    @Override
    public void setShowSubjectName(boolean val) {
        this.MB = val;
    }

    @Override
    public void setTextPosition(int pos) {
        this.MC = 1;
        if (pos == 0) {
            this.MC = pos;
        }
    }

    @Override
    public void setWriteCertificateDate(boolean val) {
        this.MD = val;
    }

    @Override
    public void setWriteCertificateDistinguishedName(boolean val) {
        this.ME = val;
    }

    @Override
    public void setWriteCertificateLabels(boolean val) {
        this.MF = val;
    }

    @Override
    public void setWriteCertificateLocation(boolean val) {
        this.MG = val;
    }

    @Override
    public void setWriteCertificateReason(boolean val) {
        this.MH = val;
    }

    @Override
    public void setWriteCertificateSubjectName(boolean val) {
        this.MI = val;
    }

    private void jY() {
        this.Mp = Msg.getMsg(this.bB.Jf, "ExportSignSignedby", new Object[0]);
        this.Mq = Msg.getMsg(this.bB.Jf, "ExportSignReason", new Object[0]) + " ";
        this.Mr = Msg.getMsg(this.bB.Jf, "ExportSignLocation", new Object[0]) + " ";
        this.Ms = Msg.getMsg(this.bB.Jf, "ExportSignSignDate", new Object[0]) + " ";
    }

    String jZ() {
        return this.Mu;
    }

    String ka() {
        return this.Mv;
    }

    String kb() {
        return this.My;
    }

    String kc() {
        return this.Mz;
    }

    String kd() {
        return this.Mp;
    }

    String ke() {
        return this.Mq;
    }

    String kf() {
        return this.Mr;
    }

    String kg() {
        return this.Ms;
    }

    @Override
    public List<? extends ReportComponent> getSubComponents() {
        return null;
    }

    public static enum a {
        MK,
        ML,
        MM,
        MN,
        MO,
        MP,
        MQ,
        MR,
        MS,
        MT;

    }
}

