/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.logging.LogManager;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingSource;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.HasCascadingParent;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.SQLValueProvider;
import com.inet.report.database.DataFactory;
import com.inet.report.database.sql.PromptPlaceholderReplacer;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class QueryValueProvider
extends SQLValueProvider
implements CascadingSource,
HasCascadingParent {
    private PromptField hz;
    private String zX;
    private Datasource qV;
    private String zY;

    public QueryValueProvider(String query, Datasource datasource) {
        if (query == null) {
            throw new IllegalArgumentException("query was null");
        }
        if (datasource == null) {
            throw new IllegalArgumentException("datasource was null");
        }
        this.zX = query;
        this.qV = datasource;
    }

    QueryValueProvider() {
    }

    public void setDatasource(Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource was null");
        }
        this.qV = datasource;
    }

    @Override
    public Datasource getDatasource() {
        return this.qV;
    }

    @Deprecated
    public void setSQL(String query) {
        LogManager.deprecatedMessage();
        this.setQuery(query);
    }

    public void setQuery(String query) {
        if (query == null) {
            throw new IllegalArgumentException("query was null");
        }
        this.zX = query;
    }

    public String getQuery() {
        return this.zX;
    }

    @Override
    public String getSQL() throws ReportException {
        Datasource datasource = this.getDatasource();
        DataFactory dataFactory = datasource.getDataFactory();
        SqlSyntax sqlSyntax = dataFactory.getSqlSyntax();
        return new PromptPlaceholderReplacer(sqlSyntax).replace(this.zX, datasource.getEngine().bB.getFields());
    }

    @Override
    public String getFieldRefName() {
        return this.zY;
    }

    public void setFieldRefName(String refName) {
        this.zY = refName;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        Engine engine = (Engine)parserMap.get(PromptField.b.zM.name());
        String string = atts.getValue("value");
        switch (a.valueOf(tag)) {
            case Ac: {
                try {
                    int n2 = engine.getDatabaseTables().getDatasourceCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Datasource datasource = engine.getDatabaseTables().getDatasource(i2);
                        if (!datasource.getDataSourceConfigurationName().equals(string)) continue;
                        this.setDatasource(datasource);
                        return null;
                    }
                    break;
                }
                catch (ReportException reportException) {
                    BaseUtils.printStackTrace(reportException);
                    break;
                }
            }
            case Aa: {
                this.setQuery(string);
                break;
            }
            case Ab: {
                this.setFieldRefName(string);
                break;
            }
            case Ae: {
                String string2 = atts.getValue("name");
                if (!"cascading parent".equals(string2)) break;
                try {
                    String string3 = atts.getValue("value");
                    Field field = engine.bT().a(false, string3);
                    PromptField promptField = (PromptField)field;
                    this.setParent(promptField);
                    break;
                }
                catch (ReportException reportException) {
                    BaseUtils.error(reportException);
                }
            }
        }
        return null;
    }

    @Override
    public PromptField getParent() {
        return this.hz;
    }

    @Override
    public void setParent(PromptField parent) {
        this.hz = parent;
    }

    private static enum a {
        Aa,
        Ab,
        Ac,
        Ad,
        Ae;

    }
}

