/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.HasErrorCode;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.cache.Cache;
import com.inet.report.cb;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.java.e;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.ClearReportsUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.archive.search.SearchHandler;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@PublicApi
public class EngineRenderData
implements RenderData {
    private final Properties hr = new Properties();
    private Properties hu;
    private final Hashtable oM = new Hashtable();
    private String url = null;
    private boolean hy;
    protected boolean isRefresh = true;
    private String hv;
    private int hx = 1;
    private PropertiesChecker oN;
    private ZipOutputStream oO;
    private a oP;

    public EngineRenderData(String props) {
        cb.kG();
        this.setReportLocation(props);
        this.oN = new PropertiesChecker(){

            @Override
            public void checkHtmlPageProperties(Properties prop) throws ReportException {
            }

            @Override
            public void checkProperties(Properties prop, Object req) throws ReportException {
            }

            @Override
            public void checkProperties(Engine engine, Properties prop, Object req) throws ReportException {
            }
        };
    }

    @Override
    public void setReportLocation(String location) {
        this.hr.clear();
        this.hr.put("export_fmt", "java");
        cb.b(location, this.hr, false);
        try {
            ReportKeyFactory.decodeProps(this.hr);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + String.valueOf(throwable));
        }
        this.url = location;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    public void clearEngineCache() {
        this.oM.clear();
    }

    protected Engine createEngine(Properties props) throws ReportException {
        Engine engine = new Engine(props.getProperty("export_fmt"));
        this.setEngineParams(engine, props);
        return engine;
    }

    protected String getKey(Properties props) throws ReportException {
        if (this.isRefresh && this.isPromptOnRefresh()) {
            this.isRefresh = false;
            props.put("promptonrefresh", "1");
        } else {
            props.put("promptonrefresh", "0");
        }
        this.oN.checkProperties(props, null);
        return ReportKeyFactory.a(props).toString();
    }

    protected Engine getEngine(String key) {
        return (Engine)this.oM.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Engine checkEngine(Properties props) throws ReportException {
        Hashtable hashtable = this.oM;
        synchronized (hashtable) {
            boolean bl2 = this.isRefresh;
            String string = this.getKey(props);
            Engine engine = (Engine)this.oM.get(string);
            if (engine != null) {
                return engine;
            }
            BaseUtils.info("new engine: " + string);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("props: " + String.valueOf(props));
            }
            engine = this.createEngine(props);
            if (bl2) {
                cb.j(engine).gE().jx();
            }
            engine.execute();
            this.oM.put(string, engine);
            return engine;
        }
    }

    protected Engine setEngineParams(Engine engine, Properties props) {
        return this.setEngineParams(engine, props, false);
    }

    protected Engine setEngineParams(Engine engine, Properties props, boolean rdc) {
        try {
            props = (Properties)props.clone();
            cb.a(null, engine, props, this.oN, null, rdc);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ReportException && ((ReportException)throwable).getErrorCode() == ReportErrorCode.FeatureForbidden.getErrorCodeNumber()) {
                throw this.a(throwable, props);
            }
            BaseUtils.printStackTrace(throwable);
            try {
                if (engine.getArea(0) == null) {
                    throw this.a(throwable, props);
                }
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
            }
            Properties properties = new Properties();
            for (String string : props.keySet()) {
                if (string.startsWith("prompt") && !string.equalsIgnoreCase("promptonrefresh")) continue;
                properties.put(string, props.get(string));
            }
            try {
                engine.getArea(0);
                cb.a(null, engine, properties, this.oN, null, true);
            }
            catch (Throwable throwable2) {
                BaseUtils.printStackTrace(throwable2);
                throw this.a("Could not set engine properties, please check URL.\n" + throwable2.getMessage(), throwable2, props);
            }
        }
        return engine;
    }

    public void setPropertiesChecker(PropertiesChecker propChecker) {
        if (propChecker == null) {
            throw new IllegalArgumentException();
        }
        this.oN = propChecker;
    }

    public PropertiesChecker getPropertiesChecker() {
        return this.oN;
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.hr);
            return engine.getPageData(page);
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hr);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.hr);
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hr);
        }
    }

    @Override
    public boolean isPageLimitExceeded() throws ViewerException {
        try {
            Engine engine = this.getEngine(this.getKey(this.hr));
            return engine != null && engine.isPageLimitExceeded();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hr);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string;
            Engine engine = this.checkEngine(this.hu);
            switch (string = this.hu.getProperty("export_fmt")) {
                case "svg": {
                    if (this.hx == 0) {
                        ++this.hx;
                        String string2 = this.hu.getProperty("file");
                        string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                        int n2 = SVGUtils.getAutoRefresh(this.hu);
                        return SVGUtils.getSvgViewerPackage(engine.nR.getPageCount(), true, string2, n2);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    RenderDataUtils.writeFileData(byteArrayOutputStream, this.hx + ".svg", engine.getPageData(this.hx++));
                    return byteArrayOutputStream.toByteArray();
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    if (this.oP == null) break;
                    int n3 = engine.getPageCount();
                    while (this.oP.cF() == 0 && this.hx <= n3) {
                        ZipEntry zipEntry = new ZipEntry(this.hx + "." + string);
                        this.oO.putNextEntry(zipEntry);
                        this.oO.write(engine.getPageData(this.hx++));
                        this.oO.closeEntry();
                    }
                    if (this.hx > n3 && this.oO != null) {
                        this.oO.close();
                        this.oO = null;
                    }
                    return this.oP.cG();
                }
            }
            if (this.hx > 0) {
                return engine.getPageData(this.hx++);
            }
            if (this.hx == 0) {
                ++this.hx;
                return engine.getGroupTree();
            }
            ++this.hx;
            if (string.startsWith("htm")) {
                String string3 = this.hu.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, string3, RenderDataUtils.getHtmlViewerData());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hu);
        }
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        try {
            String string;
            this.hu = cb.a(this.hr, expProps);
            Engine engine = this.checkEngine(this.hu);
            switch (string = expProps.getProperty("export_fmt")) {
                case "svg": {
                    this.hx = 0;
                    return engine.getPageCount() + 1;
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    int n2 = engine.getPageCount();
                    if (n2 > 1) {
                        this.hx = 1;
                        this.oP = new a();
                        this.oO = new ZipOutputStream(new BufferedOutputStream(this.oP, 4096));
                        return 0;
                    }
                    this.oP = null;
                }
            }
            if (string.startsWith("htm")) {
                this.hx = -1;
                return engine.getPageCount() + 2;
            }
            this.hx = 1;
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hu);
        }
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.hr);
            return engine.getGroupTree();
        }
        catch (Exception exception) {
            throw this.a(exception, this.hr);
        }
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        this.isRefresh = true;
        this.oM.clear();
        return this.getPageData(page);
    }

    @Override
    public void setReportProperty(String key, String value) {
        if (value == null) {
            this.hr.remove(key);
        } else {
            this.hr.setProperty(key, value);
        }
    }

    @Override
    public final String getReportProperty(String key) {
        return this.hr.getProperty(key);
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.hy = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hy;
    }

    private ViewerException a(Throwable throwable, Properties properties) {
        return this.a(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable), throwable, properties);
    }

    private ViewerException a(String string, Throwable throwable, Properties properties) {
        int n2;
        if (throwable instanceof PromptRequestWarning) {
            Prompt[] promptArray = ((PromptRequestWarning)throwable).getPrompts();
            PromptData[] promptDataArray = new PromptData[promptArray.length];
            for (int i2 = 0; i2 < promptArray.length; ++i2) {
                Prompt prompt = promptArray[i2];
                promptDataArray[i2] = promptArray[i2].isNotUsed() ? new PromptData(true) : new PromptData(prompt.getName(), prompt.getDisplayName(), prompt.getSubreportName(), prompt.getPromptText(), prompt.getDefaultValues(), prompt.getDescs(), prompt.getValueTypeNewProt(), prompt.isDiscrete(), prompt.isRange(), prompt.isMulti(), prompt.isEditable(), prompt.isOnlyDescs(), prompt.isInformixPrompt(), prompt.getEditMask(), prompt.getMinValue(), prompt.getMaxValue());
                promptDataArray[i2].setCascadingParent(prompt.getCascadingParent());
            }
            return new ViewerException(promptDataArray);
        }
        if (throwable instanceof ViewerException) {
            return (ViewerException)throwable;
        }
        int n3 = 0;
        Cache cache = Cache.getCache();
        int n4 = n2 = cache != null ? cache.getType() : -1;
        if (throwable instanceof HasErrorCode) {
            n3 = ((HasErrorCode)throwable).getErrorCode();
        }
        return new ViewerException(n3, string, properties.getProperty("export_fmt"), Engine.getVersion(), System.getProperty("java.version", "") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"), System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""), n2, "2.1", throwable, ClearReportsUtils.getSupportEmail());
    }

    @Override
    public void setReportTitle(String title) {
        this.hv = title;
    }

    @Override
    public String getReportTitle() {
        return this.hv;
    }

    @Override
    public RenderData getCopy() {
        EngineRenderData engineRenderData = new EngineRenderData(this.url);
        engineRenderData.getProperties().putAll((Map<?, ?>)this.getProperties());
        engineRenderData.isRefresh = this.isRefresh;
        return engineRenderData;
    }

    @Override
    public Properties getProperties() {
        return this.hr;
    }

    @Override
    public void stop() {
        Enumeration enumeration = this.oM.elements();
        while (enumeration.hasMoreElements()) {
            Engine engine = (Engine)enumeration.nextElement();
            if (engine == null) continue;
            engine.stop("API call EngineRenderData.stop()");
        }
        this.oM.clear();
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        try {
            return new SearchHandler(this).search(phrase, startPage, flags);
        }
        catch (ViewerException viewerException) {
            return e.getErrorData(viewerException, this.hr);
        }
    }

    @Override
    public byte[] getFontData(int fontID) {
        try {
            Engine engine = this.checkEngine(this.hr);
            return engine.getFontData(fontID);
        }
        catch (ReportException reportException) {
            return e.getErrorData(reportException, this.hr);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        throw new ViewerException("resetting does not work for EngineRenderData. You should not see this error.");
    }

    private static class a
    extends OutputStream {
        private final ArrayList<byte[]> oR = new ArrayList();

        private a() {
        }

        @Override
        public void write(int b2) throws IOException {
            this.oR.add(new byte[]{(byte)b2});
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            byte[] byArray = new byte[len];
            System.arraycopy(b2, off, byArray, 0, len);
            this.oR.add(byArray);
        }

        int cF() {
            return this.oR.size();
        }

        byte[] cG() {
            if (this.oR.size() > 0) {
                return this.oR.remove(0);
            }
            return null;
        }
    }
}

