/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.font.FontPool;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.list.StringList;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseInformix;
import com.inet.report.DatabaseReportData;
import com.inet.report.DatabaseSetData;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Element;
import com.inet.report.EngineStatistics;
import com.inet.report.EngineStatus;
import com.inet.report.FacturXSettings;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.FormulaRange;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.HasCascadingParent;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.RDC;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.ReportProperties;
import com.inet.report.SQLField;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.Subreport;
import com.inet.report.SubreportLink;
import com.inet.report.SummaryField;
import com.inet.report.SummaryInfo;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.Trigger;
import com.inet.report.as;
import com.inet.report.at;
import com.inet.report.av;
import com.inet.report.ba;
import com.inet.report.bb;
import com.inet.report.bc;
import com.inet.report.bd;
import com.inet.report.be;
import com.inet.report.bf;
import com.inet.report.bg;
import com.inet.report.bh;
import com.inet.report.bi;
import com.inet.report.bj;
import com.inet.report.cb;
import com.inet.report.config.LicenseKeyInfo;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.DataSourceConfigurationXMLFileStore;
import com.inet.report.database.DataFactory;
import com.inet.report.database.coredata.CoreData;
import com.inet.report.database.coredata.d;
import com.inet.report.event.ClippingListener;
import com.inet.report.event.EngineFinishEvent;
import com.inet.report.event.EngineFinishListener;
import com.inet.report.event.EngineStartedListener;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.FormulaException;
import com.inet.report.formula.debug.GenericBreakPointProvider;
import com.inet.report.formula.o;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.RFReader;
import com.inet.report.parser.XMLTag;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.base.j;
import com.inet.report.renderer.doc.controller.ar;
import com.inet.report.renderer.doc.controller.h;
import com.inet.report.renderer.factur.model.ProfileLevel;
import com.inet.report.rowsource.l;
import com.inet.report.statistic.Accumulator;
import com.inet.report.translation.Translations;
import com.inet.report.translation.e;
import com.inet.report.util.EngineUtils;
import com.inet.report.util.PromptUtils;
import com.inet.shared.utils.Version;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public class Engine
implements ReportGenerator,
NodeParser,
Serializable {
    public static final String AREA_TYPE_REPORT_HEADER = "RH";
    public static final String AREA_TYPE_PAGE_HEADER = "PH";
    public static final String AREA_TYPE_GROUP_HEADER_PREFIX = "GH";
    public static final String AREA_TYPE_DETAIL = "D";
    public static final String AREA_TYPE_GROUP_FOOTER_PREFIX = "GF";
    public static final String AREA_TYPE_REPORT_FOOTER = "RF";
    public static final String AREA_TYPE_PAGE_FOOTER = "PF";
    private transient a nN = new a();
    int nO;
    protected int d = -1;
    transient Throwable nP;
    private String nQ;
    ba bB;
    DocumentOutput nR;
    boolean nS;
    private final boolean nT;
    boolean nU;
    private Properties nV;
    private boolean nW;
    final Object nX = new Integer(0);
    transient ArrayList<Exception> nY;
    transient RDC.MsgListener nZ;
    final String oa;
    public static final int REPORT_HEADER = 0;
    public static final int PAGE_HEADER = 1;
    public static final int DETAILS = 2;
    public static final int REPORT_FOOTER = 3;
    public static final int PAGE_FOOTER = 4;
    public static final String NO_EXPORT = "java";
    public static final String EXPORT_PDF = "pdf";
    public static final String EXPORT_RTF = "rtf";
    public static final String EXPORT_HTML = "htm";
    public static final String EXPORT_HTML_ZIP = "htm.zip";
    public static final String EXPORT_XLS = "xls";
    public static final String EXPORT_XLSX = "xlsx";
    public static final String EXPORT_XML = "xml";
    public static final String EXPORT_TXT = "txt";
    public static final String EXPORT_CSV = "csv";
    public static final String EXPORT_PS = "ps";
    public static final String EXPORT_PS2 = "ps2";
    public static final String EXPORT_PS3 = "ps3";
    public static final String EXPORT_DATA = "data";
    public static final String EXPORT_JSON = "json";
    public static final String EXPORT_SVG = "svg";
    public static final String EXPORT_JRA = "jra";
    public static final String EXPORT_JAR = "jar";
    public static final String EXPORT_PNG = "png";
    public static final String EXPORT_GIF = "gif";
    public static final String EXPORT_JPG = "jpg";
    public static final String EXPORT_JPEG = "jpeg";
    public static final String EXPORT_BMP = "bmp";
    public static final String EXPORT_ODS = "ods";
    public static final String EXPORT_EMAIL = "email";
    public static final String EXPORT_DOCX = "docx";
    private Hashtable ob;
    private static Map<Engine, ?> oc = Collections.synchronizedMap(new WeakHashMap());
    private static List od;
    private transient ArrayList<EngineFinishListener> oe;
    private Properties of = new Properties();
    private Trigger og;
    private final j oh;
    boolean oi = true;
    public static final int LOG_STATUS = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARN = 3;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    int oj;
    int ok;
    long ol;
    private EngineStatus om;
    private int on = 0;
    private transient ArrayList oo;

    public Engine(String export_fmt) throws ReportException {
        String string;
        this.co();
        this.nT = false;
        if (export_fmt == null || export_fmt.length() == 0) {
            export_fmt = NO_EXPORT;
        }
        switch (string = export_fmt.toLowerCase()) {
            case "jpeg": {
                string = EXPORT_JPG;
            }
            case "java": 
            case "pdf": 
            case "ods": 
            case "htm.zip": 
            case "rtf": 
            case "txt": 
            case "xlsx": 
            case "png": 
            case "gif": 
            case "jpg": 
            case "bmp": 
            case "factur": 
            case "email": 
            case "docx": {
                this.bB = new ar(string);
                this.bB.f(this);
                this.oa = string;
                break;
            }
            case "ps": 
            case "ps2": 
            case "ps3": {
                this.bB = new ar(string);
                this.bB.f(this);
                this.oa = EXPORT_PS;
                break;
            }
            case "csv": 
            case "csv,": 
            case "csv;": {
                if (string.length() > 3) {
                    String string2 = string.substring(3, string.length());
                    this.bB = new bb(this, string2);
                } else {
                    this.bB = new bb(this);
                }
                this.oa = EXPORT_CSV;
                break;
            }
            case "xls": {
                this.bB = new bg(this);
                this.oa = EXPORT_XLS;
                break;
            }
            case "xml": {
                this.bB = new bh(this);
                this.oa = EXPORT_XML;
                break;
            }
            case "data": {
                this.bB = new bc(this);
                this.oa = EXPORT_DATA;
                break;
            }
            case "json": {
                this.bB = new bd(this);
                this.oa = EXPORT_JSON;
                break;
            }
            case "svg": {
                this.bB = new be(this);
                this.oa = EXPORT_SVG;
                break;
            }
            case "database_report_data": {
                this.bB = new DatabaseReportData.b(this);
                this.oa = EXPORT_DATA;
                break;
            }
            default: {
                if (string.startsWith(EXPORT_HTML)) {
                    String string3 = export_fmt.substring(3);
                    this.bB = new ar(string);
                    this.bB.f(this);
                    this.oa = EXPORT_HTML + string3;
                    break;
                }
                throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidOutFmt, export_fmt);
            }
        }
        this.oh = this.bB.gP();
    }

    Engine(@Nonnull h writerFactory, o references) {
        this.co();
        this.nT = false;
        this.bB = new ar(writerFactory, references);
        this.bB.f(this);
        this.oa = writerFactory.getFormat();
        this.oh = this.bB.gP();
    }

    Engine(ba renderer) {
        this.co();
        this.bB = renderer;
        this.oh = renderer.gP();
        this.oa = ((bi)renderer.gy()).getEngine().oa;
        this.nT = true;
    }

    private void co() {
        cb.kG();
        this.om = new EngineStatus();
    }

    public static synchronized void shutdown() {
        cb.kF();
    }

    public int getRecordCount() {
        return this.d;
    }

    @Override
    public void setDocumentOutput(DocumentOutput pages) {
        if (pages != null) {
            this.nR = pages;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.registerValidation(new ObjectInputValidation(){

            @Override
            public void validateObject() throws InvalidObjectException {
                try {
                    if (Engine.this.bB != null && Engine.this.bB.gH == 0) {
                        Engine.this.S(0);
                        Engine.this.cA();
                    }
                }
                catch (ReportException reportException) {
                    BaseUtils.error(reportException);
                }
            }
        }, 0);
        in.defaultReadObject();
    }

    private void cp() throws ReportException {
        if (this.bB == null || this.nS) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.EngineIsFinished, new Object[0]);
        }
    }

    void cq() throws ReportException {
        this.cp();
        if (this.nP != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.nP);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        if (this.bB.IS == null) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoRptFile, objectArray);
        }
    }

    static final Prompt[] t(ba ba2) {
        ResourceBundle resourceBundle = cb.P(ba2);
        ArrayList<ba> arrayList = new ArrayList<ba>();
        arrayList.add(ba2);
        if (ba2.IN != null) {
            arrayList.addAll(ba2.IN);
        }
        ArrayList<Prompt> arrayList2 = new ArrayList<Prompt>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ba ba3 = (ba)arrayList.get(i2);
            int n2 = ba3.iW().length;
            for (int i3 = 0; i3 < n2; ++i3) {
                PromptField promptField = ba3.iW()[i3];
                if (promptField.isSubreportLink()) continue;
                Prompt prompt = new Prompt();
                prompt.setIsValueSet(promptField.isValueSet());
                if (!promptField.isUsed()) {
                    prompt.setNotUsed(true);
                } else {
                    DynamicValueProvider dynamicValueProvider;
                    Datasource datasource;
                    Serializable serializable;
                    int n3;
                    if (i2 > 0) {
                        prompt.setName("#" + i2 + "#" + promptField.name);
                        try {
                            prompt.setSubreportName(ba3.getEngine().getReportTitle());
                        }
                        catch (ReportException reportException) {
                            BaseUtils.printStackTrace(reportException);
                        }
                    } else {
                        prompt.setName(promptField.name);
                    }
                    if (resourceBundle != null) {
                        prompt.setDisplayName(cb.a(resourceBundle, promptField.name));
                        prompt.setPromptText(cb.a(resourceBundle, promptField.promptText));
                    } else {
                        prompt.setDisplayName(promptField.name);
                        prompt.setPromptText(promptField.promptText);
                    }
                    DefaultValue[] defaultValueArray = promptField.getDefaultValues();
                    if (defaultValueArray == null) {
                        defaultValueArray = new DefaultValue[]{};
                    }
                    Object[] objectArray = new Object[defaultValueArray.length];
                    String[] stringArray = new String[defaultValueArray.length];
                    for (n3 = 0; n3 < defaultValueArray.length; ++n3) {
                        objectArray[n3] = defaultValueArray[n3].getValue();
                        stringArray[n3] = defaultValueArray[n3].getDescription();
                    }
                    prompt.setDefaultValues(PromptUtils.defaultPromptValues(objectArray, promptField.valueType));
                    prompt.setDescs(stringArray);
                    if (promptField.value != null) {
                        prompt.setValue(PromptUtils.defaultPrompt(promptField.value, promptField.valueType));
                    }
                    if (promptField.zd != null && promptField.getUseRange()) {
                        prompt.setMinValue(PromptUtils.defaultPrompt(promptField.zd, promptField.valueType));
                    }
                    if (promptField.ze != null && promptField.getUseRange()) {
                        prompt.setMaxValue(PromptUtils.defaultPrompt(promptField.ze, promptField.valueType));
                    }
                    prompt.setValueType(promptField.valueType);
                    prompt.setValueTypeNewProt(promptField.valueType % 128);
                    prompt.setMulti(promptField.zb);
                    prompt.setDiscrete(promptField.zc % 2 == 0);
                    prompt.setRange(promptField.zc > 0);
                    prompt.setEditMask(promptField.isPasswordField() ? "password" : "");
                    prompt.setEditable(promptField.isEditable());
                    prompt.setOnlyDescs(promptField.isDescriptionOnly());
                    if (promptField.za != null && (serializable = (datasource = promptField.za.getDatasource()).getDataFactory()) instanceof DatabaseInformix) {
                        prompt.setInformixPrompt(true);
                    }
                    if (resourceBundle != null) {
                        prompt.setPromptText(cb.a(resourceBundle, prompt.getPromptText()));
                        stringArray = prompt.getDescs();
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (stringArray[n3] == null) continue;
                            stringArray[n3] = cb.a(resourceBundle, stringArray[n3]);
                        }
                    }
                    if ((dynamicValueProvider = promptField.getDefaultValueProvider()) instanceof HasCascadingParent && (serializable = ((HasCascadingParent)((Object)dynamicValueProvider)).getParent()) != null) {
                        prompt.setCascadingParent(((Field)serializable).getName());
                    }
                }
                arrayList2.add(prompt);
            }
        }
        Prompt[] promptArray = new Prompt[arrayList2.size()];
        for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
            promptArray[i4] = (Prompt)arrayList2.get(i4);
        }
        return promptArray;
    }

    public static String getCreator() {
        return bi.IT;
    }

    public static void setCreator(String creator) {
        if (creator == null) {
            throw new NullPointerException("The creator specified with setCreator is null.");
        }
        bi.IT = creator;
    }

    public void setLocale(@Nonnull Locale locale) throws ReportException {
        String string;
        this.cq();
        if (BaseUtils.isInfo()) {
            BaseUtils.info("Set locale: " + String.valueOf(locale));
        }
        if (locale != null && BaseUtils.isWarning() && (string = LocaleUtils.checkLocale((Locale)locale)) != null) {
            BaseUtils.warning("setLocale: " + string);
        }
        this.bB.a(locale, false);
    }

    @Override
    public void setClientLocale(@Nonnull Locale locale) throws ReportException {
        String string;
        this.cq();
        if (BaseUtils.isInfo()) {
            BaseUtils.info("Set client locale: " + String.valueOf(locale));
        }
        if (locale != null && BaseUtils.isWarning() && (string = LocaleUtils.checkLocale((Locale)locale)) != null) {
            BaseUtils.warning("setClientLocale: " + string);
        }
        this.bB.a(locale, true);
    }

    public Locale getLocale() throws ReportException {
        this.cq();
        return this.bB.Jf;
    }

    public void setNumeralLanguage(int language) throws ReportException {
        this.cq();
        this.bB.setNumeralLanguage(language);
    }

    public int getNumeralLanguage() throws ReportException {
        this.cq();
        return this.bB.getNumeralLanguage();
    }

    @Override
    public void setUserProperties(Properties props) throws ReportException {
        this.cp();
        if (this.bB != null && this.bB.gH != 0) {
            this.getParent().setUserProperties(props);
        }
        this.nV = props;
    }

    public Properties getUserProperties() {
        if (this.bB != null && this.bB.gH != 0) {
            return ((bi)this.bB.gy()).getEngine().getUserProperties();
        }
        return this.nV;
    }

    public Hashtable getUserData() {
        return this.ob;
    }

    public void setUserData(Hashtable hash) {
        this.ob = hash;
    }

    public Engine getParent() throws ReportException {
        this.cp();
        return this.bB.gy() != null ? ((bi)this.bB.gy()).getEngine() : null;
    }

    private static boolean cr() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        new Throwable().printStackTrace(printWriter);
        printWriter.flush();
        String string = byteArrayOutputStream.toString();
        int n2 = string.indexOf("com.inet.designer");
        int n3 = string.indexOf("com.inet.viewer", n2);
        int n4 = string.indexOf("com.inet.designer", n2 + 1);
        if (n2 > 0 && n3 > 0 && n4 < 0) {
            return true;
        }
        return string.contains(" com.inet.report.DatabaseReportData.get") || string.contains(" com.inet.facturx.problemfinder.FacturValidateRule");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ReportException {
        cb.kG();
        if (this.nU) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.EngineExecuting, objectArray);
        }
        this.nU = true;
        oc.put(this, null);
        try {
            LicenseKeyInfo licenseKeyInfo = LicenseKeyInfo.getCurrent();
            String string = licenseKeyInfo.getLicenseText();
            if (!licenseKeyInfo.isValid()) {
                if (EngineUtils.isDesigner() && Engine.cr()) {
                    string = "i-net Designer License";
                } else {
                    throw ReportExceptionFactory.createReportException((ErrorCode)BaseErrorCode.LicenseInvalid, licenseKeyInfo.getErrorMessage());
                }
            }
            BaseUtils.info(EngineUtils.getClearReportsName(licenseKeyInfo) + " - " + string);
            this.cq();
            if ((cb.kJ() & 3) != 0) {
                return;
            }
            PermissionChecker.checkExecuteRight(this.getReportFile());
            this.cw();
            bf.a(this.bB, this.nV, true);
            if (com.inet.report.database.coredata.d.nU()) {
                DatabaseCore.a(this, this.nV);
            }
            if (this.bB.iR() == null) {
                this.bB.a(new Date());
            }
            try {
                this.a(this);
                int n2 = this.getSubReportCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Engine engine = this.getSubReport(i2);
                    this.a(engine);
                }
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
            try {
                Accumulator.incRenderedReports();
                this.a(this.getReportFile());
                this.bB.fD();
            }
            finally {
                Accumulator.decRenderedReports();
            }
            this.oh.wr();
        }
        catch (Throwable throwable) {
            if (this.nP == null) {
                this.nP = throwable;
            }
            try {
                this.bB.fQ();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            this.cs();
            this.setErrorMsg(StringFunctions.getUserFriendlyErrorMessage((Throwable)this.nP));
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    private void a(Engine engine) throws Exception {
        bj bj2 = engine.bB.gE();
        if (bj2.jj() != null) {
            return;
        }
        DatabaseTables databaseTables = engine.bB.iZ();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            if (datasource.hasValidConnection()) continue;
            av.a(datasource, engine.bB);
        }
    }

    @Override
    public synchronized byte[] getPageData(int page) throws ReportException {
        if (page < 1) {
            throw new IllegalArgumentException("invalid page number: " + page);
        }
        while (!this.nS && this.bB != null && (this.nR == null || page >= this.nR.getPageCount() || this.bB.gB())) {
            this.ct();
        }
        if (this.nP != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.nP);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        if (page > this.nR.getPageCount()) {
            return null;
        }
        return this.nR.getPageData(page);
    }

    public synchronized byte[] getFontData(int fontID) {
        if (fontID < 1) {
            throw new IllegalArgumentException("invalid font ID: " + fontID);
        }
        if (this.nR == null || this.nR.getFontCount() == 0) {
            return null;
        }
        if (fontID > this.nR.getFontCount()) {
            return this.nR.getFontData(this.nR.getFontCount() - 1);
        }
        return this.nR.getFontData(fontID - 1);
    }

    public boolean isFinish() {
        return this.nS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cs() {
        if (this.bB == null) {
            return;
        }
        long l2 = this.oh.getTotalSystemTime() / 1000000L;
        URL uRL = this.bB.IS;
        if (uRL != null) {
            BaseUtils.status("Rendered report " + uRL.getFile() + " in " + l2 + "ms.");
        }
        this.bB = null;
        this.nS = true;
        Object object = this.nX;
        synchronized (object) {
            this.nX.notifyAll();
        }
        this.a(uRL, l2);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug(this.oh);
        }
        oc.remove(this);
    }

    private void ct() throws ReportException {
        if (!this.nU) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.EngineNotExecuted, new Object[0]);
        }
        try {
            this.wait(com.inet.report.cache.store.b.mj());
        }
        catch (InterruptedException interruptedException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(interruptedException);
        }
    }

    @Override
    public synchronized int getPageCount() throws ReportException {
        while (!this.nS && this.bB != null) {
            this.ct();
        }
        if (this.nP != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.nP);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        if (this.nR == null) {
            return 0;
        }
        return this.nR.getPageCount();
    }

    public synchronized int getDocumentPageCount() throws ReportException {
        while (!this.nS && this.bB != null) {
            this.ct();
        }
        if (this.nP != null) {
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(this.nP);
            BaseUtils.printStackTrace(reportException);
            throw reportException;
        }
        return this.nO;
    }

    public void setCatalog(String catalog) throws ReportException {
        this.cq();
        try {
            if (catalog != null && catalog.length() == 0) {
                catalog = null;
            }
            this.bB.iZ().getDatasource(0).setCatalog(catalog);
            if (this.bB.IN != null) {
                for (int i2 = 0; i2 < this.bB.IN.size(); ++i2) {
                    ((ba)this.bB.IN.get(i2)).iZ().getDatasource(0).setCatalog(catalog);
                }
            }
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    public void setSchema(String schema) throws ReportException {
        this.cq();
        try {
            if (schema != null && schema.length() == 0) {
                schema = null;
            }
            this.bB.iZ().getDatasource(0).setSchema(schema);
            if (this.bB.IN != null) {
                for (int i2 = 0; i2 < this.bB.IN.size(); ++i2) {
                    ((ba)this.bB.IN.get(i2)).iZ().getDatasource(0).setSchema(schema);
                }
            }
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    public void setData(String[] columns, Object[][] data, boolean longColumnNames) throws ReportException {
        this.cq();
        BaseUtils.info("[Engine.setData] with array and long column name for id: " + this.bB.gH);
        if (columns == null) {
            this.cu();
        } else {
            String string = ".";
            block0: for (int i2 = 0; i2 < columns.length; ++i2) {
                Object object = columns[i2];
                if (((String)object).indexOf(".") >= 0) continue;
                object = "." + (String)object;
                for (int i3 = 0; i3 < this.bB.ja().size(); ++i3) {
                    String string2 = this.bB.ja().ez((int)i3).name;
                    if (!string2.endsWith((String)object)) continue;
                    columns[i2] = string2;
                    continue block0;
                }
            }
            this.setData(columns, data);
        }
    }

    public void setData(List<String> columns, List<?> data, boolean longColumnNames) throws ReportException {
        this.cq();
        BaseUtils.info("[Engine.setData] with Vector for id: " + this.bB.gH);
        if (columns == null) {
            this.cu();
        } else {
            if (data == null) {
                BaseUtils.warning("[Engine.setData] Vector 'data' is null.");
                data = Collections.emptyList();
            }
            try {
                String[] stringArray = new String[columns.size()];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = String.valueOf(columns.get(i2));
                }
                Object[][] objectArray = new Object[data.size()][];
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    Object object = data.get(i3);
                    if (object instanceof Vector) {
                        objectArray[i3] = ((Vector)object).toArray();
                        continue;
                    }
                    if (object instanceof List) {
                        objectArray[i3] = ((List)object).toArray();
                        continue;
                    }
                    if (!(object instanceof Object[])) continue;
                    objectArray[i3] = (Object[])object;
                }
                this.setData(stringArray, objectArray, longColumnNames);
            }
            catch (RuntimeException runtimeException) {
                BaseUtils.printStackTrace(runtimeException);
                throw runtimeException;
            }
        }
    }

    public void setData(String[] columns, Object[][] data) throws ReportException {
        this.cq();
        BaseUtils.info("[Engine.setData] with array for id: " + this.bB.gH);
        bj bj2 = this.bB.gE();
        bj2.Z(true);
        if (columns == null) {
            this.cu();
        } else {
            this.bB.gE().a(columns);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[Engine.setData] number of Fields: " + columns.length);
            }
            if (data != null) {
                if (BaseUtils.isDebug()) {
                    int n2 = data.length;
                    int n3 = 0;
                    if (n2 > 0 && data[0] != null) {
                        n3 = data[0].length;
                    }
                    BaseUtils.debug("[Engine.setData] data array with " + n3 + " columns and " + n2 + " rows.");
                }
                bj2.b(new com.inet.report.rowsource.a((Object[][])data.clone(), bj2));
            } else {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[Engine.setData] array 'data' is null");
                }
                bj2.b(new com.inet.report.rowsource.a());
            }
            bj2.a(bj2.jj());
        }
    }

    private void cu() throws ReportException {
        BaseUtils.warning("[Engine.setData] ReportID: " + this.bB.gH + ". Array of columns is null.");
        String[] stringArray = new String[this.bB.ja().size() + this.bB.IB.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.bB.ja().size()) {
            stringArray[n2] = this.bB.ja().ez(n3).getName();
            ++n3;
            ++n2;
        }
        n3 = 0;
        while (n3 < this.bB.IB.length) {
            stringArray[n2] = this.bB.IB[n3].getName();
            ++n3;
            ++n2;
        }
        this.setData(stringArray, null);
    }

    public void setConnection(Connection con) throws ReportException {
        this.cp();
        this.a(con, this.bB.iZ().getDatasource(0));
    }

    public void setConnectionCloseOnFinishing(boolean closeConnectionOnFinishing) {
        this.oi = closeConnectionOnFinishing;
    }

    void a(Connection connection, Datasource datasource) throws ReportException {
        BaseUtils.info("set connection " + String.valueOf(connection));
        this.cq();
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                Database.a(databaseMetaData, false, true);
            }
            catch (SQLException sQLException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
            }
            datasource.setConnection(connection);
        }
        datasource.setCatalog(null);
        datasource.m(false);
    }

    @Override
    public void stopAfterPage(int maxPageNo) {
        ba ba2 = this.bB;
        if (ba2 != null) {
            if (maxPageNo <= 0) {
                maxPageNo = 0;
            }
            ba2.IR = maxPageNo;
        }
    }

    public void stop() {
        this.stop("API call Engine.stop()");
    }

    @Override
    public void stop(String message) {
        block11: {
            try {
                ba ba2 = this.bB;
                DocumentOutput documentOutput = this.nR;
                if (ba2 != null) {
                    if ((documentOutput == null || documentOutput.getPageCount() <= 0) && this.nP == null) {
                        this.nP = ReportExceptionFactory.createReportException(ReportErrorCode.stopped, message);
                    }
                    ba2.L(true);
                }
                if (documentOutput != null) {
                    documentOutput.stop(message);
                }
                if (ba2 != null) {
                    if (BaseUtils.isDebug()) {
                        if (message == null || message.trim().length() == 0) {
                            BaseUtils.debug(new Throwable("stop engine " + String.valueOf(this)));
                        } else {
                            BaseUtils.debug("stop engine " + String.valueOf(this) + " because: " + message);
                        }
                    }
                    ba2.IR = -1;
                    Engine.u(ba2);
                    ArrayList arrayList = ba2.IN;
                    if (arrayList != null) {
                        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                            ba ba3 = (ba)arrayList.get(i2);
                            ba3.IR = -1;
                            Engine.u(ba3);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isDebug()) break block11;
                BaseUtils.debug(throwable);
            }
        }
    }

    public boolean isPageLimitExceeded() {
        return this.nR != null && this.nR.isPageLimitExceeded();
    }

    public static void stopAll() {
        Iterator<Engine> iterator = oc.keySet().iterator();
        while (iterator.hasNext()) {
            Engine engine = iterator.next();
            iterator.remove();
            if (engine == null) continue;
            engine.stop("API call Engine.stopAll()");
        }
    }

    private static void u(ba<?> ba2) {
        l l2;
        block8: {
            Statement statement = ba2.BE;
            if (statement != null) {
                block7: {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("cancel " + statement.toString());
                    }
                    try {
                        statement.cancel();
                    }
                    catch (Throwable throwable) {
                        if (!BaseUtils.isDebug()) break block7;
                        BaseUtils.debug(throwable);
                    }
                }
                try {
                    statement.close();
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isDebug()) break block8;
                    BaseUtils.debug(throwable);
                }
            }
        }
        if ((l2 = ba2.gE().N()) != null) {
            l2.close();
        }
    }

    public void setData(ResultSet resultSet) throws NullPointerException, SQLException, ReportException {
        this.cq();
        BaseUtils.info("[Engine.setData] with ResultSet for report id: " + this.bB.gH);
        if (resultSet == null) {
            BaseUtils.warning("[Engine.setData] The ResultSet that was specified with setData is null.");
            this.cu();
        } else {
            Database database = (Database)this.bB.iZ().getDatasource(0).l(false);
            boolean bl2 = !this.bB.iQ() && !database.getReportDataPerInstance();
            this.bB.gE().Z(bl2);
            if (bl2) {
                this.bB.gE().ae(false);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("We will filter the result-set multiple times.  Please note that this may be inefficient; please consider overriding the database callback getReportDataPerInstance() to return true");
                }
            }
            database.a(resultSet, this.bB);
        }
    }

    private DatabaseSetData A(String string) throws ReportException {
        DatabaseTables databaseTables = this.bB.iZ();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            TableSource tableSource = datasource.getTableSourceIfExist(string);
            if (tableSource == null) continue;
            DataFactory dataFactory = datasource.getDataFactory();
            if (!(dataFactory instanceof DatabaseSetData)) {
                dataFactory = new DatabaseSetData();
                datasource.setDataFactory(dataFactory);
            }
            return (DatabaseSetData)dataFactory;
        }
        databaseTables.getDatasource(0).getTableSource(string);
        return null;
    }

    public void setData(String tableAlias, ResultSet rs) throws ReportException {
        this.A(tableAlias).setData(tableAlias, rs);
    }

    public void setData(String tableAlias, String[] columns, Object[][] rows) throws ReportException {
        this.A(tableAlias).setData(tableAlias, columns, rows);
    }

    public static void setLogStream(PrintStream stream) {
        BaseUtils.setLogStream(stream);
        if (ConfigKey.LOG_DRIVER.getCurrent().equals(Boolean.TRUE)) {
            DriverManager.setLogStream(stream);
        }
        if (BaseUtils.getLogStream() != stream) {
            BaseUtils.setLogStream(stream);
        }
    }

    public static void setLogLevel(int level) {
        BaseUtils.setLogLevel(level);
    }

    public static PrintStream getLogStream() {
        return BaseUtils.getLogStream();
    }

    public static int getLogLevel() {
        return BaseUtils.getLogLevel();
    }

    public void setGF(String gf) throws ReportException {
        this.cq();
        BaseUtils.info("Set GF: " + gf);
        if (this.bB.jc() != null) {
            this.bB.jc().resetReferences();
        }
        this.bB.g(new FormulaField(this.bB));
        this.bB.jc().setFormulaType(2);
        this.bB.jc().setFormula(gf);
        if (this.bB.jc() != null) {
            this.bB.jc().setReferences();
        }
    }

    public String getGF() throws ReportException {
        this.cq();
        if (this.bB.jc() == null) {
            return null;
        }
        return this.bB.jc().getFormula();
    }

    public FormulaField getGFField() throws ReportException {
        this.cq();
        return this.bB.jc();
    }

    public void setSF(String sf) throws ReportException {
        this.cq();
        BaseUtils.info("Set SF: " + sf);
        if (this.bB.jb() != null) {
            this.bB.jb().resetReferences();
        }
        this.bB.f(new FormulaField(this.bB));
        this.bB.jb().setFormulaType(1);
        this.bB.jb().setFormula(sf);
        this.bB.jb().name = "Record_Selection";
    }

    public String getSF() throws ReportException {
        this.cq();
        if (this.bB.jb() == null) {
            return null;
        }
        return this.bB.jb().getFormula();
    }

    public FormulaField getSFField() throws ReportException {
        this.cq();
        return this.bB.jb();
    }

    @Override
    public void setPrompt(String value, int i2) throws ReportException {
        this.cq();
        BaseUtils.info("Set Prompt[" + i2 + "]: " + value);
        if (i2 < 0) {
            BaseUtils.info("Prompt Index out of range");
            return;
        }
        ba ba2 = this.bB;
        int n2 = 0;
        while (i2 >= ba2.iW().length && this.bB.IN != null) {
            i2 -= ba2.iW().length;
            ba2 = null;
            if (this.bB.IN.size() <= n2) break;
            ba2 = (ba)this.bB.IN.get(n2++);
        }
        if (ba2 == null || i2 >= ba2.iW().length) {
            BaseUtils.info("Prompt Index out of range");
            return;
        }
        PromptField promptField = ba2.iW()[i2];
        if (promptField == null) {
            throw new IllegalStateException("No PromptField for " + value + " at r.prompts[" + i2 + "]");
        }
        this.a(promptField, value);
    }

    @Override
    public void setPrompt(String name, String value) throws ReportException {
        this.cq();
        ba ba2 = this.bB;
        if (name == null) {
            return;
        }
        BaseUtils.info("Set Prompt[" + name + "]: " + value);
        PromptField promptField = ba2.af(name);
        if (promptField != null) {
            this.a(promptField, value);
        } else {
            BaseUtils.warning("prompt could not be found!");
        }
    }

    void a(PromptField promptField, String object) throws ReportException {
        if (object == null) {
            object = "";
        }
        boolean bl2 = false;
        Object object2 = ((String)object).trim();
        if (!((String)object2).toUpperCase().startsWith("FORMULA:") && promptField.zb && ((String)object2).length() > 0) {
            if (((String)object2).charAt(0) != '[' || ((String)object2).charAt(((String)object2).length() - 1) != ']') {
                if (promptField.valueType == 11 && ((String)object2).charAt(0) != '\"' && ((String)object2).charAt(0) != '\'') {
                    object2 = "\"" + (String)object2 + "\"";
                }
                object = "[" + (String)object2 + "]";
            }
        } else if (((String)object2).length() > 1 && (((String)object2).charAt(0) == '\"' && ((String)object2).charAt(((String)object2).length() - 1) == '\"' || ((String)object2).charAt(0) == '\'' && ((String)object2).charAt(((String)object2).length() - 1) == '\'')) {
            bl2 = true;
        }
        try {
            Object[] objectArray;
            int n2 = promptField.valueType;
            Object object3 = null;
            boolean bl3 = false;
            if (!bl2 && ((String)object).toUpperCase().startsWith("FORMULA:")) {
                bl3 = true;
                object = ((String)object).substring(8);
            }
            if (n2 == 14) {
                object3 = Base64.getDecoder().decode((String)object);
            } else if (n2 != 11 || promptField.zb || bl3 || bl2 || promptField.getDiscreteOrRangeType() != 0) {
                objectArray = this.bB.du().a((String)object, false, 0, 0, null, null);
                objectArray.bg("ProfilePrompt");
                try {
                    objectArray.qf();
                    object3 = objectArray.qd();
                }
                catch (FormulaException formulaException) {
                    BaseUtils.printStackTrace(formulaException);
                    throw ReportExceptionFactory.createReportExceptionWithCause(formulaException, ReportErrorCode.InvalidPromptValue, object, promptField.getName());
                }
            } else {
                object3 = object;
            }
            promptField.a(object3 instanceof Evaluable ? (Evaluable)object3 : null);
            promptField.value = object3;
            if (promptField.getValue() != null) {
                if (promptField.zb) {
                    if (!(promptField.getValue() instanceof Object[])) {
                        objectArray = new Object[]{promptField.getValue()};
                        promptField.value = objectArray;
                    }
                    for (int i2 = 0; i2 < ((Object[])promptField.getValue()).length; ++i2) {
                        object3 = ((Object[])promptField.getValue())[i2];
                        if (n2 == 15 && object3 instanceof java.sql.Date) {
                            object3 = new Timestamp(((java.sql.Date)object3).getTime());
                            ((Object[])promptField.getValue())[i2] = object3;
                        }
                        if (n2 == 11) {
                            object3 = String.valueOf(object3);
                        }
                        PromptField.a(object3, n2, promptField.name, promptField.getValueTypeString());
                    }
                } else {
                    if (n2 == 15 && promptField.getValue() instanceof java.sql.Date) {
                        object3 = new Timestamp(((java.sql.Date)promptField.getValue()).getTime());
                        promptField.value = object3;
                    }
                    if (!(n2 != 11 || promptField.getDiscreteOrRangeType() != 0 && object3 instanceof FormulaRange)) {
                        promptField.value = String.valueOf(promptField.getValue());
                    }
                    PromptField.a(promptField.getValue(), n2, promptField.name, promptField.getValueTypeString());
                }
            }
            promptField.valueSet = true;
        }
        catch (Throwable throwable) {
            if (promptField != null) {
                promptField.value = null;
                promptField.valueSet = false;
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
    }

    @Deprecated
    public void setPrompts(Vector prompts) throws ReportException {
        this.cq();
        BaseUtils.info("Set Prompts: " + String.valueOf(prompts));
        if (this.bB.iW() == null) {
            this.bB.a(new PromptField[0]);
        }
        for (int i2 = 0; i2 < this.bB.iW().length; ++i2) {
            if (prompts.size() <= i2) continue;
            PromptField promptField = this.bB.iW()[i2];
            this.a(promptField, (String)prompts.elementAt(i2));
        }
    }

    public Object getPrompt(int i2) throws ReportException {
        this.cq();
        if (this.bB.iW() == null || this.bB.iW().length <= i2 || i2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.bB.iW()[i2].getValue();
    }

    @Override
    public PromptField getPromptField(String name) throws ReportException {
        this.cq();
        return this.bB.af(name);
    }

    public int getPromptCount() {
        return this.bB.iW().length;
    }

    public void setSql(String statement) throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        databaseTables.a(statement, this.cv(), databaseTables.getDatasource(0), true);
    }

    public void setSqlIgnoreMetaData(String statement) throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        databaseTables.a(statement, this.cv(), databaseTables.getDatasource(0), false);
    }

    private String cv() throws ReportException {
        String string = "Query";
        Object object = string;
        int n2 = 1;
        boolean bl2 = true;
        DatabaseTables databaseTables = this.getDatabaseTables();
        if (databaseTables != null) {
            while (bl2) {
                StringList stringList = new StringList();
                int n3 = databaseTables.getDatasourceCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Datasource datasource = databaseTables.getDatasource(i2);
                    for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                        stringList.addElement(datasource.getTableSource(i3).getAlias());
                    }
                }
                if (stringList.containsIgnoreCase((String)object)) {
                    object = string + "_" + n2++;
                    continue;
                }
                bl2 = false;
            }
        }
        return object;
    }

    public void setSql(String statement, boolean useColumnIndexFromReportDesign) throws ReportException {
        DatabaseTables databaseTables = this.getDatabaseTables();
        databaseTables.a(statement, "Query", databaseTables.getDatasource(0), true);
    }

    public String[] getDefaultSqlOfAllStatements(boolean leavePrompts) throws ReportException {
        this.cp();
        if (!this.bB.gt()) {
            return new String[]{""};
        }
        DatabaseTables databaseTables = this.getDatabaseTables();
        String[] stringArray = null;
        try {
            stringArray = databaseTables.k(leavePrompts);
        }
        catch (ReportException reportException) {
            BaseUtils.error("Connection refused.");
            BaseUtils.error(reportException);
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        StringList stringList = new StringList();
        for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            stringList.addElement(databaseTables.a(leavePrompts, datasource));
        }
        return stringList.toArray();
    }

    public void setUser(String user) throws ReportException {
        this.cq();
        BaseUtils.info("Set User: " + user);
        this.bB.iZ().getDatasource(0).setUsername(user);
        if (this.bB.IN != null) {
            for (int i2 = 0; i2 < this.bB.IN.size(); ++i2) {
                ((ba)this.bB.IN.get(i2)).iZ().getDatasource(0).setUsername(user);
            }
        }
    }

    public void setPassword(String password) throws ReportException {
        this.cq();
        BaseUtils.info("Set Password: ****");
        this.bB.iZ().getDatasource(0).setPassword(password);
        if (this.bB.IN != null) {
            int n2 = this.bB.IN.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((ba)this.bB.IN.get(i2)).iZ().getDatasource(0).setPassword(password);
            }
        }
    }

    public void setErrorMsg(String msg) {
        this.nQ = msg;
    }

    public String getErrorMsg() {
        return this.nQ;
    }

    public Fields getFields() throws ReportException {
        this.cq();
        return this.bB.getFields();
    }

    public Engine getSubReport(int idx) throws ReportException {
        this.cq();
        return this.bB.bA(idx).getEngine();
    }

    public Subreport getSubReportElement() throws ReportException {
        if (this.getParent() == null) {
            return null;
        }
        ba ba2 = this.getParent().bB;
        ArrayList<Section> arrayList = ba2.iS();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Section section = arrayList.get(i2);
            for (int i3 = 0; i3 < section.bz().size(); ++i3) {
                if (!(section.bz().get(i3) instanceof Subreport) || ((Subreport)section.bz().get((int)i3)).Od != this.bB.gH) continue;
                return (Subreport)section.bz().get(i3);
            }
        }
        return null;
    }

    public int getSubReportCount() throws ReportException {
        this.cq();
        return this.bB.getSubReportCount();
    }

    public void setDataSourceConfigurationName(String datasourceName) throws ReportException {
        this.cq();
        BaseUtils.info("Set DataSourceConfigurationName:" + datasourceName);
        if (datasourceName == null) {
            datasourceName = "";
        }
        this.bB.iZ().getDatasource(0).setDataSourceConfigurationName(datasourceName);
        if (this.bB.IN != null) {
            for (int i2 = 0; i2 < this.bB.IN.size(); ++i2) {
                ((ba)this.bB.IN.get(i2)).iZ().getDatasource(0).setDataSourceConfigurationName(datasourceName);
            }
        }
    }

    public static int getMajorVersion() {
        return new Version(Engine.getVersion()).getMajor();
    }

    public static int getMinorVersion() {
        return new Version(Engine.getVersion()).getMinor();
    }

    public static String getVersion() {
        return BaseUtils.getVersion();
    }

    public URL getReportFile() throws ReportException {
        this.cp();
        return this.bB.jf();
    }

    public SummaryInfo getSummaryInfo() throws ReportException {
        this.cq();
        return this.bB.getSummaryInfo();
    }

    public Translations getTranslations() throws ReportException {
        this.cq();
        Translations translations = this.bB.getTranslations();
        if (translations == null) {
            translations = e.Nj();
            this.bB.a(translations);
        }
        return translations;
    }

    public String getReportTitle() throws ReportException {
        this.cq();
        return this.bB.getSummaryInfo().getReportTitle();
    }

    public void setReportTitle(String title) throws ReportException {
        this.cq();
        this.bB.getSummaryInfo().setReportTitle(title);
    }

    public void setTime(long time) {
        this.ol = time;
    }

    public long getTime() {
        return this.ol;
    }

    public int getCacheSize() {
        byte[] byArray;
        int n2;
        if (this.nR == null) {
            return 0;
        }
        int n3 = 0;
        for (n2 = 1; n2 <= this.nR.getPageCount(); ++n2) {
            byArray = this.nR.getPageData(n2);
            if (byArray == null) continue;
            n3 += byArray.length;
        }
        for (n2 = 0; n2 < this.nR.getFontCount(); ++n2) {
            byArray = this.nR.getFontData(n2);
            if (byArray == null) continue;
            n3 += byArray.length;
        }
        byArray = this.nR.getGroupTree();
        if (byArray != null) {
            n3 += byArray.length;
        }
        return n3;
    }

    public void setReportFile(String url) throws ReportException {
        try {
            URL uRL = com.inet.report.servlets.b.dG(url);
            if (uRL == null) {
                try {
                    uRL = new URL(url);
                }
                catch (MalformedURLException malformedURLException) {
                    if (url.indexOf(58) > 2) {
                        throw malformedURLException;
                    }
                    uRL = IOFunctions.getFileURL((String)url);
                }
            }
            this.setReportFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Object[] objectArray = new Object[]{url};
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(malformedURLException, ReportErrorCode.RptNotFound, objectArray);
            this.nP = reportException;
            throw reportException;
        }
    }

    public void relocateFile(URL newurl) throws ReportException {
        this.cp();
        this.bB.IS = newurl;
    }

    public void setReportFile(URL url) throws ReportException {
        this.cp();
        try {
            BaseUtils.info("setReportFile: " + String.valueOf(url));
            if (this.bB.IS != null) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.RptAlreadySet, new Object[0]);
            }
            this.bB.IS = url;
            try {
                PermissionChecker.checkReportLocation(url);
            }
            catch (AccessDeniedException accessDeniedException) {
                PermissionChecker.checkExecuteRight(url);
            }
            this.setErrorMsg(null);
            boolean bl2 = IOFunctions.isDirectory((URL)url);
            byte[] byArray = bl2 ? null : IOFunctions.getFileBuffer((URL)url);
            this.a(url, byArray, bl2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Serializable serializable;
            if ("file".equals(url.getProtocol())) {
                serializable = IOFunctions.getFile((URL)url);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(((File)serializable).getAbsolutePath());
                }
            } else {
                serializable = url;
            }
            ReportException reportException = ReportExceptionFactory.createReportExceptionWithCause(fileNotFoundException, ReportErrorCode.RptNotFound, serializable);
            this.nP = reportException;
            throw reportException;
        }
        catch (Throwable throwable) {
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
        finally {
            this.bB.gP().wq();
            BaseUtils.debugMemory("afterSetReportFile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void a(URL var1_1, byte[] var2_2, boolean var3_3) throws IOException, ReportException, UnsupportedEncodingException {
        block21: {
            block20: {
                var5_4 = null;
                if (!var3_3) break block20;
                var4_5 = 5;
                break block21;
            }
            var6_6 = new FastByteArrayInputStream(var2_2);
            var7_7 /* !! */  = new FastBufferedInputStream((InputStream)var6_6);
            if (IOFunctions.isZipFile((FastBufferedInputStream)var7_7 /* !! */ )) {
                var5_4 = new RFReader((InputStream)var7_7 /* !! */ );
                var2_2 = var5_4.getContent();
            }
            if (var5_4 == null) ** GOTO lbl18
            if (var5_4.getMimetype() == null) ** GOTO lbl17
            if ("application/crystalclear.report".startsWith(var5_4.getMimetype())) {
                var4_5 = 4;
            } else {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidMimeType, new Object[]{var5_4.getMimetype()});
lbl17:
                // 1 sources

                throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidMimeType, new Object[]{"<null>"});
lbl18:
                // 1 sources

                var4_5 = BaseUtils.checkSig(var2_2);
            }
        }
        this.p(true);
        try {
            switch (var4_5) {
                case 1: {
                    var6_6 = new as();
                    try {
                        var6_6.a(this.bB, var1_1, var2_2);
                    }
                    catch (ReportException var7_8) {
                        throw var7_8;
                    }
                    catch (Throwable var7_9) {
                        BaseUtils.printStackTrace(var7_9);
                        var8_10 = ReportExceptionFactory.createReportExceptionWithCause(var7_9, ReportErrorCode.InvalidRptRDC, new Object[]{var1_1});
                        this.nP = var8_10;
                        throw var8_10;
                    }
                    if (this.bB.jd() == null) {
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidRptRDC, new Object[]{var1_1});
                    }
                    this.getReportProperties().ah(false);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 2: {
                    var7_7 /* !! */  = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(var2_2), "UTF8"));
                    new at().a((BufferedReader)var7_7 /* !! */ , this.bB);
                    this.getReportProperties().ah(true);
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 4: {
                    RDC.c(this);
                    this.bB.IS = var1_1;
                    if (var5_4 != null) {
                        var5_4.initSummaryInfo(this.getSummaryInfo());
                        this.setMetaProperties(var5_4.readMetaProperties());
                    }
                    var8_11 = com.inet.report.parser.b.vE();
                    var8_11.vH().put("KEY_RF_READER", var5_4);
                    var8_11.a(this, XMLTag.Report, var2_2);
                    if (var5_4 != null && (var9_12 = var5_4.getThumbnail()) != null) {
                        this.getSummaryInfo().setThumbnailData(var9_12);
                    }
                    this.bB.a(e.b(var5_4));
                    this.o(true);
                    if (var5_4 != null && var5_4.isContainingCoreData()) {
                        CoreData.onLoadingReportWithCoreData(this.bB.getEngine(), var5_4, var1_1);
                    }
                    GenericBreakPointProvider.checkJson(this);
                    ** break;
lbl64:
                    // 1 sources

                    break;
                }
                case 5: {
                    RDC.c(this);
                    var9_13 = IOFunctions.getFile((URL)var1_1);
                    RDC.a(this, var9_13, null);
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                default: {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidRpt, new Object[]{var1_1});
                }
            }
        }
        finally {
            this.p(false);
        }
        this.cx();
        this.S(0);
        this.cA();
        Accumulator.countReportTemplates(var1_1);
        Accumulator.countReportFormats(this.oa);
    }

    private void cw() throws ReportException {
        String[] stringArray = this.getReportProperties().getEnabledFormats();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = this.oa;
        if (string.equals(EXPORT_DATA)) {
            string = EXPORT_CSV;
        } else if (string.startsWith(EXPORT_PS)) {
            string = EXPORT_PS;
        } else if (string.startsWith(EXPORT_HTML)) {
            string = EXPORT_HTML;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equalsIgnoreCase(string)) continue;
            return;
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.ExportFormatDisabled, string, this.bB.IS);
    }

    private void cx() throws ReportException {
        Object object;
        Serializable serializable;
        int n2;
        ArrayList<Section> arrayList = this.bB.iS();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            serializable = arrayList.get(n2);
            object = ((Section)serializable).getElements();
            block6: for (int i2 = 0; i2 < ((Element[])object).length; ++i2) {
                Element element = object[i2];
                switch (element.type) {
                    case 39: {
                        SubreportLink[] subreportLinkArray = ((Subreport)element).Of;
                        for (int i3 = 0; i3 < subreportLinkArray.length; ++i3) {
                            SubreportLink subreportLink = subreportLinkArray[i3];
                            try {
                                subreportLink.getSubField();
                                continue;
                            }
                            catch (ReportException reportException) {
                                BaseUtils.printStackTrace(reportException);
                            }
                        }
                        continue block6;
                    }
                }
            }
        }
        this.getFields().db();
        if (this.bB.IN != null) {
            for (n2 = 0; n2 < this.bB.IN.size(); ++n2) {
                serializable = (ba)this.bB.IN.get(n2);
                if (serializable == null) continue;
                object = ((bi)serializable).getFields();
                if (object == null) {
                    object = new Fields((ba)serializable);
                }
                ((Fields)object).db();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGroupTree() throws ReportException {
        Object object = this.nX;
        synchronized (object) {
            while (!this.nS) {
                try {
                    this.nX.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.nR != null) {
            return this.nR.getGroupTree();
        }
        return null;
    }

    void B(String string) throws ReportException {
        if (string.length() != 0) {
            Properties properties = new Properties();
            cb.b(string, properties, false);
            String string2 = properties.getProperty("type", "0");
            int n2 = Integer.parseInt(string2);
            if (n2 > 0) {
                this.nW = true;
                this.bB.e(properties);
                return;
            }
            int n3 = 0;
            try {
                Object object;
                int n4;
                Object object2;
                n3 = Integer.parseInt(properties.getProperty("subreport", null));
                ba ba2 = (ba)this.bB.IN.get(n3);
                ReportProperties reportProperties = ba2.getReportProperties();
                if (reportProperties.getPaperOrient() == 0) {
                    reportProperties.setPaperOrient(this.bB.getReportProperties().getPaperOrient(), reportProperties.getPaperFormat());
                }
                ba2.a(this.bB.getTranslations());
                Subreport subreport = null;
                ArrayList<Section> arrayList = this.bB.iS();
                int n5 = arrayList.size();
                block2: while (n5-- > 0) {
                    object2 = arrayList.get(n5);
                    Element[] elementArray = ((Section)object2).getElements();
                    n4 = elementArray.length;
                    while (n4-- > 0) {
                        object = elementArray[n4];
                        if (((Element)object).type != 39) continue;
                        Subreport subreport2 = (Subreport)object;
                        subreport2.getEngine();
                        if (subreport2.Oa != ba2) continue;
                        subreport = subreport2;
                        break block2;
                    }
                }
                Engine.a(subreport);
                ba2.IS = this.bB.IS;
                this.bB = ba2;
                this.bB.f(this);
                this.bB.gH = 0;
                this.bB.setOnDemand(true);
                this.bB.IN = null;
                this.setErrorMsg(null);
                if (string.length() > 0) {
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        object2 = (String)enumeration.nextElement();
                        int n6 = -1;
                        if (((String)object2).startsWith("prompt")) {
                            n6 = 6;
                        }
                        if (n6 == -1) continue;
                        n4 = Integer.valueOf(((String)object2).substring(n6));
                        object = properties.getProperty((String)object2, null);
                        if (object == null) continue;
                        this.setPrompt((String)object, n4);
                    }
                }
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
                Object[] objectArray = new Object[]{"subreport#", string};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidArgument, objectArray);
            }
        }
    }

    private static StringBuilder a(StringBuilder stringBuilder, SubreportLink subreportLink) {
        if (subreportLink.Op != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(100);
            } else {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("{" + subreportLink.Op.getRefName() + "}={" + subreportLink.Oo.getRefName() + "}");
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("SF=" + String.valueOf(stringBuilder));
            }
        }
        return stringBuilder;
    }

    static void a(Subreport subreport) {
        if (subreport.Oh) {
            return;
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("setSubreportLinksToSF(" + String.valueOf(subreport) + ")");
        }
        subreport.Oh = true;
        ba ba2 = subreport.getEngine().bB;
        StringBuilder stringBuilder = null;
        for (int i2 = 0; i2 < subreport.Of.length; ++i2) {
            SubreportLink subreportLink = subreport.Of[i2];
            try {
                stringBuilder = Engine.a(stringBuilder, subreportLink);
                continue;
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
        }
        if (stringBuilder != null) {
            String string;
            block12: {
                if (ba2.jb() == null) {
                    ba2.f(new FormulaField(ba2));
                    ba2.jb().valueType = 8;
                    ba2.jb().setFormulaType(1);
                    ba2.jb().name = "Record_Selection";
                }
                string = ba2.jb() == null ? "" : ba2.jb().getFormula();
                boolean bl2 = true;
                try {
                    boolean bl3 = ba2.jb().getSyntax() == 1002;
                    bl2 = FormulaField.isEmpty(string, bl3, ba2.getEngine());
                    if (bl2) {
                        ba2.jb().setFormula(stringBuilder.toString());
                    } else {
                        ba2.jb().setFormula("(" + string + "\n) AND (" + String.valueOf(stringBuilder) + "\n)");
                    }
                }
                catch (Exception exception) {
                    if (!BaseUtils.isDebug()) break block12;
                    BaseUtils.debug(exception);
                }
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("PATCH SF: " + string + " with " + String.valueOf(stringBuilder));
            }
        }
    }

    public List<Section> getSections() throws ReportException {
        this.cp();
        return Collections.unmodifiableList(this.bB.iS());
    }

    public Area getArea(int idx) throws ReportException {
        this.cp();
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        switch (idx) {
            case 0: {
                return this.bB.IK;
            }
            case 1: {
                return this.bB.II;
            }
            case 2: {
                return this.bB.IM;
            }
            case 3: {
                return this.bB.IL;
            }
            case 4: {
                return this.bB.IJ;
            }
        }
        if (this.bB.je()) {
            return this.f(idx, 2);
        }
        return this.f(idx, 1);
    }

    private Area f(int n2, int n3) {
        if (this.bB.jd() == null) {
            return null;
        }
        if ((n2 -= 5) < 0) {
            return null;
        }
        int n4 = (n2 - n2 % 2) / 2 + n3;
        if (n4 > this.bB.jd().length - 2) {
            return null;
        }
        Group group = this.bB.jd()[n4];
        if (group == null || group.dm() != 30) {
            return null;
        }
        if (n2 % 2 == 0) {
            return group.sq;
        }
        return group.sr;
    }

    public Area getArea(String item) throws ReportException {
        this.cp();
        return this.bB.getArea(item);
    }

    public int getAreaCount() throws ReportException {
        this.cq();
        if (this.bB.jd() != null) {
            return this.bB.jd().length * 2 - 1;
        }
        return 5;
    }

    public DatabaseTables getDatabaseTables() throws ReportException {
        this.cq();
        return this.bB.iZ();
    }

    public Group addGroup(Field groupField) throws ReportException {
        Group group = this.d(groupField);
        group.sE = this.getFields().a(group);
        return group;
    }

    Group d(Field field) throws ReportException {
        this.cp();
        if (this.bB.jd() == null) {
            throw new IllegalStateException("The report structure is corrupt. Please report this error.");
        }
        Group group = new Group(field, this.bB);
        group.aj(0);
        Group[] groupArray = new Group[this.bB.jd().length + 1];
        groupArray[0] = this.bB.jd()[0];
        int n2 = 1;
        if (this.bB.gH == 0) {
            if (this.bB.jd().length < 3) {
                throw new IllegalStateException("The report structure is corrupt. Please report this error.");
            }
            n2 = 2;
            groupArray[1] = this.bB.jd()[1];
        } else if (this.bB.jd().length < 2) {
            throw new IllegalStateException("The report structure is corrupt. Please report this error.");
        }
        while (n2 < groupArray.length - 2) {
            groupArray[n2] = this.bB.jd()[n2];
            ++n2;
        }
        groupArray[groupArray.length - 2] = group;
        groupArray[groupArray.length - 1] = this.bB.jd()[this.bB.jd().length - 1];
        this.bB.a(groupArray);
        group.sq = new Area(31, this.bB);
        Section section = group.sq.addSection();
        section.jm = this.bB.getReportProperties().getMarginLeft();
        section.width = this.bB.getReportProperties().getPaperWidth() - this.bB.getReportProperties().getMarginRight() - this.bB.getReportProperties().getMarginLeft();
        group.sr = new Area(32, this.bB);
        section = group.sr.addSection();
        section.jm = this.bB.getReportProperties().getMarginLeft();
        section.width = this.bB.getReportProperties().getPaperWidth() - this.bB.getReportProperties().getMarginRight() - this.bB.getReportProperties().getMarginLeft();
        return group;
    }

    public int getGroupCount() throws ReportException {
        this.cq();
        return this.bB.getGroupCount();
    }

    public void removeGroup(Group group) throws ReportException {
        this.cp();
        this.removeGroup(group.indexOf());
    }

    public void removeGroup(int grNum) throws ReportException {
        int n2;
        int n3;
        Group[] groupArray;
        this.cp();
        Group group = this.getGroup(grNum);
        if (group == null) {
            return;
        }
        if (this.bB.IA == null) {
            this.bB.IA = new SummaryField[0];
        }
        for (int i2 = 0; i2 < this.bB.IA.length; ++i2) {
            boolean bl2 = false;
            SummaryField summaryField = this.bB.IA[i2];
            if (summaryField.getGroup() == group) {
                summaryField.setChangeField(null);
                bl2 = true;
            }
            if (summaryField.OI == group) {
                summaryField.setResetField(null);
                bl2 = true;
            }
            if (!bl2) continue;
            --i2;
            if (summaryField.name.indexOf(group.getField().name) <= 0) continue;
            groupArray = null;
            if (summaryField.OE != null) {
                groupArray = summaryField.OE.name;
            }
            summaryField.name = SummaryField.generateName(summaryField.getField().name, null, summaryField.Na, (String)groupArray);
        }
        ReferencedObject[] referencedObjectArray = group.getReferencedObjects();
        for (n3 = 0; n3 < referencedObjectArray.length; ++n3) {
            if (!(referencedObjectArray[n3] instanceof Field) || !group.equals((groupArray = (Field)referencedObjectArray[n3]).getGroup())) continue;
            groupArray.setGroup(null);
        }
        group.aq();
        group.resetReferences();
        if (group.sE != null) {
            group.sE.resetReferences();
        }
        group.sz = null;
        n3 = -1;
        if (group.sE != null) {
            n3 = group.sE.indexOf();
        }
        if (n3 > -1) {
            this.getFields().ae(n3);
        }
        if (group.sE != null) {
            group.sE.setGroup(null);
        }
        group.sE = null;
        groupArray = new Group[this.bB.jd().length - 1];
        int n4 = 0;
        if (this.bB.gH == 0) {
            n4 = 1;
        }
        for (n2 = 0; n2 < grNum + n4; ++n2) {
            groupArray[n2] = this.bB.jd()[n2];
        }
        for (n2 = grNum + n4 + 1; n2 < groupArray.length; ++n2) {
            groupArray[n2 - 1] = this.bB.jd()[n2];
        }
        groupArray[groupArray.length - 1] = this.bB.jd()[this.bB.jd().length - 1];
        this.bB.a(groupArray);
    }

    public Group getGroup(int grNum) throws ReportException, IndexOutOfBoundsException {
        this.cq();
        return this.bB.getGroup(grNum - 1);
    }

    public Group getGroupByField(Field field) throws ReportException {
        this.cp();
        if (field == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.jd().length; ++i2) {
            Field field2 = this.bB.jd()[i2].getField();
            if (field2 == null || !field2.equals(field)) continue;
            return this.bB.jd()[i2];
        }
        return null;
    }

    public void moveGroup(int source, int dest) throws ReportException {
        int n2;
        this.cp();
        if (source == dest) {
            return;
        }
        Group group = this.getGroup(source);
        Group group2 = this.getGroup(dest);
        int n3 = 0;
        int n4 = 0;
        Group[] groupArray = new Group[this.bB.jd().length];
        for (n2 = 0; n2 < this.bB.jd().length; ++n2) {
            if (this.bB.jd()[n2] == group) {
                n3 = n2;
                continue;
            }
            if (this.bB.jd()[n2] != group2) continue;
            n4 = n2;
        }
        if (n3 > n4) {
            for (n2 = 0; n2 < n4; ++n2) {
                groupArray[n2] = this.bB.jd()[n2];
            }
            groupArray[n4] = this.bB.jd()[n3];
            for (n2 = n4; n2 < n3; ++n2) {
                groupArray[n2 + 1] = this.bB.jd()[n2];
            }
            for (n2 = n3 + 1; n2 < this.bB.jd().length; ++n2) {
                groupArray[n2] = this.bB.jd()[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                groupArray[n2] = this.bB.jd()[n2];
            }
            groupArray[n4] = this.bB.jd()[n3];
            for (n2 = n3 + 1; n2 < n4 + 1; ++n2) {
                groupArray[n2 - 1] = this.bB.jd()[n2];
            }
            for (n2 = n4 + 1; n2 < this.bB.jd().length; ++n2) {
                groupArray[n2] = this.bB.jd()[n2];
            }
        }
        this.bB.a(groupArray);
        this.bB.getEngine().getFields().a(group.getField(), 3);
    }

    static void b(Engine engine) {
        ArrayList<Section> arrayList = engine.bB.iS();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.get(i2).cy();
        }
    }

    void cy() {
        Engine.b(this);
        ArrayList arrayList = this.bB.IN;
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Engine.b(((ba)arrayList.get(i2)).getEngine());
            }
        }
    }

    public void setPrintDate(Date date) throws ReportException {
        this.cp();
        this.bB.a(date);
    }

    public Date getPrintDate() throws ReportException {
        this.cp();
        return this.bB.iR();
    }

    public Exception[] getLoadExceptions() {
        if (this.nY == null || this.nY.size() == 0) {
            return null;
        }
        return this.nY.toArray(new Exception[this.nY.size()]);
    }

    public void setMsgListener(RDC.MsgListener msgl) {
        this.nZ = msgl;
    }

    public RDC.MsgListener getMsgListener() {
        return this.nZ;
    }

    public boolean isSubEngine() throws ReportException {
        this.cq();
        return this.bB.gH != 0;
    }

    public EngineStatus getStatus() {
        if (this.nT) {
            throw new IllegalStateException("EngineStatus is not available for a sub report! Call getStatus() on the main engine instead!");
        }
        return this.om;
    }

    public ReportProperties getReportProperties() throws ReportException {
        this.cp();
        return this.bB.getReportProperties();
    }

    public FacturXSettings getFacturXSettings() throws ReportException {
        this.cp();
        return this.bB.iY();
    }

    void resetReferences() throws ReportException {
        int n2;
        int n3;
        FormulaField formulaField;
        FormulaField formulaField2;
        int n4;
        TablesourceList tablesourceList = this.bB.iZ().bS();
        for (n4 = 0; n4 < tablesourceList.size(); ++n4) {
            ((TableSource)tablesourceList.get(n4)).resetReferences();
        }
        if (this.bB.iZ().bU() != null) {
            for (n4 = 0; n4 < this.bB.iZ().bU().size(); ++n4) {
                this.bB.iZ().bU().get(n4).resetReferences();
            }
        }
        if ((formulaField2 = this.getSFField()) != null) {
            formulaField2.resetReferences();
        }
        if ((formulaField = this.getGFField()) != null) {
            formulaField.resetReferences();
        }
        Fields fields = this.getFields();
        int n5 = fields.getFormulaFieldsCount();
        for (n3 = 0; n3 < n5; ++n3) {
            fields.getFormulaField(n3).resetReferences();
        }
        n5 = fields.getGroupNameFieldsCount();
        for (n3 = 0; n3 < n5; ++n3) {
            fields.getGroupNameField(n3).resetReferences();
        }
        for (n3 = 0; n3 < fields.getSQLExpressionFieldsCount(); ++n3) {
            fields.getSQLExpressionField(n3).resetReferences();
        }
        for (n3 = 0; n3 < fields.getSummaryFieldsCount(); ++n3) {
            fields.getSummaryField(n3).resetReferences();
        }
        for (n3 = 0; n3 < fields.getSortFieldsCount(); ++n3) {
            fields.getSortField(n3).resetReferences();
        }
        Group[] groupArray = this.bB.jd();
        for (n2 = 0; n2 < groupArray.length; ++n2) {
            groupArray[n2].resetReferences();
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            fields.getPromptField(n2).resetReferences();
        }
    }

    void setReferences() throws ReportException {
        int n2;
        FormulaField formulaField;
        FormulaField formulaField2;
        int n3;
        TablesourceList tablesourceList = this.bB.iZ().bS();
        for (n3 = 0; n3 < tablesourceList.size(); ++n3) {
            ((TableSource)tablesourceList.get(n3)).setReferences();
        }
        if (this.bB.iZ().bU() != null) {
            for (n3 = 0; n3 < this.bB.iZ().bU().size(); ++n3) {
                this.bB.iZ().bU().get(n3).setReferences();
            }
        }
        if ((formulaField2 = this.getSFField()) != null) {
            formulaField2.setReferences();
        }
        if ((formulaField = this.getGFField()) != null) {
            formulaField.setReferences();
        }
        Fields fields = this.getFields();
        for (n2 = 0; n2 < fields.getFormulaFieldsCount(); ++n2) {
            fields.getFormulaField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getGroupNameFieldsCount(); ++n2) {
            fields.getGroupNameField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getSQLExpressionFieldsCount(); ++n2) {
            fields.getSQLExpressionField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getSummaryFieldsCount(); ++n2) {
            fields.getSummaryField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getSortFieldsCount(); ++n2) {
            fields.getSortField(n2).setReferences();
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            fields.getPromptField(n2).setReferences();
        }
        Group[] groupArray = this.bB.jd();
        for (int i2 = 0; i2 < groupArray.length; ++i2) {
            groupArray[i2].setReferences();
        }
        if (this.bB.iX() != null) {
            this.bB.iX().setReferences();
        }
    }

    void cz() {
        if (this.cC() == 2) {
            this.S(0);
        }
    }

    void cA() throws ReportException {
        int n2;
        if (this.cC() == 2) {
            throw new IllegalStateException("references already initialized");
        }
        this.S(1);
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < this.getSubReportCount(); ++n2) {
            this.getSubReport(n2).resetReferences();
        }
        this.resetReferences();
        for (n2 = 0; n2 < this.getSubReportCount(); ++n2) {
            this.getSubReport(n2).setReferences();
        }
        this.setReferences();
        if (this.bB.iQ() && BaseUtils.isDebug()) {
            Long l3 = new Long(System.currentTimeMillis() - l2);
            BaseUtils.debug(Msg.getMsg("initRefCounter", l3));
        }
        this.S(2);
    }

    public static List getEmbeddableFontNames() {
        if (od == null) {
            od = FontPool.getFontInstalled();
        }
        return od;
    }

    ArrayList cB() {
        return this.oo;
    }

    public void addClippingListener(ClippingListener listener) {
        if (this.oo == null) {
            this.oo = new ArrayList();
        }
        this.oo.add(listener);
    }

    public void removeClippingListener(ClippingListener listener) {
        if (this.oo == null) {
            return;
        }
        this.oo.remove(listener);
        if (this.oo.size() == 0) {
            this.oo = null;
        }
    }

    public void addFinishListener(EngineFinishListener listener) {
        if (this.oe == null) {
            this.oe = new ArrayList();
            this.oh.o(this.oe);
        }
        this.oe.add(listener);
    }

    public void removeFinishListener(EngineFinishListener listener) {
        if (this.oe == null) {
            return;
        }
        this.oe.remove(listener);
    }

    private void a(URL uRL) {
        for (EngineStartedListener engineStartedListener : ServerPluginManager.getInstance().get(EngineStartedListener.class)) {
            try {
                engineStartedListener.engineStarted(this, uRL);
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
        }
    }

    private void a(URL uRL, long l2) {
        EngineFinishEvent engineFinishEvent = new EngineFinishEvent(this, uRL, l2);
        for (EngineFinishListener engineFinishListener : ServerPluginManager.getInstance().get(EngineFinishListener.class)) {
            try {
                engineFinishListener.engineFinish(engineFinishEvent);
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
        }
        if (this.oe == null) {
            return;
        }
        for (int i2 = this.oe.size() - 1; i2 >= 0; --i2) {
            try {
                this.oe.get(i2).engineFinish(engineFinishEvent);
                continue;
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
            }
        }
    }

    public FormulaField[] getVariableReferences(String varName) throws ReportException {
        this.cp();
        return this.bB.du().getVariableReferences(varName);
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            XMLTag xMLTag = XMLTag.getValueOf(tag);
            if (xMLTag == XMLTag.Unknown) {
                return null;
            }
            if (xMLTag == XMLTag.Field) {
                String string = atts.getValue("type");
                b b2 = b.C(string);
                if (b2 != null) {
                    String string2 = atts.getValue("valueType");
                    int n2 = -1;
                    if (string2 != null) {
                        int n3 = Integer.valueOf(string2);
                        switch (n3 % 128) {
                            case -10: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 14: 
                            case 15: 
                            case 1024: {
                                n2 = n3 % 128;
                            }
                        }
                    }
                    switch (b2) {
                        case ov: {
                            FormulaField formulaField = this.getFields().addFormulaField("temp" + System.identityHashCode(string), "", 0);
                            formulaField.setValueType(n2);
                            this.nN.os = formulaField;
                            return formulaField;
                        }
                        case ow: {
                            FormulaField formulaField = new FormulaField(this.bB);
                            formulaField.setValueType(n2);
                            this.bB.f(formulaField);
                            this.nN.os = this.bB.jb();
                            formulaField.setFormulaType(1);
                            return formulaField;
                        }
                        case ox: {
                            FormulaField formulaField = new FormulaField(this.bB);
                            formulaField.setValueType(n2);
                            this.nN.os = this.bB.g(formulaField);
                            formulaField.setFormulaType(2);
                            return formulaField;
                        }
                        case oy: {
                            PromptField promptField = this.getFields().addPromptField("temp" + System.identityHashCode(string), "", n2);
                            this.nN.os = promptField;
                            return promptField;
                        }
                        case oz: {
                            SQLField sQLField = new SQLField(this.bB);
                            sQLField.setValueType(n2);
                            this.bB.IB = (SQLField[])Fields.a((Field[])this.bB.IB, sQLField);
                            this.nN.os = sQLField;
                            return sQLField;
                        }
                        case oA: {
                            SummaryField summaryField = new SummaryField(this.bB);
                            summaryField.setValueType(n2);
                            this.bB.IA = (SummaryField[])Fields.a((Field[])this.bB.IA, summaryField);
                            this.nN.os = summaryField;
                            return summaryField;
                        }
                        case oB: {
                            SortField sortField = new SortField(this.bB);
                            sortField.setValueType(n2);
                            this.bB.IC = (SortField[])Fields.a((Field[])this.bB.IC, sortField);
                            this.nN.os = sortField;
                            return sortField;
                        }
                        case oC: {
                            GroupField groupField = new GroupField(this.bB);
                            groupField.setValueType(n2);
                            this.bB.Iz = (GroupField[])Fields.a((Field[])this.bB.Iz, groupField);
                            this.nN.os = groupField;
                            return groupField;
                        }
                        case oD: {
                            com.inet.report.formula.userfunctions.b b3 = new com.inet.report.formula.userfunctions.b(this.bB.Iy);
                            b3.setValueType(n2);
                            this.bB.Iy.a(b3);
                            this.nN.os = null;
                            return b3;
                        }
                    }
                    BaseUtils.error("unknown Field type: " + String.valueOf((Object)b2));
                    return null;
                }
                BaseUtils.error("No type given for <Field> Tag! ");
                return null;
            }
            NodeParser nodeParser = null;
            switch (xMLTag) {
                case Report: {
                    String string;
                    Fields fields = this.bB.getFields();
                    fields.rd = new ArrayList<Element>();
                    fields.re = new ArrayList<Field>();
                    String string3 = atts.getValue("major_version");
                    this.bB.getReportProperties().bD(Integer.parseInt(string3));
                    String string4 = atts.getValue("minor_version");
                    this.bB.getReportProperties().bE(Integer.parseInt(string4));
                    String string5 = atts.getValue("major_xml_version");
                    if (string5 != null) {
                        int n4 = Integer.parseInt(string5);
                        if (n4 > Engine.getMajorVersion()) {
                            if (this.nY == null) {
                                this.nY = new ArrayList();
                            }
                            this.nY.add(ReportExceptionFactory.createReportException(ReportErrorCode.LoadingNewerVersion, string5));
                        }
                        this.bB.getReportProperties().bF(n4);
                    }
                    if ((string = atts.getValue("minor_xml_version")) != null) {
                        this.bB.getReportProperties().bG(Integer.parseInt(string));
                    }
                    this.bB.getReportProperties().ah(true);
                    break;
                }
                case Datasource: {
                    String string = atts.getValue("dll");
                    String string6 = atts.getValue("host");
                    String string7 = atts.getValue("schema");
                    String string8 = atts.getValue("catalog");
                    String string9 = atts.getValue("user");
                    String string10 = atts.getValue("password");
                    String string11 = atts.getValue("url");
                    String string12 = atts.getValue("properties");
                    string10 = Encryption.decrypt((String)string10);
                    if (string10 != null && string10.length() > 0) {
                        this.getDatabaseTables().setSavePassword(true);
                    } else {
                        string10 = null;
                    }
                    if (string6 == null) break;
                    Datasource datasource = this.nN.or = new Datasource(string, string6, string7, string8, string9, string10, this);
                    this.getDatabaseTables().d(datasource);
                    if (string11 != null && string11.length() > 0) {
                        datasource.setUrl(string11);
                    }
                    if (string12 == null) break;
                    com.inet.report.util.h.a(string12, datasource, this.bB.IS);
                    break;
                }
                case DataSourceConfiguration: {
                    DataSourceConfiguration dataSourceConfiguration;
                    String string = atts.getValue("name");
                    if (DataSourceConfigurationManager.exists(string)) {
                        this.nN.or = this.getDatabaseTables().createDatasource(string);
                        this.nN.ot = null;
                        break;
                    }
                    Datasource datasource = new Datasource(string, this);
                    this.nN.ot = dataSourceConfiguration = new DataSourceConfiguration(string, 0);
                    this.nN.ou = false;
                    datasource.setDataSourceConfiguration(dataSourceConfiguration);
                    this.getDatabaseTables().d(datasource);
                    this.nN.or = datasource;
                    break;
                }
                case property: {
                    if (this.nN.ot == null) break;
                    String string = atts.getValue("name");
                    String string13 = atts.getValue("value");
                    string = DataSourceConfigurationXMLFileStore.xmlDecode(string);
                    string13 = DataSourceConfigurationXMLFileStore.xmlDecode(string13);
                    if (string.equals("password")) {
                        string13 = Encryption.decrypt((String)string13);
                    }
                    this.nN.ot.addProperty(string, string13);
                    this.nN.ou = true;
                    break;
                }
                case Tablesource: {
                    String string = atts.getValue("alias");
                    String string14 = atts.getValue("databaseIdentifier");
                    if (this.nN.or == null) {
                        this.nN.or = new Datasource(null, null, null, null, null, null, this);
                        this.getDatabaseTables().d(this.nN.or);
                    }
                    return this.nN.or.m(string14, string);
                }
                case Join: {
                    String string = atts.getValue("from");
                    String string15 = atts.getValue("to");
                    String string16 = atts.getValue("type");
                    Join join = new Join(this.bB, DatabaseTables.p(string16), string, string15);
                    this.getDatabaseTables().bU().add(join);
                    return join;
                }
                case GroupNameFields: {
                    break;
                }
                case ReportProperties: {
                    this.getReportProperties().setPaperOrient(1, 256);
                    nodeParser = this.bB.getReportProperties();
                    break;
                }
                case FacturX: {
                    FacturXSettings facturXSettings = this.bB.iY();
                    String string = atts.getValue("profile");
                    if (string != null) {
                        facturXSettings.setProfile(ProfileLevel.valueOf(string));
                    }
                    nodeParser = facturXSettings;
                    break;
                }
                case AreaPair: {
                    int n5 = com.inet.report.util.h.f(atts);
                    switch (n5) {
                        case 30: {
                            String string = atts.getValue("id");
                            int n6 = Integer.parseInt(string);
                            nodeParser = new com.inet.report.b(n5, this.bB, n6);
                            break;
                        }
                        case 24: 
                        case 27: 
                        case 33: {
                            nodeParser = new com.inet.report.b(n5, this.bB);
                        }
                    }
                    break;
                }
                case Warning: {
                    if (this.nY == null) {
                        this.nY = new ArrayList();
                    }
                    return new c();
                }
            }
            return nodeParser;
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return null;
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        try {
            XMLTag xMLTag = XMLTag.getValueOf(tag);
            switch (xMLTag) {
                case Datasource: {
                    this.nN.or = null;
                    break;
                }
                case Field: {
                    this.getFields().a(this.nN.os, 0);
                    this.nN.os = null;
                    break;
                }
                case Report: {
                    Fields fields = this.bB.getEngine().getFields();
                    fields.da();
                    this.nN = null;
                    break;
                }
                case DataSourceConfiguration: {
                    if (this.nN.ot == null) break;
                    if (this.nN.ou) {
                        this.nN.or.setDataSourceConfiguration(this.nN.ot);
                        break;
                    }
                    this.nN.or.setDataSourceConfigurationName(this.nN.ot.getConfigurationName());
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    void o(boolean bl2) {
        try {
            this.getReportProperties().ah(bl2);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    void S(int n2) {
        this.on = n2;
    }

    int cC() {
        return this.on;
    }

    ba bT() {
        return this.bB;
    }

    public boolean isDrillDownEngine() {
        return this.nW;
    }

    void p(boolean bl2) {
        block2: {
            try {
                this.getFields().t(!bl2);
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isParanoid()) break block2;
                BaseUtils.paranoid("Engine: Could not set auto-update on Fields. The Fields object is currently not available.");
            }
        }
    }

    public Properties getMetaProperties() {
        return this.of;
    }

    public void setMetaProperties(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.of = props;
    }

    public int getReportID() {
        return this.bB.gH;
    }

    public Trigger getTrigger() {
        if (this.og == null) {
            this.og = new Trigger();
            if (this.bB != null) {
                this.bB.a(this.og);
            }
        }
        return this.og;
    }

    @Override
    @Nonnull
    public EngineStatistics getStatistics() {
        return this.oh;
    }

    private class c
    implements NodeParser {
        private c() {
        }

        @Override
        public boolean isDOMParser() {
            return false;
        }

        @Override
        public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
        }

        @Override
        public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
            return null;
        }

        @Override
        public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        }

        @Override
        public void parseText(String text, Map<String, Object> parserMap) {
            Engine.this.nY.add(ReportExceptionFactory.createReportException(ReportErrorCode.Parser_Misc_Warning, text));
            BaseUtils.warning(text);
        }
    }

    private static enum b {
        ov,
        ow,
        ox,
        oy,
        oz,
        oA,
        oB,
        oC,
        oD;

        private static HashMap<String, b> gF;

        private static b C(String string) {
            return gF.get(string);
        }

        static {
            gF = new HashMap();
            gF.put("FormulaField", ov);
            gF.put("RecordSelection", ow);
            gF.put("GroupSelection", ox);
            gF.put("PromptVarField", oy);
            gF.put("SqlExprField", oz);
            gF.put("SummaryField", oA);
            gF.put("SortField", oB);
            gF.put("GroupNameField", oC);
            gF.put("UserFunction", oD);
        }
    }

    private class a {
        private Datasource or = null;
        private Field os;
        private DataSourceConfiguration ot;
        private boolean ou;

        private a() {
        }
    }
}

