/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bAM;
    private int bAG;
    private boolean bAN;
    private Timer bAO;
    private Popup bAP;
    private JLabel bAQ;
    private JPanel bAR;
    private boolean bAS;
    private Point bAT;
    private JComboBox bAU;
    private boolean bAV;
    private boolean bAW;
    private Class bAX;
    private Constructor bAY;
    private Class[] bAZ = new Class[]{String.class};
    private Color bBa;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bBb;

    private RealtimeValidationPopup(int promptType) {
        this.bAG = promptType;
        this.bAQ = new JLabel();
        this.bAR = new JPanel();
        this.bAR.setOpaque(true);
        this.bAR.add(this.bAQ);
        this.bAR.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bAR.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bAO = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bBb == null) {
            return;
        }
        this.bAV = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bAU = surroundingBox;
        }
        this.bAM = textcomponent;
        this.bAM.addFocusListener(this);
        this.bBa = this.bAM.getBackground();
    }

    private void initFormats() {
        this.bBb = null;
        switch (this.bAG % 128) {
            case 6: 
            case 7: {
                this.bBb = this.bAV ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bBb = this.bAV ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bBb = this.bAV ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bBb = this.bAV ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void OE() {
        if (this.bAM instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bAM.isEnabled() || !this.bAM.isShowing() || object.toString().length() == 0 || this.bAM instanceof JComboBox && ((JComboBox)this.bAM).isPopupVisible() || (this.bAG % 128 == 6 || this.bAG % 128 == 7) && string.equals("-")) {
            if (!this.bAM.isEnabled()) {
                this.bAM.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bAM.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bBb.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bAW && this.bAX != null) {
                if (this.bAX == Object.class) {
                    this.bAX = String.class;
                }
                this.bAY = this.bAX.getConstructor(this.bAZ);
                this.bAY.newInstance(string);
            }
            this.bAN = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bAM.getLocationOnScreen();
                point.y += this.bAM.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bAM.invalidate();
            this.bAM.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bBb, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bBb.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).NA();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bAM.getLocationOnScreen();
        point.y += this.bAM.getHeight();
        this.bAN = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.OF();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bAM.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bAM.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bAM.getLocationOnScreen();
        point.y += this.bAM.getHeight();
        this.bAN = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.OF();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bAM.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bAM.invalidate();
    }

    private String OF() {
        Format format;
        switch (this.bAG) {
            case 9: {
                format = PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                format = PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                format = PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                format = null;
            }
        }
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bAG == 6 || this.bAG == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ed(string);
        this.bAQ.setText(string);
        this.bAR.setBackground(color);
        if (!this.bAS) {
            this.bAT = point;
        } else {
            point = this.bAT;
        }
        if (this.bAP != null) {
            this.hidePopup();
        }
        this.bAP = PopupFactory.getSharedInstance().getPopup(this.bAM, this.bAR, point.x, point.y);
        this.bAP.show();
        this.bAS = true;
        if (this.bAO.isRunning()) {
            this.bAO.restart();
        } else {
            this.bAO.start();
        }
    }

    private String ed(String object) {
        object = this.bAN ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bAM instanceof JPasswordField) {
            return new String(((JPasswordField)this.bAM).getPassword());
        }
        if (this.bAM instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bAM).getText();
            if (this.bAU == null) {
                return string2;
            }
            Object object = this.bAU.getSelectedItem();
            if (this.bAM != null && this.bAU.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bAM instanceof JComboBox) {
            return ((JComboBox)this.bAM).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bAP != null) {
            this.bAP.hide();
        }
        this.bAS = false;
        if (this.bAO.isRunning()) {
            this.bAO.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bAW = checkClassType;
        this.bAX = classtype;
    }

    public void setPromptType(int promptType) {
        this.bAG = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bAM == null) {
            return;
        }
        if (this.bAM instanceof JTextField) {
            ((JTextField)this.bAM).getDocument().removeDocumentListener(this);
        } else if (this.bAM instanceof JComboBox) {
            ((JComboBox)this.bAM).removeActionListener(this);
            ((JComboBox)this.bAM).removePopupMenuListener(this);
        }
        this.bAM.removeFocusListener(this);
        if (this.bAU != null) {
            this.bAU.removeActionListener(this);
            this.bAU.removePopupMenuListener(this);
        }
        this.bAM.setBackground(this.bBa);
    }

    public boolean isPopupError() {
        return this.bAN;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.OE();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.OE();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.OE();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.OE();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.OE();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bBb = format;
    }
}

