/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.report.BaseUtils;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.EngineBundle;
import com.inet.report.Field;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportGenerator;
import com.inet.report.af;
import com.inet.report.bf;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cb;
import com.inet.report.config.LicenseKeyInfo;
import com.inet.report.prompt.Prompt;
import java.util.Properties;
import javax.annotation.Nonnull;

@InternalApi
public class EngineUtils {
    public static Engine createEngine(Properties props, PropertiesChecker checker, EngineFactory factory, Object req) throws ReportException {
        Engine engine = factory.createEngine(props);
        if (checker != null) {
            try {
                checker.checkProperties(engine, props, req);
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
                throw reportException;
            }
            catch (Throwable throwable) {
                if (BaseUtils.isWarning()) {
                    BaseUtils.warning("Could not check properties:");
                }
                BaseUtils.printStackTrace(throwable);
            }
        }
        if ("rfsh".equals(props.getProperty("cmd"))) {
            cb.j(engine).gE().jx();
        }
        return engine;
    }

    public static ReportGenerator createReportGenerator(Properties props, PropertiesChecker checker, EngineFactory factory, Object req) throws ReportException {
        ReportGenerator reportGenerator;
        String string = props.getProperty("report");
        String string2 = props.getProperty("reports");
        if (string != null || string2 == null) {
            reportGenerator = EngineUtils.createEngine(props, checker, factory, req);
        } else {
            EngineBundle engineBundle = new EngineBundle(props.getProperty("export_fmt"));
            reportGenerator = engineBundle;
            for (String string3 : string2.split(";")) {
                Properties properties = (Properties)props.clone();
                properties.put("report", string3);
                properties.put(EngineBundle.class, engineBundle);
                EngineUtils.createEngine(properties, checker, factory, req);
                if (!properties.containsKey(EngineBundle.class)) continue;
                throw new IllegalStateException("EngineFactory does not handle EngineBundle");
            }
            cb.a(reportGenerator, props);
        }
        return reportGenerator;
    }

    @Nonnull
    public static Engine getEngine(@Nonnull Datasource ds) {
        return af.getEngine(ds);
    }

    public static void checkPrompts(Engine engine, boolean attachPrompts) throws ReportException, PromptRequestWarning {
        Properties properties = engine.getUserProperties();
        bf.a(cb.j(engine), properties, attachPrompts);
    }

    @Nonnull
    public static Prompt[] createSerializablePrompts(ReportGenerator generator) {
        return af.createSerializablePrompts(generator);
    }

    public static boolean isDesigner() {
        return AbstractStructureProvider.isDesigner();
    }

    public static Engine getEngineForField(Field field) {
        return cb.getEngineForField(field);
    }

    public static String getClearReportsName(LicenseKeyInfo license) {
        if (!LicenseKeyInfo.class.getName().equals("com.inet.report.config.LicenseKeyInfo")) {
            return "i-net Clear Reports Free Edition";
        }
        if (license.isPlus()) {
            return "i-net Clear Reports Plus";
        }
        return "i-net Clear Reports";
    }
}

