/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.svg;

import com.inet.font.FontUtils;
import com.inet.font.layout.FontContext;
import com.inet.font.layout.FontLayout;
import com.inet.lib.util.ColorUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.renderer.a;
import com.inet.report.util.RenderDataUtils;
import com.inet.report.util.l;
import com.inet.shared.utils.MemoryStream;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.Properties;

public class SVGUtils {
    private static final byte[] HZ = BaseUtils.getBytes("bold");
    private static final byte[] HS = BaseUtils.getBytes(" stroke");
    private static final byte[] bsT = BaseUtils.getBytes(" clip-path=");
    private static final byte[] bsU = BaseUtils.getBytes("\n</clipPath>");
    private static final byte[] bsV = BaseUtils.getBytes("\n<clipPath  clip-rule=\"evenodd\"");
    private static final byte[] bsW = BaseUtils.getBytes("/>");
    private static final byte[] HU = BaseUtils.getBytes(">");
    private static final byte[] bsX = BaseUtils.getBytes(")");
    private static final byte[] blZ = BaseUtils.getBytes("cm\"");
    private static final byte[] bsY = BaseUtils.getBytes(",");
    private static final byte[] bsZ = BaseUtils.getBytes(" C");
    private static final byte[] bta = BaseUtils.getBytes(" cx=\"");
    private static final byte[] btb = BaseUtils.getBytes(" cy=\"");
    private static final int[] btc = new int[]{160, 80};
    private static final int[] btd = new int[]{40, 40};
    private static final byte[] bte = BaseUtils.getBytes(" text-decoration=\"");
    private static final byte[] blT = BaseUtils.getBytes("\n</defs>");
    private static final byte[] btf = BaseUtils.getBytes("\n<defs>");
    private static final byte[] btg = BaseUtils.getBytes("\n<filter id=\"dropShadow\">\n<feGaussianBlur in=\"SourceGraphic\" stdDeviation=\"15\" result=\"shadow\" />\n</filter>");
    private static final byte[] bth = BaseUtils.getBytes(" filter=\"url(#dropShadow)\" ");
    private static final byte[] bti = BaseUtils.getBytes("\n<ellipse");
    private static final byte[] btj = BaseUtils.getBytes("=");
    private static final byte[] btk = BaseUtils.getBytes(" fill");
    private static final byte[] btl = BaseUtils.getBytes(" font-family=\"");
    private static final byte[] btm = BaseUtils.getBytes(" font-size=\"");
    private static final byte[] btn = BaseUtils.getBytes(" font-style=\"");
    private static final byte[] bto = BaseUtils.getBytes(" font-weight=\"");
    private static final byte[] btp = BaseUtils.getBytes("\n</g>");
    private static final byte[] btq = BaseUtils.getBytes("\n<g");
    private static final byte[] btr = BaseUtils.getBytes("#");
    private static final byte[] bts = BaseUtils.getBytes(" height=\"");
    private static final byte[] btt = BaseUtils.getBytes(" id=\"");
    private static final byte[] btu = BaseUtils.getBytes(" xlink:href=\"data:image/png;base64,");
    private static final byte[] btv = BaseUtils.getBytes("\n<image");
    private static final byte[] HY = BaseUtils.getBytes("italic");
    private static final byte[] btw = BaseUtils.getBytes("\n<line");
    private static final byte[] btx = BaseUtils.getBytes("line-through");
    private static final byte[] bty = BaseUtils.getBytes(" L");
    private static final byte[] btz = BaseUtils.getBytes(" l");
    private static final byte[] btA = BaseUtils.getBytes(" stroke-width=\"");
    private static final byte[] btB = BaseUtils.getBytes("\"url(#");
    private static final byte[] btC = BaseUtils.getBytes(" M");
    private static final byte[] btD = BaseUtils.getBytes("none");
    private static final byte[] btE = BaseUtils.getBytes(" opacity");
    private static final byte[] blR = BaseUtils.getBytes("\n</svg>\n");
    private static final byte[] blQ = BaseUtils.getBytes("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\"");
    private static final byte[] btF = BaseUtils.getBytes("z");
    private static final byte[] btG = BaseUtils.getBytes("\n<path d=\"");
    private static final byte[] btH = BaseUtils.getBytes(" preserveAspectRatio=\"");
    private static final byte[] btI = BaseUtils.getBytes(" Q");
    private static final byte[] btJ = BaseUtils.getBytes("\"");
    private static final byte[] btK = BaseUtils.getBytes("\n<rect");
    private static final byte[] btL = BaseUtils.getBytes(" rotate(");
    private static final byte[] btM = BaseUtils.getBytes(" rx=\"");
    private static final byte[] btN = BaseUtils.getBytes(" ry=\"");
    private static final byte[] btO = BaseUtils.getBytes(" ");
    private static final byte[] btP = BaseUtils.getBytes(" stroke-dasharray:");
    private static final byte[] bmp = BaseUtils.getBytes(" style=\"");
    private static final byte[] HK = BaseUtils.getBytes("</text>");
    private static final byte[] btQ = BaseUtils.getBytes("\n<text xml:space=\"preserve\"");
    private static final byte[] btR = BaseUtils.getBytes(" transform=\"");
    private static final byte[] btS = BaseUtils.getBytes(" translate(");
    private static final byte[] btT = BaseUtils.getBytes("-transparency");
    private static final byte[] btU = BaseUtils.getBytes("</tspan>");
    private static final byte[] btV = BaseUtils.getBytes("<tspan");
    private static final byte[] Ia = BaseUtils.getBytes("underline");
    private static final byte[] Ik = BaseUtils.getBytes(" width=\"");
    private static final byte[] btW = BaseUtils.getBytes(" x=\"");
    private static final byte[] Ic = BaseUtils.getBytes(" x1=\"");
    private static final byte[] Id = BaseUtils.getBytes(" x2=\"");
    private static final byte[] btX = BaseUtils.getBytes("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n");
    private static final byte[] btY = BaseUtils.getBytes(" y=\"");
    private static final byte[] Ie = BaseUtils.getBytes(" y1=\"");
    private static final byte[] If = BaseUtils.getBytes(" y2=\"");
    private static final byte[] btZ = BaseUtils.getBytes("<a xlink:href=\"");
    private static final byte[] bua = BaseUtils.getBytes("</a>");
    private static final byte[] bub = BaseUtils.getBytes("square");
    private static final Class buc = new SVGUtils().getClass();

    public static byte[] getSvgViewer() throws IOException {
        InputStream inputStream = buc.getResourceAsStream("SVGViewer.htm");
        if (inputStream == null) {
            throw new RuntimeException("Resource SVGViewer.htm not found.");
        }
        try {
            byte[] byArray = IOFunctions.readBytes((InputStream)inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public static byte[] getSvgViewerPackage(int lastPage, boolean localHost, String exportName, int autoRefresh) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = "-1;//##LP##".getBytes();
        byte[] byArray2 = "false;//##LH##".getBytes();
        byte[] byArray3 = "\"client/svgviewer\";//##IP##".getBytes();
        byte[] byArray4 = "<meta http-equiv=\"refresh\" content=\"60\">".getBytes();
        byte[] byArray5 = SVGUtils.getSvgViewer();
        int n2 = SVGUtils.a(byArray5, 0, byArray5.length, byArray);
        byArray5 = SVGUtils.a(byArray5, n2, byArray, String.valueOf(lastPage).getBytes());
        int n3 = SVGUtils.a(byArray5, 0, byArray5.length, byArray2);
        byArray5 = SVGUtils.a(byArray5, n3, byArray2, String.valueOf(localHost).getBytes());
        int n4 = SVGUtils.a(byArray5, 0, byArray5.length, byArray3);
        byArray5 = SVGUtils.a(byArray5, n4, byArray3, ("\"" + exportName + "\"").getBytes());
        int n5 = SVGUtils.a(byArray5, 0, byArray5.length, byArray4);
        String string = autoRefresh > 0 ? "<meta http-equiv=\"refresh\" content=\"60\">".replaceFirst("60", String.valueOf(autoRefresh)) : (autoRefresh == 0 ? "<meta http-equiv=\"refresh\" content=\"60\">" : "");
        byArray5 = SVGUtils.a(byArray5, n5, byArray4, string.getBytes());
        RenderDataUtils.writeFileData(byteArrayOutputStream, exportName + ".htm", byArray5);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getSvgViewer(String prompts, String context, int autoRefresh) throws IOException {
        byte[] byArray = "\"\";//##PR##".getBytes();
        byte[] byArray2 = "<meta http-equiv=\"refresh\" content=\"60\">".getBytes();
        byte[] byArray3 = SVGUtils.getSvgViewer();
        prompts = prompts.replaceAll("#", "%23");
        int n2 = SVGUtils.a(byArray3, 0, byArray3.length, byArray);
        byArray3 = SVGUtils.a(byArray3, n2, byArray, prompts.getBytes());
        int n3 = SVGUtils.a(byArray3, 0, byArray3.length, byArray2);
        String string = autoRefresh > 0 ? "<meta http-equiv=\"refresh\" content=\"60\">".replaceFirst("60", String.valueOf(autoRefresh)) : (autoRefresh == 0 ? "<meta http-equiv=\"refresh\" content=\"60\">" : "");
        byArray3 = SVGUtils.a(byArray3, n3, byArray2, string.getBytes());
        return byArray3;
    }

    private static int a(byte[] byArray, int n2, int n3, byte[] byArray2) {
        n3 -= byArray2.length;
        block0: for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] != byArray2[0]) continue;
            for (int i3 = 1; i3 < byArray2.length; ++i3) {
                if (byArray[i2 + i3] != byArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    private static byte[] a(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length - byArray2.length + byArray3.length];
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 < n2) {
                byArray4[n3] = byArray[i2];
                ++n3;
            }
            if (i2 == n2) {
                for (int i3 = 0; i3 < byArray3.length; ++i3) {
                    byArray4[n3] = byArray3[i3];
                    ++n3;
                }
            }
            if (i2 <= n2 + byArray2.length) continue;
            byArray4[n3] = byArray[i2];
            ++n3;
        }
        return byArray4;
    }

    public static byte[] beginGrouping(MemoryStream out, int x2, int y2) {
        out.write(btq);
        if (x2 != 0 || y2 != 0) {
            SVGUtils.b(out, x2, y2, 0);
        }
        out.write(HU);
        return btp;
    }

    private static byte[] dJ(String string) throws UnsupportedEncodingException {
        return l.dV(string).getBytes("UTF8");
    }

    private static String dK(String string) {
        String string2 = "serif";
        String string3 = FontUtils.getFontMapping((String)string);
        if (string3.equals("MONOSPACED")) {
            string2 = "monospace";
        } else if (string3.equals("SANSSERIF")) {
            string2 = "sans-serif";
        } else if (string3.equals("SERIF")) {
            string2 = "serif";
        }
        return string2;
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, byte[] byArray2) {
        memoryStream.write(byArray);
        memoryStream.write(byArray2);
        memoryStream.write(btJ);
    }

    public static void writeBytes(MemoryStream out, byte[][] byteArrays) {
        for (int i2 = 0; i2 < byteArrays.length; ++i2) {
            byte[] byArray = byteArrays[i2];
            out.write(byArray);
        }
    }

    public static byte[][] writeClip(MemoryStream out, String clipName, String hyperlinkUrl, int elementX, int elementY, int elementWidth, int elementHeight) {
        byte[][] byArrayArray;
        byte[][] byArray = SVGUtils.a(out, clipName, hyperlinkUrl);
        out.write(btK);
        SVGUtils.d(out, elementX, elementY, elementWidth, elementHeight);
        out.write(bsW);
        SVGUtils.writeBytes(out, byArray);
        if (hyperlinkUrl != null && hyperlinkUrl.length() > 0) {
            byArrayArray = new byte[2][];
            byArrayArray[1] = bua;
        } else {
            byArrayArray = new byte[][]{btp};
        }
        return byArrayArray;
    }

    private static byte[][] i(MemoryStream memoryStream, String string) {
        return SVGUtils.a(memoryStream, string, null);
    }

    private static byte[][] a(MemoryStream memoryStream, String string, String string2) {
        byte[] byArray = BaseUtils.getBytes(string);
        memoryStream.write(btf);
        memoryStream.write(bsV);
        SVGUtils.a(memoryStream, btt, byArray);
        memoryStream.write(HU);
        boolean bl2 = string2 != null && string2.length() > 0;
        int n2 = 9;
        byte[] byArray2 = null;
        if (bl2) {
            try {
                byArray2 = SVGUtils.dJ(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BaseUtils.error(unsupportedEncodingException);
            }
            n2 = 13;
        }
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        byArrayArray[n3++] = bsU;
        byArrayArray[n3++] = blT;
        if (bl2) {
            byArrayArray[n3++] = btZ;
            byArrayArray[n3++] = byArray2;
            byArrayArray[n3++] = btJ;
            byArrayArray[n3++] = HU;
        }
        byArrayArray[n3++] = btq;
        byArrayArray[n3++] = bsT;
        byArrayArray[n3++] = btB;
        byArrayArray[n3++] = byArray;
        byArrayArray[n3++] = bsX;
        byArrayArray[n3++] = btJ;
        byArrayArray[n3++] = HU;
        return byArrayArray;
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, int n2) {
        memoryStream.write(byArray);
        memoryStream.write(btj);
        memoryStream.write(btJ);
        if (ColorUtils.getAlpha((int)n2) == 0) {
            memoryStream.write(btD);
        } else {
            memoryStream.write(btr);
            memoryStream.writeByteAsHexString(n2 & 0xFF);
            memoryStream.writeByteAsHexString(n2 >> 8 & 0xFF);
            memoryStream.writeByteAsHexString(n2 >> 16 & 0xFF);
            int n3 = ColorUtils.getAlpha((int)n2);
            if (n3 < 255) {
                memoryStream.write(btJ);
                memoryStream.write(btE);
                memoryStream.write(btj);
                memoryStream.write(btJ);
                memoryStream.writeFloatAsString((float)n3 / 255.0f);
            }
        }
        memoryStream.write(btJ);
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, Color color) {
        SVGUtils.a(memoryStream, byArray, ColorUtils.toCcColor((Color)color));
    }

    private static void a(MemoryStream memoryStream, float f2, float f3) {
        memoryStream.writeFloatAsString(f2);
        memoryStream.write(bsY);
        memoryStream.writeFloatAsString(f3);
    }

    private static void e(MemoryStream memoryStream, int n2, int n3) {
        memoryStream.writeIntAsString(n2);
        memoryStream.write(bsY);
        memoryStream.writeIntAsString(n3);
    }

    public static void writeCompositeRect(MemoryStream out, int x2, int y2, int width, int height, BorderProperties border, boolean expand) {
        int n2 = border.getForeColor();
        int n3 = border.getBottomLineStyle();
        int n4 = border.getTopLineStyle();
        int n5 = border.getRightLineStyle();
        int n6 = border.getLeftLineStyle();
        int n7 = border.getBackColor();
        SVGUtils.a(out, x2, y2, width, height, n6, n5, n4, n3, n2, n7, expand);
    }

    static void a(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl2) {
        int n12 = 20;
        SVGUtils.writeRect(memoryStream, n2, n3, n4, n5, -1, n11);
        SVGUtils.writeLine(memoryStream, n2, n3, n2 + n4, n3, n8, n12, n10);
        SVGUtils.writeLine(memoryStream, n2, n3 + n5, n2 + n4, n3 + n5, n9, n12, n10);
        SVGUtils.writeLine(memoryStream, n2, n3, n2, n3 + n5, n6, n12, n10);
        SVGUtils.writeLine(memoryStream, n2 + n4, n3, n2 + n4, n3 + n5, n7, n12, n10);
    }

    private static void a(MemoryStream memoryStream, float[] fArray) {
        memoryStream.write(bsZ);
        SVGUtils.a(memoryStream, fArray[0], fArray[1]);
        memoryStream.write(btO);
        SVGUtils.a(memoryStream, fArray[2], fArray[3]);
        memoryStream.write(btO);
        SVGUtils.a(memoryStream, fArray[4], fArray[5]);
    }

    public static void writeDropShadow(MemoryStream out, int x2, int y2, int width, int height, int shadowColor, int ellipseCornerX, int ellipseCornerY) {
        out.write(btq);
        out.write(bth);
        out.write(HU);
        int n2 = -1;
        int n3 = 20;
        int n4 = 1;
        SVGUtils.writeRect(out, x2 += 75, y2 += 75, width, height, n3, n4, n2, shadowColor, ellipseCornerX, ellipseCornerY);
        out.write(btp);
    }

    private static void b(MemoryStream memoryStream, int n2, int n3, int n4, int n5) {
        int n6 = n4 / 2;
        int n7 = n2 + n6;
        int n8 = n5 / 2;
        int n9 = n3 + n8;
        SVGUtils.b(memoryStream, bta, n7);
        SVGUtils.b(memoryStream, btb, n9);
        SVGUtils.b(memoryStream, btM, n6);
        SVGUtils.b(memoryStream, btN, n8);
        SVGUtils.b(memoryStream, btA, 10);
    }

    private static void f(MemoryStream memoryStream, int n2, int n3) {
        SVGUtils.a(memoryStream, btk, n2);
        SVGUtils.a(memoryStream, HS, n3);
    }

    private static void a(MemoryStream memoryStream, Paint paint, Paint paint2) {
        SVGUtils.a(memoryStream, btk, paint);
        SVGUtils.a(memoryStream, HS, paint2);
    }

    public static void writeImage(MemoryStream out, byte[] imageData, String hyperlinkUrl, Rectangle2D rectangle) {
        int n2 = (int)rectangle.getX();
        int n3 = (int)rectangle.getY();
        int n4 = (int)rectangle.getWidth();
        int n5 = (int)rectangle.getHeight();
        SVGUtils.writeImage(out, imageData, hyperlinkUrl, n2, n3, n4, n5);
    }

    public static void writeImage(MemoryStream out, byte[] imageData, String hyperLinkUrl, int x2, int y2, int imageWidth, int imageHeight) {
        String string = "image" + x2 + "," + y2 + "," + imageWidth + "x" + imageHeight;
        byte[][] byArray = SVGUtils.writeClip(out, string, hyperLinkUrl, x2, y2, imageWidth, imageHeight);
        if (imageData != null && imageData.length > 0) {
            out.write(btv);
            SVGUtils.a(out, btH, btD);
            SVGUtils.b(out, btW, x2);
            SVGUtils.b(out, btY, y2);
            SVGUtils.b(out, Ik, imageWidth);
            SVGUtils.b(out, bts, imageHeight);
            byte[] byArray2 = Base64.getEncoder().encode(imageData);
            SVGUtils.a(out, btu, byArray2);
            out.write(bsW);
        } else {
            SVGUtils.writeRect(out, x2, y2, imageWidth, imageHeight, 255, -1);
            SVGUtils.writeLine(out, x2, y2, x2 + imageWidth, y2 + imageHeight, 255);
            SVGUtils.writeLine(out, x2, y2 + imageHeight, x2 + imageWidth, y2, 255);
        }
        SVGUtils.writeBytes(out, byArray);
    }

    private static void b(MemoryStream memoryStream, byte[] byArray, int n2) {
        memoryStream.write(byArray);
        memoryStream.writeIntAsString(n2);
        memoryStream.write(btJ);
    }

    public static void writeLine(MemoryStream out, int x1, int y1, int x2, int y2, int foreColor) {
        int n2 = 20;
        int n3 = 1;
        SVGUtils.writeLine(out, x1, y1, x2, y2, n3, n2, foreColor);
    }

    public static void writeLine(MemoryStream out, int x1, int y1, int x2, int y2, int lineStyle, int lineWidth, int foreColor) {
        SVGUtils.a(out, x1, y1, x2, y2, lineStyle, lineWidth, foreColor, true);
    }

    static void a(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        if (n7 < 1) {
            n7 = 1;
        }
        if (n6 == 0) {
            return;
        }
        if (n6 == 2) {
            if (n2 == n4) {
                SVGUtils.writeLine(memoryStream, n2 - n7, n3, n4 - n7, n5, 1, n7, n8);
                SVGUtils.writeLine(memoryStream, n2 + n7, n3, n4 + n7, n5, 1, n7, n8);
            } else {
                SVGUtils.writeLine(memoryStream, n2, n3 - n7, n4, n5 - n7, 1, n7, n8);
                SVGUtils.writeLine(memoryStream, n2, n3 + n7, n4, n5 + n7, 1, n7, n8);
            }
        } else {
            memoryStream.write(btw);
            SVGUtils.a(memoryStream, HS, n8);
            SVGUtils.c(memoryStream, n2, n3, n4, n5);
            SVGUtils.b(memoryStream, btA, n7);
            SVGUtils.p(memoryStream, n6);
            SVGUtils.a(memoryStream, btk, -1);
            SVGUtils.a(memoryStream, BaseUtils.getBytes(" stroke-linecap=\""), bub);
            memoryStream.write(bsW);
        }
    }

    private static void c(MemoryStream memoryStream, int n2, int n3, int n4, int n5) {
        SVGUtils.b(memoryStream, Ic, n2);
        SVGUtils.b(memoryStream, Ie, n3);
        SVGUtils.b(memoryStream, Id, n4);
        SVGUtils.b(memoryStream, If, n5);
    }

    private static void p(MemoryStream memoryStream, int n2) {
        if (n2 == 3) {
            SVGUtils.g(memoryStream, btc[0], btc[1]);
        } else if (n2 == 4) {
            SVGUtils.g(memoryStream, btd[0], btd[1]);
        }
    }

    private static void g(MemoryStream memoryStream, int n2, int n3) {
        memoryStream.write(bmp);
        memoryStream.write(btP);
        SVGUtils.e(memoryStream, n2, n3);
        memoryStream.write(btJ);
    }

    private static void b(MemoryStream memoryStream, float f2, float f3) {
        memoryStream.write(bty);
        SVGUtils.a(memoryStream, f2, f3);
    }

    private static void c(MemoryStream memoryStream, float f2, float f3) {
        memoryStream.write(btC);
        SVGUtils.a(memoryStream, f2, f3);
    }

    private static byte[][] a(MemoryStream memoryStream, int n2, int n3, int n4, String string, int n5, int n6, int n7) {
        boolean bl2;
        byte[][] byArrayArray = null;
        memoryStream.write(btq);
        SVGUtils.b(memoryStream, n2, n3, n4);
        memoryStream.write(HU);
        memoryStream.write(btQ);
        if (string != null) {
            memoryStream.write(btl);
            if (!string.equals("SansSerif")) {
                SVGUtils.j(memoryStream, string);
                memoryStream.write(bsY);
            }
            String string2 = SVGUtils.dK(string);
            SVGUtils.j(memoryStream, string2);
            memoryStream.write(btJ);
        }
        if (n6 >= 0) {
            SVGUtils.b(memoryStream, btm, n6);
        }
        SVGUtils.a(memoryStream, btk, n7);
        boolean bl3 = (n5 & 1) > 0;
        boolean bl4 = (n5 & 2) > 0;
        boolean bl5 = (n5 & 4) > 0;
        boolean bl6 = bl2 = (n5 & 8) > 0;
        if (bl5) {
            SVGUtils.a(memoryStream, bte, Ia);
        } else if (bl2) {
            SVGUtils.a(memoryStream, bte, btx);
        }
        if (bl3) {
            SVGUtils.a(memoryStream, bto, HZ);
        }
        if (bl4) {
            SVGUtils.a(memoryStream, btn, HY);
        }
        memoryStream.write(HU);
        if (bl2 && bl5) {
            memoryStream.write(btV);
            SVGUtils.a(memoryStream, bte, btx);
            memoryStream.write(HU);
            byArrayArray = new byte[][]{btU, HK, btp};
        } else {
            byArrayArray = new byte[][]{HK, btp};
        }
        return byArrayArray;
    }

    public static void writeOval(MemoryStream out, int x2, int y2, int width, int height, int foreColor, int backColor) {
        out.write(bti);
        SVGUtils.f(out, backColor, foreColor);
        SVGUtils.b(out, x2, y2, width, height);
        out.write(bsW);
    }

    public static void writePage(MemoryStream outThisPage, MemoryStream outWholeDocument, boolean isMainReport, int pageWidthInTwips, int pageHeightInTwips, int pageNumber) {
        if (isMainReport) {
            outThisPage.reset();
            outWholeDocument.write(btX);
            outThisPage.write(blQ);
            outThisPage.write(Ik);
            outThisPage.writeFloatAsString((float)pageWidthInTwips / 567.0f);
            outThisPage.write(blZ);
            outThisPage.write(bts);
            outThisPage.writeFloatAsString((float)pageHeightInTwips / 567.0f);
            outThisPage.write(blZ);
            outThisPage.writeASCII(" viewBox=\"0 0 " + pageWidthInTwips + " " + pageHeightInTwips + "\"");
            outThisPage.write(HU);
            outThisPage.write(btf);
            outThisPage.write(btg);
            outThisPage.write(blT);
        } else {
            outWholeDocument.write(btq);
            outWholeDocument.write(HU);
            outWholeDocument.write(btp);
        }
    }

    public static void writePageFooter(MemoryStream out) {
        out.write(blR);
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, Paint paint) {
        if (paint == null || paint instanceof Color) {
            Color color = (Color)paint;
            SVGUtils.a(memoryStream, byArray, color);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            SVGUtils.a(memoryStream, byArray, gradientPaint.getColor1());
        } else {
            if (paint instanceof TexturePaint) {
                throw new IllegalArgumentException("paint:" + paint.getClass().getName());
            }
            throw new IllegalArgumentException("paint:" + paint.getClass().getName());
        }
    }

    public static void writePath(MemoryStream out, PathIterator path, Paint fill, Paint border) {
        out.write(btG);
        SVGUtils.a(out, path);
        out.write(btJ);
        SVGUtils.a(out, fill, border);
        out.write(bsW);
    }

    private static void a(MemoryStream memoryStream, PathIterator pathIterator) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            pathIterator.next();
            switch (n2) {
                case 0: {
                    SVGUtils.c(memoryStream, fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    SVGUtils.b(memoryStream, fArray[0], fArray[1]);
                    break;
                }
                case 3: {
                    SVGUtils.a(memoryStream, fArray);
                    break;
                }
                case 2: {
                    SVGUtils.b(memoryStream, fArray);
                    break;
                }
                case 4: {
                    memoryStream.write(btF);
                }
            }
        }
    }

    private static void b(MemoryStream memoryStream, float[] fArray) {
        memoryStream.write(btI);
        SVGUtils.a(memoryStream, fArray[0], fArray[1]);
        memoryStream.write(btO);
        SVGUtils.a(memoryStream, fArray[2], fArray[3]);
    }

    public static void writeRect(MemoryStream out, int x2, int y2, int width, int height, int foreColor, int backColor) {
        int n2 = 20;
        int n3 = 1;
        SVGUtils.writeRect(out, x2, y2, width, height, n2, n3, foreColor, backColor, 0, 0);
    }

    public static void writeRect(MemoryStream out, int x2, int y2, int width, int height, int lineWidth, int lineStyle, int foreColor, int backColor, int ellipseCornerX, int ellipseCornerY) {
        if (ColorUtils.getAlpha((int)foreColor) != 0 || ColorUtils.getAlpha((int)backColor) != 0) {
            if (lineWidth < 1) {
                lineWidth = 1;
            }
            out.write(btK);
            SVGUtils.b(out, btW, x2);
            SVGUtils.b(out, btY, y2);
            SVGUtils.b(out, Ik, width);
            SVGUtils.b(out, bts, height);
            SVGUtils.b(out, btA, lineWidth);
            SVGUtils.p(out, lineStyle);
            SVGUtils.f(out, backColor, foreColor);
            if (ellipseCornerX > 0) {
                SVGUtils.b(out, btM, ellipseCornerX);
            }
            if (ellipseCornerY > 0) {
                SVGUtils.b(out, btN, ellipseCornerY);
            }
            out.write(bsW);
        }
    }

    private static void d(MemoryStream memoryStream, int n2, int n3, int n4, int n5) {
        SVGUtils.b(memoryStream, btW, n2);
        SVGUtils.b(memoryStream, btY, n3);
        SVGUtils.b(memoryStream, Ik, n4);
        SVGUtils.b(memoryStream, bts, n5);
    }

    public static void writeRotateString(MemoryStream out, String text, int x2, int y2, int rotation, Font font, int fontColor) {
        String string = font.getName();
        int n2 = font.getStyle();
        int n3 = font.getSize();
        SVGUtils.writeRotateString(out, text, x2, y2, rotation, string, n2, n3, fontColor);
    }

    public static void writeRotateString(MemoryStream out, String text, int x2, int y2, int textRotation, FontContext fontContext) {
        int n2 = fontContext.getColor();
        FontLayout fontLayout = fontContext.getFontLayout();
        int n3 = fontLayout.getSizeTwips();
        String string = fontLayout.getName();
        int n4 = fontContext.getCcStyle();
        SVGUtils.writeRotateString(out, text, x2, y2, textRotation, string, n4, n3, n2);
    }

    public static void writeRotateString(MemoryStream out, String text, int x2, int y2, int rotation, String fontName, int ccFontStyle, int fontSizeTwips, int fontColor) {
        byte[][] byArray = SVGUtils.a(out, x2, y2, rotation, fontName, ccFontStyle, fontSizeTwips, fontColor);
        text = text.replaceAll("\u0000", "");
        SVGUtils.j(out, text);
        SVGUtils.writeBytes(out, byArray);
    }

    public static byte[] writeShadowClip(MemoryStream out, String clipName, int x2, int y2, int width, int height, int ellipseWidth, int ellipseHeight) {
        RectangularShape rectangularShape;
        RectangularShape rectangularShape2;
        byte[][] byArray = SVGUtils.i(out, clipName);
        out.write(btG);
        int n2 = 15;
        int n3 = 75;
        if (ellipseWidth > 0 || ellipseHeight > 0) {
            rectangularShape2 = new RoundRectangle2D.Float(x2 - n2, y2 - n2, width, height, ellipseWidth, ellipseHeight);
            rectangularShape = new RoundRectangle2D.Float(x2 + n3, y2 + n3, width, height, ellipseWidth, ellipseHeight);
        } else {
            rectangularShape2 = new Rectangle2D.Float(x2 - n2, y2 - n2, width, height);
            rectangularShape = new Rectangle2D.Float(x2 + n3, y2 + n3, width, height);
        }
        Area area = new Area(rectangularShape);
        area.subtract(new Area(rectangularShape2));
        SVGUtils.a(out, area.getPathIterator(null));
        out.write(btJ);
        out.write(bsW);
        SVGUtils.writeBytes(out, byArray);
        return btp;
    }

    private static void j(MemoryStream memoryStream, String string) {
        try {
            memoryStream.write(SVGUtils.dJ(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void b(MemoryStream memoryStream, int n2, int n3, int n4) {
        if (n2 != 0 || n3 != 0 || n4 != 0) {
            memoryStream.write(btR);
            memoryStream.write(btS);
            SVGUtils.e(memoryStream, n2, n3);
            memoryStream.write(bsX);
            if (n4 != 0) {
                memoryStream.write(btL);
                memoryStream.writeIntAsString(360 - n4);
                memoryStream.write(bsX);
            }
            memoryStream.write(btJ);
        }
    }

    private static void a(MemoryStream memoryStream, AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            memoryStream.write(btR);
            memoryStream.write("matrix(".getBytes());
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            memoryStream.writeDoubleAsString(dArray[0], 6);
            for (int i2 = 1; i2 < dArray.length; ++i2) {
                double d2 = dArray[i2];
                memoryStream.write(bsY);
                memoryStream.writeDoubleAsString(d2, 6);
            }
            memoryStream.write(bsX);
            memoryStream.write(btJ);
        }
    }

    public static void writeBorderAndShadow(MemoryStream out, BorderProperties box, int x2, int y2, int width, int height, int lineWidth, String clipName) {
        int n2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n3 = a.f(box);
        int n4 = box.getBottomLineStyle();
        int n5 = box.getTopLineStyle();
        int n6 = box.getRightLineStyle();
        int n7 = box.getLeftLineStyle();
        int n8 = lineWidth / 2;
        int n9 = lineWidth * 2;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (n6 != 0) {
            n10 = n8;
        }
        if (n5 != 0) {
            n11 = n8;
        }
        if (n7 != 0) {
            n12 = n8;
        }
        if (n4 != 0) {
            n13 = n8;
        }
        boolean bl6 = bl5 = n5 == 2;
        if (bl5) {
            n11 += n9;
        }
        boolean bl7 = bl4 = n6 == 2;
        if (bl4) {
            n10 += n9;
        }
        boolean bl8 = bl3 = n7 == 2;
        if (bl3) {
            n12 += n9;
        }
        boolean bl9 = bl2 = n4 == 2;
        if (bl2) {
            n13 += n9;
        }
        int n14 = width + n12 + n10;
        int n15 = height + n11 + n13;
        int n16 = x2 - n12;
        int n17 = n16 + n12;
        int n18 = y2 - n11;
        int n19 = n18 + n11;
        int n20 = n16 + n14;
        int n21 = n20 - n10;
        int n22 = n18 + n15;
        int n23 = n22 - n13;
        SVGUtils.writeRect(out, n17, n19, width + n8, height + n8, -1, n3);
        int n24 = n2 = box.getForeColor();
        if (n2 != -1) {
            Color color = ColorUtils.toJavaColor((int)n2);
            n24 = ColorUtils.toCcColor((Color)new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
        }
        if (bl5) {
            SVGUtils.writeLine(out, n16, n18, n20, n18, 1, lineWidth, n2);
            SVGUtils.writeLine(out, n17, n19, n21, n19, 1, lineWidth, n2);
        } else {
            SVGUtils.writeLine(out, n16, n18, n20, n18, n5, lineWidth, n2);
        }
        if (bl3) {
            SVGUtils.writeLine(out, n16, n18, n16, n22, 1, lineWidth, n2);
            SVGUtils.writeLine(out, n17, n19, n17, n23, 1, lineWidth, n2);
        } else {
            SVGUtils.writeLine(out, n16, n18, n16, n22, n7, lineWidth, n2);
        }
        if (bl2) {
            SVGUtils.writeLine(out, n16, n22, n20, n22, 1, lineWidth, n2);
            SVGUtils.writeLine(out, n17, n23, n21, n23, 1, lineWidth, n2);
        } else {
            SVGUtils.writeLine(out, n16, n22, n20, n22, n4, lineWidth, n2);
        }
        if (bl4) {
            SVGUtils.writeLine(out, n20, n18, n20, n22, 1, lineWidth, n2);
            SVGUtils.writeLine(out, n21, n19, n21, n23, 1, lineWidth, n2);
        } else {
            SVGUtils.writeLine(out, n20, n18, n20, n22, n6, lineWidth, n2);
        }
        if (box.isDropShadow()) {
            int n25 = n14 + n8;
            int n26 = n15 + n8;
            byte[] byArray = SVGUtils.writeShadowClip(out, clipName, n16, n18, n25, n26, 0, 0);
            SVGUtils.writeDropShadow(out, n16, n18, n14, n15, n24, 0, 0);
            out.write(byArray);
        }
    }

    public static void writeStartTransform(MemoryStream out, AffineTransform tx) {
        out.write(btq);
        SVGUtils.a(out, tx);
        out.write(HU);
    }

    public static void writeEndTransform(MemoryStream out) {
        out.write(btp);
    }

    public static int getAutoRefresh(Properties props) {
        int n2 = -1;
        String string = props.getProperty("autorefresh");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
                n2 /= 1000;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }
}

