/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.javafunctions;

import com.inet.annotations.JsonData;
import com.inet.report.BaseUtils;
import com.inet.report.formula.javafunctions.Signature;
import com.inet.report.formula.number.c;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

@JsonData
public class JSONBasedSignature
implements Signature,
Serializable {
    private List<String> parameterClasses;
    private int[] parameterTypes;
    private String returnClass;
    private int returnType;
    private String name;
    private String sourceClass;
    private String helpURL;
    private boolean isDeprecated;

    private JSONBasedSignature() {
    }

    public JSONBasedSignature(Signature source) {
        if (source.getParameterClasses() != null) {
            this.parameterClasses = new ArrayList<String>();
            for (Class<?> clazz : source.getParameterClasses()) {
                this.parameterClasses.add(clazz.getName());
            }
        }
        this.parameterTypes = source.getParameterTypes();
        this.returnClass = source.getReturnClass() != null ? source.getReturnClass().getName() : null;
        this.returnType = source.getReturnType();
        this.name = source.getName();
        this.helpURL = source.getHelpUrl() != null ? source.getHelpUrl().toExternalForm() : null;
        this.isDeprecated = source.isDeprecated();
        this.sourceClass = source.getSourceClassName();
    }

    @Override
    public Class<?>[] getParameterClasses() {
        if (this.parameterClasses == null) {
            return null;
        }
        Class[] classArray = new Class[this.parameterClasses.size()];
        for (int i2 = 0; i2 < this.parameterClasses.size(); ++i2) {
            String string = this.parameterClasses.get(i2);
            try {
                classArray[i2] = this.classForName(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classArray[i2] = Object.class;
                BaseUtils.warning(classNotFoundException);
            }
        }
        return classArray;
    }

    @Override
    public int[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?> getReturnClass() {
        try {
            return this.classForName(this.returnClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(classNotFoundException);
            }
            return Object.class;
        }
    }

    public Class<?> classForName(String name) throws ClassNotFoundException {
        switch (name) {
            case "int": {
                return Integer.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        return Class.forName(name);
    }

    @Override
    public int getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object invoke(Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        switch (this.getReturnType()) {
            case 11: {
                return "";
            }
            case 6: {
                return c.b(0.0, false);
            }
            case 7: {
                return c.b(0.0, true);
            }
            case 8: {
                return Boolean.FALSE;
            }
            case 9: {
                return new java.util.Date();
            }
            case 15: {
                return new Date(new java.util.Date().getTime());
            }
            case 10: {
                return new Timestamp(new java.util.Date().getTime());
            }
        }
        return null;
    }

    @Override
    public URL getHelpUrl() {
        if (this.helpURL == null) {
            return null;
        }
        try {
            return new URL(this.helpURL);
        }
        catch (MalformedURLException malformedURLException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(malformedURLException);
            }
            return null;
        }
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public String getSourceClassName() {
        return this.sourceClass;
    }
}

