/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.StringIntMap;
import com.inet.lib.list.StringList;
import com.inet.report.AbstractLineElement;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.HasCascadingParent;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.RDC;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReportComponent;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportProperties;
import com.inet.report.SQLField;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.SpecialField;
import com.inet.report.Subreport;
import com.inet.report.SubreportLink;
import com.inet.report.SummaryField;
import com.inet.report.TableSource;
import com.inet.report.ba;
import com.inet.report.bi;
import com.inet.report.cb;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.q;
import com.inet.report.formula.userfunctions.UserFunction;
import com.inet.report.formula.userfunctions.b;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.NodeParser;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.xml.sax.Attributes;

@PublicApi
public class Fields
implements Serializable {
    private ba bB;
    private transient EventListenerList rc;
    List<Element> rd;
    List<Field> re = null;
    private boolean rf = true;

    Fields(ba renderer) {
        this.bB = renderer;
    }

    static void a(StringIntMap stringIntMap) {
        stringIntMap.put("DatabaseFields", 142);
        stringIntMap.put("FormulaFields", 143);
        stringIntMap.put("SQLFields", 144);
        stringIntMap.put("PromptFields", 145);
        stringIntMap.put("GroupNameFields", 146);
        stringIntMap.put("SummaryFields", 147);
        stringIntMap.put("SortFields", 148);
    }

    public DatabaseField getDatabaseField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        this.a(idx, this.bB.ja());
        return this.bB.ja().ez(idx);
    }

    public int getDatabaseFieldsCount() {
        if (this.bB.ja() != null) {
            return this.bB.ja().size();
        }
        return 0;
    }

    public void removeDatabaseField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.ja() == null) {
            return;
        }
        this.a(idx, this.bB.ja());
        this.a(this.bB.ja(), idx);
    }

    public DatabaseField getDatabaseField(String dbColName) {
        if (this.bB.ja() == null) {
            return null;
        }
        return this.bB.ja().bX(dbColName);
    }

    public FormulaField getFormulaField(String fieldName) {
        if (this.bB.Iv == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Iv.length; ++i2) {
            FormulaField formulaField = this.bB.Iv[i2];
            if (formulaField == null) {
                return null;
            }
            if (!formulaField.name.equalsIgnoreCase(fieldName)) continue;
            return formulaField;
        }
        return null;
    }

    public SummaryField getSummaryField(String fieldName) {
        if (this.bB.IA == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.IA.length; ++i2) {
            SummaryField summaryField = this.bB.IA[i2];
            if (summaryField == null) {
                return null;
            }
            if (!summaryField.name.equalsIgnoreCase(fieldName)) continue;
            return summaryField;
        }
        return null;
    }

    public GroupField getGroupNameField(String fieldName) {
        if (this.bB.Iz == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.Iz.length; ++i2) {
            GroupField groupField = this.bB.Iz[i2];
            if (groupField == null) {
                return null;
            }
            try {
                String string = groupField.getName();
                if (string == null || !string.equalsIgnoreCase(fieldName)) continue;
                return groupField;
            }
            catch (Exception exception) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("problems checking group name in Fields.getGroupNameField...");
                }
                BaseUtils.printStackTrace(exception);
            }
        }
        return null;
    }

    public PromptField getPromptField(String fieldName) {
        PromptField[] promptFieldArray = this.bB.iW();
        if (promptFieldArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
            PromptField promptField = promptFieldArray[i2];
            if (promptField == null) {
                return null;
            }
            if (!promptField.name.equalsIgnoreCase(fieldName)) continue;
            return promptField;
        }
        return null;
    }

    public SQLField getSQLExpressionField(String fieldName) {
        if (this.bB.IB == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.IB.length; ++i2) {
            SQLField sQLField = this.bB.IB[i2];
            if (sQLField == null) {
                return null;
            }
            if (!sQLField.name.equalsIgnoreCase(fieldName)) continue;
            return sQLField;
        }
        return null;
    }

    public FormulaField getFormulaField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        this.a(idx, this.bB.Iv);
        return this.bB.Iv[idx];
    }

    public int getFormulaFieldsCount() {
        if (this.bB.Iv != null) {
            return this.bB.Iv.length;
        }
        return 0;
    }

    public FormulaField addFormulaField(String name, String formula, int type) {
        if (type == 0 && (name == null || name.trim().length() == 0)) {
            throw new IllegalArgumentException(Msg.getMsg(ReportErrorCode.EmptyFieldNameForbidden.name(), new Object[0]));
        }
        if (type != 0 && type != 3) {
            throw new IllegalArgumentException("Illegal type of formula: " + type);
        }
        FormulaField formulaField = new FormulaField(this.bB);
        formulaField.setFormulaType(type);
        if (name != null) {
            formulaField.setName(name.trim());
        }
        formulaField.setFormula(formula);
        formulaField.valueType = -1;
        if (type != 3) {
            this.bB.Iv = (FormulaField[])Fields.a((Field[])this.bB.Iv, formulaField);
        }
        this.a(formulaField, 0);
        this.b(formulaField);
        return formulaField;
    }

    private void b(FormulaField formulaField) {
        Object object;
        if (!this.rf) {
            return;
        }
        if (this.bB.Iv != null) {
            object = this.bB.Iv;
            int n2 = ((FormulaField[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object[i2];
                if (object2 == null || object2 == formulaField || ((FormulaField)object2).getFormulaTree() == null || ((FormulaField)object2).valueType != -1) continue;
                int n3 = ((Field)object2).getReferenceHolderCount();
                int n4 = ((FormulaField)object2).getReferencedObjectCount();
                ((FormulaField)object2).resetReferences();
                ((FormulaField)object2).setReferences();
                if (n3 == ((Field)object2).getReferenceHolderCount() && n4 == ((FormulaField)object2).getReferencedObjectCount()) continue;
                this.a((Field)object2, 2);
            }
        }
        if ((object = this.bB.jb()) != null) {
            ((FormulaField)object).resetReferences();
            ((FormulaField)object).setReferences();
        }
    }

    public void removeFormulaField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.Iv == null) {
            return;
        }
        this.a(idx, this.bB.Iv);
        FormulaField formulaField = this.bB.Iv[idx];
        this.bB.Iv = (FormulaField[])this.a(this.bB.Iv, idx);
        this.a(formulaField, 1);
        if (this.bB.oH != null) {
            this.a(this.bB.oH.qR(), formulaField);
            this.a(this.bB.oH.qS(), formulaField);
            this.a(this.bB.oH.qT(), formulaField);
        }
    }

    private void a(q q2, FormulaField formulaField) {
        Collection collection = q2.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            y y2 = (y)iterator.next();
            ArrayList<FormulaField> arrayList = y2.sl();
            arrayList.remove(formulaField);
            if (arrayList.size() != 0) continue;
            iterator.remove();
        }
    }

    public PromptField getPromptField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        this.a(idx, this.bB.iW());
        return this.bB.iW()[idx];
    }

    public int getPromptFieldsCount() {
        if (this.bB.iW() != null) {
            return this.bB.iW().length;
        }
        return 0;
    }

    public void movePromptField(int from, int to) throws ReportException {
        this.a(from, to, this.bB.iW());
    }

    private void a(int n2, int n3, Field[] fieldArray) throws ReportException {
        if (n2 == n3) {
            return;
        }
        this.bB.getEngine().cq();
        this.a(n2, fieldArray);
        this.a(n3, fieldArray);
        Field field = fieldArray[n2];
        int n4 = Math.min(n2 + 1, n3);
        int n5 = Math.min(n2, n3 + 1);
        int n6 = Math.abs(n2 - n3);
        System.arraycopy(fieldArray, n4, fieldArray, n5, n6);
        fieldArray[n3] = field;
        this.a(field, 3);
    }

    public PromptField addPromptField(String name, String text, int type) throws ReportException {
        PromptField promptField = new PromptField(this.bB);
        promptField.setName(name.trim());
        promptField.promptText = text;
        promptField.setValueType(type);
        this.bB.a((PromptField[])Fields.a((Field[])this.bB.iW(), promptField));
        this.b(null);
        this.a(promptField, 0);
        return promptField;
    }

    public void removePromptField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.iW() == null) {
            return;
        }
        this.a(idx, this.bB.iW());
        PromptField promptField = this.bB.iW()[idx];
        if (promptField.isParameterOfStoredProcedure()) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDeletePromptField, objectArray);
        }
        ReferenceHolder[] referenceHolderArray = promptField.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            CascadingValueProvider cascadingValueProvider;
            PromptField promptField2;
            DynamicValueProvider dynamicValueProvider;
            ReferenceHolder referenceHolder = referenceHolderArray[i2];
            if (!(referenceHolder instanceof PromptField) || !((dynamicValueProvider = (promptField2 = (PromptField)referenceHolder).getDefaultValueProvider()) instanceof CascadingValueProvider) || !(cascadingValueProvider = (CascadingValueProvider)dynamicValueProvider).getParent().equals(promptField)) continue;
            promptField2.setDefaultValueProvider(new FieldValueProvider(cascadingValueProvider.getValues(), cascadingValueProvider.getDescriptions(), cascadingValueProvider.getSortType()));
        }
        this.bB.a((PromptField[])this.a(this.bB.iW(), idx));
        this.a(promptField, 1);
    }

    public GroupField getGroupNameField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        this.a(idx, this.bB.Iz);
        return this.bB.Iz[idx];
    }

    public int getGroupNameFieldsCount() {
        if (this.bB.Iz != null) {
            return this.bB.Iz.length;
        }
        return 0;
    }

    public SummaryField getSummaryField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        this.a(idx, this.bB.IA);
        return this.bB.IA[idx];
    }

    public int getSummaryFieldsCount() {
        if (this.bB.IA != null) {
            return this.bB.IA.length;
        }
        return 0;
    }

    public SummaryField addSummaryField(Field field, int operation, String name) throws ReportException {
        SummaryField summaryField = new SummaryField(this.bB);
        summaryField.setName(name.trim());
        summaryField.setField(field);
        summaryField.setSummaryFieldType(0);
        summaryField.ie = 1;
        if (operation < 0 || operation > 20) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongSummaryType, objectArray);
        }
        summaryField.Na = operation;
        this.bB.IA = (SummaryField[])Fields.a((Field[])this.bB.IA, summaryField);
        this.a(summaryField, 0);
        this.b(null);
        return summaryField;
    }

    public SummaryField addSummaryField(Field field, Field field2nd, int operation, String name) throws ReportException {
        SummaryField summaryField = this.addSummaryField(field, operation, name);
        summaryField.setField2nd(field2nd);
        return summaryField;
    }

    public void removeSummaryField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.IA == null) {
            return;
        }
        this.a(idx, this.bB.IA);
        SummaryField summaryField = this.bB.IA[idx];
        this.bB.IA = (SummaryField[])this.a(this.bB.IA, idx);
        this.a(summaryField, 1);
    }

    public SpecialField getSpecialField(int type) {
        if (type >= RDC.Ah.length) {
            if (type >= this.bB.Iw.length) {
                throw new IndexOutOfBoundsException("Arrayindex out of Bounds:" + type);
            }
            return this.bB.Iw[type];
        }
        return this.bB.Iw[RDC.Ah[type]];
    }

    public int getSpecialFieldsCount() {
        if (this.bB.Iw == null) {
            return 0;
        }
        return this.bB.Iw.length;
    }

    public SQLField getSQLExpressionField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        this.a(idx, this.bB.IB);
        return this.bB.IB[idx];
    }

    public int getSQLExpressionFieldsCount() {
        if (this.bB.IB == null) {
            return 0;
        }
        return this.bB.IB.length;
    }

    public SQLField addSQLField(String name, String sqlExpression) throws ReportException {
        if (!this.onlyTablesAndOneConnection()) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noNewSQLs, objectArray);
        }
        return this.addSQLField(name, -1, sqlExpression, this.bB.iZ().getDatasource(0));
    }

    public SQLField addSQLField(String name, int valueType, String sqlExpression, Datasource datasource) throws ReportException {
        if (!this.e(datasource)) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.noNewSQLs2, objectArray);
        }
        SQLField sQLField = new SQLField(this.bB, datasource);
        sQLField.setValueType(valueType);
        sQLField.LM = sqlExpression;
        sQLField.setName(name.trim());
        this.bB.IB = (SQLField[])Fields.a((Field[])this.bB.IB, sQLField);
        if (sqlExpression != null) {
            if (valueType == -1) {
                sQLField.setSQLExpression(sqlExpression);
            } else {
                sQLField.am(sqlExpression);
            }
        }
        this.a(sQLField, 0);
        this.b(null);
        return sQLField;
    }

    public void removeSQLField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.IB == null) {
            return;
        }
        this.a(idx, this.bB.IB);
        SQLField sQLField = this.bB.IB[idx];
        this.bB.IB = (SQLField[])this.a(this.bB.IB, idx);
        this.a(sQLField, 1);
    }

    public SortField getSortField(String fieldName) {
        if (this.bB.IC == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.IC.length; ++i2) {
            SortField sortField = this.bB.IC[i2];
            if (sortField == null) {
                return null;
            }
            if (!sortField.name.equalsIgnoreCase(fieldName)) continue;
            return sortField;
        }
        return null;
    }

    public SortField getSortField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.IC != null && this.a(idx, this.bB.IC)) {
            return this.bB.IC[idx];
        }
        return null;
    }

    public int getSortFieldsCount() {
        int n2 = 0;
        if (this.bB.IC != null) {
            n2 = this.bB.IC.length;
        }
        return n2;
    }

    public SortField addSortField(String name, int type) throws ReportException {
        Field field = this.bB.a(true, name);
        return this.addSortField(field, type);
    }

    public SortField addSortField(Field field, int type) throws ReportException {
        if (field == null) {
            throw new IllegalArgumentException("Fields.addSortField null is not a valid field");
        }
        Group group = field.getGroup();
        if (group == null) {
            for (int i2 = 0; i2 < this.bB.jd().length; ++i2) {
                if (this.bB.jd()[i2].getField() == null || this.bB.jd()[i2].getField() != field) continue;
                group = this.bB.jd()[i2];
                break;
            }
        }
        if (group != null && group.getGroupType() == 0) {
            Object[] objectArray = new Object[]{field.getName(), field.getTypeAsString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.groupAlreadyExists, objectArray);
        }
        if (field instanceof ReferenceHolder && cb.a((ReferenceHolder)((Object)field), SummaryField.class, false)) {
            Object[] objectArray = new Object[]{field.getName()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.summaryInSortField, objectArray);
        }
        SortField sortField = new SortField(this.bB);
        sortField.setName(field.getRefName());
        sortField.setSort(type);
        this.bB.IC = (SortField[])Fields.a((Field[])this.bB.IC, sortField);
        this.a(sortField, 0);
        return sortField;
    }

    public SortField addSortField(Field field, FormulaField formula) throws ReportException {
        SortField sortField = this.addSortField(field, 0);
        sortField.setSortDirectionFormula(formula);
        return sortField;
    }

    public void removeSortField(int idx) throws ReportException {
        this.bB.getEngine().cq();
        if (this.bB.IC == null) {
            return;
        }
        this.a(idx, this.bB.IC);
        SortField sortField = this.bB.IC[idx];
        this.bB.IC = (SortField[])this.a(this.bB.IC, idx);
        this.a(sortField, 1);
    }

    public void moveSortField(int from, int to) throws IndexOutOfBoundsException, ReportException {
        this.a(from, to, this.bB.IC);
    }

    static final Field[] a(Field[] fieldArray, Field field) {
        Field[] fieldArray2;
        int n2 = 0;
        if (fieldArray != null) {
            n2 = fieldArray.length;
        }
        if ((fieldArray2 = field.K(n2 + 1)).length == 1) {
            fieldArray2[0] = field;
        } else {
            System.arraycopy(fieldArray, 0, fieldArray2, 0, n2);
            fieldArray2[fieldArray2.length - 1] = field;
        }
        return fieldArray2;
    }

    private static boolean e(Field field) {
        ReferenceHolder[] referenceHolderArray = field.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            if (referenceHolderArray[i2] instanceof Element || referenceHolderArray[i2] instanceof Join) continue;
            return false;
        }
        return true;
    }

    private static void f(Field field) {
        if (field instanceof ReferenceHolder) {
            ((ReferenceHolder)((Object)field)).resetReferences();
        }
        ReferenceHolder[] referenceHolderArray = field.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            Element element;
            Section section;
            referenceHolderArray[i2].resetReferences();
            if (!(referenceHolderArray[i2] instanceof Element) || !(section = (Section)(element = (Element)referenceHolderArray[i2]).getParent()).contains(element)) continue;
            section.remove(element);
        }
    }

    private final Field[] a(Field[] fieldArray, int n2) throws ReportException {
        if (fieldArray == null) {
            return null;
        }
        this.a(n2, fieldArray);
        Field field = fieldArray[n2];
        BaseUtils.info(Msg.getMsg("removing", fieldArray[n2].paramString()));
        if (!Fields.e(fieldArray[n2])) {
            StringBuilder stringBuilder = new StringBuilder();
            ReferenceHolder referenceHolder = field.getReferenceHolders()[0];
            if (referenceHolder instanceof Field) {
                stringBuilder.append(((Field)((Object)referenceHolder)).getName());
            } else if (referenceHolder instanceof ReportComponent) {
                stringBuilder.append(((ReportComponent)referenceHolder).paramString());
            } else {
                stringBuilder.append(referenceHolder);
            }
            throw ReportExceptionFactory.createReportException(ReportErrorCode.cantRemove, field.getName(), stringBuilder);
        }
        Fields.f(fieldArray[n2]);
        Field[] fieldArray2 = fieldArray[n2].K(fieldArray.length - 1);
        System.arraycopy(fieldArray, 0, fieldArray2, 0, n2);
        System.arraycopy(fieldArray, n2 + 1, fieldArray2, n2, fieldArray2.length - n2);
        return fieldArray2;
    }

    private final void a(com.inet.report.list.a a2, int n2) throws ReportException {
        if (a2 == null) {
            return;
        }
        this.a(n2, a2);
        DatabaseField databaseField = a2.ez(n2);
        databaseField.kX.removeColumn(databaseField.getShortName());
    }

    public SummaryField sumFieldExists(int sumTyp, String field, String field2, String group, int nth, int condition) {
        if (this.bB.IA == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.bB.IA.length; ++i2) {
            SummaryField summaryField = this.bB.IA[i2];
            if (summaryField == null || summaryField.getField() == null || summaryField.Na != sumTyp || summaryField.OC != nth || !summaryField.getField().name.equalsIgnoreCase(field) || (summaryField.OE == null || field2 == null ? summaryField.OE != null || field2 != null : !summaryField.OE.name.equalsIgnoreCase(field2))) continue;
            if (group == null && summaryField.getGroup() == null) {
                return summaryField;
            }
            if (group == null || this.bB.IA[i2].getGroup() == null || summaryField.getGroup().getField() == null || !summaryField.getGroup().getField().name.equalsIgnoreCase(group) || summaryField.getGroup().getSectionWillBePrinted() != condition) continue;
            return summaryField;
        }
        return null;
    }

    void da() {
        int n2;
        int n3;
        NodeParser nodeParser;
        int n4;
        if (this.bB.Iv == null) {
            this.bB.Iv = new FormulaField[0];
        }
        if (this.bB.IA == null) {
            this.bB.IA = new SummaryField[0];
        }
        if (this.bB.Iz == null) {
            this.bB.Iz = new GroupField[0];
        }
        if (this.bB.iW() == null) {
            this.bB.a(new PromptField[0]);
        }
        if (this.bB.IB == null) {
            this.bB.IB = new SQLField[0];
        }
        block0: for (n4 = 0; n4 < this.re.size(); ++n4) {
            nodeParser = (GroupField)this.re.get(n4);
            if (((GroupField)nodeParser).do() < 0) continue;
            if (((GroupField)nodeParser).getGroup() == null) {
                for (n3 = 0; n3 < this.bB.jd().length; ++n3) {
                    Group group = this.bB.jd()[n3];
                    if (group.getField() == null) continue;
                    n2 = ((GroupField)nodeParser).do();
                    ((GroupField)nodeParser).am(n2 - 1);
                    if (n2 != 0) continue;
                    ((Field)nodeParser).setGroup(group);
                    if (((GroupField)nodeParser).type != 12) continue block0;
                    group.sE = nodeParser;
                    continue block0;
                }
                continue;
            }
            Group group = ((GroupField)nodeParser).getGroup();
            if (group.getGroupType() != 2) continue;
            group.sE = nodeParser;
        }
        cb.Q(this.bB);
        for (n4 = 0; n4 < this.rd.size(); ++n4) {
            nodeParser = (AbstractLineElement)this.rd.get(n4);
            n3 = ((AbstractLineElement)nodeParser).mu;
            if (n3 == -1) continue;
            for (int i2 = 0; i2 < this.bB.jd().length; ++i2) {
                if (this.bB.jd()[i2].sq.gk != null) {
                    for (n2 = 0; n2 < this.bB.jd()[i2].sq.gk.length; ++n2) {
                        if (this.bB.jd()[i2].sq.gk[n2].jV() != n3) continue;
                        ((AbstractLineElement)nodeParser).setEndSection(this.bB.jd()[i2].sq.gk[n2]);
                    }
                }
                if (this.bB.jd()[i2].sr == null) continue;
                for (n2 = 0; n2 < this.bB.jd()[i2].sr.gk.length; ++n2) {
                    if (this.bB.jd()[i2].sr.gk[n2].jV() != n3) continue;
                    ((AbstractLineElement)nodeParser).setEndSection(this.bB.jd()[i2].sr.gk[n2]);
                }
            }
        }
    }

    static void a(PrintWriter printWriter, Engine engine, int n2, Field[] fieldArray, String string) throws ReportException {
        String string2 = BaseUtils.getIndent(n2);
        if (fieldArray != null) {
            printWriter.print(string2 + "<" + string + ">\n");
            ArrayList<SummaryField> arrayList = engine.bB.du().qE();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (arrayList.contains(fieldArray[i2])) continue;
                fieldArray[i2].k(printWriter, n2 + 1);
            }
            printWriter.print(string2 + "</" + string + ">\n");
        }
    }

    static final void b(PrintWriter printWriter, Engine engine, int n2) throws ReportException {
        int n3;
        String string = BaseUtils.getIndent(n2);
        ArrayList<FormulaField> arrayList = new ArrayList<FormulaField>();
        if (engine.bB.Iv != null) {
            FormulaField[] formulaFieldArray = engine.bB.Iv;
            block8: for (n3 = 0; n3 < formulaFieldArray.length; ++n3) {
                FormulaField formulaField = formulaFieldArray[n3];
                switch (formulaField.rO) {
                    case 0: {
                        arrayList.add(formulaField);
                        continue block8;
                    }
                    case 1: {
                        if (formulaField == engine.bB.jb()) continue block8;
                        formulaField.rO = 0;
                        arrayList.add(formulaField);
                        continue block8;
                    }
                    case 2: {
                        if (formulaField == engine.bB.jc()) continue block8;
                        formulaField.rO = 0;
                        arrayList.add(formulaField);
                        continue block8;
                    }
                    case 3: {
                        continue block8;
                    }
                    default: {
                        formulaField.rO = 0;
                        arrayList.add(formulaField);
                    }
                }
            }
        }
        engine.bB.Iv = new FormulaField[arrayList.size()];
        arrayList.toArray(engine.bB.Iv);
        Fields.a(printWriter, engine, n2, engine.bB.Iv, "FormulaFields");
        Fields.x(engine.bB);
        Fields.a(printWriter, engine, n2, engine.bB.iW(), "PromptFields");
        Fields.a(printWriter, engine, n2, engine.bB.IB, "SQLFields");
        if (engine.bB.IB == null) {
            printWriter.print(string + "<SQLFields>");
            printWriter.print(string + "</SQLFields>");
        }
        Fields.a(printWriter, engine, n2, engine.bB.IA, "SummaryFields");
        Fields.a(printWriter, engine, n2, engine.bB.IC, "SortFields");
        Fields.a(printWriter, engine.bB.getFields(), n2);
        if (engine.bB.Iz != null) {
            int n4 = engine.bB.Iz.length;
            for (n3 = 0; n3 < engine.bB.Iz.length; ++n3) {
                if (engine.bB.Iz[n3].qr <= 0) continue;
                --n4;
            }
            printWriter.print(string + "<GroupNameFields>\n");
            for (n3 = 0; n3 < engine.bB.Iz.length; ++n3) {
                if (engine.bB.Iz[n3].qr > 0) continue;
                try {
                    engine.bB.Iz[n3].k(printWriter, n2 + 1);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    BaseUtils.warning("issues saving group field " + engine.bB.Iz[n3].name + "...");
                    BaseUtils.printStackTrace(illegalArgumentException);
                }
            }
            printWriter.print(string + "</GroupNameFields>\n");
        }
    }

    private static void a(PrintWriter printWriter, Fields fields, int n2) {
        String string = BaseUtils.getIndent(n2);
        if (fields != null) {
            printWriter.print(string + "<UserFunctions>\n");
            for (int i2 = 0; i2 < fields.getFunctionsCount(); ++i2) {
                Fields.a(fields.getFunction(i2), n2 + 1, printWriter);
            }
            printWriter.print(string + "</UserFunctions>\n");
        }
    }

    private static void a(UserFunction userFunction, int n2, PrintWriter printWriter) {
        String string = BaseUtils.getIndent(n2);
        ++n2;
        StringBuilder stringBuilder = new StringBuilder();
        printWriter.print(string + "<Field" + k.l("type", "UserFunction") + k.l("valueType", k.G(userFunction.getValueType())) + ">\n");
        if (userFunction.getName() != null) {
            k.a(stringBuilder, n2, b.a.aqy.name(), userFunction.getName());
        }
        if (userFunction.getDescription() != null) {
            k.a(stringBuilder, n2, b.a.aqx.name(), userFunction.getDescription());
        }
        k.a(stringBuilder, n2, b.a.aqz.name(), k.G(userFunction.getSyntax()));
        stringBuilder.append(BaseUtils.getIndent(n2));
        stringBuilder.append(k.h(userFunction.getFormula()));
        stringBuilder.append('\n');
        printWriter.write(stringBuilder.toString());
        printWriter.print(string + "</Field>\n");
    }

    private static void x(ba ba2) {
        boolean bl2;
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        PromptField[] promptFieldArray = ba2.iW();
        Collections.addAll(arrayList, promptFieldArray);
        block0: do {
            bl2 = false;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n2;
                PromptField promptField = (PromptField)arrayList.get(i2);
                DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
                if (!(dynamicValueProvider instanceof HasCascadingParent)) continue;
                PromptField promptField2 = ((HasCascadingParent)((Object)dynamicValueProvider)).getParent();
                int n3 = n2 = promptField2 == null ? -1 : arrayList.indexOf(promptField2);
                if (n2 <= i2) continue;
                arrayList.remove(i2);
                arrayList.add(n2, promptField);
                bl2 = true;
                continue block0;
            }
        } while (bl2);
        ba2.a(arrayList.toArray(ba2.iW()));
    }

    public boolean checkIfNameExists(int type, String name) {
        Field[] fieldArray = null;
        switch (type) {
            case 14: {
                return this.bB.ja().bW(name);
            }
            case 13: {
                fieldArray = this.bB.Iv;
                break;
            }
            case 16: {
                fieldArray = this.bB.iW();
                break;
            }
            case 11: {
                fieldArray = this.bB.IA;
                break;
            }
            case 12: {
                fieldArray = this.bB.Iz;
                break;
            }
            case 17: {
                fieldArray = this.bB.IB;
                break;
            }
            case 10: {
                fieldArray = this.bB.Iw;
                break;
            }
            case 15: {
                fieldArray = this.bB.IC;
                break;
            }
            default: {
                throw com.inet.report.y.a(type, "type", null);
            }
        }
        return Fields.a(fieldArray, name);
    }

    static boolean a(Field[] fieldArray, String string) {
        if (fieldArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            if (!fieldArray[i2].checkNameExists(string)) continue;
            return true;
        }
        return false;
    }

    public void addListener(RDC.FieldsRefreshListener frl) {
        if (this.rc == null) {
            this.rc = new EventListenerList();
        }
        this.rc.add(RDC.FieldsRefreshListener.class, frl);
    }

    public void removeListener(RDC.FieldsRefreshListener frl) {
        if (this.rc == null) {
            return;
        }
        this.rc.remove(RDC.FieldsRefreshListener.class, frl);
    }

    void a(Field field, int n2) {
        if (field == null && n2 != 3) {
            throw new RuntimeException("Field is null");
        }
        if (this.rc == null) {
            return;
        }
        Object[] objectArray = this.rc.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != RDC.FieldsRefreshListener.class) continue;
            ((RDC.FieldsRefreshListener)objectArray[i2 + 1]).refresh(new RDC.FieldsRefreshEvent(this.bB.getEngine(), field, n2));
        }
    }

    static void a(bi bi2, Field field, int n2) {
        try {
            bi2.getFields().a(field, n2);
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            BaseUtils.info("Problems occurred while submit refresh event.");
        }
    }

    private boolean a(int n2, Field[] fieldArray) {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index less than zero (" + n2 + ") is impossible.");
        }
        int n4 = n3 = fieldArray == null ? 0 : fieldArray.length;
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index " + n2 + " of " + n3 + " field(s) is impossible.");
        }
        return true;
    }

    private boolean a(int n2, com.inet.report.list.a a2) {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index less than zero (" + n2 + ") is impossible.");
        }
        int n4 = n3 = a2 == null ? 0 : a2.size();
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException("The access to a field with zero based index " + n2 + " of " + n3 + " field(s) is impossible.");
        }
        return true;
    }

    GroupField a(Group group) {
        GroupField groupField = new GroupField(this.bB, group);
        this.bB.Iz = (GroupField[])Fields.a((Field[])this.bB.Iz, groupField);
        this.a(groupField, 0);
        return groupField;
    }

    void ae(int n2) throws ReportException {
        GroupField groupField = this.bB.Iz[n2];
        this.bB.Iz = (GroupField[])this.a(this.bB.Iz, n2);
        this.a(groupField, 1);
    }

    public void changeAllAliases(String newAlias, Datasource dc) throws ReportException {
        this.b("", newAlias, dc, true);
    }

    public void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        this.b(oldAlias, newAlias, dc, false);
    }

    private void b(String string, String string2, Datasource datasource, boolean bl2) throws ReportException {
        block43: {
            int n2;
            if (this.bB == null) {
                return;
            }
            if (this.bB.jd() == null) {
                return;
            }
            ba ba2 = this.bB;
            int n3 = this.getDatabaseFieldsCount();
            StringList stringList = new StringList(datasource.getAliasList());
            String[] stringArray = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = this.getDatabaseField(i2).getName();
            }
            ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>();
            try {
                TableSource tableSource = datasource.getTableSource(string2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    Object object;
                    DatabaseField nodeParser2 = this.getDatabaseField(i3);
                    if (bl2 && nodeParser2.getReferenceHolderCount() <= 0) continue;
                    if (bl2) {
                        ReportProperties reportProperties;
                        boolean bl3 = true;
                        object = nodeParser2.getReferenceHolders();
                        for (int i2 = 0; i2 < ((ReferenceHolder[])object).length; ++i2) {
                            if (object[i2] instanceof Join) continue;
                            bl3 = false;
                            break;
                        }
                        if (bl3 || (reportProperties = ba2.getReportProperties()).isIgnoreFiltering() && Database.a((Field)nodeParser2, ba2.jb())) continue;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (tableSource.getSql() != null) {
                        object = tableSource.getSql();
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, " \"'\n\r,", true);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        while (((String)object).toLowerCase().indexOf(nodeParser2.getName().toLowerCase()) != -1 && !bl6 && stringTokenizer.hasMoreTokens()) {
                            String string3 = stringTokenizer.nextToken();
                            if (string3.equalsIgnoreCase(nodeParser2.getName())) {
                                bl4 = true;
                                continue;
                            }
                            if (bl4 && !string3.equals(" ")) {
                                if (string3.equalsIgnoreCase("as")) {
                                    bl5 = true;
                                    bl4 = false;
                                    continue;
                                }
                                bl4 = false;
                            }
                            if (!bl5 || string3.equals(" ")) continue;
                            stringBuilder.setLength(0);
                            if (string3.equals("'")) {
                                boolean bl7 = false;
                                while (stringTokenizer.hasMoreTokens() && !bl7) {
                                    string3 = stringTokenizer.nextToken();
                                    if (string3.equals("'")) {
                                        bl7 = true;
                                        continue;
                                    }
                                    stringBuilder.append(string3);
                                }
                            } else {
                                stringBuilder.setLength(0);
                                stringBuilder.append(string3);
                            }
                            bl6 = true;
                        }
                    }
                    object = "";
                    object = nodeParser2.getName();
                    int n4 = ((String)object).indexOf(46);
                    if (n4 >= 0) {
                        object = ((String)object).substring(0, n4);
                    }
                    if ((n4 = ((String)object).lastIndexOf(46)) >= 0) {
                        object = ((String)object).substring(n4 + 1);
                    }
                    if ((string.length() != 0 || !stringList.contains((String)object)) && !((String)object).equals(string)) continue;
                    try {
                        if (stringBuilder.length() == 0) {
                            stringBuilder.append(nodeParser2.getName().substring(((String)object).length() + 1));
                        }
                        String string4 = string2 + "." + stringBuilder.toString();
                        if (this.bB.ja().bW(string4)) {
                            DatabaseField databaseField = this.getDatabaseField(string4);
                            if (!arrayList.contains(databaseField) && databaseField.getReferenceHolderCount() == 0 && databaseField != nodeParser2) {
                                arrayList.add(databaseField);
                                tableSource.a(nodeParser2);
                            }
                            nodeParser2.setColumnLabel(databaseField.getColumnLabel());
                        }
                        nodeParser2.setName(string4);
                        continue;
                    }
                    catch (ReportException reportException) {
                        if (!nodeParser2.isUsed()) {
                            tableSource.addColumn(nodeParser2.getShortName(), nodeParser2.getValueType());
                            nodeParser2.setName(string2 + "." + nodeParser2.getShortName());
                            continue;
                        }
                        Object[] objectArray = new Object[]{nodeParser2.getName(), string2};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.FieldReferenced, objectArray);
                    }
                }
                for (DatabaseField databaseField : arrayList) {
                    tableSource.b(databaseField);
                }
            }
            catch (ReportException reportException) {
                n3 = this.getDatabaseFieldsCount();
                for (int i5 = 0; i5 < n3; ++i5) {
                    this.getDatabaseField(i5).setName(stringArray[i5]);
                }
                throw reportException;
            }
            for (n2 = 0; ba2.IA != null && n2 < ba2.IA.length; ++n2) {
                ba2.IA[n2].changeAliasName(string, string2);
            }
            if (ba2.jb() != null) {
                ba2.jb().a(string, string2, datasource);
            }
            if (ba2.jc() != null) {
                ba2.jc().a(string, string2, datasource);
            }
            for (n2 = 0; n2 < ba2.jd().length; ++n2) {
                if (ba2.jd()[n2] == null) continue;
                ba2.jd()[n2].changeAllAliases(string, string2, datasource);
            }
            if (this.bB.IB != null) {
                if (string.length() == 0) {
                    for (n2 = this.bB.IB.length - 1; n2 >= 0; --n2) {
                        this.removeSQLField(n2);
                    }
                } else {
                    for (n2 = this.bB.IB.length - 1; n2 >= 0; --n2) {
                        this.bB.IB[n2].changeAliasName(string, string2);
                    }
                }
            }
            for (n2 = 0; n2 < this.bB.IC.length; ++n2) {
                this.bB.IC[n2].updateName();
            }
            try {
                Subreport subreport = ba2.getEngine().getSubReportElement();
                if (subreport != null) {
                    for (int i6 = 0; i6 < subreport.Of.length; ++i6) {
                        SubreportLink subreportLink = subreport.Of[i6];
                        subreportLink.b(string, string2, datasource);
                    }
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block43;
                BaseUtils.debug(exception);
            }
        }
        int n5 = 0;
        if (this.bB.Iv != null) {
            n5 = this.bB.Iv.length;
        }
        for (int i7 = 0; i7 < n5; ++i7) {
            this.bB.Iv[i7].a(string, string2, datasource);
        }
        this.a((Field)null, 3);
    }

    public boolean onlyTablesAndOneConnection() {
        DatabaseTables databaseTables = this.bB.iZ();
        int n2 = databaseTables.getDatasourceCount();
        if (n2 > 1 || n2 == 0) {
            return false;
        }
        Datasource datasource = databaseTables.getDatasource(0);
        return this.e(datasource);
    }

    private boolean e(Datasource datasource) {
        int n2;
        if (datasource == null) {
            throw new IllegalArgumentException("Parameter 'datasource' is null");
        }
        for (n2 = 0; n2 < datasource.getTableSourceCount(); ++n2) {
            TableSource tableSource = datasource.getTableSource(n2);
            if (tableSource.getSql() != null) {
                return false;
            }
            if (tableSource.kC() == 3 || tableSource.kC() == 2) {
                return false;
            }
            try {
                if (tableSource.getType() == 1) continue;
                return false;
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) continue;
                BaseUtils.debug(exception);
            }
        }
        if (this.bB.iW() != null) {
            for (n2 = 0; n2 < this.bB.iW().length; ++n2) {
                if (this.bB.iW()[n2].yZ == null) continue;
                return false;
            }
        }
        return true;
    }

    void db() {
        int n2 = 0;
        if (this.bB.Iv != null) {
            for (int i2 = 0; i2 < this.bB.Iv.length; ++i2) {
                if (this.bB.Iv[i2].getFormulaType() != 0) continue;
                ++n2;
            }
            FormulaField[] formulaFieldArray = new FormulaField[n2];
            int n3 = 0;
            for (int i3 = 0; i3 < this.bB.Iv.length; ++i3) {
                if (this.bB.Iv[i3].getFormulaType() != 0) continue;
                formulaFieldArray[n3] = this.bB.Iv[i3];
                ++n3;
            }
            this.bB.Iv = formulaFieldArray;
        }
    }

    static Field a(int n2, ba ba2) throws ArrayIndexOutOfBoundsException {
        return ba2.Iz[n2 - 1];
    }

    static Field a(Attributes attributes, ba ba2) {
        String string = attributes.getValue("refname");
        if (string == null) {
            string = attributes.getValue("value");
        }
        return Fields.a(string, Group.c(attributes), ba2);
    }

    static Field a(String string, ba ba2) {
        return Fields.a(string, -1, ba2);
    }

    static Field a(String string, int n2, int n3, ba ba2) {
        Field[] fieldArray;
        switch (n2) {
            case 14: {
                return ba2.ja().bX(string);
            }
            case 13: {
                fieldArray = ba2.Iv;
                break;
            }
            case 11: {
                fieldArray = ba2.IA;
                break;
            }
            case 12: {
                return Fields.a(n3, ba2);
            }
            case 16: {
                fieldArray = ba2.iW();
                break;
            }
            case 15: {
                fieldArray = ba2.IC;
                break;
            }
            case 17: {
                fieldArray = ba2.IB;
                break;
            }
            case 10: {
                fieldArray = ba2.Iw;
                break;
            }
            default: {
                return null;
            }
        }
        if (fieldArray == null) {
            return null;
        }
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Field field = fieldArray[i2];
            if (!string.equalsIgnoreCase(field.name)) continue;
            return field;
        }
        return null;
    }

    static Field a(String string, int n2, ba ba2) {
        if (ba2 == null || string == null) {
            return null;
        }
        int n3 = ba.W(string = Fields.E(string));
        String string2 = n3 == 14 ? string : string.substring(1);
        return Fields.a(string2, n3, n2, ba2);
    }

    static Field b(String string, ba ba2) {
        if (string != null) {
            try {
                int n2 = SpecialField.a.valueOf(string).kk();
                Fields fields = ba2.getFields();
                return fields.getSpecialField(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static String E(String string) {
        if (string.charAt(0) == '{') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static Field b(Attributes attributes, ba ba2) {
        String string = attributes.getValue("type");
        int n2 = k.symbols.get(string);
        String string2 = attributes.getValue("value");
        Field field = null;
        switch (n2) {
            case 10: {
                field = Fields.b(string2, ba2);
                break;
            }
            case 12: {
                String string3 = attributes.getValue("id");
                int n3 = Integer.valueOf(string3);
                field = Fields.a(n3, ba2);
                break;
            }
            case 11: {
                if (string2.startsWith("{#") || string2.startsWith("#")) {
                    field = Fields.a(attributes, ba2);
                    break;
                }
                int n4 = string2.indexOf(" ");
                String string4 = string2.substring(0, n4);
                String string5 = string2.substring(n4 + 1);
                String[] stringArray = string5.split("[(),{}]");
                field = Fields.a(ba2, string4, stringArray, string2);
                break;
            }
            case 15: {
                field = ba2.getFields().getSortField(string2);
                break;
            }
            default: {
                try {
                    field = Fields.a(attributes, ba2);
                    break;
                }
                catch (Exception exception) {
                    BaseUtils.error(exception);
                }
            }
        }
        if (field == null) {
            field = new a();
        }
        return field;
    }

    static Field a(ba ba2, String string, String[] stringArray, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : stringArray) {
            if (object2.trim().length() <= 0) continue;
            arrayList.add(object2);
        }
        int n2 = SummaryField.getSummaryOperation(string);
        Field field = Fields.a((String)arrayList.get(0), ba2);
        if (field == null) {
            BaseUtils.error("field unknown while parsing summary field definition: " + (String)arrayList.get(0));
            return null;
        }
        Field field2 = null;
        if (arrayList.size() > 1) {
            field2 = Fields.a((String)arrayList.get(1), ba2);
        }
        SummaryField summaryField = new SummaryField(ba2);
        summaryField.setSummaryOperation(n2);
        summaryField.setField(field);
        if (field2 != null) {
            summaryField.setField2nd(field2);
        }
        try {
            Fields reportException = ba2.getFields();
            int n3 = reportException.getSummaryFieldsCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                SummaryField summaryField2 = reportException.getSummaryField(i2);
                if (!summaryField2.getField().equals(field) || summaryField2.getSummaryOperation() != n2) continue;
                Field field3 = summaryField2.getField2nd();
                if (!summaryField2.getName().equals(string2)) continue;
                if (field3 == null && field2 == null) {
                    return summaryField2;
                }
                if (field3 != null && field3.equals(field2)) {
                    return summaryField2;
                }
                return summaryField2;
            }
            summaryField.setName(SummaryField.generateName(field.getName(), null, n2, field2 != null ? field2.getName() : null));
            return reportException.addSummaryField(field, field2, n2, summaryField.getName());
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return null;
        }
    }

    void t(boolean bl2) {
        this.rf = bl2;
    }

    public int getFunctionsCount() {
        return this.bB.Iy.getFunctionsCount();
    }

    public UserFunction getFunction(int index) {
        return this.bB.Iy.getFunction(index);
    }

    public UserFunction getFunction(String name) {
        return this.bB.Iy.getFunction(name);
    }

    public UserFunction addFunction(String name, String formula, int syntax) {
        b b2 = this.bB.Iy.l(name, syntax);
        b2.setFormula(formula);
        return b2;
    }

    private int getFieldIndex(Field field) throws ReportException {
        switch (field.getType()) {
            case 13: {
                for (int i2 = 0; i2 < this.getFormulaFieldsCount(); ++i2) {
                    if (this.getFormulaField(i2) != field) continue;
                    return i2;
                }
                break;
            }
            case 14: {
                for (int i3 = 0; i3 < this.getDatabaseFieldsCount(); ++i3) {
                    if (this.getDatabaseField(i3) != field) continue;
                    return i3;
                }
                break;
            }
            case 16: {
                for (int i4 = 0; i4 < this.getPromptFieldsCount(); ++i4) {
                    if (this.getPromptField(i4) != field) continue;
                    return i4;
                }
                break;
            }
            case 15: {
                for (int i5 = 0; i5 < this.getSortFieldsCount(); ++i5) {
                    if (this.getSortField(i5) != field) continue;
                    return i5;
                }
                break;
            }
            case 17: {
                for (int i6 = 0; i6 < this.getSQLExpressionFieldsCount(); ++i6) {
                    if (this.getSQLExpressionField(i6) != field) continue;
                    return i6;
                }
                break;
            }
            case 11: {
                for (int i7 = 0; i7 < this.getSummaryFieldsCount(); ++i7) {
                    if (this.getSummaryField(i7) != field) continue;
                    return i7;
                }
                break;
            }
        }
        return -1;
    }

    public boolean removeField(Field field) throws ReportException {
        int n2 = this.getFieldIndex(field);
        if (n2 != -1) {
            switch (field.getType()) {
                case 13: {
                    this.removeFormulaField(n2);
                    break;
                }
                case 14: {
                    this.removeDatabaseField(n2);
                    break;
                }
                case 16: {
                    this.removePromptField(n2);
                    break;
                }
                case 15: {
                    this.removeSortField(n2);
                    break;
                }
                case 17: {
                    this.removeSQLField(n2);
                    break;
                }
                case 11: {
                    this.removeSummaryField(n2);
                }
            }
        }
        return n2 != -1;
    }

    protected static class a
    extends Field {
        public a() {
            this.name = "Unknown";
            this.setValueType(-1);
        }

        @Override
        Field[] K(int n2) {
            return new a[n2];
        }

        @Override
        protected void p(PrintWriter printWriter, int n2) {
        }

        @Override
        public void setName(String newValue) throws ReportException {
            this.name = newValue;
        }

        @Override
        public String getName() {
            return super.getName();
        }

        @Override
        Object getValue() throws ReportException {
            return null;
        }
    }
}

