/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.Engine;
import com.inet.report.EngineStatistics;
import com.inet.report.Fields;
import com.inet.report.PromptField;
import com.inet.report.PromptRequestWarning;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.ReportProperties;
import com.inet.report.af;
import com.inet.report.bi;
import com.inet.report.formula.o;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.base.j;
import com.inet.report.renderer.doc.controller.ar;
import com.inet.report.renderer.doc.controller.h;
import com.inet.report.util.EngineUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

@PublicApi
public class EngineBundle
implements ReportGenerator {
    private final ArrayList<Engine> oF = new ArrayList();
    private final String format;
    private h oG;
    private o oH;
    private DocumentOutput oI;
    private static String[] oJ = new String[]{"java", "htm", "html", "htm.zip", "pdf", "ps", "txt", "rtf", "jar", "png", "jpeg", "jpg", "gif", "bmp", "xlsx", "ods"};

    public EngineBundle(String format) throws ReportException {
        if (format == null) {
            format = "java";
        }
        this.format = format;
        if (!Arrays.asList(oJ).contains(format)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidOutFmt, format);
        }
    }

    public Engine addReportFile(String reportUrl) throws ReportException {
        Serializable serializable;
        Engine engine;
        if (this.oG == null) {
            engine = new Engine(this.format);
            if (!(engine.bB instanceof ar)) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidOutFmt, this.format);
            }
            serializable = (ar)engine.bB;
            this.oG = ((ar)serializable).zS();
            this.oH = ((bi)serializable).oH;
        } else {
            engine = new Engine(this.oG, this.oH);
        }
        engine.setReportFile(reportUrl);
        if (this.oF.size() == 0) {
            serializable = engine.getReportProperties();
            String[] stringArray = ((ReportProperties)serializable).getEnabledFormats();
            if (stringArray == null) {
                ((ReportProperties)serializable).setEnabledFormats(oJ);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                arrayList.retainAll(Arrays.asList(oJ));
                ((ReportProperties)serializable).setEnabledFormats(arrayList.toArray(new String[arrayList.size()]));
            }
        }
        this.oF.add(engine);
        return engine;
    }

    @Override
    public void setDocumentOutput(DocumentOutput documentOutput) {
        this.oI = documentOutput;
    }

    private void cD() throws PromptRequestWarning, ReportException {
        try {
            for (Engine engine : this.oF) {
                EngineUtils.checkPrompts(engine, false);
            }
        }
        catch (PromptRequestWarning promptRequestWarning) {
            throw new PromptRequestWarning("NeedPrompts", -601, this.cE());
        }
    }

    @Nonnull
    Prompt[] cE() {
        LinkedHashMap<String, Prompt> linkedHashMap = new LinkedHashMap<String, Prompt>();
        for (Engine engine : this.oF) {
            Prompt[] promptArray;
            for (Prompt prompt : promptArray = af.createSerializablePrompts(engine)) {
                linkedHashMap.put(prompt.getName(), prompt);
            }
        }
        return linkedHashMap.values().toArray(new Prompt[linkedHashMap.size()]);
    }

    @Override
    public void execute() throws ReportException {
        this.cD();
        int n2 = 0;
        for (int i2 = 0; i2 < this.oF.size(); ++i2) {
            Engine engine = this.oF.get(i2);
            engine.nR = this.oI;
            ar ar2 = (ar)engine.bB;
            ar2.j(i2 == 0, i2 == this.oF.size() - 1);
            ar2.IZ = -n2;
            engine.execute();
            n2 += engine.getDocumentPageCount();
            this.oI = engine.nR;
        }
    }

    public Engine getEngine0() throws ReportException {
        if (this.oF.size() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoRptFile, new Object[0]);
        }
        return this.oF.get(0);
    }

    public List<Engine> getEngines() {
        return Collections.unmodifiableList(this.oF);
    }

    @Override
    public int getPageCount() throws ReportException {
        return this.getEngine0().getPageCount();
    }

    @Override
    public byte[] getPageData(int page) throws ReportException {
        return this.getEngine0().getPageData(page);
    }

    @Override
    public void stop(String message) {
        for (Engine engine : this.oF) {
            engine.stop(message);
        }
    }

    @Override
    @Nonnull
    public EngineStatistics getStatistics() {
        if (this.oF.size() == 0) {
            return new j();
        }
        return this.oF.get(0).getStatistics();
    }

    @Override
    public void setUserProperties(Properties props) throws ReportException {
        for (Engine engine : this.oF) {
            engine.setUserProperties(props);
        }
    }

    @Override
    public void setClientLocale(@Nonnull Locale locale) throws ReportException {
        for (Engine engine : this.oF) {
            engine.setClientLocale(locale);
        }
    }

    @Override
    public void stopAfterPage(int maxPageNo) {
        for (Engine engine : this.oF) {
            engine.stopAfterPage(maxPageNo);
        }
    }

    @Override
    public void setPrompt(String name, String prompt) throws ReportException {
        for (Engine engine : this.oF) {
            engine.setPrompt(name, prompt);
        }
    }

    @Override
    public PromptField getPromptField(String name) throws ReportException {
        for (Engine engine : this.oF) {
            PromptField promptField = engine.getPromptField(name);
            if (promptField == null) continue;
            return promptField;
        }
        return null;
    }

    @Override
    public void setPrompt(String prompt, int i2) throws ReportException {
        int n2 = 0;
        for (Engine engine : this.oF) {
            Fields fields = engine.getFields();
            int n3 = i2 - n2;
            if (fields.getPromptFieldsCount() > n3) {
                engine.setPrompt(prompt, n3);
                return;
            }
            n2 += fields.getPromptFieldsCount();
        }
    }
}

