/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.ParameterList;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.SimpleResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DatabaseInformix
extends Database {
    @Override
    protected String[] parseSourceName(String sqlSource) {
        String[] stringArray = new String[3];
        stringArray[0] = null;
        int n2 = sqlSource.indexOf("@");
        if (n2 != -1) {
            stringArray[0] = sqlSource.substring(0, n2);
        }
        if ((n2 = sqlSource.indexOf(":")) != -1 && stringArray[0] == null) {
            stringArray[0] = sqlSource.substring(0, n2);
        }
        if (stringArray[0] == null) {
            n2 = 0;
        }
        stringArray[1] = null;
        int n3 = sqlSource.indexOf(".");
        if (n3 != -1 && n3 > n2) {
            stringArray[1] = sqlSource.substring(n2 == 0 ? n2 : n2 + 1, n3);
        }
        stringArray[2] = null;
        if (sqlSource.length() > n3) {
            stringArray[2] = sqlSource.substring(n3 + 1);
        }
        return stringArray;
    }

    @Override
    public ResultSet getProcedureColumns(Datasource ds, String catalog, String schema, String procedure) throws SQLException, ReportException {
        ResultSet resultSet;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] getProcedureColumns " + catalog + " " + schema + " " + procedure);
        }
        if ((resultSet = super.getProcedureColumns(ds, catalog, schema, procedure)) instanceof SimpleResultSet) {
            BaseUtils.error("[DB] getProcedureColumns exception occurs");
            resultSet = super.getProcedureColumns(ds, null, null, procedure);
        }
        SimpleResultSet simpleResultSet = new SimpleResultSet(resultSet);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("patch ResultSet of getProcedureColumns.");
        }
        List<Object[]> list = simpleResultSet.getAllRows();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object[] objectArray = list.get(i2);
            String string = (String)objectArray[3];
            if (BaseUtils.isDebug()) {
                if (string == null) {
                    BaseUtils.debug("[DB] row name is null");
                } else {
                    BaseUtils.debug("[DB] row name:" + string);
                }
            }
            if (string != null && !string.equals("null")) continue;
            String string2 = "(expression):" + (i2 + 1);
            objectArray[3] = string2;
            if (!BaseUtils.isDebug()) continue;
            BaseUtils.debug("row " + simpleResultSet.getRow() + "  -> " + string2);
        }
        return simpleResultSet;
    }

    @Override
    protected void scanIdentifierQuoteString(Datasource ds) throws SQLException, ReportException {
        try (Connection connection = ds.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = this.getConfiguration().getIdentifierQuoteString();
            string = databaseMetaData.getIdentifierQuoteString();
            if (string == null || string.trim().length() == 0) {
                string = "\"";
            }
            DatabaseInformix.a(databaseMetaData, true, true);
        }
    }

    @Override
    protected String getColumnName(String columnName, String alias, int driverVersion, TableSource ts, int colIdx) {
        if (columnName == null || columnName.length() == 0 || columnName.equalsIgnoreCase("(expression)")) {
            Object object = null;
            if (ts.getColumnCount() <= colIdx) {
                object = "(expression):" + colIdx;
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("New Stored Procedure column \"" + columnName + "\" -> " + (String)object);
                }
            } else {
                object = ts.getColumnName(colIdx);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("Stored Procedure column \"" + columnName + "\" -> " + (String)object);
                }
            }
            return object;
        }
        return columnName;
    }

    @Override
    public String getAddOp() {
        return "||";
    }

    @Override
    public String sqlConcat(Object leftOperant, Object rightOperant) {
        if (leftOperant instanceof String || rightOperant instanceof String) {
            return String.valueOf(leftOperant) + "||" + String.valueOf(rightOperant);
        }
        return super.sqlConcat(leftOperant, rightOperant);
    }

    @Override
    public int getMaxAliasNameLength() {
        return 18;
    }

    @Override
    protected boolean scanSourceType(TableSource ts, ParameterList dataTypeScale, boolean useMetaDataCache) throws SQLException, ReportException {
        boolean bl2 = super.scanSourceType(ts, dataTypeScale, useMetaDataCache);
        if (!bl2) {
            String string = "(expression):";
            for (int i2 = 0; i2 < ts.getColumnCount(); ++i2) {
                String string2 = ts.getColumnName(i2);
                if (string2.indexOf(string) <= -1) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2 && BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] is a Informix SP");
        }
        return bl2;
    }

    @Override
    protected String getSourceNameWithChange(TableSource ts, boolean escapeEverything) {
        Datasource datasource = ts.getDatasource();
        String string = ts.getDatabaseIdentifier();
        String[] stringArray = this.parseSourceName(string);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] getSourceNameWithChange catalog " + stringArray[0] + " schema " + stringArray[1] + " table " + stringArray[2]);
        }
        if (datasource.ce() || datasource.cf()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (datasource.cf() && stringArray[0] != null) {
                stringArray[0] = datasource.getCatalog();
            }
            if (datasource.ce()) {
                stringArray[1] = datasource.getSchema();
            }
            if (stringArray[0] != null) {
                stringBuilder.append(stringArray[0]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(':');
            }
            if (stringArray[1] != null) {
                stringBuilder.append(stringArray[1]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[2]);
            string = stringBuilder.toString();
        } else if (!"informix".equalsIgnoreCase(stringArray[1])) {
            string = stringArray[2];
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[DB] getSourceNameWithChange result: " + string);
        }
        return this.getSqlIdentifier(datasource, string, escapeEverything);
    }
}

