'use strict';(function(){angular.module("locationmodule",[]).service("locationservice",function($rootScope,$timeout,$location){var locationActions={};var defaultLocationOpenHandler=undefined;var defaultLocationRemoveHandler=undefined;var unhandledPathChangedHandler=undefined;var beforeUnloadFunctions=[];var initialized=false;var $this=this;this.setDefaultHandlers=function(defaultOpenHandler,defaultRemoveHandler){defaultLocationOpenHandler=defaultOpenHandler;defaultLocationRemoveHandler=defaultRemoveHandler};
this.setUnhandledPathChangedHandler=function(handler){unhandledPathChangedHandler=handler};this.isLocationActionRegistered=function(command){return locationActions[command]!=undefined};this.unregisterLocationAction=function(command){this.removePath(command);delete locationActions[command]};this.registerLocationAction=function(command,paramCount,onOpen,onRemove,onBeforeRemove){locationActions[command]={paramCount:paramCount,onOpen:onOpen,onRemove:onRemove,onBeforeRemove:onBeforeRemove};if(initialized){var currentCommands=
extractCommands($this.getPath());var cmd=currentCommands[command];if(cmd!=undefined)if(cmd.onOpen!=undefined)cmd.onOpen.apply(null,cmd.params)}};this.registerBeforeUnload=function(beforeUnloadFunction){beforeUnloadFunctions.push(beforeUnloadFunction)};this.unregisterBeforeUnload=function(beforeUnloadFunction){var index=beforeUnloadFunctions.indexOf(beforeUnloadFunction);if(index>=0)beforeUnloadFunctions.splice(index,1)};this.getPath=function(){return $location.path()||""};this.setPath=function(path,
replace){$location.path(path);if(replace)$location.replace()};this.addPath=function(commandAndParameters,replace){var path=$this.getPath();var existingCommands=extractCommands(path);if(commandAndParameters.indexOf("/")==0)commandAndParameters=commandAndParameters.substring(1);var newParts=commandAndParameters.split("/");var newCommand=newParts[0];newParts.splice(0,1);var existingCmd=existingCommands[newCommand];if(existingCmd!=undefined)existingCmd.params=newParts;else existingCommands[newCommand]=
{command:newCommand,params:newParts};var parts=[];var keys=Object.keys(existingCommands);for(var i=0;i<keys.length;i++){var key=keys[i];parts.push(key);var params=existingCommands[key].params;for(var p=0;p<params.length;p++)parts.push(params[p])}path=parts.join("/");$location.path(path);if(replace)$location.replace()};this.removePath=function(command,replace){var path=$this.getPath();if(path.indexOf("/")==0)path=path.substring(1);var parts=path.split("/");for(var i=0;i<parts.length;i++){var p=parts[i];
var actionContainer=locationActions[p];if(actionContainer!=undefined)if(p==command){parts.splice(i,actionContainer.paramCount+1);i--}else i+=actionContainer.paramCount}var newpath=parts.join("/");if(newpath==path)return;$location.path(newpath);if(replace)$location.replace()};this.initialize=function(){initialized=true;handleLocation($this.getPath(),"/")};this.executeAction=function(command){var commands=extractCommands($this.getPath());var cmd=commands[command];if(cmd!=undefined)if(cmd.onOpen!=undefined)cmd.onOpen.apply(null,
cmd.params)};var extractCommands=function(path){var commands={};if(path.indexOf("/")==0)path=path.substring(1);var parts=path.split("/");for(var i=0;i<parts.length;i++){var p=parts[i];if(p.length==0)continue;var actionContainer=locationActions[p];if(actionContainer!=undefined){commands[p]={command:p,params:parts.slice(i+1,i+1+actionContainer.paramCount),onOpen:actionContainer.onOpen,onRemove:actionContainer.onRemove,onBeforeRemove:actionContainer.onBeforeRemove};i+=actionContainer.paramCount}else commands[p]=
{command:p,params:[],onOpen:undefined,onRemove:undefined,onBeforeRemove:undefined}}return commands};this.hasCommand=function(command){var currentCommands=extractCommands($this.getPath());var cmd=currentCommands[command];return cmd!=undefined};this.getCommandParams=function(command){var currentCommands=extractCommands($this.getPath());var cmd=currentCommands[command];return cmd!=undefined?cmd.params:undefined};var parameterChanged=function(oldParameter,newParameter){if(oldParameter.length!=newParameter.length)return true;
for(var i=0;i<oldParameter.length;i++){var o=oldParameter[i];var n=newParameter[i];if(o!=n)return true}return false};var handleLocation=function(newPath,oldPath){var newCommands=extractCommands(newPath);var oldCommands=extractCommands(oldPath);var added=[];var removed=[];var newUnhandledPath="";var oldUnhandledPath="";var newKeys=Object.keys(newCommands);for(let i=0;i<newKeys.length;i++){let key=newKeys[i];let newCmd=newCommands[key];let oldCmd=oldCommands[key];if(oldCmd==undefined||parameterChanged(oldCmd.params,
newCmd.params))added.push(newCmd);if(locationActions[newCmd.command]==undefined)newUnhandledPath+="/"+newCmd.command}var oldKeys=Object.keys(oldCommands);for(let i=0;i<oldKeys.length;i++){let key=oldKeys[i];let oldCmd=oldCommands[key];let newCmd=newCommands[key];if(newCmd==undefined||parameterChanged(oldCmd.params,newCmd.params))removed.push(oldCmd);if(locationActions[oldCmd.command]==undefined)oldUnhandledPath+="/"+oldCmd.command}var unhandledOpen=[];var unhandledRemove=[];for(let i=0;i<removed.length;i++){var r=
removed[i];if(r.onRemove!=undefined)r.onRemove.apply(null,r.params);else unhandledRemove.push(r.command)}for(let i=0;i<added.length;i++){var a=added[i];if(a.onOpen!=undefined)a.onOpen.apply(null,a.params);else unhandledOpen.push(a.command)}if(typeof defaultLocationRemoveHandler=="function")for(let i=0;i<unhandledRemove.length;i++)defaultLocationRemoveHandler(unhandledRemove[i]);if(typeof defaultLocationOpenHandler=="function")for(let i=0;i<unhandledOpen.length;i++)defaultLocationOpenHandler(unhandledOpen[i]);
if(typeof unhandledPathChangedHandler=="function")if(newUnhandledPath!=oldUnhandledPath)unhandledPathChangedHandler(newUnhandledPath)};var handleBeforeRemove=function(newPath,oldPath){var newCommands=extractCommands(newPath);var oldCommands=extractCommands(oldPath);var removed=[];var oldKeys=Object.keys(oldCommands);for(let i=0;i<oldKeys.length;i++){var key=oldKeys[i];var oldCmd=oldCommands[key];var newCmd=newCommands[key];if(newCmd==undefined||parameterChanged(oldCmd.params,newCmd.params))removed.push({oldCmd:oldCmd,
newCmd:newCmd})}for(let i=0;i<removed.length;i++){var r=removed[i];if(r.oldCmd.onBeforeRemove!=undefined){let params=r.oldCmd.params.slice(0);let newCmdParams=(r.newCmd||{params:new Array(r.oldCmd.params.length)}).params;params.push(...newCmdParams);params.push(oldPath);params.push(newPath);var result=r.oldCmd.onBeforeRemove.apply(null,params);if(result===false)return false}}return true};var getRelativePath=function(path){var windowLocationPath=decodeURI(Util.getUrlParser(window.location.href).pathname);
var baseHrefPath=decodeURI(Util.getUrlParser($("base").attr("href")).pathname);var pathParser=Util.getUrlParser(path);if(windowLocationPath.indexOf(baseHrefPath)!=0||!$location.$$html5){var hash=pathParser.hash;if(hash.length>1)hash=hash.substring(1);return hash}var result=decodeURI(pathParser.pathname);result=result.substring(baseHrefPath.length);var index=result.indexOf("?");if(index==-1)return result;return result.substring(0,index)};$rootScope.$on("$locationChangeStart",function(event,newPath,
oldPath){if(newPath===oldPath)return;var result=handleBeforeRemove(getRelativePath(newPath),getRelativePath(oldPath));if(result===false)event.preventDefault()});$rootScope.$on("$locationChangeSuccess",function(event,newPath,oldPath){if(newPath===oldPath)return;handleLocation(getRelativePath(newPath),getRelativePath(oldPath))});window.onbeforeunload=function(){for(var i=beforeUnloadFunctions.length-1;i>=0;i--){var result=beforeUnloadFunctions[i]();if(result)return result}}})})();