/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.modules.signup;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.LoginManager;
import com.inet.classloader.I18nMessages;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.servlet.NopHttpServletResponse;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ModuleMetaData;
import com.inet.remote.gui.angular.ReplaceOutputStream;
import com.inet.usersandgroups.api.ui.fields.user.LoginDescription;
import com.inet.usersandgroups.api.ui.fields.user.LoginsUserFieldDefinition;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;

@InternalApi
public class SignupAngularApplicationServlet
extends AngularApplicationServlet {
    private static final I18nMessages MSG = new I18nMessages("com.inet.remote.gui.modules.signup.i18n.LanguageResources", SignupAngularApplicationServlet.class);

    public SignupAngularApplicationServlet() {
        super("/signup");
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LoginSettings loginSettings = LoginManager.getAddSignUpModeResult((HttpServletRequest)request);
        if (loginSettings != null) {
            this.a(loginSettings, (HttpServletRequest)request, response);
            return;
        }
        String string = request.getPathInfo();
        if (request.getParameter("method") != null || string != null && ("/signupform.html".equals(string) || string.startsWith("/weblib/"))) {
            super.service((HttpServletRequest)request, response);
            return;
        }
        if (!StringFunctions.isEmpty((String)string) && !string.equals("/")) {
            String string2 = request.getParameter("userid");
            GUID gUID = null;
            if (!StringFunctions.isEmpty((String)string2)) {
                gUID = GUID.valueOf((String)string2);
            }
            List list = LoginManager.getAuthenticationDescriptions((HttpServletRequest)request);
            string = string.substring(1);
            for (AuthenticationDescription authenticationDescription : list) {
                Object object;
                if (!string.equals(authenticationDescription.getName())) continue;
                String string3 = request.getParameter("signupToken");
                if (!StringFunctions.isEmpty((String)string3)) {
                    object = "Basic " + Base64.getEncoder().encodeToString(string3.getBytes(StandardCharsets.UTF_8));
                    request = new HttpServletRequestWrapper((HttpServletRequest)request, (String)object){
                        final /* synthetic */ String aL;
                        {
                            this.aL = string;
                            super(httpServletRequest);
                        }

                        public String getHeader(String name) {
                            if ("authorization".equalsIgnoreCase(name)) {
                                return this.aL;
                            }
                            return super.getHeader(name);
                        }
                    };
                    LoginManager.startAddSignUpMode((HttpServletRequest)request, (AuthenticationDescription)authenticationDescription, (GUID)gUID);
                    LoginManager.initHttpRequest((HttpServletRequest)request, (HttpServletResponse)new NopHttpServletResponse());
                    loginSettings = LoginManager.getAddSignUpModeResult((HttpServletRequest)request);
                    if (loginSettings != null) {
                        this.a(loginSettings, (HttpServletRequest)request, response);
                        return;
                    }
                    response.addHeader("x-lastformloginsuccessful", "true");
                }
                if ((object = authenticationDescription.getBasicSupport()) != AuthenticationDescription.BasicSupport.No) {
                    PluginDispatcherServlet.forward((String)("/signupbasic/" + string), (HttpServletRequest)request, (HttpServletResponse)response);
                } else {
                    LoginManager.startAddSignUpMode((HttpServletRequest)request, (AuthenticationDescription)authenticationDescription, (GUID)gUID);
                    LoginManager.forceLogin((AuthenticationDescription)authenticationDescription, (HttpServletRequest)request, (HttpServletResponse)response);
                }
                return;
            }
        }
        super.service((HttpServletRequest)request, response);
    }

    private void a(LoginSettings loginSettings, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        LoginDescription loginDescription = SignupAngularApplicationServlet.createLoginDescriptionFromSetting(loginSettings, httpServletRequest);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("LOGIN_SETTINGS", new Json().toJson((Object)loginDescription));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ReplaceOutputStream replaceOutputStream = new ReplaceOutputStream(byteArrayOutputStream, hashMap);
        try (InputStream inputStream = this.getClass().getResourceAsStream("/com/inet/remote/gui/modules/signup/signupsuccess.html");){
            IOFunctions.copyData((InputStream)inputStream, (OutputStream)replaceOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            AngularContentService.serveStaticContent(httpServletRequest, httpServletResponse, (InputStream)byteArrayInputStream, System.currentTimeMillis(), "text/html", false);
        }
    }

    public static LoginDescription createLoginDescriptionFromSetting(LoginSettings login, HttpServletRequest request) {
        ArrayList arrayList = new ArrayList(LoginManager.getAllAuthenticationDescriptions());
        String string = login.getLoginSource();
        String string2 = login.getLoginID();
        String string3 = string;
        Object object = null;
        for (Object object2 : arrayList) {
            if ("system".equals(string)) {
                if (!(object2.getProvider() instanceof SystemAuthenticationProvider)) continue;
                object = object2;
                break;
            }
            if (!object2.getName().equals(string)) continue;
            object = object2;
            string3 = object2.getProvider().name();
            break;
        }
        if (object != null) {
            Object object2;
            String string4 = object.getName();
            object2 = object.getDisplayName();
            String string5 = object.getColor();
            String string6 = GUID.generateNew().toString();
            LoginDescription loginDescription = new LoginDescription(string3, string4, (String)object2, string5, string2, login.getDisplayName(), true);
            loginDescription.setUid(string6);
            LoginsUserFieldDefinition.putLoginInSession((String)string6, (LoginSettings)login);
            return loginDescription;
        }
        if (UserManager.getInstance().getCurrentUserAccountID() == null) {
            throw new ClientMessageException("signup.nomatchingauthentication");
        }
        return null;
    }

    @Override
    public void handleGet(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        if (pathInfo != null && pathInfo.startsWith("weblib/")) {
            AngularContentService.serveLibResource(request, response, pathInfo.substring(7));
            return;
        }
        if (pathInfo != null && pathInfo.equals("signupform.html")) {
            AngularContentService.serveStaticContent(request, response, this.getClass().getClassLoader().getResource("com/inet/remote/gui/modules/signup/signupform.html"), replace, this.getPathSpec(), false);
            return;
        }
        if (!LoginManager.isUserCanRegister()) {
            throw new ClientMessageException(MSG.getMsg("signup.disabled", new Object[0]));
        }
        if (UserManager.getInstance().getCurrentUserAccountID() != null) {
            throw new ClientMessageException(MSG.getMsg("signup.alreadyloggedin", new Object[0]));
        }
        ModuleMetaData moduleMetaData = new ModuleMetaData(this.getPath(), this.getClass().getResource("signup.html"));
        moduleMetaData.addJsPath("signupmodule.app.js");
        moduleMetaData.setName(MSG.getMsg("module.signup.name", new Object[0]));
        AngularContentService.serveTemplate(request, response, replace, moduleMetaData);
    }
}

