/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.angular;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AccessForbiddenException;
import com.inet.authentication.base.LoginManager;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.ModulePriority;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.error.ErrorCodeHelper;
import com.inet.error.HasErrorCode;
import com.inet.error.ServiceUnavailableException;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.PluginServlet;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.io.data.DataURLConnection;
import com.inet.lib.json.EncodedWriter;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.DependencyClassLoader;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.ModuleManager;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.remote.gui.a;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.remote.gui.angular.ErrorPacket;
import com.inet.remote.gui.angular.ModuleMetaData;
import com.inet.remote.gui.angular.PWAPromptFilter;
import com.inet.remote.gui.angular.RemoteAngularThemeService;
import com.inet.remote.gui.angular.ReplaceOutputStream;
import com.inet.remote.gui.modules.signup.handler.b;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.shared.servlet.ServletUtils;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class AngularContentService {
    public static final String KEY_USERID = "userid";
    public static final String KEY_ACCOUNT_REGISTRATION_ACTIVE = "accountregistrationactive";
    public static final String KEY_GUESTACCOUNT_ACTIVE = "guestaccountactive";
    public static final String KEY_IS_GUESTACCOUNT = "isguestaccount";
    public static final String KEY_BASE_PATH = "base_path";
    public static final String KEY_PUBLIC_HREF = "public_href";
    public static final String KEY_PRIVATE_HREF = "private_href";
    public static final String KEY_SERVER_ROOT = "root_path";
    public static final String KEY_BUILD_VERSION = "build_version";
    public static final String KEY_LANGUAGE = "language";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_PRODUCT_NAME = "product_name";
    public static final String KEY_IMPRINT_LINK = "imprint_link";
    public static final String KEY_TEMPLATE_CONTENT = "template_content";
    public static final String KEY_META_TAGS = "meta_tags";
    public static final String KEY_LINK_CANONICAL = "link_canonical";
    public static final String KEY_MODULE_ENTRIES = "module_entries";
    public static final String KEY_MODULE_ENTRIES_SIZE = "module_entries_size";
    public static final String KEY_MODULE_NAME = "module_name";
    public static final String KEY_MODULE_TITLE = "module_title";
    public static final String KEY_MODULE_ICON = "module_icon";
    public static final String KEY_MODULE_ICON_XS = "module_icon_xs";
    public static final String KEY_MODULE_ICON_MD = "module_icon_md";
    public static final String KEY_MODULE_PATH = "module_path";
    public static final String KEY_MODULE_JS = "module_js";
    public static final String KEY_MODULE_AVAILABLE = "module_available";
    public static final String KEY_PWA_TITLE = "pwa_title";
    public static final String KEY_PWA_SHOWINSTALLPROMPT = "pwa_showinstallprompt";
    public static final String KEY_PWA_MANIFEST = "pwa_manifest";
    public static final String KEY_MAIN_CSS = "main_css";
    public static final String KEY_MODULE_COLOR = "module_color";
    public static final String KEY_MAIN_COLOR = "main_color";
    public static final String KEY_NOSCRIPT_INFORMATION = "NOSCRIPT_INFORMATION";
    public static final String KEY_INSTANCE_ID = "INSTANCE_ID";
    public static final String KEY_REDIRECT_URL = "REDIRECT_URL";
    public static final String KEY_IS_ACCOUNT_MANAGABLE = "isaccountmanagable";
    public static final String KEY_RUNTIME_MODE = "runtimemode";
    public static final String KEY_PLUGINS_HASHCODE = "plugins_hashcode";
    public static final String KEY_COOKIEBANNER_MESSAGE = "COOKIEBANNER_MESSAGE";
    public static final String KEY_COOKIEBANNER_LINK = "COOKIEBANNER_LINK";
    public static final String KEY_COOKIEBANNER_ACTIVE = "COOKIEBANNER_ACTIVE";
    private static final ConfigValue<String> k = new ConfigValue(ConfigKey.IMPRINT_CONTENT_URL);
    private static final ConfigValue<String> l = new ConfigValue(ConfigKey.IMPRINT_CONTENT_LINKTEXT);
    private static final ConfigValue<String> m = new ConfigValue(ConfigKey.PWA_PROMPT_FILTER);
    private static final ConfigValue<Boolean> o = new ConfigValue(ConfigKey.COOKIEBANNER_ACTIVE);
    private static final ConfigValue<String> p = new ConfigValue(ConfigKey.COOKIEBANNER_MESSAGE);
    private static final ConfigValue<String> q = new ConfigValue(ConfigKey.COOKIEBANNER_LINK);
    private static final ThreadLocal<SimpleDateFormat> r = new ThreadLocal();
    private static FileCombiner u;
    public static final String RESOURCE_PATH = "com/inet/remote/gui/angular/weblib/";
    private static String w;
    private static ConfigValue<String> x;

    public static String getSupportEmail() {
        if (x == null) {
            x = new ConfigValue<String>(ConfigKey.SUPPORT_EMAIL){

                protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                    super.setValue(CoreSystemStructureProvider.getSupportEmail((String)strValue, (LicenseInfo)ConfigKeyParser.getCurrent()));
                }
            };
        }
        return (String)x.get();
    }

    public static void sendClientError(HttpServletRequest req, HttpServletResponse resp, ClientMessageException cme) throws IOException {
        if (resp.isCommitted()) {
            return;
        }
        ServletOutputStream servletOutputStream = resp.getOutputStream();
        if ("POST".equalsIgnoreCase(req.getMethod())) {
            resp.setContentType("application/error-json");
            ErrorPacket errorPacket = new ErrorPacket(cme);
            new Json().toJson((Object)errorPacket, (OutputStream)servletOutputStream);
        } else {
            resp.setContentType("text/plain; charset=utf-8");
            servletOutputStream.write(cme.getMessage().getBytes(StandardCharsets.UTF_8));
        }
        resp.flushBuffer();
    }

    public static void serveStaticContent(HttpServletRequest request, HttpServletResponse response, URL resourceUrl, Map<String, String> replaceMap, String modulePath, boolean allowCache) throws IOException {
        AngularContentService.serveStaticContent(request, response, resourceUrl, replaceMap, modulePath, (long)(allowCache ? 43200000 : 1000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URLs point to internal resources. Access is checked by callers.")
    public static void serveStaticContent(HttpServletRequest request, HttpServletResponse response, URL resourceUrl, Map<String, String> replaceMap, String modulePath, long cachetime) throws IOException {
        Object object;
        if (resourceUrl == null) {
            throw new FileNotFoundException(request.getPathInfo() + (String)(request.getQueryString() == null ? "" : "?" + request.getQueryString()));
        }
        URLConnection uRLConnection = resourceUrl.openConnection();
        String string = null;
        if (!(uRLConnection instanceof HttpURLConnection)) {
            if (uRLConnection instanceof DataURLConnection) {
                string = ((DataURLConnection)uRLConnection).getContentType();
            }
            if (string == null) {
                string = MimeTypes.getMimeType((String)resourceUrl.getFile());
            }
        }
        if (string == null && (string = uRLConnection.getContentType()) == null && (object = ServletUtils.getServletContext()) != null) {
            string = object.getMimeType(resourceUrl.getPath());
        }
        if (string != null) {
            AngularContentService.a(response, string);
        }
        if (ServletUtils.checkLastModified((HttpServletRequest)request, (HttpServletResponse)response, (long)uRLConnection.getLastModified(), (long)cachetime)) {
            return;
        }
        object = null;
        try {
            Object object2;
            object = uRLConnection.getInputStream();
            if ("text/html".equals(uRLConnection.getContentType()) || resourceUrl.getFile().endsWith("/manifest.webmanifest")) {
                Map<String, String> map = AngularContentService.buildReplaceMap(request, modulePath);
                if (replaceMap == null) {
                    replaceMap = map;
                } else {
                    replaceMap.putAll(map);
                }
            } else {
                replaceMap = null;
            }
            int n = uRLConnection.getContentLength();
            if (replaceMap != null) {
                object2 = new ByteArrayOutputStream();
                ReplaceOutputStream replaceOutputStream = new ReplaceOutputStream((OutputStream)object2, replaceMap);
                IOFunctions.copyData((InputStream)object, (OutputStream)replaceOutputStream);
                replaceOutputStream.close();
                ((InputStream)object).close();
                object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                n = ((InputStream)object).available();
            }
            object2 = null;
            if (ServerPluginManager.DEBUG && string != null && (string.toLowerCase().startsWith("application/javascript") || string.toLowerCase().startsWith("application/x-javascript") || string.toLowerCase().startsWith("text/javascript")) && !string.toLowerCase().endsWith("; nostrict")) {
                object2 = "'use strict';\r\n".getBytes(StandardCharsets.UTF_8);
                n += ((Object)object2).length;
            }
            response.setContentLength(n);
            if (object2 != null) {
                response.getOutputStream().write((byte[])object2);
            }
            AngularContentService.a(response, (InputStream)object);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
    }

    public static void serveStaticContent(HttpServletRequest request, HttpServletResponse response, URL resourceUrl, String modulePath, long cachetime) throws IOException {
        AngularContentService.serveStaticContent(request, response, resourceUrl, null, modulePath, cachetime);
    }

    public static void serveStaticContent(HttpServletRequest request, HttpServletResponse response, URL resourceUrl, String modulePath, boolean allowCache) throws IOException {
        AngularContentService.serveStaticContent(request, response, resourceUrl, null, modulePath, allowCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serveStaticContent(HttpServletRequest request, HttpServletResponse response, @Nonnull InputStream resourceStream, long lastmodified, String mimeType, boolean allowCache) throws IOException {
        try {
            AngularContentService.a(response, mimeType);
            if (ServletUtils.checkLastModified((HttpServletRequest)request, (HttpServletResponse)response, (long)lastmodified, (long)(allowCache ? 43200000 : 1000))) {
                return;
            }
            if (ServerPluginManager.DEBUG && mimeType != null && (mimeType.toLowerCase().startsWith("application/javascript") || mimeType.toLowerCase().startsWith("application/x-javascript") || mimeType.toLowerCase().startsWith("text/javascript")) && !mimeType.toLowerCase().endsWith("; nostrict")) {
                response.getOutputStream().write("'use strict';\r\n".getBytes(StandardCharsets.UTF_8));
            }
            AngularContentService.a(response, resourceStream);
        }
        finally {
            resourceStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serveStaticContent(HttpServletRequest request, HttpServletResponse response, @Nonnull InputStream resourceStream, long lastmodified, String mimeType, long cachetime) throws IOException {
        try {
            AngularContentService.a(response, mimeType);
            if (ServletUtils.checkLastModified((HttpServletRequest)request, (HttpServletResponse)response, (long)lastmodified, (long)cachetime)) {
                return;
            }
            if (ServerPluginManager.DEBUG && mimeType != null && (mimeType.toLowerCase().startsWith("application/javascript") || mimeType.toLowerCase().startsWith("application/x-javascript") || mimeType.toLowerCase().startsWith("text/javascript")) && !mimeType.toLowerCase().endsWith("; nostrict")) {
                response.getOutputStream().write("'use strict';\r\n".getBytes(StandardCharsets.UTF_8));
            }
            AngularContentService.a(response, resourceStream);
        }
        finally {
            resourceStream.close();
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URLs are provided by caller and are internal resources.")
    public static void serveTemplate(HttpServletRequest request, HttpServletResponse response, Map<String, String> replaceMap, ModuleMetaData moduleMetaData) throws IOException {
        URL uRL = moduleMetaData.getInnerContentResource();
        if (uRL == null) {
            throw new FileNotFoundException(request.getPathInfo() + (String)(request.getQueryString() == null ? "" : "?" + request.getQueryString()));
        }
        URLConnection uRLConnection = uRL.openConnection();
        String string = "application/octetstream";
        if (ServletUtils.getServletContext() != null) {
            string = ServletUtils.getServletContext().getMimeType(uRL.getPath());
        }
        long l = uRLConnection.getLastModified();
        try (InputStream inputStream = AngularContentService.createTemplate(request, replaceMap, uRLConnection, moduleMetaData);){
            AngularContentService.serveStaticContent(request, response, inputStream, l, string, false);
        }
    }

    public static void serveWebManifest(HttpServletRequest request, HttpServletResponse response, String modulePath) throws IOException {
        IModule iModule;
        ModuleManager moduleManager;
        Map<String, String> map = AngularContentService.buildReplaceMap(request, modulePath);
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        String string = request.getContextPath();
        String string2 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + string + "/favicon.ico";
        map.put("module_icon_64", string2);
        map.put("module_icon_128", string2);
        map.put("module_icon_256", string2);
        map.put("module_icon_512", string2);
        map.put(KEY_MODULE_COLOR, ApplicationDescription.get().getRemoteGuiInformation().getMainColor());
        map.put(KEY_MODULE_NAME, applicationDescription.getRemoteGuiInformation().getProductTitle());
        map.put(KEY_MODULE_TITLE, applicationDescription.getRemoteGuiInformation().getProductTitle());
        map.put(KEY_MODULE_PATH, "/");
        map.put("module_description", "");
        map.put("context", string);
        String string3 = modulePath;
        if (StringFunctions.isEmpty((String)string3) && (moduleManager = PluginDispatcherServlet.getRootServlet((HttpServletRequest)request)) != null) {
            string3 = moduleManager.getPathSpec();
        }
        if ((iModule = (moduleManager = ModuleManager.getInstance()).getModule(string3)) != null) {
            map.put("module_icon_64", map.get(KEY_SERVER_ROOT) + "start/?method=getModuleIcon&modulepath=" + iModule.getPath() + "&iconsize=64");
            map.put("module_icon_128", map.get(KEY_SERVER_ROOT) + "start/?method=getModuleIcon&modulepath=" + iModule.getPath() + "&iconsize=128");
            map.put("module_icon_256", map.get(KEY_SERVER_ROOT) + "start/?method=getModuleIcon&modulepath=" + iModule.getPath() + "&iconsize=256");
            map.put("module_icon_512", map.get(KEY_SERVER_ROOT) + "start/?method=getModuleIcon&modulepath=" + iModule.getPath() + "&iconsize=512");
            if (!"/start".equals(iModule.getPath())) {
                map.put(KEY_MODULE_NAME, iModule.getName());
                if (!StringFunctions.isEmpty((String)modulePath)) {
                    map.put(KEY_MODULE_TITLE, applicationDescription.getRemoteGuiInformation().getProductTitle() + " - " + iModule.getName());
                }
                map.put(KEY_MODULE_PATH, modulePath + "/");
                String string4 = iModule.getDescription();
                if (string4 != null) {
                    int n = string4.indexOf(10, 10);
                    if (n > 0) {
                        string4 = string4.substring(0, n).trim();
                    }
                    string4 = string4.replace("\"", "\\\"");
                } else {
                    string4 = "";
                }
                map.put("module_description", string4);
                String string5 = iModule.getColor();
                if (!StringFunctions.isEmpty((String)string5)) {
                    map.put(KEY_MODULE_COLOR, string5);
                }
            }
        }
        AngularContentService.serveStaticContent(request, response, AngularContentService.class.getResource("/com/inet/remote/gui/modules/pwa/manifest.webmanifest"), map, modulePath, false);
    }

    public static void serveIcon(HttpServletRequest request, HttpServletResponse response, byte[] icon) throws IOException {
        if (icon != null) {
            String string = switch (string = MimeTypes.getMimeTypeFromData((byte[])icon)) {
                case "text/xml; charset=utf-8" -> "image/svg+xml";
                case "image/svg+xml", "image/jpeg", "image/png" -> {
                }
                default -> "image/jpeg";
            };
            String string2 = new FastByteArrayInputStream(icon);
            AngularContentService.serveStaticContent(request, response, (InputStream)((Object)string2), System.currentTimeMillis(), string, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream createTemplate(HttpServletRequest request, Map<String, String> replaceMap, URLConnection connection, ModuleMetaData moduleMetaData) throws IOException {
        ReplaceOutputStream replaceOutputStream;
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        Object object5;
        String string2;
        Object object6;
        void var9_20;
        Object object7;
        Object object11;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        Map<String, String> map = AngularContentService.buildReplaceMap(request, moduleMetaData.getPath());
        if (replaceMap != null) {
            map.putAll(replaceMap);
        }
        replaceMap = map;
        String string3 = "";
        try (Object object12 = connection.getInputStream();){
            object11 = new ByteArrayOutputStream();
            ReplaceOutputStream object102 = new ReplaceOutputStream((OutputStream)object11, replaceMap);
            IOFunctions.copyData((InputStream)object12, (OutputStream)object102);
            object102.close();
            string3 = new String(((ByteArrayOutputStream)object11).toByteArray(), StandardCharsets.UTF_8);
        }
        replaceMap.put(KEY_TEMPLATE_CONTENT, string3);
        object12 = new StringBuilder();
        for (String string4 : moduleMetaData.getJsPaths()) {
            object7 = "weblib/" + string4 + "?version=" + map.get(KEY_BUILD_VERSION) + "&lang=" + map.get(KEY_LOCALE) + "&hashcode=" + map.get(KEY_PLUGINS_HASHCODE);
            ((StringBuilder)object12).append("<script src=\"");
            ((StringBuilder)object12).append((String)object7);
            if (string4.endsWith(".mjs")) {
                ((StringBuilder)object12).append("\" type=\"module\"");
            } else {
                ((StringBuilder)object12).append("\" type=\"text/javascript\"");
            }
            ((StringBuilder)object12).append("></script>\n\t");
        }
        replaceMap.put(KEY_MODULE_JS, ((StringBuilder)object12).toString());
        if (!(!moduleMetaData.isPwaEnabled() || ConfigurationManager.isRecoveryMode() || ConfigurationManager.isHelpCenterMode() || userAccount == null || userAccount.getAccountType().equals((Object)UserAccountType.Guest) || userAccount.getAccountType().equals((Object)UserAccountType.Temp))) {
            replaceMap.put(KEY_PWA_MANIFEST, "<link rel=\"manifest\" href=\"weblib/manifest.webmanifest\">");
        } else {
            replaceMap.put(KEY_PWA_MANIFEST, "");
        }
        object11 = map.get(KEY_USERID);
        String string5 = "?u=" + (String)object11;
        object7 = request.getParameter("theme");
        String string6 = request.getParameter("themecolors");
        String string7 = request.getParameter("themetimestamp");
        if (object7 != null && !((String)object7).isEmpty()) {
            String string8 = string5 + "&theme=" + EncodingFunctions.encodeUrlParameter((String)object7);
        }
        if (string6 != null && !string6.isEmpty()) {
            void var9_16;
            String string9 = (String)var9_16 + "&themecolors=" + EncodingFunctions.encodeUrlParameter((String)string6);
        }
        if (string7 != null && !string7.isEmpty()) {
            void var9_18;
            String string10 = (String)var9_18 + "&themetimestamp=" + EncodingFunctions.encodeUrlParameter((String)string7);
        }
        String string11 = (String)var9_20 + "&time=" + System.currentTimeMillis();
        String string12 = "<link rel=\"stylesheet\" href=\"weblib/remotegui.styles.css" + string11 + "\">";
        string12 = string12 + "\n<link rel=\"stylesheet\" href=\"weblib/defaultfont.css" + string11 + "\">";
        replaceMap.put(KEY_MAIN_CSS, string12);
        Object object8 = "";
        String string13 = StringFunctions.encodeHTML((String)(String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + request.getContextPath()), (boolean)true) + "/favicon.ico";
        String string14 = StringFunctions.encodeHTML((String)(String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + request.getContextPath()), (boolean)true) + "/favicon.ico";
        String string15 = StringFunctions.encodeHTML((String)(String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + request.getContextPath()), (boolean)true) + "/favicon.ico";
        String string16 = moduleMetaData.getName() == null ? "" : moduleMetaData.getName();
        String string17 = moduleMetaData.getTitle() == null ? "" : moduleMetaData.getTitle();
        ModulePriority modulePriority = null;
        if (userAccount != null && (object6 = (String)userAccount.getValue(RemoteGuiServerPlugin.USERFIELD_REMOTEGUI_MODULEPRIORITIES)) != null) {
            modulePriority = (ModulePriority)new Json().fromJson((String)object6, ModulePriority.class);
        }
        object6 = ApplicationDescription.get();
        if (modulePriority == null) {
            modulePriority = object6.getRemoteGuiInformation().getModulePriority();
        }
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        List<String> list = ModuleManager.getInstance().getPaths();
        if (list.remove("/setup")) {
            linkedHashMap.put("/setup", Boolean.TRUE);
        }
        for (String string18 : modulePriority.getPriorityModules()) {
            if (!list.remove(string18)) continue;
            linkedHashMap.put(string18, Boolean.TRUE);
        }
        for (String string19 : modulePriority.getOtherModules()) {
            if (!list.remove(string19)) continue;
            linkedHashMap.put(string19, Boolean.FALSE);
        }
        for (String string20 : list) {
            linkedHashMap.put(string20, Boolean.FALSE);
        }
        object8 = (String)object8 + "<div class=\"moduleEntries\">";
        boolean bl = false;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            string2 = (String)entry.getKey();
            boolean bl2 = (Boolean)entry.getValue();
            IModule iModule = ModuleManager.getInstance().getModule(string2);
            if (!bl2) {
                if (bl) {
                    object8 = (String)object8 + "</div>";
                    object8 = (String)object8 + "<div class=\"moduleEntries\">";
                }
                bl = false;
            } else {
                bl = true;
            }
            object5 = AngularContentService.a(iModule.getName(), replaceMap.get(KEY_SERVER_ROOT) + string2.substring(1), string2, moduleMetaData.getIconServiceName(), iModule.getColor(), string2.equals(moduleMetaData.getPath()));
            object8 = (String)object8 + "<li style=\"position: relative;\">" + (String)object5 + "</li>\n";
            if (!string2.equals(moduleMetaData.getPath())) continue;
            string16 = iModule.getName();
            string13 = replaceMap.get(KEY_SERVER_ROOT) + "start/?method=" + moduleMetaData.getIconServiceName() + "&amp;modulepath=" + string2 + "&amp;iconsize=128";
            string14 = replaceMap.get(KEY_SERVER_ROOT) + "start/?method=" + moduleMetaData.getIconServiceName() + "&amp;modulepath=" + string2 + "&amp;iconsize=16";
            string15 = replaceMap.get(KEY_SERVER_ROOT) + "start/?method=" + moduleMetaData.getIconServiceName() + "&amp;modulepath=" + string2 + "&amp;iconsize=32";
        }
        object8 = (String)object8 + "</div>";
        I18nMessages i18nMessages = AngularApplicationServlet.I18N;
        String string21 = StringFunctions.encodeHTML((String)i18nMessages.getMsg("remoteinterface.menuback", new Object[]{i18nMessages.getMsg("remoteinterface.menuname", new Object[0])}));
        string2 = AngularContentService.a(request, map);
        object8 = "<ul class=\"dropdown-menu dropdown-menu-right top-menu\"><div class=\"homelink\"><a href=\"" + string2 + "\" target=\"_self\">" + string21 + "</a></div>" + (String)object8;
        object8 = (String)object8 + "</ul>";
        IModule iModule = ModuleManager.getInstance().getModule(moduleMetaData.getPath());
        replaceMap.put(KEY_MODULE_ENTRIES, (String)object8);
        replaceMap.put(KEY_MODULE_ENTRIES_SIZE, String.valueOf(linkedHashMap.size()));
        replaceMap.put(KEY_MODULE_ICON, string13);
        replaceMap.put(KEY_MODULE_ICON_XS, string14);
        replaceMap.put(KEY_MODULE_ICON_MD, string15);
        replaceMap.put(KEY_MODULE_NAME, StringFunctions.encodeHTML((String)string16, (boolean)false));
        replaceMap.put(KEY_MODULE_TITLE, StringFunctions.encodeHTML((String)(string17.isEmpty() ? string16 : string17), (boolean)false));
        replaceMap.put(KEY_MODULE_PATH, moduleMetaData.getPath());
        replaceMap.put(KEY_PWA_TITLE, StringFunctions.encodeHTML((String)(StringFunctions.isEmpty((String)string16) || iModule == null || iModule.isInternal() || iModule.getPath().equals("/") ? replaceMap.get(KEY_PRODUCT_NAME) : string16), (boolean)false));
        boolean bl3 = moduleMetaData.isShowPwaPrompt();
        if (bl3) {
            bl3 = false;
            if (userAccount != null && userAccount.getAccountType().equals((Object)UserAccountType.Standard)) {
                bl3 = true;
                object5 = (String)m.get();
                if (!StringFunctions.isEmpty((String)object5)) {
                    try {
                        object4 = (PWAPromptFilter)ServerPluginManager.getInstance().getSingleInstanceByName(PWAPromptFilter.class, (String)object5, false);
                        bl3 = object4.canShowPWAPrompt();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        }
        replaceMap.put(KEY_PWA_SHOWINSTALLPROMPT, String.valueOf(bl3));
        replaceMap.put(KEY_MODULE_AVAILABLE, iModule == null || iModule.isInternal() || iModule.getPath().equals("/setup") ? "noModuleAvailable" : "moduleAvailable");
        if (iModule == null) {
            replaceMap.put(KEY_MODULE_COLOR, object6.getRemoteGuiInformation().getMainColor());
        } else {
            object5 = iModule.getColor();
            if (object5 == null || ((String)object5).isEmpty()) {
                object5 = object6.getRemoteGuiInformation().getMainColor();
            }
            replaceMap.put(KEY_MODULE_COLOR, (String)object5);
        }
        replaceMap.put(KEY_MAIN_COLOR, object6.getRemoteGuiInformation().getMainColor());
        object5 = replaceMap.getOrDefault(KEY_META_TAGS, "");
        if (iModule != null) {
            object4 = iModule.getName();
            string = moduleMetaData.getTitle();
            if (!StringFunctions.isEmpty((String)string)) {
                object4 = string;
            }
            object5 = (String)object5 + "<meta property=\"og:title\" content=\"" + StringFunctions.encodeHTML((String)object4, (boolean)false) + "\">\n";
            object5 = (String)object5 + "<meta property=\"twitter:title\" content=\"" + StringFunctions.encodeHTML((String)object4, (boolean)false) + "\">\n";
            object3 = request.getRequestURL();
            if (object3 != null) {
                object5 = (String)object5 + "<meta property=\"og:url\" content=\"" + StringFunctions.encodeHTML((String)((StringBuffer)object3).toString(), (boolean)false) + "\">\n";
                object5 = (String)object5 + "<meta property=\"twitter:url\" content=\"" + StringFunctions.encodeHTML((String)((StringBuffer)object3).toString(), (boolean)false) + "\">\n";
            }
            object2 = iModule.getDescription();
            object = moduleMetaData.getDescription();
            if (!StringFunctions.isEmpty((String)object)) {
                object2 = object;
            }
            if (!StringFunctions.isEmpty((String)object2)) {
                object5 = (String)object5 + "<meta name=\"description\" content=\"" + StringFunctions.encodeHTML((String)object2, (boolean)false) + "\">\n";
                object5 = (String)object5 + "<meta property=\"og:description\" content=\"" + StringFunctions.encodeHTML((String)object2, (boolean)false) + "\">\n";
                object5 = (String)object5 + "<meta property=\"twitter:description\" content=\"" + StringFunctions.encodeHTML((String)object2, (boolean)false) + "\">\n";
            }
        }
        replaceMap.put(KEY_META_TAGS, (String)object5);
        object4 = (String)p.get();
        if (StringFunctions.isEmpty((String)object4)) {
            object4 = RemoteGuiServerPlugin.WEBLIB_MESSAGES.getMsg("cookiebanner.defaultmessage", new Object[0]);
        }
        object4 = StringFunctions.encodeHTML((String)object4, (boolean)false);
        replaceMap.put(KEY_COOKIEBANNER_MESSAGE, (String)object4);
        replaceMap.put(KEY_COOKIEBANNER_LINK, (String)q.get());
        replaceMap.put(KEY_COOKIEBANNER_ACTIVE, String.valueOf(o.get()).toLowerCase());
        if (iModule != null && !iModule.getPath().equals("/start")) {
            string = object6.getVersion();
            object3 = null;
            object2 = iModule.getClass().getClassLoader();
            if (object2 instanceof DependencyClassLoader) {
                object = ((DependencyClassLoader)object2).getPluginId();
                replaceOutputStream = ServerPluginManager.getInstance().getPluginDescription((String)object);
                if (replaceOutputStream != null) {
                    object3 = replaceOutputStream.getVersion();
                }
            }
            if (object3 != null && object3.compareTo((Version)string) != 0) {
                replaceMap.put("version", RemoteGuiServerPlugin.getVersion() + " | " + iModule.getName() + " " + String.valueOf(object3));
            }
        }
        string = "template/template.html";
        object3 = AngularContentService.class.getResource(string).openConnection();
        object2 = null;
        object2 = ((URLConnection)object3).getInputStream();
        object = new ByteArrayOutputStream();
        replaceOutputStream = new ReplaceOutputStream((OutputStream)object, replaceMap);
        IOFunctions.copyData((InputStream)object2, (OutputStream)replaceOutputStream);
        replaceOutputStream.close();
        ((InputStream)object2).close();
        object2 = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
        return object2;
    }

    private static String a(HttpServletRequest httpServletRequest, Map<String, String> map) {
        PluginServlet pluginServlet = PluginDispatcherServlet.getRootServlet((HttpServletRequest)httpServletRequest);
        if (pluginServlet != null && !"/start".equals(pluginServlet.getPathSpec())) {
            return map.get(KEY_SERVER_ROOT) + "/start".substring(1);
        }
        return map.get(KEY_SERVER_ROOT);
    }

    private static String a(String string, String string2, String string3, String string4, String string5, boolean bl) {
        string = StringFunctions.encodeHTML((String)string, (boolean)false);
        StringBuilder stringBuilder = new StringBuilder();
        if (string5 == null || string5.isEmpty()) {
            string5 = ApplicationDescription.get().getRemoteGuiInformation().getMainColor();
        }
        if (string3 == null || string3.isEmpty()) {
            string3 = "error";
        }
        stringBuilder.append("<a class=\"btn btn-default moduleEntry applauncher " + (bl ? "currentapp" : "") + "\" style=\"outline-color:" + string5 + ";\" target=\"_self\" href=\"" + (String)(string2 != null ? string2 + "/" : "") + "\">\n");
        stringBuilder.append("    <div class=\"icon\">\n");
        stringBuilder.append("         <img ng-src=\"{{$root.rootPath}}start/?method=" + string4 + "&amp;modulepath=" + string3 + "&amp;iconsize=48\"");
        stringBuilder.append("          ng-srcset=\"{{$root.rootPath}}start/?method=" + string4 + "&amp;modulepath=" + string3 + "&amp;iconsize=96 2x,");
        stringBuilder.append("          {{$root.rootPath}}start/?method=" + string4 + "&amp;modulepath=" + string3 + "&amp;iconsize=64 1.5x\">\n");
        stringBuilder.append("     </div>\n");
        stringBuilder.append("    <div class=\"titlewrapper\">\n");
        stringBuilder.append("        <div class=\"title\">\n");
        stringBuilder.append("            <div class=\"colormarker\" ng-style=\"{'background-color':'" + string5 + "'}\" style=\"background-color: " + string5 + ";\">\n");
        stringBuilder.append("             </div>\n");
        stringBuilder.append("            <div class=\"titletext\">\n");
        stringBuilder.append("                " + string);
        stringBuilder.append("             </div>\n");
        stringBuilder.append("         </div>\n");
        stringBuilder.append("     </div>\n");
        stringBuilder.append("</a>");
        return stringBuilder.toString();
    }

    private static void a(HttpServletResponse httpServletResponse, InputStream inputStream) throws IOException {
        IOFunctions.copyData((InputStream)inputStream, (OutputStream)httpServletResponse.getOutputStream());
    }

    private static void a(HttpServletResponse httpServletResponse, String object) {
        if (object != null) {
            if (((String)object).equals("application/x-javascript") || ((String)object).equals("text/html")) {
                object = (String)object + "; charset=utf-8";
            }
        } else {
            object = "application/octet-stream";
        }
        if (((String)object).endsWith("; nostrict")) {
            object = ((String)object).substring(0, ((String)object).length() - 10);
        }
        httpServletResponse.setContentType((String)object);
    }

    public static void handleError(HttpServletRequest request, HttpServletResponse response, String pathInfo, String modulePath, ErrorCode errorCode, Throwable error) throws IOException {
        Object object;
        int n;
        block30: {
            if (pathInfo == null) {
                pathInfo = "";
            }
            if (error != null && ServletErrorHandler.isClientAbort((Throwable)error)) {
                return;
            }
            if ("/reporterror".equals(modulePath)) {
                try {
                    response.setStatus(500);
                    response.setContentType("text/html");
                    byte[] byArray = "<html><head><title>Internal Server Error</title></head><body><h1>500 Internal Server Error</h1><p>Error occurred displaying the error page. Please see server log for further details</p></body></html>".getBytes("UTF-8");
                    response.setContentLength(byArray.length);
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    servletOutputStream.write(byArray);
                    servletOutputStream.flush();
                }
                catch (IOException iOException) {
                    AngularApplicationServlet.LOGGER.error((Throwable)iOException);
                }
                return;
            }
            if (error instanceof HasErrorCode) {
                n = ((HasErrorCode)error).getErrorCode();
            } else if (errorCode != null) {
                n = errorCode.getErrorCodeNumber();
                error = new a(errorCode, (Throwable)error, !pathInfo.isEmpty() ? pathInfo : modulePath);
            } else {
                n = error instanceof FileNotFoundException ? BaseErrorCode.AccessDeniedOrFileNotExists.getErrorCodeNumber() : 0;
            }
            if (error == null) {
                error = errorCode == null ? new IllegalArgumentException("Must pass in an errorCode or an exception!") : new a(errorCode, pathInfo);
            }
            int n2 = ErrorCodeHelper.getHttpStatusCode((Throwable)error);
            response.setStatus(n2);
            if (response.isCommitted()) {
                return;
            }
            if (n2 == 401) {
                try {
                    if (!ServletErrorHandler.handleUnautorized((HttpServletRequest)request, (HttpServletResponse)response)) {
                        return;
                    }
                    break block30;
                }
                catch (ServiceUnavailableException serviceUnavailableException) {
                    AngularContentService.handleError(request, response, pathInfo, modulePath, null, serviceUnavailableException);
                    return;
                }
            }
            if (ErrorCodeHelper.isServiceUnavailable((Throwable)error) || error instanceof ClientMessageException || ErrorCodeHelper.isNotFoundCode((Throwable)error) || n2 == 400 || n2 == 403 || n == BaseErrorCode.InvalidOrigin.getErrorCodeNumber()) {
                AngularApplicationServlet.LOGGER.debug(error);
            } else {
                AngularApplicationServlet.LOGGER.error((Throwable)error);
            }
        }
        if ("POST".equalsIgnoreCase(request.getMethod()) && LoginManager.isApplicationRequest((HttpServletRequest)request)) {
            if (error instanceof ClientMessageException) {
                AngularContentService.sendClientError(request, response, (ClientMessageException)((Object)error));
            } else {
                AngularContentService.sendClientError(request, response, new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)error)));
            }
            return;
        }
        boolean bl = ErrorCodeHelper.isHideStackTraceToUser((Throwable)error, (HttpServletRequest)request);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("0", StringFunctions.encodeHTML((String)StringFunctions.getUserFriendlyErrorMessage((Throwable)error, (!bl ? 1 : 0) != 0)));
        hashMap.put("1", String.valueOf(n));
        hashMap.put("2", StringFunctions.encodeHTML((String)(((Throwable)error).getLocalizedMessage() == null ? "" : ((Throwable)error).getLocalizedMessage().trim().replace('\n', ' '))));
        hashMap.put("4", RemoteGuiServerPlugin.getVersion());
        try {
            hashMap.put("5", System.getProperty("java.version", "") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"));
        }
        catch (Throwable throwable) {
            hashMap.put("5", "");
        }
        try {
            hashMap.put("6", System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""));
        }
        catch (Throwable throwable) {
            hashMap.put("6", "");
        }
        try {
            hashMap.put("7", StringFunctions.encodeHTML((String)ApplicationDescription.get().getApplicationName()));
        }
        catch (Throwable throwable) {
            hashMap.put("7", "Product version");
        }
        if (bl) {
            hashMap.put("4", "");
            hashMap.put("5", "");
            hashMap.put("6", "");
            hashMap.put("8", "");
        } else {
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            ((Throwable)error).printStackTrace(printWriter);
            hashMap.put("8", ((StringWriter)object).toString().replace("<", "&#60;").replace(">", "&#62;"));
        }
        hashMap.put("supportmail", AngularContentService.getSupportEmail());
        object = AngularContentService.findHandlerForModulePath("/reporterror");
        if (object == null) {
            AngularContentService.handleError(request, response, pathInfo, "/reporterror", null, null);
        } else {
            ((AngularApplicationServlet)object).handle(request, response, pathInfo, hashMap);
        }
    }

    protected static SimpleDateFormat getFormatter() {
        SimpleDateFormat simpleDateFormat = r.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            r.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    public static AngularApplicationServlet findHandlerForModulePath(String modulePath) {
        DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
        List list = dynamicExtensionManager.get(PluginServlet.class);
        for (PluginServlet pluginServlet : list) {
            if (!pluginServlet.getPathSpec().equals(modulePath) || !(pluginServlet instanceof AngularApplicationServlet)) continue;
            return (AngularApplicationServlet)pluginServlet;
        }
        return null;
    }

    public static Map<String, String> buildReplaceMap(HttpServletRequest request, String modulePath) {
        String string;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = request.getServletPath();
        if (string2 == null) {
            string2 = "";
        }
        if ("/".equals(string2)) {
            modulePath = null;
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (modulePath == null) {
            modulePath = string2;
        } else {
            string2 = "";
        }
        if (string2.equals(modulePath)) {
            string2 = "";
        }
        Object object2 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + request.getContextPath();
        object2 = StringFunctions.encodeHTML((String)object2, (boolean)true);
        hashMap.put(KEY_BASE_PATH, (String)object2 + string2 + modulePath + "/");
        Object object3 = "";
        object3 = object2;
        if (((String)object3).endsWith("/public")) {
            object3 = ((String)object3).substring(0, ((String)object3).length() - 7);
        }
        String string3 = (String)object3 + string2 + modulePath + "/";
        String string4 = (String)object3 + "/public" + string2 + modulePath + "/";
        String string5 = ServletUtils.getRequestPage((HttpServletRequest)request);
        if (string5 == null) {
            string5 = "";
        }
        hashMap.put(KEY_PRIVATE_HREF, string3);
        hashMap.put(KEY_PUBLIC_HREF, (String)(LoginManager.isGuestAccount() ? string4 : ""));
        hashMap.put(KEY_SERVER_ROOT, (String)object2 + "/");
        hashMap.put(KEY_REDIRECT_URL, StringFunctions.encodeHTML((String)string5));
        hashMap.put(KEY_BUILD_VERSION, AngularContentService.e());
        hashMap.put(KEY_LANGUAGE, ClientLocale.getThreadLocale().getLanguage());
        hashMap.put(KEY_LOCALE, ClientLocale.getThreadLocale().toLanguageTag());
        hashMap.put(KEY_LINK_CANONICAL, StringFunctions.encodeHTML((String)(String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)request)) + request.getRequestURI())));
        String[] stringArray = ServerPluginManager.getInstance().getLoadedPlugins();
        hashMap.put(KEY_PLUGINS_HASHCODE, String.valueOf(Arrays.asList(stringArray).hashCode()));
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount != null) {
            string6 = userAccount.getID().toString();
            bl = userAccount.getAccountType() == UserAccountType.Guest;
            boolean bl3 = bl2 = userAccount.getAccountType() == UserAccountType.Standard || userAccount.getAccountType() == UserAccountType.Temp || userAccount.getID().equals((Object)UserManager.MASTER_ACCOUNT_ID) && !ConfigurationManager.isRecoveryMode();
            if (Boolean.TRUE.equals(request.getAttribute("reportError"))) {
                bl2 = false;
            }
        }
        hashMap.put(KEY_USERID, String.valueOf(string6));
        hashMap.put(KEY_IS_ACCOUNT_MANAGABLE, String.valueOf(bl2));
        hashMap.put(KEY_GUESTACCOUNT_ACTIVE, String.valueOf(LoginManager.isGuestAccount()));
        hashMap.put(KEY_IS_GUESTACCOUNT, String.valueOf(bl));
        boolean bl4 = LoginManager.isUserCanRegister();
        if (bl4 && (object = b.a(request, true)).isEmpty()) {
            bl4 = false;
        }
        hashMap.put(KEY_ACCOUNT_REGISTRATION_ACTIVE, String.valueOf(bl4));
        object = "default";
        if (ConfigurationManager.isHelpCenterMode()) {
            object = "helpcenter";
        } else if (ConfigurationManager.isRecoveryMode()) {
            object = "recovery";
        }
        hashMap.put(KEY_RUNTIME_MODE, (String)object);
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        hashMap.put(KEY_PRODUCT_NAME, StringFunctions.encodeHTML((String)applicationDescription.getRemoteGuiInformation().getProductTitle(), (boolean)false));
        String string7 = (String)k.get();
        if (string7 != null && string7.length() > 0) {
            try {
                string7 = new URL(string7).toURI().toString();
            }
            catch (Throwable throwable) {
                string7 = null;
            }
        }
        if (string7 != null && string7.length() > 0) {
            string = (String)l.get();
            if (string == null || string.trim().length() == 0) {
                string = AngularApplicationServlet.I18N.getMsg("imprint.linktitle", new Object[0]);
            }
            hashMap.put(KEY_IMPRINT_LINK, "<a href=\"" + string7 + "\" target=\"_blank\">" + StringFunctions.encodeHTML((String)string.trim(), (boolean)false) + "</a>");
        } else {
            hashMap.put(KEY_IMPRINT_LINK, "");
        }
        string = request.getHeader("Cookie");
        if (string != null && !string.isEmpty()) {
            hashMap.put(KEY_INSTANCE_ID, string);
        }
        hashMap.put(KEY_NOSCRIPT_INFORMATION, StringFunctions.encodeHTML((String)AngularApplicationServlet.I18N.getMsg("error.noscript", new Object[0]), (boolean)false));
        hashMap.put("version", RemoteGuiServerPlugin.getVersion());
        return hashMap;
    }

    public static void writeJSON(HttpServletRequest request, HttpServletResponse response, Object responseObj) {
        block3: {
            AngularContentService.a(response, "application/binary-json");
            try {
                if (responseObj != null) {
                    String string = request.getHeader("User-Agent");
                    boolean bl = string == null || !string.contains("MSIE 8") && !string.contains("MSIE 7");
                    Object object = bl ? new EncodedWriter((OutputStream)response.getOutputStream()) : new UTF8StreamWriter((OutputStream)response.getOutputStream());
                    new Json().toJson(responseObj, (Appendable)object);
                    object.close();
                }
            }
            catch (Throwable throwable) {
                if (ServletErrorHandler.isClientAbort((Throwable)throwable)) break block3;
                AngularApplicationServlet.LOGGER.error(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serveLibResource(HttpServletRequest request, HttpServletResponse response, String resourcePath) throws IOException {
        Locale locale = ClientLocale.getThreadLocale();
        try {
            String string = request.getParameter("volatilelocale");
            if (!StringFunctions.isEmpty((String)string)) {
                ClientLocale.setThreadLocale((Locale)LocaleUtils.valueOf((String)string));
            }
            if (resourcePath != null && resourcePath.contains("..")) {
                AngularContentService.handleError(request, response, resourcePath, null, (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists, null);
                return;
            }
            FileCombiner fileCombiner = AngularContentService.d();
            FileCombiner.CombinedFile combinedFile = fileCombiner.getCombinedFile(resourcePath);
            if (combinedFile != null) {
                InputStream inputStream = combinedFile.getStream();
                AngularContentService.serveStaticContent(request, response, inputStream, combinedFile.getLastModified(), combinedFile.getMimeType(), combinedFile.isCachingAllowed());
                return;
            }
            if ("remotegui.styles.css".equals(resourcePath)) {
                AngularContentService.a(request, response);
                return;
            }
            URL uRL = AngularContentService.class.getClassLoader().getResource(RESOURCE_PATH + resourcePath);
            if (uRL != null) {
                AngularContentService.serveStaticContent(request, response, uRL, "", resourcePath != null && !resourcePath.toLowerCase().endsWith(".html") && !resourcePath.toLowerCase().endsWith(".css"));
                return;
            }
            AngularContentService.handleError(request, response, resourcePath, null, (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists, null);
        }
        finally {
            ClientLocale.setThreadLocale((Locale)locale);
        }
    }

    public static FileCombiner.CombinedFile getCombinedFile(String resourcePath) {
        FileCombiner fileCombiner = AngularContentService.d();
        return fileCombiner.getCombinedFile(resourcePath);
    }

    private static void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("text/css");
        httpServletResponse.setHeader("Expires", AngularContentService.getFormatter().format(new Date(System.currentTimeMillis())));
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (!serverPluginManager.isPluginLoaded("theme") || !RemoteAngularThemeService.getInstance().serveCorporateTheme(httpServletRequest, httpServletResponse)) {
            AngularContentService.serveLibResource(httpServletRequest, httpServletResponse, "defaulttheme.css");
        }
    }

    public static boolean checkSystemPermission(HttpServletRequest request, HttpServletResponse response, String modulePath) throws AccessForbiddenException {
        ModuleManager moduleManager = ModuleManager.getInstance();
        if (!moduleManager.isModuleAllowed(moduleManager.getModule(modulePath))) {
            throw new AccessForbiddenException();
        }
        return true;
    }

    public static void preloadI18nMessages() {
        AngularContentService.d();
        List list = ServerPluginManager.getInstance().get(CombinedFileDescription.class);
        for (CombinedFileDescription combinedFileDescription : list) {
            FileCombiner.CombinedFile combinedFile = combinedFileDescription.getCombinedFile();
            ArrayList arrayList = combinedFile.getMessages();
            if (arrayList == null) continue;
            for (I18nMessages i18nMessages : arrayList) {
                i18nMessages.getBundle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private static FileCombiner d() {
        FileCombiner fileCombiner = u;
        if (fileCombiner != null) return fileCombiner;
        Class<AngularContentService> clazz = AngularContentService.class;
        synchronized (AngularContentService.class) {
            fileCombiner = u;
            if (fileCombiner != null) return fileCombiner;
            u = fileCombiner = new FileCombiner("remotegui");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fileCombiner;
        }
    }

    private static synchronized String e() {
        if (w == null) {
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            Version version = applicationDescription.getVersion();
            w = version.getMajor() + "." + version.getMinor() + "." + version.getBuild() + "." + version.getMicroBuild();
        }
        return w;
    }
}

