import {KytosAttribute} from "./kytos-attribute.js";

/**
 * Represents a KytosSrc attribute handler that sets the 'src' attribute of a node. Usefull for images or iframes, when the src attribute contains a mustache placeholder.
 * 
 * @class
 * @extends KytosAttribute
 */
export class KytosSrc extends KytosAttribute {

	/**
	 * Handles the attachment of a source URL to a DOM node by setting its 'src' attribute.
	 *
	 * @param {HTMLElement} kytosElement - The custom element or context in which this method is called.
	 * @param {HTMLElement} node - The DOM node to which the 'src' attribute will be set.
	 * @param {string} attrName - The name of the attribute containing the source URL.
	 */
	attached(kytosElement, node, attrName) {
		let srcUrl = node.getAttribute(attrName);
		node.setAttribute('src', srcUrl);
	};
	
};

KytosAttribute.define('k-src', KytosSrc, false);
