'use strict';(function(){angular.module("clearreportsApp").service("localfilesystem",["indexedDB",function(indexedDB){var $this=this;const historyChangeListener={};function historyEntry(newId,fileHandle){return{id:newId,file:fileHandle,lastAccess:(new Date).getTime()}}$this.registerHistoryChangeListener=function(callback,storeName="inet"){if(typeof callback==="function"){let list=historyChangeListener[storeName];if(list==undefined){list=[];historyChangeListener[storeName]=list}list.push(callback)}};
$this.updateHistory=function(historyEntry,storeName="inet"){const adHocFileStore=indexedDB.createCustomStore(storeName);return indexedDB.entries(adHocFileStore).then(entries=>{entries.sort((a,b)=>b[1].lastAccess-a[1].lastAccess);for(let i=entries.length-1;i>=0;i--)if(entries[i][1].file.name===historyEntry.file.name)entries.splice(i,1);entries.splice(0,0,[historyEntry.id,{file:historyEntry.file,lastAccess:historyEntry.lastAccess}]);entries.splice(10);indexedDB.clear(adHocFileStore);return indexedDB.setMany(entries,
adHocFileStore).then(()=>{let list=historyChangeListener[storeName];if(list!=undefined)for(let i=0;i<list.length;i++)list[i](entries);return entries})})};function performActionWithPermission(permission,newId,fileHandle,storeName){return(new Promise((resolve,reject)=>{fileHandle.requestPermission({mode:permission}).then(()=>resolve(historyEntry(newId,fileHandle))).catch(error=>reject(error))})).then(file=>$this.updateHistory(file,storeName).then(()=>file))}$this.selectOpenSingleFileFromLocalSystem=
function(types,idPrefix="",storeName="inet"){return window.showOpenFilePicker({types:types,multiple:false,id:storeName}).then(fileHandles=>{if(fileHandles.length==0)return null;const newId=idPrefix+GUID.createNew();const fileHandle=fileHandles[0];return performActionWithPermission("read",newId,fileHandle,storeName)}).catch(error=>{if(error.name==="AbortError")return null;throw error;})};$this.openFile=function(fileId,storeName="inet"){const adHocFileStore=indexedDB.createCustomStore(storeName);return indexedDB.get(fileId,
adHocFileStore).then(dbFile=>performActionWithPermission("read",fileId,dbFile.file,storeName)).then(file=>file.file.getFile())};$this.selectSaveSingleFileInLocalSystem=function(suggestedFileName,types,data,idPrefix="",storeName="inet"){return window.showSaveFilePicker({suggestedName:suggestedFileName,types:types,multiple:false,id:"adhoc"}).then(fileHandle=>{if(fileHandle==undefined)return null;return fileHandle.createWritable().then(stream=>stream.write(data).then(()=>stream.close().then(()=>{const newId=
idPrefix+GUID.createNew();return performActionWithPermission("readwrite",newId,fileHandle,storeName)})))}).catch(error=>{if(error.name==="AbortError")return null;throw error;})};$this.saveFile=function(fileId,data,storeName="inet"){const adHocFileStore=indexedDB.createCustomStore(storeName);return indexedDB.get(fileId,adHocFileStore).then(dbFile=>dbFile.file.createWritable().then(stream=>stream.write(data).then(()=>stream.close())).then(()=>performActionWithPermission("readwrite",fileId,dbFile.file,
storeName)))};$this.recentFiles=function(storeName="inet"){const adHocFileStore=indexedDB.createCustomStore(storeName);return indexedDB.entries(adHocFileStore).then(entries=>{entries.sort((a,b)=>b[1].lastAccess-a[1].lastAccess);return entries})};return this}])})();