'use strict';(function(){angular.module("clearreportsApp").service("dataservice",function($http,errorservice,dialogservice,$rootScope,$q,$timeout,moduleHeader){var serverVersion=undefined;var currentUser=undefined;var reminder=undefined;var requestsRunning=false;var loadingOverlayStart=0;var loadingOverlayHideEnd=0;var requestStart=0;var pleaseWaitOverlayCount=0;var runningRequestCount=0;var pleaseWaitOverlayTimeout=undefined;var reloadsWhenReconnectedFlag=true;var url="?method\x3d";var defaultHttpOptions=
{method:"POST",transformRequest:function(data){var enc=encrypt(data);var utf8Bytes=toUTF8Array(enc);return arrayToArrayBufferView(utf8Bytes)},transformResponse:function(data,headers,status){if(data)if(headers()["content-type"]=="application/binary-json"||headers()["content-type"]=="application/error-json")if(data instanceof ArrayBuffer)data=extractJsonBytes(data);else data=extractJson(data);else{if(data instanceof ArrayBuffer)data=utf8ArrayToStr(new Uint8Array(data));if(headers()["content-type"]!=
undefined&&headers()["content-type"].indexOf("text/html")==0)data=Util.html2text(data)}return data},cache:false,timeout:6E4,responseType:"arraybuffer",headers:{"Content-Type":"application/binary-json"}};this.getActiveRequestCount=function(){return runningRequestCount};var showPleaseWait=function(delay){pleaseWaitOverlayCount++;requestsRunning=true;if(pleaseWaitOverlayCount>1)return;loadingOverlayStart=(new Date).getTime();window.clearTimeout(pleaseWaitOverlayTimeout);pleaseWaitOverlayTimeout=window.setTimeout(function(){if(requestsRunning)$("#loadingoverlay").show().triggerHandler("show")},
delay||750)};var hidePleaseWait=function(){pleaseWaitOverlayCount--;if(pleaseWaitOverlayCount>0)return;requestsRunning=false;window.clearTimeout(pleaseWaitOverlayTimeout);var loadingOverlayEnd=(new Date).getTime();var diffLoadingShown=loadingOverlayEnd-loadingOverlayStart;if(diffLoadingShown>750&&diffLoadingShown<1250){loadingOverlayHideEnd=loadingOverlayEnd+1250-diffLoadingShown;pleaseWaitOverlayTimeout=window.setTimeout(function(){$("#loadingoverlay").hide().triggerHandler("hide")},1250-diffLoadingShown)}else if(loadingOverlayHideEnd>
loadingOverlayEnd){diffLoadingShown=loadingOverlayHideEnd-loadingOverlayEnd;pleaseWaitOverlayTimeout=window.setTimeout(function(){$("#loadingoverlay").hide().triggerHandler("hide")},diffLoadingShown)}else $(".loadingoverlay").hide().triggerHandler("hide")};window.legacyEventEmitter.on("dataservice.request.started",function(data){$rootScope.$apply(function(){runningRequestCount++;requestStart=(new Date).getTime();if(data.showWaitingOverlay)showPleaseWait(750)})});window.legacyEventEmitter.on("dataservice.request.ended",
function(data){$rootScope.$apply(function(){runningRequestCount--;if(data.showWaitingOverlay)hidePleaseWait()})});this.showWaitingOverlay=function(delay){showPleaseWait(delay)};this.hideWaitingOverlay=function(){hidePleaseWait()};this.execute=function(command,opts){runningRequestCount++;requestStart=(new Date).getTime();var timeoutChecker=undefined;var defaults={handleSuccess:$.noop,beforeError:$.noop,handleError:errorservice.showerror,afterError:$.noop,beforeExecute:function(){showPleaseWait()},
afterExecute:function(){hidePleaseWait()},cancelHandler:{wasCanceled:false,canceler:$q.defer(),cancelFunction:function(){defaults.cancelHandler.wasCanceled=true;defaults.cancelHandler.canceler.resolve()}}};$.extend(defaults,opts);delete opts.data;var error=function(response){if(typeof response=="string")response={data:response};if(response instanceof Error){console.error(response);response={data:response.message}}if(response.data instanceof Blob){var fileReader=new FileReader;fileReader.onerror=function(){$timeout(function(){error({data:"Error reading blob data with error message",
status:-1})})};fileReader.onload=function(event){let result=event.target.result;if(response.data.type=="application/error-json")result=extractJson(result);$timeout(function(){error({data:result,status:response.status})})};fileReader.readAsText(response.data);return}var data=response.data;var status=response.status;var headers=response.headers;var config=response.config;if(timeoutChecker!=undefined)$timeout.cancel(timeoutChecker);runningRequestCount--;try{var requestTime=(new Date).getTime()-requestStart;
if(status<=0)if(requestTime<1E3)status=-2;var shouldSuppressError=defaults.beforeError(data,status,headers,config)===true;if(requestTime>defaultHttpOptions.timeout*10)shouldSuppressError=true;if(defaults.cancelHandler.wasCanceled===true)shouldSuppressError=true;if(!shouldSuppressError)defaults.handleError(data,status,headers,config,defaults.alertSelector,defaults.animateScrollSelector);defaults.afterError(data,status,headers,config)}finally{defaults.afterExecute(response)}};var success=function(response){var data=
response.data;var status=response.status;var headers=response.headers;var config=response.config;if(timeoutChecker!=undefined)$timeout.cancel(timeoutChecker);try{if(status!=200){error(response);return}var release=headers()["x-server-version"];var userId=headers()["x-user"];if(userId!=undefined&&userId.length>0){if(currentUser!=undefined&&userId!=currentUser){$rootScope.answerhandler=function(answer){if(answer==DIALOGSERVICE.OK)location.reload(true)};console.warn('Logged in user in current browser instance change from id "'+
currentUser+'" to id "'+userId+'"');dialogservice.showMessageBox("body",getMsg("currentuserchanged.title"),getMsg("currentuserchanged.msg"),DIALOGSERVICE.ERROR_MESSAGE,DIALOGSERVICE.OK_OPTION,"answerhandler",$rootScope)}currentUser=userId}if(release!=undefined&&release.length>0)if(serverVersion==undefined&&(release!=undefined&&release.length>0))serverVersion=release;else if(!reloadsWhenReconnectedFlag&&(release!=serverVersion||reminder!=undefined&&reminder-(new Date).getTime()<0)){console.warn("ServerVersion changed from: "+
serverVersion+" to: "+release);serverVersion=release;reminder=undefined;$rootScope.answerhandler=function(answer){if(answer=="reload"){var reloadPageNow=function(){window.location.reload(true)};var iframe=$("\x3ciframe\x3e\x3c/iframe\x3e");iframe.appendTo("body");iframe.on("load",reloadPageNow);iframe.on("error",reloadPageNow);iframe.attr("src",$rootScope.rootPath+"start/?method\x3dclearcache\x26themetimestamp\x3d"+(new Date).getTime());window.setTimeout(reloadPageNow,2E3)}else if(answer=="5minutes"){reminder=
(new Date).getTime()+1E3*60*5;appendRestartNowButton()}else if(answer=="15minutes"){reminder=(new Date).getTime()+1E3*60*15;appendRestartNowButton()}else if(answer=="30minutes"){reminder=(new Date).getTime()+1E3*60*30;appendRestartNowButton()}};var buttons=[{text:getMsg("serverversionchanged.yes"),classes:"btn-success",answer:"reload",nofocus:true},{text:getMsg("serverversionchanged.later"),classes:"btn-default",optional:[{text:getMsg("serverversionchanged.5min"),answer:"5minutes"},{text:getMsg("serverversionchanged.15min"),
answer:"15minutes"},{text:getMsg("serverversionchanged.30min"),answer:"30minutes"}]}];var productname=$("title").attr("product");var titleMsg=getMsg("serverversionchanged.title")+": "+productname+" "+release;dialogservice.showMessageBox("body",titleMsg,getMsg("serverversionchanged.msg"),DIALOGSERVICE.ERROR_MESSAGE,buttons,"answerhandler",$rootScope)}if(data&&(headers()["content-type"]=="application/binary-json"||headers()["content-type"]=="application/error-json")){data=extractJson(data);if(data.cmd==
"error"){error(response);return}}if(headers()["x-authentication-message"]!=undefined){error({data:decodeURIComponent(headers()["x-authentication-message"].replace(/\+/g,"%20")),status:status,headers:headers,config:config});return}runningRequestCount--;try{defaults.handleSuccess(data,status,headers,config)}catch(handleSuccessError){console.error(handleSuccessError);error({data:handleSuccessError,status:-1})}}finally{defaults.afterExecute(response)}};var currentHttpOptions=$.extend({},defaultHttpOptions);
defaults.beforeExecute();try{currentHttpOptions.url=url;if(defaults.url!=undefined)currentHttpOptions.url=defaults.url;currentHttpOptions.url+=command;currentHttpOptions.data=defaults.data;delete defaults.data;if(defaults.attachments!=undefined&&defaults.attachments.length>0){var contentsize=0;for(var k=0;k<defaults.attachments.length;k++){var attach=defaults.attachments[k];if(attach.file)contentsize=contentsize+attach.file.size}var timeoutSec=Math.round(contentsize/16384)+30;timeoutSec=Math.min(timeoutSec,
1800);currentHttpOptions.timeout=Math.max(6E4,timeoutSec*1E3)}if(defaults.timeout!=undefined)currentHttpOptions.timeout=defaults.timeout;currentHttpOptions.timeoutInMS=currentHttpOptions.timeout;currentHttpOptions.cancelHandler=defaults.cancelHandler;currentHttpOptions.timeout=currentHttpOptions.cancelHandler.canceler.promise;if(defaults.attachments!=undefined&&defaults.attachments.length>0){currentHttpOptions.processData=false;currentHttpOptions.contentType=false;currentHttpOptions.transformRequest=
function(data){return data};currentHttpOptions.headers={"Content-Type":undefined};var formData=new FormData;var largeContent=[];jQuery.each(defaults.attachments,function(i,att){formData.append("attachment"+i,att.file,att.name);largeContent[i]={name:att.name,lastModified:att.file.lastModifiedDate==undefined?att.file.lastModified||(new Date).getTime():att.file.lastModifiedDate.getTime(),attachmentType:att.attachmentType};var varNames=Object.keys(att);for(var v=0;v<varNames.length;v++){var varName=varNames[v];
if(varName.indexOf("$_")==0)largeContent[i][varName.substring(2)]=att[varName]}});var dataObj=JSON.parse(currentHttpOptions.data);dataObj.attachments=largeContent;formData.append("json",new Blob([JSON.stringify(dataObj)],{"type":"application/binary-json"}));currentHttpOptions.data=formData}if(defaults.encrypt===false)currentHttpOptions.transformRequest=function(data){return data};if(defaults.jsonresponse===false)currentHttpOptions.transformResponse=function(data){if(data instanceof ArrayBuffer)return utf8ArrayToStr(new Uint8Array(data));
return data};if(defaults.method!=undefined){currentHttpOptions.method=defaults.method;currentHttpOptions.processData=false;currentHttpOptions.headers={"Content-Type":undefined};currentHttpOptions.transformResponse=function(data){if(data instanceof ArrayBuffer)return utf8ArrayToStr(new Uint8Array(data));return data};currentHttpOptions.transformRequest=function(data){return data}}if(defaults.responseType=="blob")currentHttpOptions.responseType="blob";if(defaults.headers!=undefined)$.extend(currentHttpOptions.headers,
defaults.headers)}catch(e){console.error(e);error({data:e,status:-1});return}timeoutChecker=$timeout(defaults.cancelHandler.canceler.resolve,currentHttpOptions.timeoutInMS);if(defaults.attachments!=undefined&&defaults.attachments.length>0)for(var a=0;a<defaults.attachments.length;a++)(function(att,isLast){if(defaults.cancelHandler.wasCanceled===true)return;var firstBytes=att.file;if(firstBytes.size>10){firstBytes=firstBytes.slice(0,10);if(firstBytes.size<10){error({data:$rootScope.getMsg("attachmentnotreadable",
att.name),status:-1});currentHttpOptions.cancelHandler.cancelFunction();return}}var fileReader=new FileReader;fileReader.onerror=function(){if(defaults.cancelHandler.wasCanceled===true)return;error({data:$rootScope.getMsg("attachmentnotreadable",att.name),status:-1});currentHttpOptions.cancelHandler.cancelFunction()};fileReader.onload=function(event){if(defaults.cancelHandler.wasCanceled===true)return;if(isLast)$http(currentHttpOptions).then(success,error)};fileReader.readAsBinaryString(firstBytes)})(defaults.attachments[a],
a==defaults.attachments.length-1);else $http(currentHttpOptions).then(success,error);return currentHttpOptions.cancelHandler.cancelFunction};var appendRestartNowButton=function(){var actions=moduleHeader.getNavigationActions();if(actions!=undefined&&actions.length>0)for(var i=0;i<actions.length;i++)if(actions[i].restartNowAction===true)return;moduleHeader.registerNavigationAction({classname:"btn-danger",title:getMsg("serverversionchanged.yes"),label:getMsg("serverversionchanged.yes"),icon:"icon-restart-danger-inverse",
iconxs:"icon-restart-danger-inverse",restartNowAction:true,action:function(event){var reloadPageNow=function(){window.location.reload(true)};var iframe=$('\x3ciframe style\x3d"width:0px; height: 0px;"\x3e\x3c/iframe\x3e');iframe.appendTo("body");iframe.on("load",reloadPageNow);iframe.on("error",reloadPageNow);iframe.attr("src",$rootScope.rootPath+"start/?method\x3dclearcache\x26themetimestamp\x3d"+(new Date).getTime());window.setTimeout(reloadPageNow,2E3)}},true)};this.updateProgressState=function(progressState){if($rootScope.dataserviceProgressState==
undefined&&progressState!=undefined)showPleaseWait(1);else if($rootScope.dataserviceProgressState!=undefined&&progressState==undefined)hidePleaseWait();$rootScope.dataserviceProgressState=progressState};this.download=function(command,opts){$.extend(opts||{},{jsonresponse:false,responseType:"blob",handleSuccess:function(blob,status,headers,config){var filename=headers()["content-disposition"].replace(new RegExp('^.*?filename\x3d"?(.*?)"?(;.*?)?$'),"$1");if(window.navigator.msSaveOrOpenBlob){window.navigator.msSaveOrOpenBlob(blob,
filename);return}var url=window.URL.createObjectURL(blob);var $link=$("\x3ca\x3e\x3c/a\x3e").hide().attr({href:url,download:filename}).appendTo(".body");$link[0].click();$timeout(function(){window.URL.revokeObjectURL(url);$link.remove()})},handleError:function(data,status,headers,config,alertSelector,animateScrollSelector){var reader=new FileReader;reader.onloadend=function(){var response=defaultHttpOptions.transformResponse(reader.result,headers,status);errorservice.showerror(response,status,headers,
config,alertSelector,animateScrollSelector)};reader.readAsArrayBuffer(data)}});return this.execute(command,opts)};this.extractErrorMessage=function(data,status,headers){if(data&&data.cmd=="error")data=JSON.parse(data.json);else if(status==undefined){var msgNoConnection=$rootScope.getMsg("noconnection");if(data!=undefined)data=msgNoConnection+" "+data;else data=msgNoConnection}else if(status===0||status==-1&&data==undefined){var msgTimeout=$rootScope.getMsg("timeout");if(data!=undefined)data=msgTimeout+
" "+data;else data=msgTimeout}else{var msg=$rootScope.getMsg("error");if(status==undefined)status="";if(status==-1&&data!=undefined&&typeof data==="object"&&"message"in data)data=data.message;if(data==undefined||!data.length)if(status==401)data=$rootScope.getMsg("unauthorized");else data=$rootScope.getMsg("unknown");if(data!=undefined)data=msg+" "+data;else data=status+" "+msg}return Util.getHtmlDecoded(data)};this.reloadsWhenReconnected=function(flag){reloadsWhenReconnectedFlag=flag}})})();