/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.modules.importexport;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.modules.importexport.ExportableWidget;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;

@InternalApi
public interface GenericExportHandler<Folder extends ExportableWidget, Widget extends ExportableWidget> {
    default public void writeFullZip(HttpServletResponse response, String filename, @Nonnull Folder folder, boolean includeSubFolder) throws IOException {
        String string = filename;
        if (!StringFunctions.isEmpty((String)folder.getName())) {
            string = GenericExportHandler.filterString(folder.getName());
        }
        ServletUtils.setContentDisposition((HttpServletResponse)response, (String)(string + ".zip"), (boolean)false);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)response.getOutputStream()));){
            this.a(folder, "", zipOutputStream, includeSubFolder);
        }
    }

    private void a(Folder Folder, String string, ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        Object object;
        FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream((OutputStream)zipOutputStream);
        List<Widget> list = this.getWidgetsFromFolder(Folder);
        for (ExportableWidget exportableWidget : list) {
            object = new ZipEntry(string + String.valueOf(exportableWidget.getId()));
            zipOutputStream.putNextEntry((ZipEntry)object);
            this.writeWidgetData((OutputStream)fastBufferedOutputStream, exportableWidget);
            fastBufferedOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        if (bl) {
            for (ExportableWidget exportableWidget : this.getSubFoldersFromFolder(Folder)) {
                object = string + exportableWidget.getId().toString() + "/";
                zipOutputStream.putNextEntry(new ZipEntry((String)object));
                zipOutputStream.closeEntry();
                this.writeFolderDataToZip(zipOutputStream, exportableWidget, (String)object);
                this.a(exportableWidget, (String)object, zipOutputStream, bl);
            }
        }
    }

    default public void writeWidgetData(OutputStream outStream, Widget widget) throws IOException {
        new Json().toJson(widget, outStream);
    }

    @Nonnull
    public List<Widget> getWidgetsFromFolder(Folder var1);

    @Nonnull
    public @Nonnull List<@Nonnull Folder> getSubFoldersFromFolder(Folder var1);

    default public void writeFolderDataToZip(ZipOutputStream zip, Folder folder, String subPath) throws IOException {
        zip.putNextEntry(new ZipEntry(subPath + "folder.name"));
        zip.write(folder.getName().getBytes(StandardCharsets.UTF_8));
        zip.closeEntry();
    }

    public static String filterString(String str) {
        String string = "[^a-zA-Z0-9-_ ]";
        String string2 = str.replaceAll(string, "_");
        return string2;
    }
}

