/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.modules.login;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AccessForbiddenException;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.classloader.I18nMessages;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ModuleMetaData;
import com.inet.remote.gui.modules.login.handler.c;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class LoginServlet
extends AngularApplicationServlet {
    public static final I18nMessages MSG = new I18nMessages("com.inet.remote.gui.modules.login.i18n.LanguageResources", LoginServlet.class);

    public LoginServlet() {
        super("/login");
        this.addServiceMethod(new c());
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String string = request.getPathInfo();
        if (request.getParameter("method") != null || string != null && ("/loginform.html".equals(string) || string.startsWith("/weblib/"))) {
            super.service(request, response);
            return;
        }
        if (UserManager.getInstance().getCurrentUserAccountID() == null) {
            List list = LoginManager.getAuthenticationDescriptions((HttpServletRequest)request);
            if (list.isEmpty() && !LoginManager.isGuestAccount()) {
                String string2 = request.getQueryString();
                LoginProcessor.LOGGER.debug((Object)(String.valueOf(request.getRequestURL()) + (String)(StringFunctions.isEmpty((String)string2) ? "" : "?" + string2) + "]\n"));
                throw new AccessForbiddenException();
            }
            if (list.size() == 1 && ((AuthenticationDescription)list.get(0)).getBasicSupport() == AuthenticationDescription.BasicSupport.No) {
                if (!LoginManager.forceLogin((AuthenticationDescription)((AuthenticationDescription)list.get(0)), (HttpServletRequest)request, (HttpServletResponse)response)) {
                    return;
                }
                this.b(request, response);
                return;
            }
            if (!StringFunctions.isEmpty((String)string)) {
                string = string.substring(1);
                for (AuthenticationDescription authenticationDescription : list) {
                    if (!string.equals(authenticationDescription.getName())) continue;
                    if (!LoginManager.forceLogin((AuthenticationDescription)authenticationDescription, (HttpServletRequest)request, (HttpServletResponse)response)) {
                        return;
                    }
                    this.b(request, response);
                    return;
                }
            }
            super.service(request, response);
            return;
        }
        this.b(request, response);
    }

    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="Redirect to defined url with no possible user input.")
    private void b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object = ServletUtils.getRequestPage((HttpServletRequest)httpServletRequest);
        if (StringFunctions.isEmpty((String)object)) {
            object = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest)) + ProxyHttpServletRequest.getContextPath((HttpServletRequest)httpServletRequest);
        }
        String string = ServletUtils.createRedirectURL((HttpServletRequest)httpServletRequest, (String)object, null);
        httpServletResponse.sendRedirect(string);
    }

    @Override
    public void handleGet(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        if (pathInfo != null && pathInfo.startsWith("weblib/")) {
            AngularContentService.serveLibResource(request, response, pathInfo.substring(7));
            return;
        }
        if (pathInfo != null && pathInfo.equals("loginform.html")) {
            String string;
            if (replace == null) {
                replace = new HashMap();
            }
            if (!"true".equals(string = response.getHeader("x-lastformloginsuccessful"))) {
                string = "false";
            }
            replace.put("DISPLAY_LOGIN_FAILURE", string);
            String string2 = ServletUtils.getRequestPage((HttpServletRequest)request);
            if (string2 == null) {
                string2 = request.getRequestURI();
            }
            replace.put("REDIRECT_URL", string2);
            AngularContentService.serveStaticContent(request, response, this.getClass().getClassLoader().getResource("com/inet/remote/gui/modules/login/loginform.html"), replace, this.getPathSpec(), false);
            return;
        }
        LoginServlet.serveLoginPage(request, response, replace);
    }

    public static void serveLoginPage(HttpServletRequest request, HttpServletResponse response, HashMap<String, String> replace) throws IOException {
        ModuleMetaData moduleMetaData = new ModuleMetaData("/login", LoginServlet.class.getResource("login.html"));
        moduleMetaData.addJsPath("loginmodule.app.js");
        moduleMetaData.setName(MSG.getMsg("module.login.name", new Object[0]));
        moduleMetaData.setHtml5ModeURLS(false);
        AngularContentService.serveTemplate(request, response, replace, moduleMetaData);
    }
}

