/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.emoji;

import com.inet.config.ConfigurationManager;
import com.inet.config.provider.ConfigurationProvider;
import com.inet.config.provider.DefaultConfigurationProvider;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.http.servlet.ClientLocale;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.remote.gui.emoji.EmojiData;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class a
implements BackupTask {
    public String getKey() {
        return "customemojis";
    }

    public String getTitle() {
        return EmojiData.MSG.getMsg("backup.customemojis.title", new Object[0]);
    }

    public String getDescription() {
        return EmojiData.MSG.getMsg("backup.customemojis.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/remote/gui/structure/emoji_48.svg");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        backupHelper.createZipFromFolderContent(persistence.resolve("customemoji"), taskPath.resolve("customemoji.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                final String string = EmojiData.MSG.getMsg("backup.customemojis.task.detail", new Object[]{Math.max(0, files - 1)});
                contentInformation.putTaskDetails(a.this.getKey(), (ArrayList)new ArrayList<String>(){
                    {
                        this.add(string);
                    }
                });
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, final ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        Path path = taskPath.resolve("customemoji.zip");
        PersistenceEntry persistenceEntry = persistence.resolve("customemoji");
        backupHelper.extractZipIntoFolder(path, persistenceEntry, false, new FileProgress(){

            public void progressUpdate(int progress, int files) {
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public boolean isSupported() {
        ConfigStructure configStructure = new ConfigStructure(ConfigurationManager.getInstance().getCurrent(), ClientLocale.getThreadLocale(), true, null, (ConfigurationProvider)new DefaultConfigurationProvider());
        for (ConfigGroup configGroup : configStructure.getGroups()) {
            for (ConfigCategory configCategory : configStructure.getCategories(configGroup.getKey())) {
                if (!"category.emoji".equals(configCategory.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("23.4")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

