/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.angular.changeavatar;

import com.inet.classloader.I18nMessages;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.UserAvatar;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.angular.changeavatar.SaveCurrentUserImageRequestData;
import com.inet.remote.gui.angular.changeavatar.a;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nonnull;

public class d
extends ServiceMethod<SaveCurrentUserImageRequestData, Void> {
    private static final I18nMessages ac = new I18nMessages("com.inet.remote.gui.angular.changeavatar.i18n.LanguageResources", d.class);

    @Override
    public String getMethodName() {
        return "changeavatar.savecurrentuserimage";
    }

    @Override
    public short getMethodType() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, final SaveCurrentUserImageRequestData saveCurrentUserImageRequestData) throws IOException {
        GUID gUID = saveCurrentUserImageRequestData.getUserId();
        if (UserManager.getInstance().getCurrentUserAccountID() == null || gUID == null) {
            throw new AccessDeniedException();
        }
        if (!gUID.equals((Object)UserManager.getInstance().getCurrentUserAccountID()) && !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS)) {
            throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
        }
        UserManager userManager = UserManager.getInstance();
        final UserAccount userAccount = userManager.getUserAccount(gUID);
        if (userAccount == null) {
            throw new ClientMessageException(ac.getMsg("changeavatar.error.creationfailed", new Object[]{ac.getMsg("changeavatar.error.nouseraccount", new Object[0])}));
        }
        if (saveCurrentUserImageRequestData.isRemoveImage()) {
            ServerPluginManager.getInstance().runIfPluginLoaded("avatar", () -> new Executable(){

                public void execute() {
                    a.c(userAccount);
                }
            });
            userManager.deleteBinaryData(userAccount.getID(), UserAvatar.BINARYKEY_USERAVATAR);
            return null;
        }
        ServerPluginManager.getInstance().runIfPluginLoaded("avatar", () -> new Executable(){

            public void execute() {
                if (saveCurrentUserImageRequestData.getAvatarProviderKey() != null) {
                    a.a(saveCurrentUserImageRequestData.getAvatarProviderKey(), userAccount);
                } else {
                    a.c(userAccount);
                }
            }
        });
        try {
            if (saveCurrentUserImageRequestData.getAvatarProviderKey() != null) return null;
            Collection collection = httpServletRequest.getParts();
            if ((collection == null || collection.size() == 0) && saveCurrentUserImageRequestData.getAvatarProviderKey() == null) {
                throw new ClientMessageException(ac.getMsg("changeavatar.error.nofile", new Object[0]));
            }
            if (collection == null) return null;
            for (Part part : collection) {
                if ("json".equals(part.getName())) continue;
                try {
                    InputStream inputStream = part.getInputStream();
                    try {
                        byte[] byArray = this.a(inputStream, saveCurrentUserImageRequestData.getWidth(), saveCurrentUserImageRequestData.getHeight(), saveCurrentUserImageRequestData.getLeft(), saveCurrentUserImageRequestData.getTop());
                        userManager.storeBinaryData(userAccount.getID(), UserAvatar.BINARYKEY_USERAVATAR, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    RemoteGuiServerPlugin.LOGGER.error(throwable);
                    throw new ClientMessageException(ac.getMsg("changeavatar.error.creationfailed", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)}));
                    return null;
                }
            }
        }
        catch (ServletException servletException) {
            RemoteGuiServerPlugin.LOGGER.error((Throwable)servletException);
            throw new ClientMessageException(ac.getMsg("changeavatar.error.nofile", new Object[0]));
        }
    }

    private byte[] a(InputStream inputStream, int n, int n2, int n3, int n4) throws ClientMessageException {
        try {
            byte[] byArray = UserAvatar.createScaledUserImage((InputStream)inputStream, (int)n, (int)n2, (int)n3, (int)n4);
            if (byArray == null) {
                throw new ClientMessageException(ac.getMsg("changeavatar.error.failed", new Object[0]));
            }
            return byArray;
        }
        catch (ClientMessageException clientMessageException) {
            throw clientMessageException;
        }
        catch (IOException iOException) {
            RemoteGuiServerPlugin.LOGGER.error((Throwable)iOException);
            throw new ClientMessageException(iOException.getMessage());
        }
        catch (Exception exception) {
            RemoteGuiServerPlugin.LOGGER.error((Throwable)exception);
            throw new ClientMessageException(ac.getMsg("changeavatar.error.failed", new Object[0]));
        }
    }

    @Override
    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (SaveCurrentUserImageRequestData)object);
    }
}

