/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.angular;

import com.inet.annotations.InternalApi;
import com.inet.authentication.base.LoginManager;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigurationManager;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.PluginServlet;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.MaintenanceMode;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.ModuleManager;
import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public abstract class AngularApplicationServlet
implements PluginServlet {
    public static final Logger LOGGER = LogManager.getLogger((String)"Remotegui");
    public static final I18nMessages I18N = new I18nMessages("com.inet.remote.gui.angular.i18n.LanguageResources", AngularApplicationServlet.class);
    private String path;
    protected Map<String, ServiceMethod<?, ?>> postMethods = new HashMap();
    protected Map<String, ServiceMethod<?, ?>> getMethods = new HashMap();
    private boolean j = false;

    public AngularApplicationServlet(String path) {
        this.path = path;
    }

    public void init(@Nonnull ServletConfig config) throws ServletException {
    }

    public void destroy() {
    }

    @Nonnull
    public String getPathSpec() {
        return this.path;
    }

    public void service(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        Object object;
        String string = request.getPathInfo();
        if (string == null || string.isEmpty()) {
            string = "";
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.equals("pwa-service-worker.js")) {
            AngularContentService.serveLibResource(request, response, string);
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance();
        IModule iModule = moduleManager.getModule(this.path);
        if (iModule != null && iModule.blockableByVeto() && ((object = VetoManager.getInstance()).isCurrentlyVetoed() || MaintenanceMode.getState() != MaintenanceMode.NONE)) {
            PluginDispatcherServlet.forward((String)"/vetomessage", (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (string.equals("weblib/manifest.webmanifest")) {
            object = iModule != null ? iModule.getPath() : "";
            AngularContentService.serveWebManifest(request, response, (String)object);
            return;
        }
        object = UserManager.getInstance().getCurrentUserAccount();
        if (object == null && iModule != null && (iModule.getRequiredPermission() != null || iModule.authenticationRequired())) {
            if (!LoginManager.forceLogin((HttpServletRequest)request, (HttpServletResponse)response)) {
                return;
            }
            object = UserManager.getInstance().getCurrentUserAccount();
            if (object == null) {
                throw new AccessDeniedException("Login required to access.");
            }
        }
        if (string.startsWith("weblib/")) {
            AngularContentService.serveLibResource(request, response, string.substring(7));
            return;
        }
        if (iModule != null) {
            if (!AngularContentService.checkSystemPermission(request, response, this.path)) {
                return;
            }
            if (iModule.blockableByVeto() && !ConfigKeyParser.getCurrent().isValid() && !ConfigurationManager.isRecoveryMode()) {
                PluginDispatcherServlet.forward((String)"/invalidlicense", (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            if (iModule.getFeatureLicenseKey() != null && !ConfigKeyParser.hasValidLicenseFor((String)iModule.getFeatureLicenseKey())) {
                PluginDispatcherServlet.forward((String)("/invalidlicense/" + iModule.getFeatureLicenseKey()), (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
        }
        this.handle(request, response, string);
    }

    private synchronized void c() {
        if (this.j) {
            return;
        }
        this.j = true;
        for (ServiceMethod serviceMethod : ServerPluginManager.getInstance().get(ServiceMethod.class)) {
            this.addServiceMethod(serviceMethod);
        }
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, ServiceMethod<?, ?>> getPostMethods() {
        return this.postMethods;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        this.c();
        if ("GET".equals(request.getMethod())) {
            if (this.checkGetMethods(request, response)) {
                return;
            }
            this.handleGet(request, response, pathInfo, replace);
        } else {
            this.handlePost(request, response, pathInfo, replace);
        }
    }

    public final void handle(HttpServletRequest request, HttpServletResponse response, String pathInfo) throws IOException {
        response.setStatus(200);
        this.handle(request, response, pathInfo, null);
    }

    public abstract void handleGet(HttpServletRequest var1, HttpServletResponse var2, String var3, HashMap<String, String> var4) throws IOException;

    public void handlePost(HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace) throws IOException {
        if (this.checkPostMethods(request, response)) {
            return;
        }
        this.handleGet(request, response, pathInfo, replace);
    }

    private final void a(ServiceMethod<?, ?> serviceMethod, boolean bl) {
        if ((serviceMethod.getMethodType() & 2) > 0) {
            if (this.getMethods.containsKey(serviceMethod.getMethodName())) {
                if (!bl) {
                    throw new IllegalArgumentException("A method with name " + serviceMethod.getMethodName() + " has already been registered. Existing method is " + String.valueOf(this.getMethods.get(serviceMethod.getMethodName())));
                }
            } else {
                this.getMethods.put(serviceMethod.getMethodName(), serviceMethod);
            }
        }
        if ((serviceMethod.getMethodType() & 1) > 0) {
            if (this.postMethods.containsKey(serviceMethod.getMethodName())) {
                if (!bl) {
                    throw new IllegalArgumentException("A method with name " + serviceMethod.getMethodName() + " has already been registered. Existing method is " + String.valueOf(this.postMethods.get(serviceMethod.getMethodName())));
                }
            } else {
                this.postMethods.put(serviceMethod.getMethodName(), serviceMethod);
            }
        }
    }

    public final void addServiceMethod(ServiceMethod<?, ?> method) {
        this.a(method, false);
    }

    protected boolean checkGetMethods(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String string;
        String string2 = req.getQueryString();
        if (string2 != null && !string2.isEmpty() && (string = req.getParameter("method")) != null) {
            ServiceMethod<?, ?> serviceMethod = this.getMethods.get(string);
            if (serviceMethod != null) {
                serviceMethod.invoke(req, resp, null);
                return true;
            }
            LOGGER.warn((Object)("No GET serviceMethod found for " + string + " handler = " + this.getClass().getName()));
            resp.setStatus(200);
            AngularContentService.sendClientError(req, resp, new ClientMessageException(I18N.getMsg("error.notimplemented", new Object[0])));
            return true;
        }
        return false;
    }

    protected boolean checkPostMethods(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String string = req.getParameter("method");
        if (string != null) {
            ServiceMethod<?, ?> serviceMethod = this.postMethods.get(string);
            if (serviceMethod != null) {
                Object object = this.a(req, resp, serviceMethod);
                AngularContentService.writeJSON(req, resp, object);
                return true;
            }
            LOGGER.warn((Object)("No serviceMethod found for " + string));
            LOGGER.debug((Object)req.getParameterMap());
            Object object = "Params: ";
            Enumeration enumeration = req.getParameterNames();
            while (enumeration != null && enumeration.hasMoreElements()) {
                object = (String)object + "\n" + String.valueOf(enumeration.nextElement());
            }
            LOGGER.debug(object);
            resp.setStatus(501);
            AngularContentService.sendClientError(req, resp, new ClientMessageException(I18N.getMsg("error.notimplemented", new Object[0])));
            return true;
        }
        return false;
    }

    private <IN, OUT> Object a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServiceMethod<IN, OUT> serviceMethod) throws IOException {
        return serviceMethod.invoke(httpServletRequest, httpServletResponse, serviceMethod.getPayload(httpServletRequest));
    }
}

