import {KytosElement} from './kytos-element.js';
import {KytosOn} from './kytos-on.js';

export class MyTest extends KytosElement {

    template = `
		<i k-on-click="sayHello">{{dataBindingModel.myValue}}{{dataBindingModel.externalValue}}</i>`; // Template in back ticks to allow better formatting with line breaks and so on
    
    dataBindingModel = { 
        myValue: 'Hello world',
		externalValue: ''
    };
    
    init() {
        // Initialize what is required
        this.dataBindingModel.myValue += ' and the rest of the universe!';
    };
	
	// Festlegen, welche Attribute überwacht werden sollen
	static get observedAttributes() {
	    return ['val'];
	};

	attributeChangedCallback(attributeName, oldValue, newValue) {
	    this.dataBindingModel.externalValue = ' (' + newValue + ')';
	};
	
	sayHello() {
		window.alert('Hello!');
	};

}

customElements.define('my-test', MyTest);