import { EventEmitter } from "./eventemitter.js";

/**
 * Service to display a toast message at the right bottom side of the user interface
 */
export class ToastService {

	/*****************************************************************************************************************************************************************************************************************************/
	/*****************************************************************************************************************************************************************************************************************************/
	/** API methods and members                                                                                                                                                                                                 **/
	/*****************************************************************************************************************************************************************************************************************************/
	/*****************************************************************************************************************************************************************************************************************************/

	static DEFAULT = undefined;
	static SUCCESS = "success";
	static WARNING = "warning";

	static showToast(message, type = ToastService.DEFAULT) {
		if (message == undefined || message.length == 0) {
			throw new Error("A message must be provided to be displayed as toast.");
		}
		EventEmitter.fire('errorservice.toast.show', {
			message: message,
			type: type
		});
	};

	/*****************************************************************************************************************************************************************************************************************************/
	/*****************************************************************************************************************************************************************************************************************************/
	/** API END                                                                                                                                                                                                                 **/
	/*****************************************************************************************************************************************************************************************************************************/
	/*****************************************************************************************************************************************************************************************************************************/

};
