import {KytosAttribute} from "./kytos-attribute.js";

/**
 * Represents a KytosSrc attribute handler that sets a data-* attribute at a node.
 * 
 * @class
 * @extends KytosAttribute
 */
export class KytosData extends KytosAttribute {

	/**
	 * Handles the attachment of a source URL to a DOM node by adding a data- attribute.
	 *
	 * @param {HTMLElement} kytosElement - The custom element or context in which this method is called.
	 * @param {HTMLElement} node - The DOM node to which the data- attribute will be set.
	 * @param {string} attrName - The name of the attribute.
	 */
	attached(kytosElement, node, attrName) {
		let propName = node.getAttribute(attrName);
		node.setAttribute('data-'+propName, kytosElement[propName]);
	};
	
};

KytosAttribute.define('k-data', KytosData, false);
