/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.emoji;

import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.emoji.EmojiData;
import com.inet.remote.gui.emoji.GetEmojisOfCategoryRequest;
import com.inet.remote.gui.emoji.GetEmojisOfCategoryResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class d
extends ServiceMethod<GetEmojisOfCategoryRequest, GetEmojisOfCategoryResponse> {
    public GetEmojisOfCategoryResponse a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GetEmojisOfCategoryRequest getEmojisOfCategoryRequest) throws IOException {
        Comparator comparator = (emojiDescription, emojiDescription2) -> {
            int n = Integer.compare(emojiDescription.getSortOrder(), emojiDescription2.getSortOrder());
            if (n != 0) {
                return n;
            }
            return emojiDescription.getNames().get(0).compareToIgnoreCase(emojiDescription2.getNames().get(0));
        };
        if (!StringFunctions.isEmpty((String)getEmojisOfCategoryRequest.getSearchTerm())) {
            List<EmojiData.EmojiMatch> list = EmojiData.searchEmojis(getEmojisOfCategoryRequest.getSearchTerm());
            int n = list.size();
            List<EmojiData.EmojiDescription> list2 = list.stream().map(EmojiData.EmojiMatch::getEmojiDescription).filter(emojiDescription -> emojiDescription != null).limit(150L).collect(Collectors.toList());
            return new GetEmojisOfCategoryResponse("search", getEmojisOfCategoryRequest.getSearchTerm(), list2, n);
        }
        if ("Recently Used".equals(getEmojisOfCategoryRequest.getCategoryKey())) {
            List<String> list = getEmojisOfCategoryRequest.getRecentlyUsedNames();
            if (list == null) {
                list = new ArrayList<String>();
            }
            List<EmojiData.EmojiDescription> list3 = list.stream().map(string -> EmojiData.getShortNameMap().get(string)).filter(string -> string != null).map(string -> EmojiData.getEmojiDescription(string)).filter(emojiDescription -> emojiDescription != null && emojiDescription.getVariationParent() == null).collect(Collectors.toList());
            return new GetEmojisOfCategoryResponse(getEmojisOfCategoryRequest.getCategoryKey(), getEmojisOfCategoryRequest.getSearchTerm(), list3, -1);
        }
        List<EmojiData.EmojiDescription> list = EmojiData.getEmojiDescriptionsMap().values().stream().filter(emojiDescription -> emojiDescription.getVariationParent() == null && getEmojisOfCategoryRequest.getCategoryKey().equals(emojiDescription.getCategory())).sorted(comparator).collect(Collectors.toList());
        return new GetEmojisOfCategoryResponse(getEmojisOfCategoryRequest.getCategoryKey(), getEmojisOfCategoryRequest.getSearchTerm(), list, -1);
    }

    @Override
    public String getMethodName() {
        return "emojiselector_getemojisofcategory";
    }

    @Override
    public short getMethodType() {
        return 1;
    }

    @Override
    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (GetEmojisOfCategoryRequest)object);
    }
}

