/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui.angular.usersorgroupsselection;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.ui.TargetChild;
import com.inet.usersandgroups.api.ui.TargetEntry;
import com.inet.usersandgroups.api.ui.TargetParent;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@JsonData
public class UsersOrGroupsSelection {
    public static final String PRESELECTION_PRIVATE = "private";
    public static final String PRESELECTION_PUBLIC = "public";
    public static final String PRESELECTION_CUSTOM = "custom";
    private List<TargetEntry> entries;
    private String preselection;

    private UsersOrGroupsSelection() {
    }

    public UsersOrGroupsSelection(List<SelectedMember> selectedMembers) {
        this.entries = this.convertToEntries(selectedMembers);
        this.preselection = selectedMembers == null || selectedMembers.isEmpty() ? PRESELECTION_PRIVATE : (selectedMembers.size() == 1 && selectedMembers.get((int)0).type == Type.group && selectedMembers.get((int)0).id.equals((Object)UsersAndGroups.GROUPID_ALLUSERS) ? PRESELECTION_PUBLIC : PRESELECTION_CUSTOM);
    }

    public List<SelectedMember> getSelectedMembers() {
        return this.convertToMembers();
    }

    public String getPreselection() {
        return this.preselection;
    }

    public void setPreselection(String preselection) {
        this.preselection = preselection;
    }

    private List<SelectedMember> convertToMembers() {
        if (this.entries == null || this.entries.isEmpty()) {
            return null;
        }
        ArrayList<SelectedMember> arrayList = new ArrayList<SelectedMember>();
        for (TargetEntry targetEntry : this.entries) {
            arrayList.add(new SelectedMember(targetEntry.getEntryType(), targetEntry.getGuid()));
        }
        return arrayList;
    }

    private List<TargetEntry> convertToEntries(List<SelectedMember> selectedMembers) {
        ArrayList<TargetEntry> arrayList = new ArrayList<TargetEntry>();
        if (selectedMembers != null) {
            UserGroupManager userGroupManager = UserGroupManager.getInstance();
            UserManager userManager = UserManager.getInstance();
            Set set = userGroupManager.getAllGroups();
            for (SelectedMember selectedMember : selectedMembers) {
                UserGroupInfo userGroupInfo;
                GUID gUID = selectedMember.getId();
                if (selectedMember.getType().equals((Object)Type.group)) {
                    UserGroupInfo userGroupInfo22;
                    userGroupInfo = userGroupManager.getGroup(gUID);
                    if (userGroupInfo == null || !userGroupInfo.isActive()) continue;
                    TargetEntry targetEntry = new TargetEntry(gUID, Type.group, userGroupInfo.getType().getName(), userGroupInfo.getDisplayName());
                    UserGroupTreeUtils.DescendantGroups descendantGroups = UserGroupTreeUtils.findDescendantGroups((UserGroupInfo)userGroupInfo, (Set)set);
                    ArrayList<TargetChild> arrayList2 = new ArrayList<TargetChild>();
                    for (UserGroupInfo userGroupInfo22 : descendantGroups.getDescendantGroups()) {
                        arrayList2.add(new TargetChild(userGroupInfo22.getID(), userGroupInfo22.getDisplayName()));
                    }
                    targetEntry.setChildren(arrayList2);
                    ArrayList arrayList3 = new ArrayList();
                    userGroupInfo22 = userGroupInfo;
                    while (userGroupInfo22.hasParent()) {
                        userGroupInfo22 = userGroupManager.getGroup(userGroupInfo22.getParentID());
                        arrayList3.add(new TargetParent(userGroupInfo22.getID(), userGroupInfo22.getDisplayName()));
                    }
                    targetEntry.setParents(arrayList3);
                    arrayList.add(targetEntry);
                    continue;
                }
                if (!selectedMember.getType().equals((Object)Type.user) || (userGroupInfo = userManager.getUserAccount(gUID)) == null) continue;
                arrayList.add(new TargetEntry(gUID, Type.user, userGroupInfo.getAccountType().name(), userGroupInfo.getDisplayName()));
            }
        }
        return arrayList;
    }

    @JsonData
    public static class SelectedMember {
        private Type type;
        private GUID id;

        private SelectedMember() {
        }

        public SelectedMember(Type type, GUID id) {
            this.type = type;
            this.id = id;
        }

        public Type getType() {
            return this.type;
        }

        public GUID getId() {
            return this.id;
        }
    }
}

