import {KytosAttribute} from "./kytos-attribute.js";

/**
 * Attribute that can be attached to node in the template of a KytosElement. It will set the translated text as text content of the current node. 
 * 
 * Usage:
 * <span k-i18n="i18n.key"></span>
 * 
 * Limitations:
 * - Does not support parameters
 * - Will only be executed when the parent KytosElement is attached to the DOM. No later execution, e.g. when added via javascript, will be recognized.
 * - No 'node detached' callback is available. In rare cases, Kytos.onNodeRemoved(node, callback, parentNode) may be used. Attention: It must be ensured that the parentNode is a good node for an observer and is not a child of a node that will be removed.  
 */
export class KytosI18n extends KytosAttribute {

	/**
	 * When attached, the value of the attribute will be translated via internal translate-API and set as inner text content of the node.
	 */
	attached(kytosElement, node, attrName) {
		let i18nKey = node.getAttribute(attrName);
		let translated = getMsg(i18nKey);
		node.textContent = translated;
	};
	
};

KytosAttribute.define('k-i18n', KytosI18n, false);
