/*
 * Decompiled with CFR 0.152.
 */
package com.inet.remote.gui;

import com.inet.config.ConfigurationManager;
import com.inet.logging.LogManager;
import com.inet.plugin.DynamicExtensionListener;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ModuleManager
implements Serializable {
    private AbstractMap<String, IModule> b = new ConcurrentHashMap<String, IModule>();
    private boolean d;
    private static ModuleManager e = new ModuleManager();

    private ModuleManager() {
    }

    public static ModuleManager getInstance() {
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (!this.d) {
            ModuleManager moduleManager = this;
            synchronized (moduleManager) {
                if (!this.d) {
                    this.d = true;
                    this.a(DynamicExtensionManager.getInstance().get(IModule.class));
                    DynamicExtensionManager.getInstance().registerListener(IModule.class, (DynamicExtensionListener)new DynamicExtensionListener<IModule>(){

                        public void valuesChanged(@Nonnull @Nonnull List<@Nonnull IModule> values) {
                            ModuleManager.this.b.clear();
                            ModuleManager.this.a(values);
                        }
                    });
                }
            }
        }
    }

    private void a(@Nonnull List<IModule> list) {
        for (IModule iModule : list) {
            this.a(iModule);
        }
    }

    private final void a(IModule iModule) throws IllegalArgumentException {
        String string;
        this.b();
        String string2 = string = iModule == null ? null : iModule.getPath();
        if (iModule == null || string == null) {
            throw new IllegalArgumentException(RemoteGuiServerPlugin.MSG.getMsg("manager.error.nullNotAllowed", new Object[0]));
        }
        if (this.b.containsKey(string)) {
            throw new IllegalArgumentException(RemoteGuiServerPlugin.MSG.getMsg("manager.error.pathAlreadyRegistered", new Object[]{string}));
        }
        if (this.b.containsValue(iModule)) {
            throw new IllegalArgumentException(RemoteGuiServerPlugin.MSG.getMsg("manager.error.nameAlreadyRegistered", new Object[]{iModule.getName()}));
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(RemoteGuiServerPlugin.MSG.getMsg("manager.error.pathMustStartWithSlash", new Object[0]));
        }
        this.b.put(string, iModule);
    }

    public ArrayList<IModule> getModules(boolean checkAccess) {
        this.b();
        ArrayList<IModule> arrayList = new ArrayList<IModule>();
        for (IModule iModule : this.b.values()) {
            if (iModule.isInternal() || checkAccess && !this.isModuleAllowed(iModule)) continue;
            arrayList.add(iModule);
        }
        return arrayList;
    }

    @Nonnull
    public List<String> getPaths() {
        this.b();
        Map<String, String> map = this.b.values().stream().filter(iModule -> {
            if (!iModule.isInternal()) {
                if (ConfigurationManager.isRecoveryMode() && !iModule.availableInRecovery()) {
                    return false;
                }
                return this.isModuleAllowed((IModule)iModule);
            }
            return false;
        }).collect(Collectors.toMap(IModule::getPath, IModule::getName));
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean isModuleAllowed(IModule mod) {
        this.b();
        if (mod == null) {
            return false;
        }
        return mod.isAccessAllowed();
    }

    public IModule getModule(String path) {
        this.b();
        if (path != null && path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path == null ? null : this.b.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        if (!this.d) {
            ModuleManager moduleManager = this;
            synchronized (moduleManager) {
                this.init();
                if (!this.d) {
                    try {
                        ThreadUtils.threadDump((OutputStream)LogManager.getLogStream());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                    throw new IllegalStateException("ModuleManager is not initialized. Make sure that plugin remotegui is initialized. See log file for further information.");
                }
            }
        }
    }
}

