/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.setup;

import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.setup.OldQuickTicketTableMigrator;
import com.inet.helpdesk.plugins.quickticket.setup.QuickTicketDbTableUtils;
import com.inet.helpdesk.plugins.setupwizard.api.HelpDeskSetupMode;
import com.inet.helpdesk.plugins.setupwizard.api.HelpDeskSetupModeChecker;
import com.inet.helpdesk.plugins.setupwizard.steps.database.DatabaseConnectionFactory;
import com.inet.helpdesk.plugins.setupwizard.steps.database.HdDatabaseCheck;
import com.inet.helpdesk.shared.model.QuickTicketDataSet;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressInfo;
import com.inet.setupwizard.api.StepKey;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QuickTicketSetupStep
extends AutoSetupStep {
    private static final String OLD_TABLE_NAME = "tblQuickTicket";
    private static final String NEW_TABLE_NAME = "tblQuickTickets";

    public static void register(ServerPluginManager spm) {
        spm.register(SetupStep.class, (Object)new QuickTicketSetupStep());
    }

    public StepKey stepKey() {
        return new StepKey("quickticket.setup");
    }

    public String getStepDisplayName() {
        return QuickTicketServerPlugin.MSG.getMsg("setup.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        if (QuickTicketDbTableUtils.hasDatabaseStructureChanged()) {
            return true;
        }
        String dbConfigs = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS.getKey());
        if (dbConfigs == null || dbConfigs.isEmpty()) {
            return true;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)new Json().fromJson(dbConfigs, DatabaseConfigInfoList.class);
        DatabaseConfigInfo dbInfo = list.get("HDS");
        if (dbInfo == null) {
            return true;
        }
        try {
            DatabaseConnectionFactory conFactory = (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
            if (HdDatabaseCheck.tableExists((DatabaseConnectionFactory)conFactory, (String)OLD_TABLE_NAME)) {
                return true;
            }
            if (HdDatabaseCheck.tableExists((DatabaseConnectionFactory)conFactory, (String)NEW_TABLE_NAME)) {
                return false;
            }
        }
        catch (SQLException t) {
            SetupLogger.LOGGER.debug((Object)t);
            return true;
        }
        catch (Throwable e) {
            SetupLogger.LOGGER.error(e);
            return true;
        }
        return true;
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        try {
            QuickTicketDbTableUtils.createOrUpdateTableForQuickTickets(event -> this.getStepExecutionProgressListener().progressInfoUpdated(new StepExecutionProgressInfo(0, () -> event.getCurrentJobName(ClientLocale.getThreadLocale()))));
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
        DatabaseConnectionFactory conFactory = (DatabaseConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(DatabaseConnectionFactory.class);
        try (Connection con = conFactory.getConnectionFromCurrentConfiguration();){
            DatabaseTransactionUtils.executeAsTransaction((Connection)con, connection -> {
                if (!HdDatabaseCheck.tableExists((Connection)connection, (String)OLD_TABLE_NAME)) {
                    if (HelpDeskSetupModeChecker.isModeOfTheLastCheck((HelpDeskSetupMode)HelpDeskSetupMode.NEW_INSTALLATION)) {
                        OldQuickTicketTableMigrator migrator = new OldQuickTicketTableMigrator();
                        List<QuickTicketDataSet> data = Collections.singletonList(migrator.createDataOfQuickTicketPasswordZurucksetzen());
                        migrator.migrateData(data);
                        return null;
                    }
                    return null;
                }
                OldQuickTicketTableMigrator migrator = new OldQuickTicketTableMigrator();
                List<QuickTicketDataSet> data = migrator.loadData(con);
                migrator.migrateData(data);
                try (Statement stm = con.createStatement();){
                    stm.executeUpdate("DROP TABLE tblQuickTicket");
                }
                return null;
            });
        }
        catch (Throwable t) {
            throw new StepExecutionException(t);
        }
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(5700);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> QuickTicketServerPlugin.MSG.getMsg("setup.info", new Object[0]);
    }
}

