/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.field.Field;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketProcessingTime;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class QuickTicketVO {
    private static final int EDIT_REASTEP_TEXT_INDEX = 0;
    public static final Set<TicketField<?>> OPTIONAL_FIELDS_FOR_APPLICATION_PURPOSES_OF_CONSTRAINED_QT = Collections.unmodifiableSet(new HashSet<TicketField>(Arrays.asList(Tickets.FIELD_OWNER_GUID, Tickets.FIELD_DEADLINE, Tickets.FIELD_TARGET_TIME)));
    private final GUID quickTicketID;
    private final String quickTicketName;
    private final MutableTicketData ticketData;
    private final ExtensionArguments extArgs;
    private final List<ApplicableActionDataVO> actionsData;

    protected QuickTicketVO(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<? extends ApplicableActionData> actionsData) {
        this.quickTicketID = quickTicketID;
        this.quickTicketName = quickTicketName;
        this.ticketData = ticketData.copy();
        this.extArgs = ExtensionArguments.copyOf((ExtensionArguments)extArgs);
        this.actionsData = actionsData.stream().map(ApplicableActionData::toImmutable).collect(Collectors.toList());
    }

    public static QuickTicketVO create(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<? extends ApplicableActionData> actionsData) {
        QuickTicketVO.throwIfIdIsInvalid(quickTicketID);
        QuickTicketVO.throwIfExtArgsAreNull(extArgs);
        QuickTicketVO.throwIfNameIsInvalid(quickTicketName);
        QuickTicketVO.throwIfTicketOrActionsDataIsInvalid(ticketData, actionsData);
        QuickTicketVO.throwIfContainsNonRelativeProcessingTime(actionsData);
        QuickTicketVO.throwIfContainsSendMailActionsWithoutExtData(actionsData);
        return new QuickTicketVO(quickTicketID, quickTicketName, ticketData, extArgs, actionsData);
    }

    public static QuickTicketVO createReplacementForQtWithNoData(GUID quickTicketID, String quickTicketName, ExtensionArguments extArgs) {
        QuickTicketVO.throwIfIdIsInvalid(quickTicketID);
        QuickTicketVO.throwIfNameIsInvalid(quickTicketName);
        return new QuickTicketVO(quickTicketID, quickTicketName, new MutableTicketData(), extArgs, new ArrayList());
    }

    public GUID getID() {
        return this.quickTicketID;
    }

    public String getQuickTicketName() {
        return this.quickTicketName;
    }

    public MutableTicketData getTicketData() {
        return this.ticketData.copy();
    }

    public ExtensionArguments getExtensionArguments() {
        return ExtensionArguments.copyOf((ExtensionArguments)this.extArgs);
    }

    public List<ApplicableActionDataVO> getActionsData() {
        return Collections.unmodifiableList(this.actionsData);
    }

    public ApplicableQuickTicketVO toApplicable() {
        return ApplicableQuickTicketVO.createFrom(this);
    }

    public int hashCode() {
        return Objects.hash(this.actionsData, this.extArgs, this.quickTicketID, this.quickTicketName, this.ticketData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickTicketVO other = (QuickTicketVO)obj;
        return Objects.equals(this.actionsData, other.actionsData) && Objects.equals(this.extArgs, other.extArgs) && Objects.equals(this.quickTicketID, other.quickTicketID) && Objects.equals(this.quickTicketName, other.quickTicketName) && Objects.equals(this.ticketData, other.ticketData);
    }

    public String toString() {
        return "QuickTicketVO [quickTicketID=" + String.valueOf(this.quickTicketID) + ", quickTicketName=" + this.quickTicketName + ", ticketData=" + String.valueOf(this.ticketData) + ", actionsData=" + String.valueOf(this.actionsData) + ", ExtArgs=" + this.extArgs.toString() + "]";
    }

    public static void throwIfIdIsInvalid(GUID quickTicketID) {
        if (quickTicketID == null) {
            throw QuickTicketException.forIAE("quick-ticket's ID must not be null");
        }
    }

    public static void throwIfExtArgsAreNull(ExtensionArguments extArgs) {
        if (extArgs == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.createQuickTicket.missingExtensionArguments", new Object[0]));
        }
    }

    public static void throwIfNameIsInvalid(String quickTicketName) {
        if (quickTicketName == null) {
            throw QuickTicketException.forIAE("quick-ticket's name must not be null");
        }
        if (quickTicketName.trim().isEmpty()) {
            throw QuickTicketException.forIAE("quick-ticket's name must not be empty after trim");
        }
        if (quickTicketName.length() > 100) {
            throw QuickTicketException.forIAE("quick-ticket's name must not exceed length limit of 100 characters");
        }
    }

    public static void throwIfTicketOrActionsDataIsInvalid(MutableTicketData ticketData, List<? extends ApplicableActionData> actionsData) {
        GUID resID;
        if (ticketData == null) {
            throw QuickTicketException.forIAE("ticket data must not be null");
        }
        if (actionsData == null) {
            throw QuickTicketException.forIAE("actions data must not be null");
        }
        if (actionsData.contains(null)) {
            throw QuickTicketException.forIAE("actions data must not contain null");
        }
        if (ticketData.isEmpty() && actionsData.isEmpty()) {
            throw QuickTicketException.forIAE("ticket and actions data must not be both empty");
        }
        if (!actionsData.isEmpty()) {
            String editStepTextUniqueActionID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
            long countOfEditStepTextActionEntries = actionsData.stream().filter(e -> Objects.equals(e.getUniqueActionID(), editStepTextUniqueActionID)).count();
            if (countOfEditStepTextActionEntries > 1L) {
                throw QuickTicketException.forIAE("actions data must contain no more than one element that represents action EDIT_REASTEP_TEXT");
            }
            if (countOfEditStepTextActionEntries == 1L) {
                ApplicableActionData firstActionData = actionsData.get(0);
                if (!Objects.equals(firstActionData.getUniqueActionID(), editStepTextUniqueActionID)) {
                    throw QuickTicketException.forIAE("actions data must contain element that represents action EDIT_REASTEP_TEXT on first position in the list");
                }
                QuickTicketVO.throwIfEditTextActionDataIsInvalid(firstActionData, false);
            }
        }
        if (ticketData.containsKey((TicketField)Tickets.FIELD_RESOURCE_GUID) && (resID = (GUID)ticketData.get((TicketField)Tickets.FIELD_RESOURCE_GUID)) != null) {
            QuickTicketVO.throwIfResourceIdIsInvalid(resID);
        }
    }

    public static void throwIfTicketOrActionsDataIsInvalidForConstrainedQuickTicket(MutableTicketData ticketData, List<? extends ApplicableActionData> actionsData, boolean checkForApplicationPurposes) {
        QuickTicketVO.throwIfTicketDataIsInvalidForConstrainedQuickTicket(ticketData, checkForApplicationPurposes);
        if (actionsData == null) {
            throw QuickTicketException.forIAE("actions data must not be null");
        }
        if (actionsData.contains(null)) {
            throw QuickTicketException.forIAE("actions data must not contain null");
        }
        if (actionsData.isEmpty()) {
            throw QuickTicketException.forIAE("actions data must not be empty");
        }
        if (actionsData.size() != 2) {
            throw QuickTicketException.forIAE("actions data must contain two elements");
        }
        Set uniqueActionIDs = actionsData.stream().map(ApplicableActionData::getUniqueActionID).collect(Collectors.toSet());
        if (uniqueActionIDs.size() != 2) {
            throw QuickTicketException.forIAE("actions data must contain elements that represent two different actions");
        }
        String editStepTextUniqueActionID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
        ApplicableActionData editTextActionData = actionsData.get(0);
        if (!Objects.equals(editTextActionData.getUniqueActionID(), editStepTextUniqueActionID)) {
            throw QuickTicketException.forIAE("actions data must contain element that represents action EDIT_REASTEP_TEXT on first position in the list");
        }
        QuickTicketVO.throwIfEditTextActionDataIsInvalid(editTextActionData, true);
    }

    private static void throwIfTicketDataIsInvalidForConstrainedQuickTicket(MutableTicketData ticketData, boolean checkForApplicationPurposes) {
        if (ticketData == null) {
            throw QuickTicketException.forIAE("ticket data must not be null");
        }
        if (ticketData.isEmpty()) {
            throw QuickTicketException.forIAE("ticket data must not be empty");
        }
        ArrayList<TicketField> constrainedQuickTicketFields = new ArrayList<TicketField>(Arrays.asList(Tickets.FIELD_SUBJECT, Tickets.FIELD_RESOURCE_GUID, Tickets.FIELD_PRIORITY_ID, Tickets.FIELD_CATEGORY_ID, Tickets.getFieldByKey((String)"custom1"), Tickets.getFieldByKey((String)"custom2"), Tickets.getFieldByKey((String)"custom3"), Tickets.getFieldByKey((String)"custom4"), Tickets.FIELD_IDENTIFIER, Tickets.FIELD_ITIL_ID, Tickets.FIELD_CLASSIFICATION_ID));
        constrainedQuickTicketFields.stream().forEach(field -> {
            if (!ticketData.containsKey(field)) {
                throw QuickTicketException.forIAE("ticket data must contain value for field with key=\"" + field.getKey() + "\"");
            }
        });
        if (checkForApplicationPurposes) {
            constrainedQuickTicketFields.addAll(OPTIONAL_FIELDS_FOR_APPLICATION_PURPOSES_OF_CONSTRAINED_QT);
        }
        Set unwantedFields = ticketData.getIncludedFields();
        unwantedFields.removeAll(constrainedQuickTicketFields);
        if (!unwantedFields.isEmpty()) {
            List unwantedFieldKeys = unwantedFields.stream().map(Field::getKey).collect(Collectors.toList());
            throw QuickTicketException.forIAE("ticket data must not contain values for fields with keys: " + String.valueOf(unwantedFieldKeys));
        }
        if (((String)ticketData.get((TicketField)Tickets.FIELD_SUBJECT)).trim().isEmpty()) {
            throw QuickTicketException.forIAE("ticket data must contain value for field with key=\"" + Tickets.FIELD_SUBJECT.getKey() + "\", which is empty after trim");
        }
        GUID resID = (GUID)ticketData.get((TicketField)Tickets.FIELD_RESOURCE_GUID);
        if (resID == null) {
            String msg = "ticket data must not contain NULL as value for field with key=\"" + Tickets.FIELD_RESOURCE_GUID.getKey() + "\"";
            throw QuickTicketException.forIAE(msg);
        }
        QuickTicketVO.throwIfResourceIdIsInvalid(resID);
    }

    private static void throwIfResourceIdIsInvalid(GUID resID) {
        UserGroupInfo res = UserGroupManager.getRecoveryEnabledInstance().getGroup(resID);
        if (res == null || !Objects.equals(res.getType(), HDUsersAndGroups.RESOURCE)) {
            String msg = "value for field with key=\"" + Tickets.FIELD_RESOURCE_GUID.getKey() + "\", which is included in ticket data, must match existing resource: " + resID.toString();
            throw QuickTicketException.forIAE(msg);
        }
    }

    private static void throwIfEditTextActionDataIsInvalid(@Nonnull ApplicableActionData editTextActionData, boolean checkForConstrainedQT) {
        Consumer<String> throwQTAE = msg -> {
            String actionDisplayName = ((ActionVO)ActionManager.getInstance().get(-22)).getDisplayValue();
            throw QuickTicketException.forIAE(msg, 0, actionDisplayName);
        };
        if (!editTextActionData.getReaStepData().isEmpty()) {
            throwQTAE.accept("data of action EDIT_REASTEP_TEXT must include empty container for rea-step data");
        }
        if (checkForConstrainedQT && editTextActionData.getReaStepText() == null) {
            throwQTAE.accept("data of action EDIT_REASTEP_TEXT must include step-text, which is not undefined (null)");
        }
        if (checkForConstrainedQT && editTextActionData.getReaStepText().isEmpty()) {
            throwQTAE.accept("data of action EDIT_REASTEP_TEXT must include step-text, which is non-empty after trim");
        }
        if (checkForConstrainedQT && !editTextActionData.getExtensionArguments().getIncludedExtArgs().isEmpty()) {
            throwQTAE.accept("data of action EDIT_REASTEP_TEXT must include empty container for extension arguments");
        }
    }

    public static void throwIfContainsNonRelativeProcessingTime(List<? extends ApplicableActionData> actionsData) {
        for (int index = 0; index < actionsData.size(); ++index) {
            ApplicableActionData data = actionsData.get(index);
            ProcessingTime processingTime = (ProcessingTime)data.getReaStepData().get((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME);
            if (processingTime == null || QuickTicketProcessingTime.isRelativeProcessingTime(processingTime)) continue;
            String msg = "actions data must not contain non-relative processing time";
            ActionVO action = TicketManager.getTicketActionChecker().getActionByUniqueID(data.getUniqueActionID(), -1);
            String actionDisplayName = action == null ? "" : action.getDisplayValue();
            throw QuickTicketException.forIAE(msg, index, actionDisplayName);
        }
    }

    public static void throwIfContainsSendMailActionsWithoutExtData(List<? extends ApplicableActionData> actionsData) {
        ActionVO actionSendMail = (ActionVO)ActionManager.getInstance().get(-7);
        String sendMailActionUniqueID = actionSendMail.getUniqueID();
        for (int index = 0; index < actionsData.size(); ++index) {
            ApplicableActionData data = actionsData.get(index);
            if (!Objects.equals(sendMailActionUniqueID, data.getUniqueActionID()) || data.getExtensionArguments().containsExtArg(QuickTicketServerPlugin.EXTARG_SEND_MAIL_FROM_QT_DATA)) continue;
            String msg = "data of action sendMail must include sendMail's extension data";
            throw QuickTicketException.forIAE(msg, index, actionSendMail.getDisplayValue());
        }
    }
}

