/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import javax.annotation.Nullable;

public class QuickTicketException
extends RuntimeException {
    private Integer actionIndex;
    private String actionDisplayName;

    public static QuickTicketException forIAE(String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must not be null");
        }
        IllegalArgumentException cause = new IllegalArgumentException(msg);
        return new QuickTicketException(msg, (Throwable)cause, null, "");
    }

    public static QuickTicketException forIAE(String msg, @Nullable Integer actionIndex, String actionDisplayName) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must not be null");
        }
        IllegalArgumentException cause = new IllegalArgumentException(msg);
        return new QuickTicketException(msg, (Throwable)cause, actionIndex, actionDisplayName);
    }

    public QuickTicketException(String msg, Throwable cause, @Nullable Integer actionIndex, String actionDisplayName) {
        super(msg, cause);
        if (msg == null) {
            msg = "";
        }
        if (cause == null) {
            throw new IllegalArgumentException("cause must not be null");
        }
        if (actionIndex != null && actionIndex < 0) {
            throw new IllegalArgumentException("actionIndex must not be negative");
        }
        if (actionDisplayName == null) {
            throw new IllegalArgumentException("actionDisplayName must not be null");
        }
        this.actionIndex = actionIndex;
        this.actionDisplayName = actionDisplayName;
    }

    @Nullable
    public Integer getActionIndex() {
        return this.actionIndex;
    }

    public String getActionDisplayName() {
        return this.actionDisplayName;
    }
}

