/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.ConfigPage;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsForNewTicketExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.ApplyQuickTicketActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.CreateTicketWithQuickTicketExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketAttachmentDataCareExtension;
import com.inet.helpdesk.plugins.quickticket.QuickTicketAttachmentProviderImpl;
import com.inet.helpdesk.plugins.quickticket.QuickTicketManagerImpl;
import com.inet.helpdesk.plugins.quickticket.QuickTicketManagerWithPermissionChecks;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistenceImpl;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistenceWithCache;
import com.inet.helpdesk.plugins.quickticket.ReaStepFieldQuickTicketId;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketAttachmentProvider;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketEventListener;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.SendMailFromQuickTicketExtensionData;
import com.inet.helpdesk.plugins.quickticket.client.config.QuickTicketConfigPage;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.CreateOrEditQuickTicket;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.CreateOrEditQuickTicketFolder;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.CreateTask;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.DeleteQuickTicketOrFolder;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.ListDeletableTasks;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.SaveQuickTicket;
import com.inet.helpdesk.plugins.quickticket.client.config.handler.SaveQuickTicketFolder;
import com.inet.helpdesk.plugins.quickticket.client.shared.handler.LoadAvailableQuickTickets;
import com.inet.helpdesk.plugins.quickticket.client.shared.handler.QuickTicketIcon;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.AdditionalReaStepFieldDefinitionQuickTicketId;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler.ApplyQuickTicketAction;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler.ApplyQuickTicketFields;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler.ApplyQuickTicketInit;
import com.inet.helpdesk.plugins.quickticket.client.ticketlist.handler.ValidateQuickTicketAction;
import com.inet.helpdesk.plugins.quickticket.setup.QuickTicketSetupStep;
import com.inet.helpdesk.plugins.quickticket.taskplanner.ApplyQuickTicketActionFactory;
import com.inet.helpdesk.plugins.quickticket.taskplanner.CreateTicketFromQuickTicketJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskTemplateDefinition;
import com.inet.helpdesk.plugins.ticketlist.api.ExtendibleTicketListAngularApplicationServlet;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.plugins.config.server.ConfigAngularApplicationServlet;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinition;
import com.inet.taskplanner.server.api.trigger.TimeTriggerBuilder;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@PluginInfo(id="quickticket", dependencies="helpdesk;remotegui;htmlengine;mail", optionalDependencies="attachments;setupwizard;helpdesksetupwizard;theme;ticketlist;configuration;taskplanner;taskplanner.helpdesk;statistics;inventory", group="tickets;administration;taskplanner", version="25.10.314", icon="com/inet/helpdesk/plugins/quickticket/images/quickticket_48.png", packages="com.inet.helpdesk.plugins.quickticket.api;com.inet.helpdesk.plugins.quickticket.setup.scheduledtasks")
public class QuickTicketServerPlugin
implements ServerPlugin,
ConnectionCreationListener {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.quickticket.i18n.LanguageResources", QuickTicketServerPlugin.class);
    public static final I18nMessages CLIENT_MSG = new I18nMessages("com.inet.helpdesk.plugins.quickticket.client.i18n.LanguageResources", QuickTicketServerPlugin.class);
    private static final QuickTicketPersistenceImpl qtPersistence = new QuickTicketPersistenceImpl();
    private static final QuickTicketPersistenceWithCache qtPersistenceWithCache = new QuickTicketPersistenceWithCache(qtPersistence);
    private static final QuickTicketManager quickTicketManager = new QuickTicketManagerWithPermissionChecks(new QuickTicketManagerImpl(qtPersistenceWithCache));
    public static final ExtensionArguments.ExtArg<SendMailFromQuickTicketExtensionData> EXTARG_SEND_MAIL_FROM_QT_DATA = new ExtensionArguments.JsonizableAndImmutableExtArg("quickticketextension.sendmail", SendMailFromQuickTicketExtensionData.class);
    private static final String KEY_NEW_TICKET_BEFORE_EXPIRY = "KEY_NEW_TICKET_BEFORE_EXPIRY";
    private static final String KEY_SERIENAUFGABE_TEMPLATE = "KEY_SERIENAUFGABE_TEMPLATE";
    private static final String KEY_HIGH_WORKLOAD = "KEY_HIGH_WORKLOAD";
    public static final ConfigPage CONFIG_PAGE = new QuickTicketConfigPage();

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("configuration", 9442, false, new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("ticketlist", 1313, new Permission[]{HdPermissions.TEMPLATE_DEFINITION}){

            public boolean isVisible(HelpPage helpPage) {
                boolean visible = super.isVisible(helpPage);
                if (!visible) {
                    UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                    visible = currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
                }
                return visible;
            }
        }, new String[]{"ticketlist"});
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9171, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner")}){

            public boolean isVisible(HelpPage helpPage) {
                boolean visible = super.isVisible(helpPage);
                if (visible && !ConfigurationManager.isHelpCenterMode() && !ConfigurationManager.isRecoveryMode()) {
                    visible = TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-33);
                }
                return visible;
            }
        }, new String[]{"taskplanner"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(QuickTicketManager.class, (Object)quickTicketManager);
        spm.register(CreateTicketExtensionFactory.class, (Object)new CreateTicketWithQuickTicketExtensionFactory());
        spm.register(ExtensionArguments.ExtArg.class, CreateTicketWithQuickTicketExtensionFactory.EXTARG_CREATE_TICKET_WITH_QT);
        spm.register(TicketActionExtensionFactory.class, (Object)new ApplyQuickTicketActionExtensionFactory());
        spm.register(ExtensionArguments.ExtArg.class, ApplyQuickTicketActionExtensionFactory.EXTARG_APPLY_QUICK_TICKET_DATA);
        spm.register(ExtensionArguments.ExtArg.class, EXTARG_SEND_MAIL_FROM_QT_DATA);
        spm.register(ReaStepField.class, (Object)ReaStepFieldQuickTicketId.INSTANCE);
        spm.register(AdditionalReaStepFieldDefinition.class, (Object)new AdditionalReaStepFieldDefinitionQuickTicketId());
        if (spm.isPluginLoaded("configuration")) {
            spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

                public void execute() {
                    spm.register(ConfigPage.class, (Object)CONFIG_PAGE);
                    FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.html");
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.quickticket.html", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.edit.html");
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.quickticket.edit.html", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.createfolder.html");
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configuration.quickticket.createfolder.html", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.js");
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.edit.js");
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.createfolder.js");
                    combinedFile.addMessages(CLIENT_MSG);
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/config/configuration.quickticket.renderer.js");
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 99999, "configAppExtras.js", combinedFile));
                }
            });
        }
        spm.runIfPluginLoaded("attachments", () -> new Executable(){

            public void execute() {
                spm.register(QuickTicketAttachmentProvider.class, (Object)new QuickTicketAttachmentProviderImpl(qtPersistenceWithCache));
                spm.register(TicketActionExtensionFactory.class, (Object)new AddQuickTicketAttachmentsActionExtensionFactory());
                spm.register(CreateTicketExtensionFactory.class, (Object)new AddQuickTicketAttachmentsForNewTicketExtensionFactory());
                spm.register(ExtensionArguments.ExtArg.class, AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
                spm.register(AttachmentDataCareExtension.class, (Object)new QuickTicketAttachmentDataCareExtension());
            }
        });
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/ticketlist/ticketlist.quickticket.apply.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "ticketlist.quickticket.apply.html", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/ticketlist/ticketlist.extension.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/ticketlist/ticketlist.quickticket.apply.js");
                combinedFile.addMessages(CLIENT_MSG);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 222, "helpdesk.ticket.extensions.js", combinedFile));
            }
        });
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/css", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/quickticket/client/css/quickticketdefault.css");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 107, "defaulttheme.css", combinedFile));
            }
        });
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/quickticket/client/css/quickticket.less")));
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/quickticket/client/css/quickticket-sprites.less")));
            }
        });
        spm.runIfPluginLoaded("helpdesksetupwizard", () -> new Executable(){

            public void execute() {
                QuickTicketSetupStep.register(spm);
            }
        });
        spm.runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

            public void execute() {
                spm.register(ConnectionCreationListener.class, (Object)QuickTicketServerPlugin.this);
                spm.register(JobFactory.class, (Object)new CreateTicketFromQuickTicketJobFactory());
                spm.register(ResultActionFactory.class, (Object)new ApplyQuickTicketActionFactory());
                QuickTicketServerPlugin.this.registerSerienaufgabeTemplate(spm);
                QuickTicketServerPlugin.this.registerHighWorkload(spm);
                spm.runIfPluginLoaded("inventory", () -> new Executable(){

                    public void execute() {
                        QuickTicketServerPlugin.this.registerNewTicketBeforeExpiry(spm);
                    }
                });
            }
        });
    }

    private boolean haveQuickTicketAnwendenPermission() {
        return TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-33);
    }

    private void registerSerienaufgabeTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_serienaufgabetemplate");
        TriggerDefinition checkTrigger = new TimeTriggerBuilder().withRepeating(RepeatInterval.WEEKLY).withHourAndMinute(8, 0).create();
        taskDesc.addTrigger(checkTrigger);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put("quickticketsubject", "");
        JobDefinition jobDefinition = new JobDefinition("quickticket.taskplanner.createfromquickticketjob", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList keysToLocalize = new ArrayList();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_SERIENAUFGABE_TEMPLATE, MSG, "Template.Serienaufgabe", "Template.Serienaufgabe.desc", taskDesc, keysToLocalize){

            public boolean isAvailable() {
                return super.isAvailable() && QuickTicketServerPlugin.this.haveQuickTicketAnwendenPermission();
            }
        };
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerNewTicketBeforeExpiry(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_newticketbeforeexpiry");
        TriggerDefinition checkTrigger = new TimeTriggerBuilder().withRepeating(RepeatInterval.WEEKLY).withHourAndMinute(8, 0).create();
        taskDesc.addTrigger(checkTrigger);
        HashMap<String, String> seriesProps = new HashMap<String, String>();
        seriesProps.put("warrantytime", "4week");
        SeriesDefinition series = new SeriesDefinition("series.helpdesk.devicewarrantyendapproaching", seriesProps);
        taskDesc.setSeries(series);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put("quickticketsubject", "{Device-Name}");
        JobDefinition jobDefinition = new JobDefinition("quickticket.taskplanner.createfromquickticketjob", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList keysToLocalize = new ArrayList();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_NEW_TICKET_BEFORE_EXPIRY, MSG, "Template.NewTicketBeforeExpiry", "Template.NewTicketBeforeExpiry.desc", taskDesc, keysToLocalize){

            public boolean isAvailable() {
                return super.isAvailable() && QuickTicketServerPlugin.this.haveQuickTicketAnwendenPermission();
            }
        };
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerHighWorkload(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_highworkload");
        HashMap<String, String> triggerProps = new HashMap<String, String>();
        triggerProps.put("FilterType", "FilterTypeCategory");
        triggerProps.put("Category", "0");
        triggerProps.put("Category.display", "novalue");
        triggerProps.put("toomanytickets.howmany", "5");
        TriggerDefinition workloadTrigger = new TriggerDefinition("taskplanner.helpdesk.toomanytickets", triggerProps);
        taskDesc.addTrigger(workloadTrigger);
        HashMap<String, String> triggerProps2 = new HashMap<String, String>();
        triggerProps2.put("FilterType", "FilterTypeResource");
        triggerProps2.put("toomanytickets.howmany", "10");
        TriggerDefinition workloadTrigger2 = new TriggerDefinition("taskplanner.helpdesk.toomanytickets", triggerProps2);
        taskDesc.addTrigger(workloadTrigger2);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put("quickticketsubject", "TooManyTickets.QTSubject");
        JobDefinition jobDefinition = new JobDefinition("quickticket.taskplanner.createfromquickticketjob", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        keysToLocalize.add("Category.display");
        keysToLocalize.add("quickticketsubject");
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_HIGH_WORKLOAD, MSG, "Template.HighWorkload", "Template.HighWorkload.desc", taskDesc, keysToLocalize){

            public boolean isAvailable() {
                return super.isAvailable() && QuickTicketServerPlugin.this.haveQuickTicketAnwendenPermission();
            }
        };
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    public void init(final ServerPluginManager spm) {
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        ConnectionFactory conFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
        List reaStepFields = spm.get(ReaStepField.class);
        List extensionArguments = spm.get(ExtensionArguments.ExtArg.class);
        qtPersistence.init(conFactory, reaStepFields, extensionArguments);
        spm.get(QuickTicketEventListener.class).stream().forEach(listener -> quickTicketManager.registerListener((QuickTicketEventListener)listener));
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                ExtendibleTicketListAngularApplicationServlet ticketListAngularApplicationServlet = (ExtendibleTicketListAngularApplicationServlet)spm.getSingleInstance(ExtendibleTicketListAngularApplicationServlet.class);
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadAvailableQuickTickets(false));
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new ApplyQuickTicketInit());
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new ApplyQuickTicketFields());
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new ValidateQuickTicketAction());
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new ApplyQuickTicketAction());
                ticketListAngularApplicationServlet.addServiceMethod((ServiceMethod)new QuickTicketIcon());
            }
        });
        spm.runIfPluginLoaded("configuration", () -> new Executable(){

            public void execute() {
                final ConfigAngularApplicationServlet configAngularApplicationServlet = (ConfigAngularApplicationServlet)spm.getSingleInstance(ConfigAngularApplicationServlet.class);
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new LoadAvailableQuickTickets(true));
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new QuickTicketIcon());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new DeleteQuickTicketOrFolder());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new SaveQuickTicket());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new CreateOrEditQuickTicket());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new CreateOrEditQuickTicketFolder());
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new SaveQuickTicketFolder());
                spm.runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

                    public void execute() {
                        configAngularApplicationServlet.addServiceMethod((ServiceMethod)new CreateTask());
                        configAngularApplicationServlet.addServiceMethod((ServiceMethod)new ListDeletableTasks());
                    }
                });
            }
        });
    }

    public void connectionCreated() {
        this.performPostInitTemplateChanges();
    }

    private void performPostInitTemplateChanges() {
        UserGroupManager groupManager = HelpDeskUserGroupManager.getInstance();
        List templates = ServerPluginManager.getInstance().get(TaskTemplateDefinition.class);
        block0: for (TaskTemplateDefinition t : templates) {
            if (!t.getKey().equals(KEY_HIGH_WORKLOAD)) continue;
            List triggers = t.getTaskDefinition().getTriggers();
            for (TriggerDefinition tDef : triggers) {
                if (!((String)tDef.getProperties().get("FilterType")).equals("FilterTypeResource")) continue;
                Set groups = groupManager.getGroups(HDUsersAndGroups.RESOURCE);
                if (groups.size() <= 0) continue block0;
                UserGroupInfo info = groups.toArray(new UserGroupInfo[0])[0];
                tDef.getProperties().put("Resource", String.valueOf(info.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)));
                tDef.getProperties().put("TooManyTicketsResource.display", String.valueOf(info.getDisplayName()));
                continue block0;
            }
        }
    }

    public void reset() {
    }

    public void restart() {
    }
}

