/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.helpdesk.core.error.HDErrors;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketEventListener;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import javax.annotation.Nullable;

public class QuickTicketManagerWithPermissionChecks
implements QuickTicketManager {
    private final QuickTicketManager manager;

    public QuickTicketManagerWithPermissionChecks(QuickTicketManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("instance must not be null");
        }
        this.manager = manager;
    }

    @Override
    public QuickTicketVO getQuickTicket(GUID quickTicketID) {
        this.requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions();
        return this.manager.getQuickTicket(quickTicketID);
    }

    @Override
    public List<GUID> getAllQuickTicketIDs() {
        this.requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions();
        return this.manager.getAllQuickTicketIDs();
    }

    @Override
    public GUID createQuickTicket(String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        return this.manager.createQuickTicket(quickTicketName, ticketData, extArgs, actionsData);
    }

    @Override
    public GUID createQuickTicketFromOldSwingClientData(String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        return this.manager.createQuickTicketFromOldSwingClientData(quickTicketName, ticketData, extArgs, actionsData);
    }

    @Override
    public void updateQuickTicket(QuickTicketVO updatedQuickTicket) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        this.manager.updateQuickTicket(updatedQuickTicket);
    }

    @Override
    public void deleteQuickTicket(GUID quickTicketID) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        this.manager.deleteQuickTicket(quickTicketID);
    }

    @Override
    public int createNewTicketWithQuickTicket(ApplicableQuickTicketVO customizedQuickTicket) {
        this.requireUserWhoIsSupporter();
        return this.manager.createNewTicketWithQuickTicket(customizedQuickTicket);
    }

    @Override
    public void applyQuickTicket(int ticketID, ApplicableQuickTicketVO customizedQuickTicket) {
        ActionVO action = (ActionVO)ActionManager.getInstance().get(-33);
        ActionCheckError error = TicketManager.getTicketActionChecker().checkAction(action, ticketID);
        if (error != null) {
            throw HDErrors.createExceptionForCode((ActionCheckError)error);
        }
        this.manager.applyQuickTicket(ticketID, customizedQuickTicket);
    }

    @Override
    public List<ActionVO> getActionsAvailableForQuickTickets() {
        return this.manager.getActionsAvailableForQuickTickets();
    }

    @Override
    public void registerListener(QuickTicketEventListener listener) {
        this.manager.registerListener(listener);
    }

    @Override
    public void unregisterListener(QuickTicketEventListener listener) {
        this.manager.unregisterListener(listener);
    }

    @Override
    public GUID createFolder(@Nullable GUID parentID, String folderName, @Nullable List<UsersOrGroupsSelection.SelectedMember> folderPermission) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        return this.manager.createFolder(parentID, folderName, folderPermission);
    }

    @Override
    public void updateFolder(QuickTicketFolderVO updatedFolder) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        this.manager.updateFolder(updatedFolder);
    }

    @Override
    public void deleteFolder(GUID folderID) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        this.manager.deleteFolder(folderID);
    }

    @Override
    public void setFolder(GUID quickTicketID, GUID folderID) {
        this.requireUserWithAccessToQuickTicketDefinitions();
        this.manager.setFolder(quickTicketID, folderID);
    }

    @Override
    public QuickTicketFolderVO getFolder(GUID folderID) {
        this.requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions();
        return this.manager.getFolder(folderID);
    }

    @Override
    public List<GUID> listQuickTicketsInFolder(GUID folderID) {
        this.requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions();
        return this.manager.listQuickTicketsInFolder(folderID);
    }

    @Override
    public List<GUID> listQuickTicketsUnassignedToFolders() {
        this.requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions();
        return this.manager.listQuickTicketsUnassignedToFolders();
    }

    @Override
    public QuickTicketFolderStructureVO getFolderStructure() {
        this.requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions();
        return this.manager.getFolderStructure();
    }

    private void requireUserWhoIsSupporterOrHasAccessToQuickTicketDefinitions() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount != null) {
            if (SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION})) {
                return;
            }
            if (HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
                return;
            }
        }
        throw new AccessDeniedException(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.requiredSupporterOrAccessToDefinitions", new Object[0]));
    }

    private void requireUserWhoIsSupporter() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return;
        }
        throw new AccessDeniedException(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.requiredSupporter", new Object[0]));
    }

    private void requireUserWithAccessToQuickTicketDefinitions() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount != null && SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION})) {
            return;
        }
        throw new AccessDeniedException(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.requiredAccessToDefinitions", new Object[0]));
    }
}

