/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistence;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketAttachmentProvider;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QuickTicketAttachmentProviderImpl
implements QuickTicketAttachmentProvider {
    private QuickTicketPersistence persistence;

    public QuickTicketAttachmentProviderImpl(QuickTicketPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        this.persistence = persistence;
    }

    @Override
    public List<AttachmentRow> getQuickTicketAttachments(GUID quickTicketID) {
        if (quickTicketID == null) {
            throw new IllegalArgumentException("ID of quick-ticket must not be null");
        }
        Integer intID = this.persistence.getIntID(quickTicketID);
        if (intID == null) {
            throw new IllegalArgumentException("quick-ticket with ID = \"" + String.valueOf(quickTicketID) + "\" does not exist");
        }
        AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
        try {
            Map fullAttachmentData = attService.getFullAttachmentDataFor(AttachmentOwnerType.QuickTicketAttachment, Collections.singletonList(intID));
            return new ArrayList<AttachmentRow>(fullAttachmentData.keySet());
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }
}

