/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class QuickTicketAttachmentDataCareExtension
implements AttachmentDataCareExtension {
    public AttachmentOwnerType getAttachmentType() {
        return AttachmentOwnerType.QuickTicketAttachment;
    }

    public List<Integer> findUnrelatedAttachments(Connection connection) throws Exception {
        ArrayList<Integer> attachmentIds = new ArrayList<Integer>();
        String sql = "SELECT attachmentId FROM tblAttachments WHERE type = ? AND isEmbedded = 0 AND ownerId NOT IN (SELECT QuickTicketID FROM tblQuickTickets)";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, this.getAttachmentType().getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    int attId = rs.getInt(1);
                    attachmentIds.add(attId);
                }
            }
        }
        ServerPluginManager spm = ServerPluginManager.getInstance();
        QuickTicketManager qtManager = (QuickTicketManager)spm.getSingleInstance(QuickTicketManager.class);
        ExternalImageAttachmentAdder externalImageAttAdder = (ExternalImageAttachmentAdder)spm.getSingleInstance(ExternalImageAttachmentAdder.class);
        sql = "SELECT attachmentId, ownerId, secondId, fileName, QuickTicketUUID FROM tblAttachments LEFT JOIN tblQuickTickets ON tblAttachments.ownerId = tblQuickTickets.QuickTicketID WHERE type = ? AND isEmbedded = 1";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, this.getAttachmentType().getId());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    int attId = rs.getInt(1);
                    Integer ownerId = rs.getInt(2);
                    Integer stepId = rs.getInt(3);
                    String fileName = new String(rs.getBytes(4), "UTF-8");
                    GUID quickTicketID = null;
                    try {
                        String idValue = rs.getString(5);
                        if (idValue != null) {
                            quickTicketID = GUID.valueOf((String)idValue);
                        }
                    }
                    catch (IllegalArgumentException idValue) {
                        // empty catch block
                    }
                    if (quickTicketID == null) {
                        attachmentIds.add(attId);
                        continue;
                    }
                    boolean foundReference = false;
                    QuickTicketVO qt = qtManager.getQuickTicket(quickTicketID);
                    if (qt != null) {
                        AttachmentKey attKey = new AttachmentKey(this.getAttachmentType(), ownerId, stepId, Integer.valueOf(-1), fileName);
                        for (ApplicableActionDataVO actionData : qt.getActionsData()) {
                            Set namesOfReferencedAttachments;
                            ReaStepTextVO reaStepText = actionData.getReaStepText();
                            if (reaStepText == null || reaStepText.getText().isEmpty() || !reaStepText.hasHtmlContent() || !(namesOfReferencedAttachments = externalImageAttAdder.findNamesOfReferencedAttachments(this.getAttachmentType(), attKey.getOwnerId().intValue(), attKey.getStepId().intValue(), reaStepText.getText())).contains(attKey.getFileName())) continue;
                            foundReference = true;
                            break;
                        }
                    }
                    if (foundReference) continue;
                    attachmentIds.add(attId);
                }
            }
        }
        return attachmentIds;
    }
}

