/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.taskplanner;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class QuickTicketSelectFieldGenerator {
    ArrayList<LocalizedKey> generateQTIDs(QuickTicketManager qtManager) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null || !SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION}) && !HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
            return new ArrayList<LocalizedKey>();
        }
        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
        QuickTicketFolderStructureVO folders = qtManager.getFolderStructure();
        if (folders != null) {
            List<QuickTicketFolderStructureVO.NodeVO> nodes = folders.getNodes().stream().sorted((n1, n2) -> n1.getFolder().getFolderName().compareToIgnoreCase(n2.getFolder().getFolderName())).collect(Collectors.toList());
            nodes.forEach(n -> this.recursivelyAddToList(qtManager, (QuickTicketFolderStructureVO.NodeVO)n, (List<LocalizedKey>)result, n.getFolder().getFolderName() + "/"));
        }
        qtManager.listQuickTicketsUnassignedToFolders().stream().map(qtManager::getQuickTicket).filter(Objects::nonNull).sorted((q1, q2) -> q1.getQuickTicketName().compareToIgnoreCase(q2.getQuickTicketName())).forEach(quickTicket -> {
            String quickTicketName = quickTicket.getQuickTicketName();
            result.add(new LocalizedKey(quickTicket.getID().toString(), quickTicketName));
        });
        return result;
    }

    private void recursivelyAddToList(QuickTicketManager qtManager, QuickTicketFolderStructureVO.NodeVO n, List<LocalizedKey> result, String currentPath) {
        List children = n.getChildren().stream().sorted((n1, n2) -> n1.getFolder().getFolderName().compareToIgnoreCase(n2.getFolder().getFolderName())).collect(Collectors.toList());
        for (QuickTicketFolderStructureVO.NodeVO child : children) {
            this.recursivelyAddToList(qtManager, child, result, currentPath + child.getFolder().getFolderName() + "/");
        }
        qtManager.listQuickTicketsInFolder(n.getFolder().getID()).stream().map(qtManager::getQuickTicket).filter(Objects::nonNull).sorted((n1, n2) -> n1.getQuickTicketName().compareToIgnoreCase(n2.getQuickTicketName())).forEach(quickTicket -> {
            String quickTicketName = quickTicket.getQuickTicketName();
            result.add(new LocalizedKey(quickTicket.getID().toString(), currentPath + quickTicketName));
        });
    }
}

