/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.taskplanner;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.taskplanner.ApplyQuickTicketAction;
import com.inet.helpdesk.plugins.quickticket.taskplanner.QuickTicketSelectFieldGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.LinkField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplyQuickTicketActionFactory
extends ResultActionFactory<ApplyQuickTicketAction> {
    private static final QuickTicketSelectFieldGenerator QT_GEN = new QuickTicketSelectFieldGenerator();
    public static final String EXTENSION_NAME = "result.applyquickticket";
    private ArrayList<LocalizedKey> quickTicketsData;

    public ApplyQuickTicketActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = QuickTicketServerPlugin.MSG.getMsg("ApplyQuickTicketCategory", new Object[0]);
        String description = QuickTicketServerPlugin.MSG.getMsg("ApplyQuickTicketCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/quickticket/taskplanner/images/quickticket_32.png");
        String helpKey = "taskplanner.action.apply-quickticket";
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("TICKET_ID", QuickTicketServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction((GUID)taskID, (TextField)textField);
        fields.add(textField);
        QuickTicketManager qtManager = this.getQuickTicketManagerInstance();
        this.quickTicketsData = QT_GEN.generateQTIDs(qtManager);
        if (this.quickTicketsData.size() > 0) {
            SelectField s = new SelectField("quickticketid", QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.QuickTicket", new Object[0]), this.quickTicketsData);
            s.setValue(this.quickTicketsData.get(0).getKey());
            fields.add(s);
            if (SystemPermissionChecker.checkAccess((Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION})) {
                for (LocalizedKey qt : this.quickTicketsData) {
                    String targetURL = "configmanager/page/configuration.quicktickets/editquickticket/" + qt.getKey();
                    String rootURL = SessionStore.getRootURL();
                    targetURL = rootURL != null ? rootURL + targetURL : "../" + targetURL;
                    LinkField l = new LinkField("link." + qt.getKey(), "", targetURL, QuickTicketServerPlugin.MSG.getMsg("EditQuickticket", new Object[]{qt.getDisplayName()}));
                    ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
                    conditions.add(FieldCondition.visible((Field)s, (FieldCondition.OP)FieldCondition.OP.equals, (String)qt.getKey()));
                    l.setConditions(conditions);
                    fields.add(l);
                }
            }
        } else {
            LabelField label = new LabelField("CreateFromQuickTicket.NoQuickTickets", QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicketLabel", new Object[0]), QuickTicketServerPlugin.MSG.getMsg("CreateFromQuickTicket.NoQuickTickets.text", new Object[0]));
            fields.add(label);
        }
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected QuickTicketManager getQuickTicketManagerInstance() {
        return (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketId = definition.getProperty("TICKET_ID");
        String qtName = this.quickTicketsData.stream().filter(l -> l.getKey().equals(definition.getProperty("quickticketid"))).map(l -> l.getDisplayName()).findFirst().orElse("???");
        summary.add(new SummaryEntry(QuickTicketServerPlugin.MSG.getMsg("ApplyQuickTicketTo", new Object[]{qtName}), QuickTicketServerPlugin.MSG.getMsg("ApplyQuickTicketTo.ticketWithID", new Object[]{ticketId})));
        return new SummaryInfo(summary);
    }

    protected ApplyQuickTicketAction createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        String ticketId = definition.getProperty("TICKET_ID");
        if (ticketId != null && ticketId.contains("Ticket ID")) {
            throw new IllegalArgumentException(QuickTicketServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        GUID quickticketid = GUID.valueOf((String)definition.getProperty("quickticketid"));
        return new ApplyQuickTicketAction(HDPlaceholderUtils.getTicketIds((String)ticketId), quickticketid, taskID);
    }

    public boolean isAvailable() {
        return TicketManager.getTicketActionChecker().checkCurrentUserHasPermissionToExecuteAction(-33);
    }
}

