/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.taskplanner;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ApplyQuickTicketAction
extends ResultAction {
    public static final String TICKET_ID = "TICKET_ID";
    private final List<Integer> ticketIds;
    private final GUID quickticketid;
    private GUID taskID;

    public ApplyQuickTicketAction(List<Integer> ticketIds, GUID quickticketid, @Nullable GUID taskID) {
        this.quickticketid = quickticketid;
        this.ticketIds = ticketIds;
        this.taskID = taskID;
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        ArrayList<Object> toThrow = new ArrayList<Object>();
        for (Integer ticketId : this.ticketIds) {
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId.intValue());
            if (ticket == null) {
                toThrow.add(new TaskExecutionException(-1, QuickTicketServerPlugin.MSG.getMsg("Error.TicketNoLongerExists", new Object[]{"" + ticketId}), (Throwable)new IllegalStateException(), new Object[0]));
                continue;
            }
            if (ticket.isSlaveInBundle()) {
                toThrow.add(new TaskExecutionException(-1, QuickTicketServerPlugin.MSG.getMsg("Error.TicketIsSlave", new Object[]{"" + ticketId}), (Throwable)new IllegalStateException(), new Object[0]));
                continue;
            }
            QuickTicketManager m = this.getQuickTicketManagerInstance();
            QuickTicketVO quickTicket = m.getQuickTicket(this.quickticketid);
            if (quickTicket == null) {
                toThrow.add(new TaskExecutionException(-1, QuickTicketServerPlugin.MSG.getMsg("Error.QTNoLongerExists", new Object[0]), (Throwable)new IllegalStateException(), new Object[0]));
                continue;
            }
            ApplicableQuickTicketVO aQTVO = this.updateQuickTicketInquiryTextIfPresent(quickTicket.toApplicable(), ticket.getInitialReaStepID());
            try {
                WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
                try {
                    m.applyQuickTicket(ticketId, aQTVO);
                }
                finally {
                    if (addReaStepData == null) continue;
                    addReaStepData.close();
                }
            }
            catch (Exception e) {
                if (e instanceof TaskExecutionException) {
                    toThrow.add(e);
                    continue;
                }
                Throwable th = e.getCause();
                if (th == null) {
                    th = e;
                }
                toThrow.add(new TaskExecutionException(-1, QuickTicketServerPlugin.MSG.getMsg("Error.CannotApplyQT", new Object[]{quickTicket.getQuickTicketName(), th.getMessage()}), th, new Object[0]));
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        this.setProgress(100);
    }

    private ApplicableQuickTicketVO updateQuickTicketInquiryTextIfPresent(ApplicableQuickTicketVO aQTVO, int ticketInquiryReaStepID) {
        List<ApplicableActionDataVO> actionsData = aQTVO.getActionsData();
        if (!actionsData.isEmpty()) {
            ApplicableActionDataVO firstAction = actionsData.get(0);
            String editStepTextUniqueActionID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
            if (Objects.equals(firstAction.getUniqueActionID(), editStepTextUniqueActionID)) {
                ReaStepTextVO originalInquiryText = TicketManager.getReaderForSystem().getReaStepText(ticketInquiryReaStepID);
                ReaStepTextVO updatedQtText = ReaStepTextVO.concatenateOriginalInitialTextWithNewOne((ReaStepTextVO)firstAction.getReaStepText(), (ReaStepTextVO)originalInquiryText);
                MutableApplicableActionData mutableFirstAction = firstAction.toMutable();
                mutableFirstAction.setReaStepText(updatedQtText);
                actionsData = new ArrayList<ApplicableActionDataVO>(actionsData);
                actionsData.set(0, mutableFirstAction.toImmutable());
                return ApplicableQuickTicketVO.create(aQTVO.getID(), aQTVO.getTicketData(), aQTVO.getExtensionArguments(), actionsData);
            }
        }
        return aQTVO;
    }

    protected QuickTicketManager getQuickTicketManagerInstance() {
        return (QuickTicketManager)ServerPluginManager.getInstance().getSingleInstance(QuickTicketManager.class);
    }
}

