/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import java.util.concurrent.TimeUnit;

public class QuickTicketProcessingTime {
    public static ProcessingTime createRelativeProcessingTime(int effortInMin) {
        if (effortInMin < 0) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.effort.negative", new Object[0]));
        }
        return ProcessingTime.of((long)0L, (long)TimeUnit.MINUTES.toMillis(effortInMin));
    }

    public static boolean isRelativeProcessingTime(ProcessingTime processingTime) {
        if (processingTime == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.processingtime.null", new Object[0]));
        }
        return processingTime.getStart() == 0L;
    }

    public static ProcessingTime toNonRelativeProcessingTime(ProcessingTime processingTime) {
        if (QuickTicketProcessingTime.isRelativeProcessingTime(processingTime)) {
            int effortInMin = Long.valueOf(processingTime.getEffortInMin()).intValue();
            return ProcessingTime.ofEffort((int)effortInMin);
        }
        return processingTime;
    }
}

