/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket.api;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import javax.annotation.Nullable;

public class MutableApplicableActionData
implements ApplicableActionData {
    private String uniqueActionID;
    private final MutableReaStepData reaStepData;
    private ReaStepTextVO reaStepText;
    private final ExtensionArguments extArgs;

    public MutableApplicableActionData(String uniqueActionID, MutableReaStepData reaStepData, ReaStepTextVO reaStepText, ExtensionArguments extArgs) {
        this.setUniqueActionID(uniqueActionID);
        if (reaStepData == null) {
            throw QuickTicketException.forIAE("reaStepData must not be null");
        }
        this.reaStepData = reaStepData;
        ApplicableActionDataVO.throwIfUndefinedStepTextIsNotAllowed(uniqueActionID, reaStepText);
        this.reaStepText = reaStepText;
        if (extArgs == null) {
            throw QuickTicketException.forIAE("extArgs must not be null");
        }
        this.extArgs = extArgs;
    }

    public void setUniqueActionID(String uniqueActionID) {
        if (uniqueActionID == null) {
            throw QuickTicketException.forIAE("uniqueActionID must not be null");
        }
        if (uniqueActionID.trim().isEmpty()) {
            throw QuickTicketException.forIAE("uniqueActionID must not be empty after trim");
        }
        this.uniqueActionID = uniqueActionID;
    }

    public void setReaStepText(@Nullable ReaStepTextVO reaStepText) {
        this.reaStepText = reaStepText;
    }

    @Override
    public String getUniqueActionID() {
        return this.uniqueActionID;
    }

    @Override
    public MutableReaStepData getReaStepData() {
        return this.reaStepData;
    }

    @Override
    public ReaStepTextVO getReaStepText() {
        return this.reaStepText;
    }

    @Override
    public ExtensionArguments getExtensionArguments() {
        return this.extArgs;
    }

    public MutableApplicableActionData copy() {
        MutableApplicableActionData copy = new MutableApplicableActionData(this.uniqueActionID, this.reaStepData.copy(), ReaStepTextVO.empty(), ExtensionArguments.copyOf((ExtensionArguments)this.extArgs));
        copy.setReaStepText(this.reaStepText);
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extArgs == null ? 0 : this.extArgs.hashCode());
        result = 31 * result + (this.reaStepData == null ? 0 : this.reaStepData.hashCode());
        result = 31 * result + (this.reaStepText == null ? 0 : this.reaStepText.hashCode());
        result = 31 * result + (this.uniqueActionID == null ? 0 : this.uniqueActionID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableApplicableActionData other = (MutableApplicableActionData)obj;
        if (this.extArgs == null ? other.extArgs != null : !this.extArgs.equals((Object)other.extArgs)) {
            return false;
        }
        if (this.reaStepData == null ? other.reaStepData != null : !this.reaStepData.equals((Object)other.reaStepData)) {
            return false;
        }
        if (this.reaStepText == null ? other.reaStepText != null : !this.reaStepText.equals((Object)other.reaStepText)) {
            return false;
        }
        return !(this.uniqueActionID == null ? other.uniqueActionID != null : !this.uniqueActionID.equals(other.uniqueActionID));
    }

    @Override
    public MutableApplicableActionData toMutable() {
        return this;
    }

    @Override
    public ApplicableActionDataVO toImmutable() {
        return ApplicableActionDataVO.create(this.uniqueActionID, this.reaStepData, this.reaStepText, this.extArgs);
    }
}

