/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistence;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class QuickTicketPersistenceWithCache
implements QuickTicketPersistence {
    private final MemoryStoreMap<GUID, QuickTicketVO> qtCache;
    private final MemoryStoreMap<GUID, Integer> qtIntIdCache;
    private QuickTicketFolderStructureVO cachedFolderStructure;
    private final QuickTicketPersistence persistence;

    public QuickTicketPersistenceWithCache(QuickTicketPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        if (persistence instanceof QuickTicketPersistenceWithCache) {
            throw new IllegalArgumentException("double cache for quick-ticket");
        }
        this.persistence = persistence;
        this.qtCache = new MemoryStoreMap();
        this.qtCache.setTimeout(1800, true);
        this.qtIntIdCache = new MemoryStoreMap();
        this.qtIntIdCache.setTimeout(1800, true);
        DynamicExtensionManager.getInstance().registerListener(TicketField.class, a -> this.qtCache.clear());
    }

    @Override
    public QuickTicketVO load(GUID quickTicketID) {
        QuickTicketVO quickTicket = (QuickTicketVO)this.qtCache.get((Object)quickTicketID);
        if (quickTicket == null && (quickTicket = this.persistence.load(quickTicketID)) != null) {
            this.qtCache.put((Object)quickTicketID, (Object)quickTicket);
        }
        return quickTicket;
    }

    @Override
    public List<GUID> listAll() {
        return this.persistence.listAll();
    }

    @Override
    public void saveNew(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        this.persistence.saveNew(quickTicketID, quickTicketName, ticketData, extArgs, actionsData);
    }

    @Override
    public void save(GUID quickTicketID, String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        this.persistence.save(quickTicketID, quickTicketName, ticketData, extArgs, actionsData);
        this.qtCache.remove((Object)quickTicketID);
    }

    @Override
    public void delete(GUID quickTicketID) {
        this.persistence.delete(quickTicketID);
        this.qtCache.remove((Object)quickTicketID);
        this.qtIntIdCache.remove((Object)quickTicketID);
    }

    @Override
    public Integer getIntID(GUID quickTicketID) {
        Integer intID = (Integer)this.qtIntIdCache.get((Object)quickTicketID);
        if (intID == null && (intID = this.persistence.getIntID(quickTicketID)) != null) {
            this.qtIntIdCache.put((Object)quickTicketID, (Object)intID);
        }
        return intID;
    }

    @Override
    public <R> R inTransaction(Callable<R> operation) {
        return this.persistence.inTransaction(operation);
    }

    @Override
    public QuickTicketFolderVO loadFolder(GUID folderID) {
        QuickTicketFolderStructureVO.NodeVO node = this.loadFolderStructure().find(folderID);
        return node == null ? null : node.getFolder();
    }

    @Override
    public QuickTicketFolderStructureVO loadFolderStructure() {
        if (this.cachedFolderStructure == null) {
            this.cachedFolderStructure = this.persistence.loadFolderStructure();
        }
        return this.cachedFolderStructure;
    }

    @Override
    public List<GUID> listQuickTicketsInFolder(GUID folderID) {
        return this.persistence.listQuickTicketsInFolder(folderID);
    }

    @Override
    public void setFolder(GUID quickTicketID, GUID folderID) {
        this.persistence.setFolder(quickTicketID, folderID);
    }

    @Override
    public void saveNewFolder(GUID parentID, GUID folderID, String folderName, @Nullable List<UsersOrGroupsSelection.SelectedMember> folderPermission) {
        this.persistence.saveNewFolder(parentID, folderID, folderName, folderPermission);
        this.cachedFolderStructure = null;
    }

    @Override
    public void saveFolder(GUID parentID, GUID folderID, String folderName, @Nullable List<UsersOrGroupsSelection.SelectedMember> folderPermission) {
        this.persistence.saveFolder(parentID, folderID, folderName, folderPermission);
        this.cachedFolderStructure = null;
    }

    @Override
    public void deleteFolder(GUID folderID) {
        this.persistence.deleteFolder(folderID);
        this.cachedFolderStructure = null;
    }
}

