/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.quickticket;

import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ExternalImageAttachmentAdder;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.EmbeddedImagesReferencePatcher;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.plugins.quickticket.AddQuickTicketAttachmentsActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.ApplyQuickTicketActionExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.AttachmentsToAdd;
import com.inet.helpdesk.plugins.quickticket.CreateTicketWithQuickTicketExtensionFactory;
import com.inet.helpdesk.plugins.quickticket.QuickTicketPersistence;
import com.inet.helpdesk.plugins.quickticket.QuickTicketServerPlugin;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableActionDataVO;
import com.inet.helpdesk.plugins.quickticket.api.ApplicableQuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.api.MutableApplicableActionData;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketEventListener;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketException;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderStructureVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketFolderVO;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketManager;
import com.inet.helpdesk.plugins.quickticket.api.QuickTicketVO;
import com.inet.helpdesk.plugins.quickticket.eventlog.QuickTicketEventsForTemplateEventLog;
import com.inet.helpdesk.plugins.quickticket.eventlog.QuickTicketEventsForTicketEventLog;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.id.GUID;
import com.inet.mail.api.MailAttachmentUtilities;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.thread.EventDispatcher;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QuickTicketManagerImpl
implements QuickTicketManager {
    private final EventDispatcher<QuickTicketEventListener> dispatcher = new EventDispatcher();
    private final QuickTicketPersistence persistence;
    private final ReentrantReadWriteLock folderLock = new ReentrantReadWriteLock();

    public QuickTicketManagerImpl(QuickTicketPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        this.persistence = persistence;
    }

    @Override
    public void registerListener(QuickTicketEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.dispatcher.registerListener((Object)listener);
    }

    @Override
    public void unregisterListener(QuickTicketEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.dispatcher.unregisterListener((Object)listener);
    }

    @Override
    public QuickTicketVO getQuickTicket(GUID quickTicketID) {
        QuickTicketVO.throwIfIdIsInvalid(quickTicketID);
        return this.persistence.load(quickTicketID);
    }

    @Override
    public List<GUID> getAllQuickTicketIDs() {
        return this.persistence.listAll();
    }

    @Override
    public GUID createQuickTicket(String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        QuickTicketVO.throwIfNameIsInvalid(quickTicketName);
        QuickTicketVO.throwIfTicketOrActionsDataIsInvalid(ticketData, actionsData);
        this.throwIfContainsDeletedActions(actionsData);
        ApplicableQuickTicketVO.throwIfContainsUnsupportedActions(actionsData);
        ApplicableQuickTicketVO.throwIfContainsActionsInIncorrectOrder(actionsData);
        QuickTicketVO.throwIfContainsNonRelativeProcessingTime(actionsData);
        QuickTicketVO.throwIfContainsSendMailActionsWithoutExtData(actionsData);
        QuickTicketVO.throwIfExtArgsAreNull(extArgs);
        this.throwIfExtArgsForQuickTicketContainDataOfEmbeddedAttachments(extArgs);
        if (extArgs.containsExtArg(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.createQuickTicket.wrongExtensionArguments", new Object[]{AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES.getKey()}));
        }
        for (MutableApplicableActionData data : actionsData) {
            if (!data.getExtensionArguments().containsExtArg(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) continue;
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.createQuickTicket.wrongExtArgWithActionData", new Object[]{AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES.getKey()}));
        }
        MutableTicketData ticketDataToUse = ticketData.copy();
        ExtensionArguments extArgsToUse = ExtensionArguments.copyOf((ExtensionArguments)extArgs);
        List<MutableApplicableActionData> actionsDataToUse = this.copyActionsData(actionsData);
        GUID quickTicketID = GUID.generateNew();
        this.persistence.inTransaction(() -> {
            AttachmentsToAdd attachmentsToAdd = this.replaceAttachmentsWithQuickTicketExtData(null, Collections.emptySet(), extArgsToUse, actionsDataToUse);
            this.persistence.saveNew(quickTicketID, quickTicketName, ticketDataToUse, extArgsToUse, actionsDataToUse);
            this.createQuickTicketAttachments(quickTicketID, attachmentsToAdd);
            boolean updatedRefsToNonExternalImages = this.updateReferencesToNonExternalImagesInActionsData(quickTicketID, actionsDataToUse, attachmentsToAdd);
            boolean updatedRefsToExternalImages = this.convertExternalImagesToQuickTicketAttachmentsAndUpdateReferencesInActionsData(quickTicketID, actionsDataToUse);
            if (updatedRefsToNonExternalImages || updatedRefsToExternalImages) {
                this.persistence.save(quickTicketID, quickTicketName, ticketDataToUse, extArgsToUse, actionsDataToUse);
            }
            return null;
        });
        QuickTicketEventsForTemplateEventLog.QuickTicketCreated.log(quickTicketID, quickTicketName, new Object[0]);
        QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
        this.dispatcher.dispatchEvent(lis -> {
            try {
                lis.quickTicketCreated(quickTicket);
            }
            catch (Exception ex) {
                HDLogger.error((Object)ex);
            }
        });
        return quickTicketID;
    }

    @Override
    public GUID createQuickTicketFromOldSwingClientData(String quickTicketName, MutableTicketData ticketData, ExtensionArguments extArgs, List<MutableApplicableActionData> actionsData) {
        QuickTicketVO.throwIfNameIsInvalid(quickTicketName);
        QuickTicketVO.throwIfTicketOrActionsDataIsInvalidForConstrainedQuickTicket(ticketData, actionsData, false);
        QuickTicketVO.throwIfContainsNonRelativeProcessingTime(actionsData);
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments") && actionsData.stream().anyMatch(e -> e.getExtensionArguments().containsExtArg(AttachmentsServerPlugin.EXTARG_ATTACHMENTS))) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.createConstrained.attachmentNotSupported", new Object[0]));
        }
        if (actionsData.stream().anyMatch(e -> e.getExtensionArguments().containsExtArg(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES))) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.createConstrained.actionDataWithAttachment", new Object[]{AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES.getKey()}));
        }
        MutableTicketData ticketDataToUse = ticketData.copy();
        List<MutableApplicableActionData> actionsDataToUse = this.copyActionsData(actionsData);
        GUID quickTicketID = GUID.generateNew();
        this.persistence.inTransaction(() -> {
            AttachmentsToAdd attachmentsToAdd = this.replaceAttachmentsWithQuickTicketExtData(null, Collections.emptySet(), ExtensionArguments.create(), actionsDataToUse);
            this.persistence.saveNew(quickTicketID, quickTicketName, ticketDataToUse, extArgs, actionsDataToUse);
            this.createQuickTicketAttachments(quickTicketID, attachmentsToAdd);
            boolean embeddedAttachmentsAdded = this.convertExternalImagesToQuickTicketAttachmentsAndUpdateReferencesInActionsData(quickTicketID, actionsDataToUse);
            if (embeddedAttachmentsAdded) {
                this.persistence.save(quickTicketID, quickTicketName, ticketDataToUse, ExtensionArguments.create(), actionsDataToUse);
            }
            return null;
        });
        QuickTicketEventsForTemplateEventLog.QuickTicketCreated.log(quickTicketID, quickTicketName, new Object[0]);
        QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
        this.dispatcher.dispatchEvent(lis -> {
            try {
                lis.quickTicketCreated(quickTicket);
            }
            catch (Exception ex) {
                HDLogger.error((Object)ex);
            }
        });
        return quickTicketID;
    }

    @Override
    public void updateQuickTicket(QuickTicketVO updatedQuickTicket) {
        this.throwIfQuickTicketIsNull(updatedQuickTicket);
        List<ApplicableActionDataVO> actionsData = updatedQuickTicket.getActionsData();
        this.throwIfContainsDeletedActions(actionsData);
        ApplicableQuickTicketVO.throwIfContainsUnsupportedActions(actionsData);
        ApplicableQuickTicketVO.throwIfContainsActionsInIncorrectOrder(actionsData);
        List actionsDataToUse = actionsData.stream().map(ApplicableActionDataVO::toMutable).collect(Collectors.toList());
        GUID quickTicketID = updatedQuickTicket.getID();
        String quickTicketName = updatedQuickTicket.getQuickTicketName();
        MutableTicketData ticketDataToUse = updatedQuickTicket.getTicketData();
        ExtensionArguments extArgsToUse = updatedQuickTicket.getExtensionArguments();
        this.throwIfExtArgsForQuickTicketContainDataOfEmbeddedAttachments(extArgsToUse);
        try (ServerLock lock = this.getQuickTicketLock(quickTicketID);){
            QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
            this.throwIfQuickTicketDoesNotExist(quickTicket, quickTicketID);
            if (quickTicket.equals(updatedQuickTicket)) {
                return;
            }
            this.throwIfNamesOfNonEmbeddedAttachmentsDoNotMatchExistingQuickTicketAttachments(quickTicketID, extArgsToUse, actionsDataToUse);
            this.persistence.inTransaction(() -> {
                Set<String> attachmentsToDelete = this.findNamesOfQuickTicketAttachmentsWhichAreNoLongerReferenced(quickTicket, extArgsToUse, actionsDataToUse);
                AttachmentsToAdd attachmentsToAdd = this.replaceAttachmentsWithQuickTicketExtData(quickTicketID, attachmentsToDelete, extArgsToUse, actionsDataToUse);
                this.persistence.save(quickTicketID, quickTicketName, ticketDataToUse, extArgsToUse, actionsDataToUse);
                this.deleteQuickTicketAttachments(quickTicketID, attachmentsToDelete);
                this.createQuickTicketAttachments(quickTicketID, attachmentsToAdd);
                boolean updatedRefsToNonExternalImages = this.updateReferencesToNonExternalImagesInActionsData(quickTicketID, actionsDataToUse, attachmentsToAdd);
                boolean updatedRefsToExternalImages = this.convertExternalImagesToQuickTicketAttachmentsAndUpdateReferencesInActionsData(quickTicketID, actionsDataToUse);
                if (updatedRefsToNonExternalImages || updatedRefsToExternalImages) {
                    this.persistence.save(quickTicketID, quickTicketName, ticketDataToUse, extArgsToUse, actionsDataToUse);
                }
                return null;
            });
            if (Objects.equals(quickTicket.getQuickTicketName(), quickTicketName)) {
                QuickTicketEventsForTemplateEventLog.QuickTicketUpdated.log(quickTicketID, quickTicketName, new Object[0]);
            } else {
                QuickTicketEventsForTemplateEventLog.QuickTicketUpdated.log(quickTicketID, quickTicketName, quickTicket.getQuickTicketName());
            }
            QuickTicketVO quickTicketAfter = this.persistence.load(quickTicketID);
            this.dispatcher.dispatchEvent(lis -> {
                try {
                    lis.quickTicketUpdated(quickTicket, quickTicketAfter);
                }
                catch (Exception ex) {
                    HDLogger.error((Object)ex);
                }
            });
        }
    }

    private void throwIfNamesOfNonEmbeddedAttachmentsDoNotMatchExistingQuickTicketAttachments(GUID quickTicketID, ExtensionArguments updatedQtExtArgs, List<? extends ApplicableActionData> updatedActionsData) {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return;
        }
        ArrayList<String> attNamesToCheck = new ArrayList<String>();
        AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData qtExtData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)updatedQtExtArgs.get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
        if (qtExtData != null) {
            attNamesToCheck.addAll(qtExtData.getAttachmentNames());
        }
        for (ApplicableActionData applicableActionData : updatedActionsData) {
            AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData extData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)applicableActionData.getExtensionArguments().get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
            if (extData == null) continue;
            attNamesToCheck.addAll(extData.getAttachmentNames());
        }
        if (attNamesToCheck.isEmpty()) {
            return;
        }
        try {
            int intID = this.persistence.getIntID(quickTicketID);
            AttachmentService attachmentService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
            Map fullAttachmentDataForQT = attachmentService.getFullAttachmentDataFor(AttachmentOwnerType.QuickTicketAttachment, Collections.singletonList(intID));
            List qtAttNames = fullAttachmentDataForQT.keySet().stream().map(AttachmentRow::getFileName).collect(Collectors.toList());
            attNamesToCheck.removeAll(qtAttNames);
            if (!attNamesToCheck.isEmpty()) {
                throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.nonEmbeddedAttachmentsDoNotMatch", new Object[]{attNamesToCheck}));
            }
        }
        catch (SQLException ex) {
            throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
        }
    }

    private Set<String> findNamesOfQuickTicketAttachmentsWhichAreNoLongerReferenced(QuickTicketVO actualData, ExtensionArguments updatedQtExtArgs, List<MutableApplicableActionData> updatedActionsData) {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return Collections.emptySet();
        }
        int intID = this.persistence.getIntID(actualData.getID());
        ExternalImageAttachmentAdder externalImageAttAdder = (ExternalImageAttachmentAdder)spm.getSingleInstance(ExternalImageAttachmentAdder.class);
        HashSet<String> attachmentNamesFromDefinition = new HashSet<String>();
        AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData qtExtData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)actualData.getExtensionArguments().get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
        if (qtExtData != null) {
            attachmentNamesFromDefinition.addAll(qtExtData.getAttachmentNames());
        }
        for (ApplicableActionDataVO data : actualData.getActionsData()) {
            ReaStepTextVO reaStepText;
            AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData extData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)data.getExtensionArguments().get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
            if (extData != null) {
                attachmentNamesFromDefinition.addAll(extData.getAttachmentNames());
            }
            if ((reaStepText = data.getReaStepText()) == null || reaStepText.getText().isEmpty() || !reaStepText.hasHtmlContent()) continue;
            Set namesOfReferencedAttachments = externalImageAttAdder.findNamesOfReferencedAttachments(AttachmentOwnerType.QuickTicketAttachment, intID, -1, reaStepText.getText());
            attachmentNamesFromDefinition.addAll(namesOfReferencedAttachments);
        }
        HashSet<String> attachmentNamesFromUpdatedActionsData = new HashSet<String>();
        AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData updatedQtExtData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)updatedQtExtArgs.get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
        if (updatedQtExtData != null) {
            attachmentNamesFromUpdatedActionsData.addAll(updatedQtExtData.getAttachmentNames());
        }
        for (MutableApplicableActionData data : updatedActionsData) {
            ReaStepTextVO reaStepText;
            AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData extData = (AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)data.getExtensionArguments().get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES);
            if (extData != null) {
                attachmentNamesFromUpdatedActionsData.addAll(extData.getAttachmentNames());
            }
            if ((reaStepText = data.getReaStepText()) == null || reaStepText.getText().isEmpty() || !reaStepText.hasHtmlContent()) continue;
            Set namesOfReferencedAttachments = externalImageAttAdder.findNamesOfReferencedAttachments(AttachmentOwnerType.QuickTicketAttachment, intID, -1, reaStepText.getText());
            attachmentNamesFromUpdatedActionsData.addAll(namesOfReferencedAttachments);
        }
        HashSet<String> attachmentsWhichAreNoLongerReferenced = new HashSet<String>(attachmentNamesFromDefinition);
        attachmentsWhichAreNoLongerReferenced.removeAll(attachmentNamesFromUpdatedActionsData);
        return attachmentsWhichAreNoLongerReferenced;
    }

    @Override
    public void deleteQuickTicket(GUID quickTicketID) {
        QuickTicketVO.throwIfIdIsInvalid(quickTicketID);
        try (ServerLock lock = this.getQuickTicketLock(quickTicketID);){
            QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
            if (quickTicket == null) {
                return;
            }
            int quickTicketIntID = this.persistence.getIntID(quickTicketID);
            this.persistence.delete(quickTicketID);
            try {
                this.deleteAllQuickTicketAttachments(quickTicketIntID);
            }
            catch (Exception ex) {
                HDLogger.error((Object)"Error occurred while removing attachments of already deleted Quick-Ticket. It is recommended to visit maintenance in order to manually remove unreferenced attachment files and attachments with missing files.");
                HDLogger.error((Object)ex);
            }
            QuickTicketEventsForTemplateEventLog.QuickTicketDeleted.log(quickTicketID, quickTicket.getQuickTicketName(), new Object[0]);
            this.dispatcher.dispatchEvent(lis -> {
                try {
                    lis.quickTicketDeleted(quickTicket);
                }
                catch (Exception ex) {
                    HDLogger.error((Object)ex);
                }
            });
        }
    }

    @Override
    public int createNewTicketWithQuickTicket(ApplicableQuickTicketVO customizedQuickTicket) {
        this.throwIfApplicableQuickTicketIsNull(customizedQuickTicket);
        List<ApplicableActionDataVO> actionsData = customizedQuickTicket.getActionsData();
        this.throwIfContainsDeletedActions(actionsData);
        ReaStepTextVO ticketText = ReaStepTextVO.empty();
        ExtensionArguments extensionArguments = ExtensionArguments.create();
        if (!actionsData.isEmpty()) {
            String editStepTextUniqueActionID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
            ApplicableActionDataVO firstActionData = actionsData.get(0);
            if (Objects.equals(firstActionData.getUniqueActionID(), editStepTextUniqueActionID)) {
                if (firstActionData.getReaStepText() != null) {
                    ticketText = firstActionData.getReaStepText();
                }
                extensionArguments = firstActionData.getExtensionArguments();
            }
        }
        this.throwIfExtArgsForQuickTicketContainDataOfEmbeddedAttachments(customizedQuickTicket.getExtensionArguments());
        MutableTicketData ticketData = customizedQuickTicket.getTicketData();
        String emailEingang = null;
        GUID quickTicketID = customizedQuickTicket.getID();
        try (ServerLock lock = this.getQuickTicketLock(quickTicketID);){
            QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
            this.throwIfQuickTicketDoesNotExist(quickTicket, quickTicketID);
            this.throwIfActionsDataContainsForbiddenModifications(quickTicket, customizedQuickTicket.getActionsData());
            this.throwIfTicketOwnerIsDeactivated(ticketData);
            this.throwIfNamesOfNonEmbeddedAttachmentsDoNotMatchExistingQuickTicketAttachments(quickTicketID, customizedQuickTicket.getExtensionArguments(), actionsData);
            int quickTicketIntID = this.persistence.getIntID(quickTicketID);
            CreateTicketWithQuickTicketExtensionFactory.CreateTicketWithQuickTicketExtensionData extData = new CreateTicketWithQuickTicketExtensionFactory.CreateTicketWithQuickTicketExtensionData(quickTicketIntID, quickTicket.getQuickTicketName(), customizedQuickTicket);
            extensionArguments.put(CreateTicketWithQuickTicketExtensionFactory.EXTARG_CREATE_TICKET_WITH_QT, (Object)extData);
            extensionArguments.put(ExtensionArguments.EXTARG_DISPATCH_NOW, (Object)ExtensionArguments.DispatchNow.NOT);
            TicketVO ticket = TicketManager.getManipulator().createTicket(ticketText, ticketData, emailEingang, extensionArguments);
            int ticketID = ticket.getID();
            QuickTicketEventsForTicketEventLog.QuickTicketApplied.log(quickTicketID, quickTicket.getQuickTicketName(), ticketID);
            this.dispatcher.dispatchEvent(lis -> {
                try {
                    lis.quickTicketApplied(ticketID, customizedQuickTicket);
                }
                catch (Exception ex) {
                    HDLogger.error((Object)ex);
                }
            });
            int n = ticketID;
            return n;
        }
    }

    @Override
    public void applyQuickTicket(int ticketID, ApplicableQuickTicketVO customizedQuickTicket) {
        this.throwIfApplicableQuickTicketIsNull(customizedQuickTicket);
        List<ApplicableActionDataVO> actionsData = customizedQuickTicket.getActionsData();
        this.throwIfContainsDeletedActions(actionsData);
        List<MutableApplicableActionData> actionsDataToUse = actionsData.stream().map(ApplicableActionDataVO::toMutable).collect(Collectors.toList());
        GUID quickTicketID = customizedQuickTicket.getID();
        MutableTicketData ticketData = customizedQuickTicket.getTicketData();
        ExtensionArguments qtExtArgs = customizedQuickTicket.getExtensionArguments();
        this.throwIfExtArgsForQuickTicketContainDataOfEmbeddedAttachments(qtExtArgs);
        try (ServerLock lock = this.getQuickTicketLock(quickTicketID);){
            QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
            this.throwIfQuickTicketDoesNotExist(quickTicket, quickTicketID);
            this.throwIfActionsDataContainsForbiddenModifications(quickTicket, actionsDataToUse);
            this.throwIfTicketOwnerIsDeactivated(ticketData);
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketID);
            if (ticket == null) {
                throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.ticketDoesNotExist", new Object[]{ticketID}));
            }
            this.throwIfNamesOfNonEmbeddedAttachmentsDoNotMatchExistingQuickTicketAttachments(quickTicketID, customizedQuickTicket.getExtensionArguments(), actionsDataToUse);
            int quickTicketIntID = this.persistence.getIntID(quickTicketID);
            MutableReaStepData reaStepData = new MutableReaStepData();
            reaStepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)quickTicket.getQuickTicketName());
            ActionVO action = (ActionVO)ActionManager.getInstance().get(-33);
            qtExtArgs.put(ApplyQuickTicketActionExtensionFactory.EXTARG_APPLY_QUICK_TICKET_DATA, (Object)new ApplyQuickTicketActionExtensionFactory.ApplyQuickTicketActionExtensionData(quickTicket.getID(), quickTicketIntID, ticketData, actionsDataToUse));
            TicketManager.getManipulator().applyAction(ticketID, reaStepData, ReaStepTextVO.empty(), action, qtExtArgs);
            QuickTicketEventsForTicketEventLog.QuickTicketApplied.log(quickTicketID, quickTicket.getQuickTicketName(), ticketID);
            this.dispatcher.dispatchEvent(lis -> {
                try {
                    lis.quickTicketApplied(ticketID, customizedQuickTicket);
                }
                catch (Exception ex) {
                    HDLogger.error((Object)ex);
                }
            });
        }
    }

    private void throwIfActionsDataContainsForbiddenModifications(QuickTicketVO quickTicket, List<? extends ApplicableActionData> actionsData) {
        String firstActionUniqueID;
        String editTextActionUniqueID = ((ActionVO)ActionManager.getInstance().get(-22)).getUniqueID();
        List<ApplicableActionDataVO> originalActionsData = quickTicket.getActionsData();
        if (!originalActionsData.isEmpty() && Objects.equals(editTextActionUniqueID, firstActionUniqueID = originalActionsData.get(0).getUniqueActionID())) {
            originalActionsData = originalActionsData.subList(1, originalActionsData.size());
        }
        if (!actionsData.isEmpty() && Objects.equals(editTextActionUniqueID, firstActionUniqueID = actionsData.get(0).getUniqueActionID())) {
            actionsData = actionsData.subList(1, actionsData.size());
        }
        if (actionsData.size() > originalActionsData.size()) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.actionsDataContainsForbiddenModifications.toMuchEntries", new Object[0]));
        }
        Set originalUniqueActionIDs = originalActionsData.stream().map(ApplicableActionData::getUniqueActionID).collect(Collectors.toSet());
        Set uniqueActionIDs = actionsData.stream().map(ApplicableActionData::getUniqueActionID).collect(Collectors.toSet());
        uniqueActionIDs.removeAll(originalUniqueActionIDs);
        if (!uniqueActionIDs.isEmpty()) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.actionsDataContainsForbiddenModifications.wrongEntries", new Object[0]));
        }
        List originalOrderOfUniqueActionIDs = originalActionsData.stream().map(ApplicableActionData::getUniqueActionID).collect(Collectors.toList());
        List orderOfUniqueActionIDs = actionsData.stream().map(ApplicableActionData::getUniqueActionID).collect(Collectors.toList());
        Iterator originalOrder = originalOrderOfUniqueActionIDs.iterator();
        block0: for (String nextUniqueActionID : orderOfUniqueActionIDs) {
            while (originalOrder.hasNext()) {
                if (!nextUniqueActionID.equals(originalOrder.next())) continue;
                continue block0;
            }
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.actionsDataContainsForbiddenModifications.wrongOrder", new Object[0]));
        }
    }

    private AttachmentsToAdd replaceAttachmentsWithQuickTicketExtData(@Nullable GUID quickTicketID, Set<String> noLongerReferencedAttNames, ExtensionArguments qtExtArgs, List<MutableApplicableActionData> actionsData) throws SQLException {
        List<String> existingFileNames;
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return AttachmentsToAdd.createEmpty();
        }
        if (quickTicketID != null) {
            AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
            int intID = this.persistence.getIntID(quickTicketID);
            existingFileNames = attService.getFileNamesFromAttachments(AttachmentOwnerType.QuickTicketAttachment, intID, -1);
            existingFileNames.removeAll(noLongerReferencedAttNames);
        } else {
            existingFileNames = new ArrayList();
        }
        HashMap<String, LargeContent> qtAttachmentsToAdd = new HashMap<String, LargeContent>();
        AddAttachmentsExtensionData qtAttExtData = (AddAttachmentsExtensionData)qtExtArgs.remove(AttachmentsServerPlugin.EXTARG_ATTACHMENTS);
        if (qtAttExtData != null) {
            for (LargeContent data : qtAttExtData.getAttachments()) {
                String normalizedFileName = MailAttachmentUtilities.normalisiertenFileName((String)data.getName());
                String uniqueFileName = AttachmentFilePathBuilder.getUniqueFileName((String)normalizedFileName, existingFileNames);
                qtAttachmentsToAdd.put(uniqueFileName, data);
                existingFileNames.add(uniqueFileName);
            }
            HashSet<String> qtAttNames = new HashSet<String>();
            qtAttNames.addAll(qtAttachmentsToAdd.keySet());
            if (qtExtArgs.containsExtArg(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) {
                qtAttNames.addAll(((AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)qtExtArgs.get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)).getAttachmentNames());
            }
            qtExtArgs.put(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES, (Object)new AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData(qtAttNames));
        }
        ArrayList<Map<String, LargeContent>> actionAttachmentsToAdd = new ArrayList<Map<String, LargeContent>>();
        for (MutableApplicableActionData action : actionsData) {
            ExtensionArguments extArgs = action.getExtensionArguments();
            AddAttachmentsExtensionData attExtData = (AddAttachmentsExtensionData)extArgs.remove(AttachmentsServerPlugin.EXTARG_ATTACHMENTS);
            if (attExtData == null) {
                actionAttachmentsToAdd.add(Collections.emptyMap());
                continue;
            }
            HashMap<String, LargeContent> attMap = new HashMap<String, LargeContent>();
            for (LargeContent data : attExtData.getAttachments()) {
                String normalizedFileName = MailAttachmentUtilities.normalisiertenFileName((String)data.getName());
                String uniqueFileName = AttachmentFilePathBuilder.getUniqueFileName((String)normalizedFileName, existingFileNames);
                attMap.put(uniqueFileName, data);
                existingFileNames.add(uniqueFileName);
            }
            actionAttachmentsToAdd.add(attMap);
            Set<String> qtAttNames = attMap.entrySet().stream().filter(e -> !Objects.equals(AttachmentType.EmbeddedImage, ((LargeContent)e.getValue()).getContentType())).map(e -> (String)e.getKey()).collect(Collectors.toSet());
            if (qtAttNames.isEmpty()) continue;
            if (extArgs.containsExtArg(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)) {
                qtAttNames.addAll(((AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData)extArgs.get(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES)).getAttachmentNames());
            }
            extArgs.put(AddQuickTicketAttachmentsActionExtensionFactory.EXTARG_QT_ATT_NAMES, (Object)new AddQuickTicketAttachmentsActionExtensionFactory.AddQuickTicketAttachmentsExtensionData(qtAttNames));
        }
        return AttachmentsToAdd.create(qtAttachmentsToAdd, actionAttachmentsToAdd);
    }

    private boolean updateReferencesToNonExternalImagesInActionsData(GUID quickTicketID, List<MutableApplicableActionData> actionsData, AttachmentsToAdd addedAttachments) throws SQLException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return false;
        }
        int intID = this.persistence.getIntID(quickTicketID);
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        Map<String, String> attNameToRestfulPath = attService.getFullAttachmentDataFor(AttachmentOwnerType.QuickTicketAttachment, Collections.singletonList(intID)).keySet().stream().collect(Collectors.toMap(AttachmentRow::getFileName, row -> AttachmentFilePathBuilder.getRestfulPath((AttachmentKey)row.getAttachmentKey())));
        boolean updatedReferences = false;
        for (int index = 0; index < actionsData.size(); ++index) {
            MutableApplicableActionData data = actionsData.get(index);
            ReaStepTextVO reaStepText = data.getReaStepText();
            if (reaStepText == null || !reaStepText.hasHtmlContent()) continue;
            List<Map<String, LargeContent>> actionAttachments = addedAttachments.getActionAttachments();
            HashMap<String, String> attNameToRestfulPathForThisAction = new HashMap<String, String>();
            for (Map.Entry<String, LargeContent> attData : actionAttachments.get(index).entrySet()) {
                String uniqueAttName = attData.getKey();
                String originalName = attData.getValue().getName();
                String restfulPath = attNameToRestfulPath.get(uniqueAttName);
                attNameToRestfulPathForThisAction.put(originalName, restfulPath);
            }
            String updatedText = EmbeddedImagesReferencePatcher.patchAttachmentNamesWithRestfulPaths((String)reaStepText.getText(), attNameToRestfulPathForThisAction);
            if (reaStepText.getText().equals(updatedText)) continue;
            data.setReaStepText(ReaStepTextVO.of((String)updatedText, (boolean)reaStepText.hasHtmlContent()));
            updatedReferences = true;
        }
        return updatedReferences;
    }

    private boolean convertExternalImagesToQuickTicketAttachmentsAndUpdateReferencesInActionsData(GUID quickTicketID, List<MutableApplicableActionData> actionsData) {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return false;
        }
        ExternalImageAttachmentAdder externalImageAttAdder = (ExternalImageAttachmentAdder)spm.getSingleInstance(ExternalImageAttachmentAdder.class);
        boolean attachmentsAdded = false;
        int intID = this.persistence.getIntID(quickTicketID);
        for (MutableApplicableActionData data : actionsData) {
            String updatedStepContent;
            ReaStepTextVO reaStepText = data.getReaStepText();
            if (reaStepText == null || reaStepText.getText().isEmpty() || !reaStepText.hasHtmlContent() || (updatedStepContent = externalImageAttAdder.convertExternalImagesToAttachments(AttachmentOwnerType.QuickTicketAttachment, intID, -1, reaStepText.getText())) == null) continue;
            data.setReaStepText(ReaStepTextVO.of((String)updatedStepContent, (boolean)true));
            attachmentsAdded = true;
        }
        return attachmentsAdded;
    }

    private void createQuickTicketAttachments(GUID quickTicketID, AttachmentsToAdd attachments) throws IOException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (attachments.isEmpty() || !spm.isPluginLoaded("attachments")) {
            return;
        }
        int intID = this.persistence.getIntID(quickTicketID);
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        for (Map.Entry<String, LargeContent> entry : attachments.getQtAttachments().entrySet()) {
            String uniqueAttName = entry.getKey();
            LargeContent data = entry.getValue();
            attService.createAttachment(AttachmentOwnerType.QuickTicketAttachment, intID, -1, uniqueAttName, data);
        }
        for (Map map : attachments.getActionAttachments()) {
            for (String uniqueAttName : map.keySet()) {
                LargeContent data = (LargeContent)map.get(uniqueAttName);
                attService.createAttachment(AttachmentOwnerType.QuickTicketAttachment, intID, -1, uniqueAttName, data);
            }
        }
    }

    private void deleteAllQuickTicketAttachments(int quickTicketIntID) throws IOException, SQLException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (!spm.isPluginLoaded("attachments")) {
            return;
        }
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        List allFileNames = attService.getFileNamesFromAttachments(AttachmentOwnerType.QuickTicketAttachment, quickTicketIntID, -1);
        for (String fileName : allFileNames) {
            attService.deleteAttachment(AttachmentOwnerType.QuickTicketAttachment, quickTicketIntID, -1, fileName);
        }
    }

    private void deleteQuickTicketAttachments(GUID quickTicketID, Set<String> attachmentNames) throws IOException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        if (attachmentNames.isEmpty() || !spm.isPluginLoaded("attachments")) {
            return;
        }
        int quickTicketIntID = this.persistence.getIntID(quickTicketID);
        AttachmentService attService = (AttachmentService)spm.getSingleInstance(AttachmentService.class);
        for (String fileName : attachmentNames) {
            attService.deleteAttachment(AttachmentOwnerType.QuickTicketAttachment, quickTicketIntID, -1, fileName);
        }
    }

    private List<MutableApplicableActionData> copyActionsData(List<MutableApplicableActionData> actionsData) {
        ArrayList<MutableApplicableActionData> result = new ArrayList<MutableApplicableActionData>();
        for (MutableApplicableActionData data : actionsData) {
            result.add(data.copy());
        }
        return result;
    }

    private void throwIfQuickTicketDoesNotExist(@Nullable QuickTicketVO quickTicket, @Nonnull GUID quickTicketID) {
        if (quickTicket == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.quickTicketDoesNotExist", new Object[]{quickTicketID}));
        }
    }

    private ServerLock getQuickTicketLock(GUID quickTicketID) {
        return ThreadUtils.getLock((Object)("quickTicket" + quickTicketID.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID createFolder(@Nullable GUID parentID, String folderName, @Nullable List<UsersOrGroupsSelection.SelectedMember> folderPermission) {
        QuickTicketFolderVO.throwIfNameIsInvalid(folderName);
        try {
            this.folderLock.writeLock().lock();
            GUID folderID = GUID.generateNew();
            if (parentID != null) {
                QuickTicketFolderVO parent = this.persistence.loadFolder(parentID);
                this.throwIfFolderDoesNotExist(parent, parentID);
            }
            this.persistence.saveNewFolder(parentID, folderID, folderName, folderPermission);
            GUID gUID = folderID;
            return gUID;
        }
        finally {
            this.folderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(QuickTicketFolderVO updatedFolder) {
        if (updatedFolder == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.updateFolder.missingFolder", new Object[0]));
        }
        try {
            this.folderLock.writeLock().lock();
            GUID folderID = updatedFolder.getID();
            QuickTicketFolderVO folder = this.persistence.loadFolder(folderID);
            this.throwIfFolderDoesNotExist(folder, folderID);
            if (folder.equals(updatedFolder)) {
                return;
            }
            GUID parentID = updatedFolder.getParentID();
            if (parentID != null) {
                QuickTicketFolderVO parent = this.persistence.loadFolder(parentID);
                this.throwIfFolderDoesNotExist(parent, parentID);
                QuickTicketFolderStructureVO folderStructure = this.persistence.loadFolderStructure();
                QuickTicketFolderStructureVO.NodeVO parentNode = folderStructure.find(parentID);
                while (parentNode.getParent() != null) {
                    if (!folderID.equals((Object)(parentNode = parentNode.getParent()).getFolder().getID())) continue;
                    throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.updateFolder.parentCannotSet", new Object[0]));
                }
            }
            List<UsersOrGroupsSelection.SelectedMember> folderPermission = updatedFolder.getFolderPermission();
            this.persistence.saveFolder(parentID, updatedFolder.getID(), updatedFolder.getFolderName(), folderPermission);
        }
        finally {
            this.folderLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFolder(GUID folderID) {
        QuickTicketFolderVO.throwIfIdIsInvalid(folderID);
        try {
            this.folderLock.writeLock().lock();
            QuickTicketFolderStructureVO folderStructure = this.persistence.loadFolderStructure();
            QuickTicketFolderStructureVO.NodeVO node = folderStructure.find(folderID);
            if (node == null) {
                return;
            }
            ArrayList<GUID> folderIDs = new ArrayList<GUID>();
            this.collectFolderIDs(node, folderIDs);
            Collections.reverse(folderIDs);
            this.persistence.inTransaction(() -> {
                folderIDs.stream().forEach(id -> this.persistence.deleteFolder((GUID)id));
                return null;
            });
        }
        finally {
            this.folderLock.writeLock().unlock();
        }
    }

    private void collectFolderIDs(QuickTicketFolderStructureVO.NodeVO node, List<GUID> collectingParam) {
        collectingParam.add(node.getFolder().getID());
        node.getChildren().stream().forEach(child -> this.collectFolderIDs((QuickTicketFolderStructureVO.NodeVO)child, collectingParam));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFolder(GUID quickTicketID, @Nullable GUID folderID) {
        QuickTicketVO.throwIfIdIsInvalid(quickTicketID);
        try {
            this.folderLock.writeLock().lock();
            QuickTicketVO quickTicket = this.persistence.load(quickTicketID);
            this.throwIfQuickTicketDoesNotExist(quickTicket, quickTicketID);
            if (folderID != null) {
                QuickTicketFolderVO folder = this.persistence.loadFolder(folderID);
                this.throwIfFolderDoesNotExist(folder, folderID);
            }
            this.persistence.setFolder(quickTicketID, folderID);
        }
        finally {
            this.folderLock.writeLock().unlock();
        }
    }

    @Override
    public QuickTicketFolderVO getFolder(GUID folderID) {
        QuickTicketFolderVO.throwIfIdIsInvalid(folderID);
        try {
            this.folderLock.readLock().lock();
            QuickTicketFolderVO quickTicketFolderVO = this.persistence.loadFolder(folderID);
            return quickTicketFolderVO;
        }
        finally {
            this.folderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GUID> listQuickTicketsInFolder(GUID folderID) {
        QuickTicketFolderVO.throwIfIdIsInvalid(folderID);
        try {
            this.folderLock.readLock().lock();
            QuickTicketFolderVO folder = this.persistence.loadFolder(folderID);
            this.throwIfFolderDoesNotExist(folder, folderID);
            List<GUID> list = this.persistence.listQuickTicketsInFolder(folderID);
            return list;
        }
        finally {
            this.folderLock.readLock().unlock();
        }
    }

    @Override
    public List<GUID> listQuickTicketsUnassignedToFolders() {
        try {
            this.folderLock.readLock().lock();
            List<GUID> list = this.persistence.listQuickTicketsInFolder(null);
            return list;
        }
        finally {
            this.folderLock.readLock().unlock();
        }
    }

    @Override
    public QuickTicketFolderStructureVO getFolderStructure() {
        try {
            this.folderLock.readLock().lock();
            QuickTicketFolderStructureVO quickTicketFolderStructureVO = this.persistence.loadFolderStructure();
            return quickTicketFolderStructureVO;
        }
        finally {
            this.folderLock.readLock().unlock();
        }
    }

    private void throwIfQuickTicketIsNull(QuickTicketVO quickTicket) {
        if (quickTicket == null) {
            throw QuickTicketException.forIAE("data of quick-ticket must not be null");
        }
    }

    private void throwIfApplicableQuickTicketIsNull(ApplicableQuickTicketVO quickTicket) {
        if (quickTicket == null) {
            throw QuickTicketException.forIAE("data of quick-ticket must not be null");
        }
    }

    private void throwIfFolderDoesNotExist(@Nullable QuickTicketFolderVO folder, @Nonnull GUID folderID) {
        if (folder == null) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.folderDoesNotExist", new Object[]{folderID}));
        }
    }

    private void throwIfContainsDeletedActions(List<? extends ApplicableActionData> actionsData) {
        List uniqueIDsOfAllActiveActions = ActionManager.getInstance().getAll(true).stream().map(ActionVO::getUniqueID).collect(Collectors.toList());
        for (int index = 0; index < actionsData.size(); ++index) {
            ApplicableActionData data = actionsData.get(index);
            if (uniqueIDsOfAllActiveActions.contains(data.getUniqueActionID())) continue;
            String msg = QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.deletedAction", new Object[0]);
            throw QuickTicketException.forIAE(msg, index, "");
        }
    }

    private void throwIfExtArgsForQuickTicketContainDataOfEmbeddedAttachments(ExtensionArguments extArgs) {
        AddAttachmentsExtensionData attExtData;
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments") && (attExtData = (AddAttachmentsExtensionData)extArgs.get(AttachmentsServerPlugin.EXTARG_ATTACHMENTS)) != null && attExtData.getAttachments().stream().anyMatch(att -> Objects.equals(AttachmentType.EmbeddedImage, att.getContentType()))) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.embeddedAttachmentNotSupported", new Object[0]));
        }
    }

    private void throwIfTicketOwnerIsDeactivated(@Nonnull MutableTicketData ticketData) {
        UserAccount userAccount;
        GUID ticketOwnerID = (GUID)ticketData.get((TicketField)Tickets.FIELD_OWNER_GUID);
        if (ticketOwnerID != null && (userAccount = UserManager.getInstance().getUserAccount(ticketOwnerID)) != null && !userAccount.isActive()) {
            throw QuickTicketException.forIAE(QuickTicketServerPlugin.MSG.getMsg("quickticketmanager.errormessage.deactivatedTicketOwnerAccount", new Object[0]));
        }
    }

    @Override
    public List<ActionVO> getActionsAvailableForQuickTickets() {
        List<ActionVO> availableActions = this.getUnfilteredActionsAvailableForQuickTickets();
        this.filterOutActionsThatCurrentUserCannotAccess(availableActions);
        return availableActions;
    }

    public List<ActionVO> getUnfilteredActionsAvailableForQuickTickets() {
        ArrayList<ActionVO> availableActions = new ArrayList<ActionVO>();
        block3: for (ActionVO action : ActionManager.getInstance().getAll(true)) {
            if (action.isInternal() || Status.isDeletedStatus((int)action.getStatusID()) || action.getId() == -33) continue;
            switch (action.getId()) {
                case -36: 
                case -34: 
                case -13: 
                case -12: 
                case -7: 
                case -2: 
                case -1: 
                case 7: 
                case 8: {
                    continue block3;
                }
            }
            availableActions.add(action);
        }
        availableActions.add((ActionVO)ActionManager.getInstance().get(-7));
        return availableActions;
    }

    private void filterOutActionsThatCurrentUserCannotAccess(List<ActionVO> actions) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            actions.clear();
            return;
        }
        Set effectiveAllowedActionsForCurrentUser = TicketManager.getTicketActionChecker().getEffectiveAllowedActionsForCurrentUser();
        actions.removeIf(action -> !effectiveAllowedActionsForCurrentUser.contains(action.getId()));
    }
}

